

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptMagReconGetOrphanJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptMagReconGetOrphanJob.sp,v $ $Id: RptMagReconGetOrphanJob.sp,v 1.3.86.5 2018/11/18 03:50:04 skatz Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptMagReconGetOrphanJob')
BEGIN
	print '>>> Drop Stored Procedure: RptMagReconGetOrphanJob <<<'
	drop procedure RptMagReconGetOrphanJob
END
IF EXISTS (select * from GxQscripts where name='RptMagReconGetOrphanJob')
	delete from GxQscripts where name = 'RptMagReconGetOrphanJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMagReconGetOrphanJob')
	delete from GXDBVersions where aliasname = 'RptMagReconGetOrphanJob'
GO
print '... Creating Procedure: RptMagReconGetOrphanJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptMagReconGetOrphanJob
  @i_LibraryId integer,
  @i_jobId integer
AS
  DECLARE @o_JobId integer
  DECLARE @o_AdminJobId integer
  DECLARE @o_ClientId integer
  DECLARE @o_AppTypeId integer
  DECLARE @o_CopyId integer
  DECLARE @o_LibraryId integer
  DECLARE @o_ReconDate integer
  DECLARE @o_ClientName NVARCHAR(255)
  DECLARE @o_iDaName NVARCHAR(255)
  DECLARE @o_SPName NVARCHAR(255)
  DECLARE @o_CopyName NVARCHAR(255)
  DECLARE @o_LibraryName NVARCHAR(255)
  DECLARE @o_maNames NVARCHAR(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- Defined in mms2LibraryOperationDefines.h
Declare @volReconVACStatusInCSDB integer
set @volReconVACStatusInCSDB = 3
declare @tblReconJobForCopy table (ArchCopyId int, AdminJobId int)
insert into @tblReconJobForCopy
select ArchCopyId, max(AdminJobId)
from MMVolReconChunkList
group by ArchCopyId
DECLARE @userId			integer
DECLARE @tblLibs		TABLE (t_libId int)
DECLARE @libOpt			integer
declare @tblDanglingChunk table
(
	ChunkId bigint,
	VolumeId int,
	MountPathId int,
	ArchCopyId int,
	AdminJobId int,
	LibraryId int
)
-- Get all chunks on dangling volume
insert into @tblDanglingChunk
select c.id, a.VolumeId, a.MountPathId, a.ArchCopyId, a.AdminJobId, 0
from MMVolReconChunkList a, @tblReconJobForCopy b, archChunk c
where a.ArchCopyId = b.ArchCopyId and a.AdminJobId = b.AdminJobId
and a.VACStatus = @volReconVACStatusInCSDB
and a.ChunkId = 0 and a.VolumeId = c.volumeId
-- Get all dangling chunks on valid volume
insert into @tblDanglingChunk
select a.ChunkId, a.VolumeId, a.MountPathId, a.ArchCopyId, a.AdminJobId, 0
from MMVolReconChunkList a, @tblReconJobForCopy b
where a.ArchCopyId = b.ArchCopyId and a.AdminJobId = b.AdminJobId
and a.VACStatus = @volReconVACStatusInCSDB
and a.ChunkId > 0
update @tblDanglingChunk
set LibraryId = b.LibraryId
from @tblDanglingChunk a, MMMountPath b
where a.MountPathId = b.MountPathId
SET @userId		= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
INSERT INTO @tblLibs	EXEC rptOptGetObjectList @i_jobId, 412850839, @libOpt OUTPUT
-- Use cursor to get media agents for all libraries
declare @tblLibMA table (LibraryId int, LibraryName nvarchar(256), MediaAgentNames nvarchar(2048))
insert into @tblLibMA
exec RptGetMaNamesForLibrary @i_LibraryId
IF(@libOpt!=0)
BEGIN
	DELETE  @tblLibMA WHERE LibraryId NOT IN (select t_libId from @tblLibs)
	DELETE  @tblDanglingChunk WHERE LibraryId NOT IN (select t_libId from @tblLibs)
END
--got all qualified media, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @libOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2049, 0, '#rptUserObjects'	-- 2049 = LIBRARY_ITEM
	DELETE #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR clientId <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0
	DELETE @tblDanglingChunk
	FROM   @tblDanglingChunk T
	WHERE NOT EXISTS (select * from #rptUserObjects R where R.LibraryId in (0, T.LibraryId))
	DROP TABLE #rptUserObjects
END
declare @tblDanglingJobForCopy table
(
	JobId int,
	AppId int,
	VolumeId int,
	MountPathId int,
	ArchCopyId int,
	AdminJobId int,
	LibraryId int,
	ClientId int,
	AppTypeId int
)
-- Get jobs for dangling chunks
insert into @tblDanglingJobForCopy
select distinct d.jobId, d.appId, a.VolumeId, a.MountPathId, a.ArchCopyId, a.AdminJobId, a.LibraryId, 0, 0
from @tblDanglingChunk a, archChunkMapping b, archFileCopy c, archFile d
where a.ChunkId = b.archChunkId and a.ArchCopyId = b.archCopyId
and b.archFileId = c.archFileId and b.archCopyId = c.archCopyId and b.commCellId = c.commCellId
and c.archFileId = d.id and c.commCellId = d.commCellId
update @tblDanglingJobForCopy
set ClientId = b.clientId, AppTypeId = b.appTypeId
from @tblDanglingJobForCopy a, APP_Application b
where a.AppId = b.id
-- Output
select a.JobId, a.adminJobId, a.ClientId, a.AppTypeId, a.ArchCopyId, a.LibraryId,
isnull((select servStart from JMAdminJobStatsTable where jobId = a.AdminJobId), 0) as reconDate,
isnull((select displayName from APP_Client where id = a.ClientId), 'N/A') as clienName,
isnull((select name from APP_iDAType where type = a.AppTypeId), 'N/A') as iDaName,
isnull((select ag.name from archGroup ag, archGroupCopy agc where ag.id = agc.archGroupId and agc.id = a.ArchCopyId), 'N/A') as agName,
isnull((select name from archGroupCopy where id = a.ArchCopyId), 'N/A') as agcName,
isnull((select AliasName from mmlibrary where LibraryId = a.LibraryId), 'N/A') as libName,
isnull((select MediaAgentNames from @tblLibMA where LibraryId = a.LibraryId), 'N/A') as maNames
from @tblDanglingJobForCopy a
where @i_LibraryId = 0 OR a.LibraryId = @i_LibraryId
order by a.LibraryId, a.ArchCopyId, a.JobId
GO

IF EXISTS (select * from GxQscripts where name = 'RptMagReconGetOrphanJob')
	delete from GxQscripts where name = 'RptMagReconGetOrphanJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMagReconGetOrphanJob')
	delete from GXDBVersions where aliasname = 'RptMagReconGetOrphanJob'
GO

insert into GXDBVersions values(2, 'RptMagReconGetOrphanJob',  '00010003008600050000', 'RptMagReconGetOrphanJob', '00010003008600050000')
GO

