

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptMagReconGetDanglingVol.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptMagReconGetDanglingVol.sp,v $ $Id: RptMagReconGetDanglingVol.sp,v 1.7.86.4 2018/03/22 02:59:08 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptMagReconGetDanglingVol <<<'

IF EXISTS (select * from sysobjects where name='RptMagReconGetDanglingVol')
	drop procedure RptMagReconGetDanglingVol
IF EXISTS (select * from GxQscripts where name='RptMagReconGetDanglingVol')
	delete from GxQscripts where name = 'RptMagReconGetDanglingVol'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMagReconGetDanglingVol')
	delete from GXDBVersions where aliasname = 'RptMagReconGetDanglingVol'
GO
print '... Creating Procedure: RptMagReconGetDanglingVol'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptMagReconGetDanglingVol
  @i_LibraryId integer,
  @i_jobId integer
AS
  DECLARE @o_AdminJobId integer
  DECLARE @o_VolumeId integer
  DECLARE @o_MountPathId integer
  DECLARE @o_CopyId integer
  DECLARE @o_LibraryId integer
  DECLARE @o_DataSize bigint
  DECLARE @o_PruneStatus integer
  DECLARE @o_PruneDate integer
  DECLARE @o_ReconDate integer
  DECLARE @o_NumOfChunks integer
  DECLARE @o_MountPath NVARCHAR(255)
  DECLARE @o_SPName NVARCHAR(255)
  DECLARE @o_CopyName NVARCHAR(255)
  DECLARE @o_LibraryName NVARCHAR(255)
  DECLARE @o_maNames NVARCHAR(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--Defined in mms2LibraryOperationDefines.h
Declare @volReconVACStatusInMP integer
set @volReconVACStatusInMP = 2
declare @tblReconJobForCopy table (ArchCopyId int, AdminJobId int)
insert into @tblReconJobForCopy
select ArchCopyId, max(AdminJobId)
from MMVolReconChunkList
group by ArchCopyId
DECLARE @userId			integer
DECLARE @tblLibs		TABLE (t_libId int)
DECLARE @libOpt			integer
declare @tblDanglingChunk table
(
	VolumeId int,
	MountPathId int,
	ArchCopyId int,
	AdminJobId int,
	LibraryId int,
	MaxChunkId int,
	NumOfChunks int,
	DataSize bigint,
	PruneStatus int,
	PruneDate int
)
-- Get all dangling chunks not exist in database
insert into @tblDanglingChunk
select a.VolumeId, a.MountPathId, a.ArchCopyId, a.AdminJobId, 0,
	   max(a.ChunkId), count(a.ChunkId), sum(a.ChunkSize), max(a.PruneStatus), max(a.PruneTime)
from MMVolReconChunkList a, @tblReconJobForCopy b
where a.ArchCopyId = b.ArchCopyId and a.AdminJobId = b.AdminJobId
and a.VACStatus = @volReconVACStatusInMP
group by a.VolumeId, a.MountPathId, a.ArchCopyId, a.AdminJobId
update @tblDanglingChunk
set LibraryId = b.LibraryId
from @tblDanglingChunk a, MMMountPath b
where a.MountPathId = b.MountPathId
SET @userId		= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
INSERT INTO @tblLibs	EXEC rptOptGetObjectList @i_jobId, 412850839, @libOpt OUTPUT
-- Use cursor to get media agents for all libraries
declare @tblLibMA table (LibraryId int, LibraryName nvarchar(256), MediaAgentNames nvarchar(2048))
insert into @tblLibMA
exec RptGetMaNamesForLibrary @i_LibraryId
IF(@libOpt!=0)
BEGIN
	DELETE  @tblLibMA WHERE LibraryId NOT IN (select t_libId from @tblLibs)
	DELETE  @tblDanglingChunk WHERE LibraryId NOT IN (select t_libId from @tblLibs)
END
--got all qualified media, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @libOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2049, 0, '#rptUserObjects'	-- 2049 = LIBRARY_ITEM
	DELETE #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR clientId <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0
	DELETE @tblDanglingChunk
	FROM   @tblDanglingChunk T
	WHERE NOT EXISTS (select * from #rptUserObjects R where R.LibraryId in (0, T.LibraryId))
	DROP TABLE #rptUserObjects
END
-- Output
select a.adminJobId, a.VolumeId, a.MountPathId, a.ArchCopyId, a.LibraryId, a.DataSize, a.PruneStatus, a.PruneDate,
isnull((select servStart from JMAdminJobStatsTable where jobId = a.AdminJobId), 0) as reconDate,
(case when a.MaxChunkId > 0 then a.NumOfChunks else 0 end) as NumOfChunks,
isnull((select MountPathName from MMS2getMountPathNameGUIView where MountPathId = a.MountPathId), 'N/A') as MountPathName,
isnull((select ag.name from archGroup ag, archGroupCopy agc where ag.id = agc.archGroupId and agc.id = a.ArchCopyId), 'N/A') as agName,
isnull((select name from archGroupCopy where id = a.ArchCopyId), 'N/A') as agcName,
isnull((select AliasName from mmlibrary where LibraryId = a.LibraryId), 'N/A') as libName,
isnull((select MediaAgentNames from @tblLibMA where LibraryId = a.LibraryId), 'N/A') as maNames
from @tblDanglingChunk a
where @i_LibraryId = 0 OR a.LibraryId = @i_LibraryId
order by a.LibraryId, a.VolumeId
GO

IF EXISTS (select * from GxQscripts where name = 'RptMagReconGetDanglingVol')
	delete from GxQscripts where name = 'RptMagReconGetDanglingVol'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMagReconGetDanglingVol')
	delete from GXDBVersions where aliasname = 'RptMagReconGetDanglingVol'
GO

insert into GXDBVersions values(2, 'RptMagReconGetDanglingVol',  '00010007008600040000', 'RptMagReconGetDanglingVol', '00010007008600040000')
GO

