

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptMAPerformance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptMAPerformance.sp,v $ $Id: RptMAPerformance.sp,v 1.13.36.6 2018/11/18 03:49:34 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "rptMAPerformance"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptMAPerformance')
BEGIN
	print '>>> Drop Stored Procedure: rptMAPerformance <<<'
	drop procedure rptMAPerformance
END
IF EXISTS (select * from GxQscripts where name='rptMAPerformance')
	delete from GxQscripts where name = 'rptMAPerformance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptMAPerformance')
	delete from GXDBVersions where aliasname = 'rptMAPerformance'
GO
print '... Creating Procedure: rptMAPerformance'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptMAPerformance
  @i_jobId integer
AS
  DECLARE @o_maId integer;
  DECLARE @o_avgMntsHr char(255);
  DECLARE @o_avgMntsDay char(255);
  DECLARE @o_maxStreamsHr char(255);
  DECLARE @o_maxStreamsDay char(255);
  DECLARE @o_reservationsHr char(255);
  DECLARE @o_reservationsDay char(255);
  DECLARE @o_avgJobsHr char(255);
  DECLARE @o_avgJobsDay char(255);
  DECLARE @o_totBkpHr char(255);
  DECLARE @o_totBkpDay char(255);
  DECLARE @o_mediaAgent nvarchar(255);
  DECLARE @o_mediaAgentDisplayName nvarchar(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId			integer
DECLARE @libOpt			integer
DECLARE @tblLibs		TABLE (t_libId int)
SET @userId		= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
INSERT INTO @tblLibs	EXEC rptOptGetObjectList @i_jobId, 412850839, @libOpt OUTPUT
IF object_id('tempdb.dbo.#tmpMAList') is not null DROP TABLE #tmpMAList
IF object_id('tempdb.dbo.#mountsPerMA') is not null DROP TABLE #mountsPerMA
IF object_id('tempdb.dbo.#perMAJobs') is not null DROP TABLE #perMAJobs
CREATE TABLE #tmpMAList
(
	MAId	int,
	avgMntsHr VARCHAR(50),
	avgMntsDay VARCHAR(50),
	maxStreamsHr VARCHAR(50),
	maxStreamsDay VARCHAR(50),
	Reservations_hr VARCHAR(50),
	Reservations_24hr VARCHAR(50),
	avgJobsHr VARCHAR(50) NULL,
	avgJobsDay VARCHAR(50) NULL,
	BkpHr VARCHAR(50) NULL,
    BkpDay VARCHAR(50) NULL,
    MediaAgent NVARCHAR(255),
    MediaAgentDisplayName NVARCHAR(255)
)
CREATE TABLE #mountsPerMA
(
	MaId int,
	avgMntsHr FLOAT(5),
	avgMntsDay FLOAT(5),
	maxStreamsHr FLOAT(5),
	maxStreamsDay FLOAT(5),
	Reservations_hr FLOAT(5),
	Reservations_24hr FLOAT(5)
)
DECLARE @CUR_TIME INT
SET @CUR_TIME = dbo.GetUnixTime(GetUTCDate())
DECLARE @OneHourAgo DATETIME = DATEADD(HOUR, -1, GetUTCDate())
DECLARE @24HoursAgo DATETIME = DATEADD(HOUR, -24, GetUTCDate())
INSERT INTO #mountsPerMA
SELECT DISTINCT COALESCE(C.MaId,D.MaId,E.MaId),
	   C.mounts_hr,C.mounts_24hr,
	   D.max_streamshr,D.max_streams24hr,
	   E.reservations_hr,E.reservations_24hr
FROM
(
	 -- This gives the count of number of mounts in the last one and twenty four hours
	SELECT query2.MAId,query1.mounts_hr AS mounts_hr,query2.mounts_24hr AS mounts_24hr
	FROM
	(
		SELECT ClientId AS MAId, SUM(NumberOfMounts)/24.0 AS mounts_hr
		FROM MMDriveHistory d WITH (READUNCOMMITTED)
		WHERE TimeStart > @OneHourAgo
		GROUP BY ClientId
	)query1 RIGHT JOIN
	(
		SELECT ClientId AS MAId,SUM(NumberOfMounts)/24.0 AS mounts_24hr
		FROM MMDriveHistory d WITH (READUNCOMMITTED)
		WHERE TimeStart > @24HoursAgo
		GROUP BY ClientId
	)query2 ON query1.MAId = query2.MAId
)C  FULL OUTER JOIN
(
	-- To obtain the maximum number of streams transferred
	SELECT MAX(isnull(query1.counthr_ids,0))as max_streamshr,MAX(isnull(query.counthr_ids,0)) AS max_streams24hr, query.MaId
	FROM
	(
		SELECT RMTimeStamp/300 AS times,COUNT(DISTINCT h.StreamId) AS counthr_ids, ClientId AS MaId
		FROM jmjobresourcehistory AS h WITH (READUNCOMMITTED)
		WHERE RMTimeStamp > (@CUR_TIME-24*60*60)
		GROUP BY ClientId, RMTimeStamp/300
	) query LEFT JOIN
	(
		SELECT RMTimeStamp/300 AS times,COUNT(distinct h.StreamId) AS counthr_ids, ClientId AS MaId
		FROM jmjobresourcehistory  AS h WITH (READUNCOMMITTED)
		WHERE RMTimeStamp > (@CUR_TIME-60*60)
		GROUP BY ClientId, RMTimeStamp/300
	)query1 ON query.MaId = query1.MaId
	GROUP BY query.MaId
)D ON C.MAId = D.MaId FULL OUTER JOIN
(
	-- This query helps in obtaining the the number of reservations in per MA
	SELECT query3.MaId ,query2.noofreservations_hr AS reservations_hr, query3.noofreservations_24hr AS reservations_24hr
	FROM
	(
		SELECT a.id as MaId, a.displayName AS MediaAgent,query.noofreservations_hr AS noofreservations_hr
		FROM
		(
			SELECT clientid,COUNT(*) AS noofreservations_hr
			FROM jmjobresourcehistory  WITH (READUNCOMMITTED)
			WHERE ReservationTime > (@CUR_TIME-60*60)
			GROUP BY clientid
		)query,app_client a  WITH (READUNCOMMITTED)
		WHERE a.id = query.clientId
	)query2 RIGHT JOIN
	(
		SELECT a.id AS MaId, query.noofreservations_24hr AS noofreservations_24hr
		FROM
		(
			SELECT clientid,COUNT(*)/24.0 AS noofreservations_24hr
			FROM jmjobresourcehistory  WITH (READUNCOMMITTED)
			WHERE ReservationTime > (@CUR_TIME-24*60*60)
			GROUP BY clientid
		)query,app_client a  WITH (READUNCOMMITTED)
		where a.id = query.clientId
	) query3 ON query2.MaId = query3.MaId
)E ON E.MaId = D.MaId
ORDER BY  COALESCE(C.MaId,D.MaId,E.MaId)
IF @libOpt > 0
	DELETE FROM #mountsPerMA
	WHERE MaId NOT IN(SELECT ClientId FROM MMLibraryController WITH (READUNCOMMITTED) , @tblLibs  where t_libId = LibraryId)
INSERT INTO #tmpMAList
SELECT t.*,'','','','','','' from #mountsPerMA t
CREATE TABLE #perMAJobs
(
	MaId int,
	MediaAgent NVARCHAR(255),
    MediaAgentDisplayName NVARCHAR(255),
	avgJobsHr FLOAT(5) NULL,
	avgJobsDay FLOAT(5) NULL,
	BkpHr FLOAT(5) NULL,
	BkpDay FLOAT(5) NULL,
)
INSERT INTO #perMAJobs
SELECT DISTINCT COALESCE(A.MaId,B.MaId),
        COALESCE(A.MediaAgent,B.MediaAgent), COALESCE(A.MediaAgentDisplayName,B.MediaAgentDisplayName),
	   A.count_of_jobs_hr,A.count_of_jobs_24hr,
	   B.bytes_per_hr,B.bytes_per_24hr
FROM
(
	-- This Select statement gets the count of jobs/hour in the last one and twenty four hours
    SELECT  ab.id as MaId, ab.displayName AS MediaAgent, ab.displayname AS MediaAgentDisplayName,
			query1.count_of_jobs_24hr AS count_of_jobs_24hr ,
			query2.count_of_jobs_1hr AS count_of_jobs_hr
	FROM
	(
		SELECT COUNT(DISTINCT b.JobId)/24.0 AS count_of_jobs_24hr, r.ClientId AS client1
    	FROM JMJobResourceHistory r WITH (READUNCOMMITTED) INNER JOIN JMBkpStats b  WITH (READUNCOMMITTED)
		ON b.JobId = r.JobId AND b.CommcellId = r.CommcellId
		WHERE (b.servEndDate > ( @CUR_TIME-24*60*60))
		GROUP BY r.ClientId
	) query1 LEFT JOIN
    (
		SELECT COUNT(DISTINCT b.JobId) AS count_of_jobs_1hr, r.ClientId AS client2
    	FROM JMJobResourceHistory r WITH (READUNCOMMITTED) INNER JOIN JMBkpStats b  WITH (READUNCOMMITTED)
		ON b.JobId = r.JobId AND b.CommcellId = r.CommcellId
		WHERE (b.servEndDate > ( @CUR_TIME-60*60))
		GROUP BY r.ClientId
	 ) query2 ON query1.client1 = query2.client2,
	 app_client ab
	WHERE ab.id = query1.client1
) A FULL OUTER JOIN
(
	-- This Select is for obtaining the amount of GB transferred
    SELECT ad.id as MaId, ad.displayName AS MediaAgent, ad.displayname AS MediaAgentDisplayName,
		   query1.bytes_per_24hr AS bytes_per_24hr,
		   query2.bytes_per_hr AS bytes_per_hr
	FROM
    (
		SELECT ClientId,(SUM(totalUncompBytes)*60.0*60/(1024*1024))/(24*1024) AS bytes_per_24hr
		FROM JMJobResourceHistory WITH (READUNCOMMITTED)
		WHERE (ReservationTime > ( @CUR_TIME-24*60*60))
		group by ClientId
	) query1 LEFT JOIN
	(
		SELECT ClientId,(SUM(totalUncompBytes)*60.0*60/(1024*1024))/1024 AS bytes_per_hr
		FROM JMJobResourceHistory WITH (READUNCOMMITTED)
		WHERE (ReservationTime > ( @CUR_TIME-60*60))
		group by ClientId
	) query2 ON query1.clientid = query2.clientid ,
	app_client ad
	WHERE ad.id = query1.clientid
) B ON A.MaId = B.MaId, app_client ae
ORDER BY  COALESCE(A.MaId ,B.MaId)
UPDATE #tmpMAList
SET avgJobsHr =J.avgJobsHr,
	avgJobsDay =J.avgJobsDay,
	BkpHr =J.BkpHr,
	BkpDay =J.BkpDay,
	MediaAgent = J.MediaAgent,
    MediaAgentDisplayName = J.MediaAgentDisplayName
FROM #perMAJobs J, #tmpMAList  T
WHERE J.MaId= T.MAId
--got all qualified media, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @libOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2049, 0, '#rptUserObjects'	-- 2049 = LIBRARY_ITEM
	DELETE #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR clientId <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0
	DELETE #tmpMAList
	WHERE MaId NOT IN(SELECT LC.ClientId FROM MMLibraryController AS LC WITH (READUNCOMMITTED) ,#rptUserObjects AS R where R.LibraryId = LC.LibraryId OR R.LibraryId =0)
	DROP TABLE #rptUserObjects
END
SELECT * FROM #tmpMAList
DROP TABLE #mountsPerMA
DROP TABLE #perMAJobs
DROP TABLE #tmpMAList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptMAPerformance')
	delete from GxQscripts where name = 'RptMAPerformance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMAPerformance')
	delete from GXDBVersions where aliasname = 'RptMAPerformance'
GO

insert into GXDBVersions values(2, 'RptMAPerformance',  '00010013003600060000', 'RptMAPerformance', '00010013003600060000')
GO

