

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptLogMonitoringSummary.sp] ---------- 

--ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptLogMonitoringSummary.sp,v $ $Id: RptLogMonitoringSummary.sp,v 1.11.88.3 2018/11/18 03:50:58 skatz Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RptLogMonitoringGetCountFileClient()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        Muath Ali  Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptLogMonitoringSummary')
BEGIN
	print '>>> Drop Stored Procedure: RptLogMonitoringSummary <<<'
	drop procedure RptLogMonitoringSummary
END
IF EXISTS (select * from GxQscripts where name='RptLogMonitoringSummary')
	delete from GxQscripts where name = 'RptLogMonitoringSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLogMonitoringSummary')
	delete from GXDBVersions where aliasname = 'RptLogMonitoringSummary'
GO
print '... Creating Procedure: RptLogMonitoringSummary'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptLogMonitoringSummary
  @i_jobId integer
AS
  DECLARE @monitorPolicyId integer;
  DECLARE @monitorPolicyName nvarchar(255);
  DECLARE @templateName nvarchar(255);
  DECLARE @criteriaId integer;
  DECLARE @severity integer;
  DECLARE @countline integer;
  DECLARE @criteriaName nvarchar(MAX);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @monitoropt       integer
DECLARE @criteriaopt       integer
DECLARE @clOpt               integer
DECLARE @groupByOpt          integer
DECLARE @svrInformation		integer
DECLARE @svrWarning		integer
DECLARE @svrError		integer
Declare @timeDiff integer
DECLARE @tblSeverity		TABLE (t_severity int)
DECLARE @tblClients		TABLE (t_clId int)
DECLARE @tblClients1		TABLE (t_clId int)
DECLARE @tblmonitorPolicy  TABLE(t_mid int,t_cid int)
DECLARE @tblcritera         TABLE (t_cid int)
DECLARE @startTime		integer
DECLARE @endTime		integer
DECLARE @jobStartTime   integer
DECLARE @tblLogMsgs	TABLE (
                    monitorPolicyId   integer,
					monitorPolicy	  nvarchar(255),
					templateName      nvarchar(255),
					criteriaId        integer,
					severity    integer,
					countline  integer,
					criteriaName  varchar(MAX)
					)
IF EXISTS (select * from sys.databases where name  = 'SRM')
BEGIN
    IF EXISTS (select * from SRM.dbo.sysobjects where id = object_id(N'[SRM].[dbo].[SRMLMFilteredMessages]') )
    BEGIN
SET @svrInformation	= dbo.GetOptionInt(619331572, @i_jobId, 0, 0)
SET @svrWarning	= dbo.GetOptionInt(1207748991, @i_jobId, 0, 0)
SET @svrError= dbo.GetOptionInt(821092823, @i_jobId, 0, 0)
SET @groupByOpt=dbo.GetOptionInt(52239626,@i_jobId,0,0)
		EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
		INSERT INTO @tblClients EXEC rptOptGetClientsForLM @i_jobId, @clOpt OUTPUT
		INSERT INTO @tblmonitorPolicy EXEC RptOptGetMonitoringPolicy @i_jobId, @monitorOpt OUTPUT
		INSERT INTO @tblcritera EXEC RptOptGetLogMonitoringCriteria @i_jobId, @criteriaOpt OUTPUT
		IF @svrInformation > 0
			INSERT INTO @tblSeverity VALUES(2)
		IF @svrWarning > 0
			INSERT INTO @tblSeverity VALUES(1)
		IF @svrError > 0
			INSERT INTO @tblSeverity VALUES(0)
		select @timeDiff=Bias from SchedTimeZone where TimeZoneID in (select attrVal from APP_ClientProp where componentNameId = 2 and attrName like 'timezone Id')
		if(@startTime!=0)
			set @startTime=@startTime+@timeDiff
		if(@endTime!=0)
			set @endTime=@endTime+@timeDiff
        select @jobStartTime= jobStartTime from JMJobInfo with (NOLOCK) where jobId=@i_jobId
		set @jobStartTime=@jobStartTime+@timeDiff
		-- joining selected rows from SRM..SRMFilteredMessages from other tables to get monitoring policy name, severity, criteria and returing number of matches per monitoring policy and criteria and j
if(@groupByOpt=19)
		begin
			INSERT INTO @tblLogMsgs
			select  MP.monitorPolicyId,MonitorPolicyName,templateName,criteria.criteriaId,severity,count(lineNum),criteriaXML
			from  App_criteria   criteria WITH (NOLOCK)
			JOIN Commserv..APP_MonitoringPolicy  MP WITH (NOLOCK)
			ON criteria.monitorPolicyId=MP.monitorPolicyId
			INNER JOIN APP_MonitorTemplateAssoc as MonitorTemplateAssoc
			ON Mp.monitorPolicyId=MonitorTemplateAssoc.monitorPolicyId
			INNER JOIN  APP_Template
			on MonitorTemplateAssoc.templateId = APP_Template.templateId
			LEFT OUTER JOIN (  --returning number of matches from SRM..SRMFMFiltered Messages
									select monitorPolicyId, criteriaId, lineNum
									from SRM..SRMLMLines WITH (NOLOCK)
									where criteriaId!=0
											AND ( @startTime=0 Or dbo.GetUnixTime(processedTime) >@startTime)
											and (@endTime=0 or dbo.GetUnixTime(processedTime) <@endTime)
											and  (monitorPolicyId IN (select t_mid from @tblmonitorPolicy where t_cid=0 or criteriaId=t_cid))
											AND (@criteriaopt=0 OR criteriaId  not IN (select * from @tblcritera))
											AND (@clOpt=0 OR clientId  IN (select * from @tblClients))
											AND (dbo.GetUnixTime(processedTime)<=@jobStartTime))
								as fm
			ON fm.monitorPolicyId=MP.monitorPolicyId and fm.criteriaId=criteria.criteriaId
			where severity IN (select * from @tblSeverity)
				  AND ( Mp.monitorPolicyId IN (select t_mid from @tblmonitorPolicy))
				AND (@criteriaopt=0 OR  criteria.criteriaId not IN (select * from @tblcritera))
			  --AND (@clOpt=0 OR APP_Client.id in(select * from @tblClients)
	 	 GROUP BY  criteria.severity,MP.MonitorPolicyName,MP.monitorPolicyId,criteria.criteriaId,criteriaXML,templateName
		 select *
		 from @tblLogMsgs
		 where monitorPolicyId in (select t_mid
									from @tblmonitorPolicy
									where t_cid=0 or criteriaId=t_cid) and (@criteriaopt=0 OR criteriaId  not IN (select * from @tblcritera))
	     Order by severity,monitorPolicyId,criteriaId,countline
	end
	else
	begin
         declare @flag integer =0
	 	 select @flag=flags from @tblmonitorPolicy join APP_MonitorAssocEntity on monitorPolicyId=t_mid where flags=2
	 	 if(@flag=2)
			 insert into @tblClients1
			select distinct id from APP_Client where (@clOpt=0 or id  IN(select * from @tblClients))
		 else
		 begin
			insert into @tblClients1
			select id
			from APP_Client WITH (NOLOCK)
		 	where Id  in (select clientId from APP_MonitorAssocEntity MAE join @tblmonitorPolicy on t_mid =MAE.monitorPolicyId
						  union
						  select CGA.clientId
						  from APP_MonitorAssocEntity MAE
						  join @tblmonitorPolicy
						  on t_mid =MAE.monitorPolicyId
		          	      join APP_ClientGroupAssoc CGA
		          	      on CGA.clientGroupId=MAE.clientGroupId)
		          		  and (@clOpt=0 or id in (select * from @tblClients))
  	    end
		INSERT INTO @tblLogMsgs
		select C.id,C.displayName,' ',0,0,countLine=count(lineNum),fm.filePath
	    from (  --returning number of matches from SRM..SRMFMFiltered Messages
			   select Lines.clientId,Lines.lineNum,filePath
			   from SRM..SRMLMFiles WITH (NOLOCK)
			   join ( select monitorPolicyId,clientId, clientFileId,lineNum
			          from SRM..SRMLMLines WITH (NOLOCK)
					  where ( @startTime=0 Or dbo.GetUnixTime(processedTime) >@startTime)
						 and (@endTime=0 or dbo.GetUnixTime(processedTime)<@endTime)
					     and  (monitorPolicyId IN (select t_mid from @tblmonitorPolicy where t_cid=0 or criteriaId=t_cid))
						 AND (@clOpt=0 OR clientId IN (select * from @tblClients))
						 AND (dbo.GetUnixTime(processedTime)<=@jobStartTime)
					     and criteriaId in  (select criteriaId
											 from APP_Criteria
										    wherE severity in (select * from @tblSeverity)
								                 and (@criteriaopt=0 OR  criteriaId not IN (select * from @tblcritera)))
				    )as Lines
				on Lines.clientId=SRM..SRMLMFiles.clientId
				   and Lines.clientFileId=SRM..SRMLMFiles.clientFileId
		 		   and Lines.monitorPolicyId=SRM..SRMLMFiles.monitorPolicyId)
			   as fm
	  FULL OUTER JOIN APP_Client as C  WITH (NOLOCK)
      ON fm.clientId=C.id
	  where  C.id!=1
		    AND id in(select * from @tblClients1)
	  GROUP BY  C.id,C.displayName, fm.filePath
	  order by countLine
	 select *
	 from @tblLogMsgs
	 order by severity,monitorPolicyId,criteriaId,countline
	end
	SET NOCOUNT OFF
	END
END

IF EXISTS (select * from GxQscripts where name = 'RptLogMonitoringSummary')
	delete from GxQscripts where name = 'RptLogMonitoringSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLogMonitoringSummary')
	delete from GXDBVersions where aliasname = 'RptLogMonitoringSummary'
GO

insert into GXDBVersions values(2, 'RptLogMonitoringSummary',  '00010011008800030000', 'RptLogMonitoringSummary', '00010011008800030000')
GO

