

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptLogMonitoringGetLines.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptLogMonitoringGetLines')
BEGIN
	print '>>> Drop Stored Procedure: RptLogMonitoringGetLines <<<'
	drop procedure RptLogMonitoringGetLines
END
IF EXISTS (select * from GxQscripts where name='RptLogMonitoringGetLines')
	delete from GxQscripts where name = 'RptLogMonitoringGetLines'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLogMonitoringGetLines')
	delete from GXDBVersions where aliasname = 'RptLogMonitoringGetLines'
GO
print '... Creating Procedure: RptLogMonitoringGetLines'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptLogMonitoringGetLines
  @i_jobId integer
AS
  DECLARE @monitorPolicyId integer;
  DECLARE @criteriaId integer;
  DECLARE @clientId integer;
  DECLARE @clientName nvarchar(255);
  DECLARE @FileId integer;
  DECLARE @filePath nvarchar(1024);
  DECLARE @lNum integer;
  DECLARE @processedTime integer;
  DECLARE @severity integer;
  DECLARE @monitorPolicyName nvarchar(255);
  DECLARE @text nvarchar(MAX);
  DECLARE @criteriaXML nvarchar(MAX);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @monitoropt       	integer
DECLARE @criteriaopt       	integer
DECLARE @clOpt               	integer
DECLARE @svrInformation		integer
DECLARE @svrWarning		integer
DECLARE @svrError		integer
DECLARE @groupByOpt          integer
Declare @timeDiff integer
DECLARE @jobStartTime   integer
DECLARE @tblSeverity		TABLE (t_severity int)
DECLARE @tblClients		TABLE (t_clId int)
DECLARE @tblmonitorPolicy  	TABLE(t_mid int,t_cid int)
DECLARE @tblcritera         	TABLE (t_cid int)
DECLARE @tblTemplateDelim       table (T_mpid int,delim nvarchar(max), sdelim nvarchar(max))
DECLARE @startTime		integer
DECLARE @endTime		integer
DECLARE @outputType  integer
IF OBJECT_ID('tempdb..#tempLine') IS NOT NULL
    DROP TABLE #tempLine
create table #tempLine (monitorPolicyId int ,criteriaId int,clientId int,clientFileId int,lineNum int,text nvarchar(max),processedTime datetime)
IF OBJECT_ID('tempdb..#tempFilteredMessage') IS NOT NULL
    DROP TABLE #tempFilteredMessage
create table #tempFilteredMessage (monitorPolicyId int ,criteriaId int,clientId int,clientFileId int,lineNum int,position nvarchar(1024))
IF EXISTS (select * from sys.databases where name  = 'SRM')
BEGIN
    IF EXISTS (select * from SRM.dbo.sysobjects where id = object_id(N'[SRM].[dbo].[SRMLMLines]') ) AND
       EXISTS (select * from SRM.dbo.sysobjects where id = object_id(N'[SRM].[dbo].[SRMLMFilteredMessages]') )
    BEGIN
set @outputType= dbo.GetOptionInt(1310074675,@i_jobId,0,0)
		if(@outputType=2)  --for text reports no nedd to mark
		  set @outputType=1
		else
		   set @outputType=0
SET @svrInformation	= dbo.GetOptionInt(619331572, @i_jobId, 0, 0)
SET @svrWarning	= dbo.GetOptionInt(1207748991, @i_jobId, 0, 0)
SET @svrError= dbo.GetOptionInt(821092823, @i_jobId, 0, 0)
		EXEC RptOptGetTime @i_jobId, @startTime OUTPUT,@endTime OUTPUT
		INSERT INTO @tblClients EXEC rptOptGetClientsForLM @i_jobId, @clOpt OUTPUT
		INSERT INTO @tblmonitorPolicy EXEC RptOptGetMonitoringPolicy @i_jobId, @monitorOpt OUTPUT
		INSERT INTO @tblcritera EXEC RptOptGetLogMonitoringCriteria @i_jobId, @criteriaOpt OUTPUT
	    INSERT into @tblTemplateDelim
			select t_mid,delim,sdelim from @tblmonitorPolicy cross apply dbo.TemplateDelim(t_mid)
		IF @svrInformation > 0
			INSERT INTO @tblSeverity VALUES(2)
		IF @svrWarning > 0
			INSERT INTO @tblSeverity VALUES(1)
		IF @svrError > 0
			INSERT INTO @tblSeverity VALUES(0)
		--returing lines , processed time, file path and client as per selection.
		SELECT @timeDIFf=Bias FROM SchedTimeZone WHERE TimeZoneID in (SELECT attrVal FROM APP_ClientProp WHERE componentNameId = 2 and attrName like 'timezone Id')
		IF(@startTime!=0)
			SET @startTime=@startTime+@timeDIFf
		IF(@ENDTime!=0)
			SET @ENDTime=@ENDTime+@timeDIFf
		select @jobStartTime= jobStartTime from JMJobInfo with (NOLOCK) where jobId=@i_jobId
		set @jobStartTime=@jobStartTime+@timeDiff
		CREATE  INDEX temp_line on #tempLine (clientId,monitorPolicyId,criteriaId,clientFileId,lineNum)
									include (text,processedTime)
		CREATE  INDEX temp_FilteredMessage on #tempFilteredMessage (clientId,monitorPolicyId,criteriaId,clientFileId,lineNum)
									include (position)
--For text report type no highligt require..so no need to joining with filtered message table ( group by client , monitoring policy gives same result)
IF(@outputType=2)
		 BEGIN
			 DECLARE @countLine integer
			 DECLARE @upperLimit integer
			 SET @upperLimit =(SELECT value FROM GXGlobalParam WHERE name ='LMReportMaxLines' and modIFied=0)
			 IF(@upperLimit is NULL)
				SET @upperLimit=20000
			 SELECT @countLine=COUNT(*)
			 FROM SRM..SRMLMLines WITH  (NOLOCK)
			 WHERE (monitorPolicyId IN (SELECT t_mid FROM @tblmonitorPolicy WHERE t_cid=0 or criteriaId=t_cid))
			        AND (@clOpt=0 or clientId IN (SELECT * FROM @tblClients))
			        AND criteriaId<>0 and criteriaId in (SELECT criteriaId
								     FROM APP_Criteria WITH (NOLOCK)
								     WHERE severity in (SELECT * FROM @tblSeverity)
								and (@criteriaopt=0 OR  criteriaId  not IN (SELECT * FROM @tblcritera)))
                    AND ( @startTime=0 Or dbo.GetUnixTime(processedTime) >@startTime)
					AND (@ENDTime=0 or dbo.GetUnixTime(processedTime)<@ENDTime)
					AND (dbo.GetUnixTime(processedTime)<=@jobStartTime)
			IF(@countLine>@upperLimit)
				SELECT 0,0,0,'',0,'',0,0,0,'','','' --returning NULL SET
			ELSE
			BEGIN
				INSERT into #tempLine
				SELECT monitorPolicyId,criteriaId,clientId,clientFileId,lineNum,text,processedTime
				FROM SRM..SRMLMLines with  (NOLOCK)
				WHERE (monitorPolicyId IN (SELECT t_mid FROM @tblmonitorPolicy WHERE t_cid=0 or criteriaId=t_cid))
					AND (@clOpt=0 or clientId IN (SELECT * FROM @tblClients))
					AND criteriaId<>0 and criteriaId in  (SELECT criteriaId
									      FROM APP_Criteria WITH (NOLOCK)
									      WHERE severity in (SELECT * FROM @tblSeverity)
										and (@criteriaopt=0 OR  criteriaId  not IN (SELECT * FROM @tblcritera)))
					and ( @startTime=0 Or dbo.GetUnixTime(processedTime) >@startTime)
					and (@ENDTime=0 or dbo.GetUnixTime(processedTime)<@ENDTime)
					AND (dbo.GetUnixTime(processedTime)<=@jobStartTime)
				SELECT  lines.monitorPolicyId,lines.criteriaId,lines.clientId,name,lines.clientFileId,files.filePath,lines.lineNum,dbo.GetUnixTime(lines.processedTime),severity,MonitorPolicyName,text,criteriaXML
				FROM ( SELECT *  FROM #tempLine )as lines
				join (SELECT *
					  FROM SRM..SRMLMFiles
					  WITH (NOLOCK)
					  WHERE (@clOpt=0 OR clientId IN (SELECT * FROM @tblClients))
						 AND monitorPolicyId IN (SELECT t_mid  FROM @tblmonitorPolicy))
			      as files
				ON lines.monitorPolicyId=Files.monitorPolicyId
					AND lines.clientId=Files.clientId
					and lines.clientFileId=Files.clientFileId
				join (SELECT Mp.monitorPolicyId,criteriaId,criteriaXml,monitorPolicyName,severity
			 	  FROM APP_MonitoringPolicy as Mp
			 	  join APP_Criteria
			 	  on Mp.monitorPolicyId=APP_criteria.monitorPolicyId
				  WHERE (Mp.monitorPolicyId IN (SELECT t_mid FROM @tblmonitorPolicy WHERE t_cid=0 or criteriaId=t_cid))
						   and criteriaId in  (SELECT criteriaId
								       FROM APP_Criteria
	 							       WHERE severity in (SELECT * FROM @tblSeverity)
									and (@criteriaopt=0 OR  criteriaId not IN (SELECT * FROM @tblcritera))))
	        as MonitorPolicyInfo
	        on MonitorPolicyInfo.monitorPolicyId=lines.monitorPolicyId
				and lines.criteriaId=MonitorPolicyInfo.criteriaId
		    join ( SELECT id,displayName as name
				   FROM APP_Client
				   WHERE (@clOpt=0 OR id IN (SELECT * FROM @tblClients)))
				   as client
		    on lines.clientId=client.Id
			order by lines.clientId,files.filePath,lines.monitorPolicyId,lines.criteriaId,lines.lineNum
	    END
    END
    ELSE
    BEGIN
        insert into #tempLine
		SELECT monitorPolicyId,criteriaId,clientId,clientFileId,lineNum,text,processedTime
				FROM SRM..SRMLMLines with  (NOLOCK)
				WHERE (monitorPolicyId IN (SELECT t_mid FROM @tblmonitorPolicy WHERE t_cid=0 or criteriaId=t_cid))
					AND (@clOpt=0 or clientId IN (SELECT * FROM @tblClients))
					AND criteriaId<>0 and criteriaId in  (SELECT criteriaId
									      FROM APP_Criteria WITH (NOLOCK)
									      WHERE severity in (SELECT * FROM @tblSeverity)
										     and (@criteriaopt=0 OR  criteriaId  not IN (SELECT * FROM @tblcritera)))
										   	and ( @startTime=0 Or dbo.GetUnixTime(processedTime) >@startTime)
											AND (dbo.GetUnixTime(processedTime)<=@jobStartTime)
					and (@ENDTime=0 or dbo.GetUnixTime(processedTime)<@ENDTime)
insert into #tempFilteredMessage
		SELECT monitorPolicyId,criteriaId,clientId,clientFileId,lineNum,position
				FROM SRM..SRMLMFilteredMessages with  (NOLOCK)
				WHERE (monitorPolicyId IN (SELECT t_mid FROM @tblmonitorPolicy WHERE t_cid=0 or criteriaId=t_cid))
					AND (@clOpt=0 or clientId IN (SELECT * FROM @tblClients))
					AND criteriaId<>0 and criteriaId in  (SELECT criteriaId
															FROM APP_Criteria WITH (NOLOCK)
															WHERE severity in (SELECT * FROM @tblSeverity)
																and (@criteriaopt=0 OR  criteriaId  not IN (SELECT * FROM @tblcritera)))
IF(@groupByOpt=19)
		BEGIN
			SELECT  lines.monitorPolicyId,lines.criteriaId,lines.clientId,name,lines.clientFileId,files.filePath,lines.lineNum,dbo.GetUnixTime(lines.processedTime),-1,'0',text = dbo.LMAddMarkTag(lines.text,filteredMessage.position,delim,sdelim,0),'0'
		    FROM (select * from #tempFilteredMessage)as filteredMessage
		  join (SELECT *
				  FROM SRM..SRMLMFiles WITH (NOLOCK)
				  WHERE (@clOpt=0 OR clientId IN (SELECT * FROM @tblClients))
						 and  monitorPolicyId IN (SELECT t_mid FROM @tblmonitorPolicy))as files
		   on filteredMessage.monitorPolicyId=Files.monitorPolicyId
			  and filteredMessage.clientId=Files.clientId
			  and filteredMessage.clientFileId=Files.clientFileId
	 	  JOIN @tblTemplateDelim
	 	  on filteredMessage.monitorPolicyId=T_mpid
		  join (SELECT *  FROM #tempLine)
				as lines
		  on lines.clientId=filteredMessage.clientId
		 	 and lines.monitorPolicyId=filteredMessage.monitorPolicyId
			 and lines.criteriaId=filteredMessage.criteriaId
			 and  lines.clientFileId=filteredMessage.clientFileId
			 and lines.lineNum=filteredMessage.lineNum
		  join ( SELECT id, displayName as name FROM APP_Client WHERE (@clOpt=0 OR id IN (SELECT * FROM @tblClients)))as client
		  on lines.clientId=client.Id
		  order by lines.monitorPolicyId, lines.criteriaId,lines.clientId,files.filePath,lines.lineNum
	 END
	 else
	 BEGIN
		SELECT    lines.monitorPolicyId,lines.criteriaId,lines.clientId,name,lines.clientFileId,files.filePath,lines.lineNum,dbo.GetUnixTime(lines.processedTime),severity,MonitorPolicyName,text = dbo.LMAddMarkTag(lines.text,filteredMessage.position,delim,sdelim,0),criteriaXML
		FROM ( SELECT *  FROM #tempLine )as lines
		join (select * from #tempFilteredMessage)as filteredMessage
		 on lines.clientId=filteredMessage.clientId
			and lines.monitorPolicyId=filteredMessage.monitorPolicyId
			and lines.criteriaId=filteredMessage.criteriaId
			and  lines.clientFileId=filteredMessage.clientFileId
			and lines.lineNum=filteredMessage.lineNum
		join (SELECT *
			  FROM SRM..SRMLMFiles WITH (NOLOCK)
			  WHERE (@clOpt=0 OR clientId IN (SELECT * FROM @tblClients))
					 and   monitorPolicyId IN (SELECT t_mid  FROM @tblmonitorPolicy))as files
		ON lines.monitorPolicyId=Files.monitorPolicyId
		   and lines.clientId=Files.clientId
		   and lines.clientFileId=Files.clientFileId
		JOIN @tblTemplateDelim
		on lines.monitorPolicyId=T_mpid
		join (SELECT Mp.monitorPolicyId,criteriaId,criteriaXml,monitorPolicyName,severity
			  FROM APP_MonitoringPolicy as Mp join APP_Criteria on Mp.monitorPolicyId=APP_criteria.monitorPolicyId
			  WHERE(Mp.monitorPolicyId IN (SELECT t_mid FROM @tblmonitorPolicy WHERE t_cid=0 or criteriaId=t_cid))
					and criteriaId in  (SELECT criteriaId
										FROM APP_Criteria
										WHERE severity in (SELECT * FROM @tblSeverity)
					and (@criteriaopt=0 OR  criteriaId not IN (SELECT * FROM @tblcritera)))
			 )as MonitorPolicyInfo
	   on MonitorPolicyInfo.monitorPolicyId=lines.monitorPolicyId
	   and lines.criteriaId=MonitorPolicyInfo.criteriaId
	   join ( SELECT id,displayName as name FROM APP_Client WHERE (@clOpt=0 OR id IN (SELECT * FROM @tblClients)))as client
	   on lines.clientId=client.Id
	   order by lines.clientId,files.filePath,lines.monitorPolicyId,lines.criteriaId,lines.lineNum --not ordering by severity
	 END
  END
SET NOCOUNT OFF
END
END
DROP TABLE #tempLine
drop table #tempFilteredMessage

IF EXISTS (select * from GxQscripts where name = 'RptLogMonitoringGetLines')
	delete from GxQscripts where name = 'RptLogMonitoringGetLines'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLogMonitoringGetLines')
	delete from GXDBVersions where aliasname = 'RptLogMonitoringGetLines'
GO

insert into GXDBVersions values(2, 'RptLogMonitoringGetLines',  '00000000000000000000', 'RptLogMonitoringGetLines', '00000000000000000000')
GO

