

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptLogMonitoringGetCountFileClient.sp] ---------- 

--ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptLogMonitoringGetCountFileClient.sp,v $ $Id: RptLogMonitoringGetCountFileClient.sp,v 1.10.88.2 2018/03/22 03:02:23 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: RptLogMonitoringGetCountFileClient()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        Muath Ali  Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptLogMonitoringGetCountFileClient <<<'

IF EXISTS (select * from sysobjects where name='RptLogMonitoringGetCountFileClient')
	drop procedure RptLogMonitoringGetCountFileClient
IF EXISTS (select * from GxQscripts where name='RptLogMonitoringGetCountFileClient')
	delete from GxQscripts where name = 'RptLogMonitoringGetCountFileClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLogMonitoringGetCountFileClient')
	delete from GXDBVersions where aliasname = 'RptLogMonitoringGetCountFileClient'
GO
print '... Creating Procedure: RptLogMonitoringGetCountFileClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptLogMonitoringGetCountFileClient
  @i_jobId integer
AS
  DECLARE @monitorPolicyId integer;
  DECLARE @criteriaId integer;
  DECLARE @clientId integer;
  DECLARE @filePath nvarchar(1024);
  DECLARE @countLine integer;
  DECLARE @countFile integer;
  DECLARE @countLine_client integer;
  DECLARE @severity integer;
  DECLARE @clientName nvarchar(255);
  DECLARE @criteriaName nvarchar(max);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @monitoropt       	integer
DECLARE @criteriaopt      	integer
DECLARE @clOpt            	integer
DECLARE @svrInformation		integer
DECLARE @svrWarning		integer
DECLARE @svrError		integer
DECLARE @groupByOpt integer
Declare @timeDiff integer
DECLARE @tblSeverity		TABLE (t_severity int)
DECLARE @tblClients		TABLE (t_clId int)
DECLARE @tblmonitorPolicy  	TABLE(t_mid int,t_cid int)
DECLARE @tblcritera         	TABLE (t_cid int)
DECLARE @tblFile 		TABLE(t_mid int, t_cid int, t_clientId int , t_filePath nvarchar(1024), t_countLine int)
DECLARE @tbl_temp_count 	TABLE( temp_mid int, temp_cid int,temp_clientId int, temp_countfile int , temp_countline_client int, temp_clientname nvarchar(1024),temp_filePath nvarchar(2048))
DECLARE @startTime		integer
DECLARE @endTime		integer
DECLARE @jobStartTime   integer
IF EXISTS (select * from sys.databases where name  = 'SRM')
BEGIN
    IF EXISTS (select * from SRM.dbo.sysobjects where id = object_id(N'[SRM].[dbo].[SRMLMFilteredMessages]') )
    BEGIN
SET @svrInformation	= dbo.GetOptionInt(619331572, @i_jobId, 0, 0)
SET @svrWarning	= dbo.GetOptionInt(1207748991, @i_jobId, 0, 0)
SET @svrError= dbo.GetOptionInt(821092823, @i_jobId, 0, 0)
SET @groupByOpt=dbo.GetOptionInt(52239626,@i_jobId,0,0)
		EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
		INSERT INTO @tblClients EXEC rptOptGetClientsForLM @i_jobId, @clOpt OUTPUT
		INSERT INTO @tblmonitorPolicy EXEC RptOptGetMonitoringPolicy @i_jobId, @monitorOpt OUTPUT
		INSERT INTO @tblcritera EXEC RptOptGetLogMonitoringCriteria @i_jobId, @criteriaOpt OUTPUT
		select @timeDiff=Bias from SchedTimeZone where TimeZoneID in (select attrVal from APP_ClientProp where componentNameId = 2 and attrName like 'timezone Id')
		if(@startTime!=0)
			set @startTime=@startTime+@timeDiff
		if(@endTime!=0)
			set @endTime=@endTime+@timeDiff
		select @jobStartTime= jobStartTime from JMJobInfo with (NOLOCK) where jobId=@i_jobId
		set @jobStartTime=@jobStartTime+@timeDiff
		IF @svrInformation > 0
			INSERT INTO @tblSeverity VALUES(2)
		IF @svrWarning > 0
			INSERT INTO @tblSeverity VALUES(1)
		IF @svrError > 0
			INSERT INTO @tblSeverity VALUES(0)
		--returning count per file, client,criteria,monitoring policy
if(@groupByOpt=19)
		begin
			insert into @tblFile
			select lines.monitorPolicyId,lines.criteriaId,lines.clientId,files.filePath,count_Line_file=COUNT(*)
			from (( select * from SRM..SRMLMFiles WITH(NOLOCK)  where  monitorPolicyId IN (select t_mid from @tblmonitorPolicy)
			                                      and  (@clOpt=0 OR clientId IN (select * from @tblClients)))
			       as files
			       JOIN (select monitorPolicyId,criteriaId,clientFileId,clientId,lineNum from SRM..SRMLMLines WITH (NOLOCK)
			             where ( @startTime=0 Or dbo.GetUnixTime(processedTime) >@startTime)
			                   and (@endTime=0 or dbo.GetUnixTime(processedTime) <@endTime)
							   AND (dbo.GetUnixTime(processedTime)<=@jobStartTime)
			                   and  (monitorPolicyId IN (select t_mid from @tblmonitorPolicy where t_cid=0 or criteriaId=t_cid))
			                   and criteriaId in  (select criteriaId from APP_Criteria WITH(NOLOCK)
																		where severity in (select * from @tblSeverity)
																		and (@criteriaopt=0 OR  criteriaId not IN (select * from @tblcritera)))
                               and criteriaId!=0
                               ) as Lines
			     on files.monitorPolicyId=Lines.monitorPolicyId and files.clientFileId=Lines.clientFileId and files.clientId=Lines.clientId )
			group by lines.monitorPolicyId ,lines.criteriaId,lines.clientId,files.filePath
				--returing count per clients, and number of files which have any match occured.
			insert into @tbl_temp_count
			select t_mid,t_cid, t_clientId,count_file_client = COUNT(DISTINCT t_filePath),count_client=SUM(t_countLine),name,'\0'
			from @tblFile Join CommServ..APP_Client ON t_clientId=id
			group by t_mid,t_cid,t_clientId,name
		--merging both above selections
           select t_mid,t_cid,t_clientId,t_filePath,t_countLine,temp_countfile,temp_countline_client,-1,temp_clientname,'0' from @tblFile Join @tbl_temp_count ON t_mid = temp_mid AND t_cid=temp_cid AND t_clientId=temp_clientId
           order by t_mid,t_cid,t_clientId,t_filePath,t_countLine
         end
         --group by client
         else
          begin
          insert into @tblFile
			select lines.monitorPolicyId,lines.criteriaId,lines.clientId,files.filePath,count_Line_file=COUNT(*)
			from (( select * from SRM..SRMLMFiles WITH(NOLOCK)  where ( monitorPolicyId IN (select t_mid from @tblmonitorPolicy))
			                                      and  (@clOpt=0 OR clientId IN (select * from @tblClients)))
			         as files
			         JOIN (select monitorPolicyId,criteriaId,clientFileId,clientId,lineNum from SRM..SRMLMLines WITH (NOLOCK)
			             where ( @startTime=0 Or dbo.GetUnixTime(processedTime) >@startTime)
			                  and (@endTime=0 or dbo.GetUnixTime(processedTime) <@endTime)
							  AND (dbo.GetUnixTime(processedTime)<=@jobStartTime)
			                   and (monitorPolicyId IN (select t_mid from @tblmonitorPolicy where t_cid=0 or criteriaId=t_cid))
			                   and criteriaId in  (select criteriaId from APP_Criteria WITH(NOLOCK)
																		where severity in (select * from @tblSeverity)
																		and (@criteriaopt=0 OR  criteriaId not IN (select * from @tblcritera)))
								and criteriaId<>0
			                   ) as Lines
			     on files.monitorPolicyId=Lines.monitorPolicyId and files.clientFileId=Lines.clientFileId and files.clientId=Lines.clientId )
			group by  lines.clientId,files.filePath,lines.monitorPolicyId,lines.criteriaId
				--returing count per monitorPolicy , and number of criterias which have any match occured.
			insert into @tbl_temp_count
			select t_mid,0,t_clientId,count_file_client = COUNT(DISTINCT t_cid),count_client=SUM(t_countLine),MonitorPolicyName,t_filePath
			from @tblFile Join CommServ..APP_MonitoringPolicy ON t_mid=monitorPolicyId
			group by  t_clientId,t_filePath,t_mid,MonitorPolicyName
		--merging both above selections
	           select t_mid,t_cid,t_clientId,t_filePath,t_countLine,temp_countfile,temp_countline_client,severity,temp_clientname,criteriaXml from @tblFile Join @tbl_temp_count ON t_mid = temp_mid  AND t_clientId=temp_clientId and t_filePath = temp_filePath join APP_Criteria on t_mid=APP_Criteria.monitorPolicyId and t_cid=criteriaId
           order by t_clientId,t_filePath,t_mid,t_cid,t_countLine --not oredring by severity, ( all criterias in for a monitoring policy will come together)
        end
	END
END
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'RptLogMonitoringGetCountFileClient')
	delete from GxQscripts where name = 'RptLogMonitoringGetCountFileClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLogMonitoringGetCountFileClient')
	delete from GXDBVersions where aliasname = 'RptLogMonitoringGetCountFileClient'
GO

insert into GXDBVersions values(2, 'RptLogMonitoringGetCountFileClient',  '00010010008800020000', 'RptLogMonitoringGetCountFileClient', '00010010008800020000')
GO

