

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptLibNDrivePerformance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptLibNDrivePerformance.sp,v $ $Id: RptLibNDrivePerformance.sp,v 1.12.40.6 2018/03/22 03:02:20 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "rptLibNDrivePerformance"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptLibNDrivePerformance')
BEGIN
	print '>>> Drop Stored Procedure: rptLibNDrivePerformance <<<'
	drop procedure rptLibNDrivePerformance
END
IF EXISTS (select * from GxQscripts where name='rptLibNDrivePerformance')
	delete from GxQscripts where name = 'rptLibNDrivePerformance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptLibNDrivePerformance')
	delete from GXDBVersions where aliasname = 'rptLibNDrivePerformance'
GO
print '... Creating Procedure: rptLibNDrivePerformance'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptLibNDrivePerformance
  @i_jobId integer
AS
  DECLARE @o_libId integer;
  DECLARE @o_drivrId integer;
  DECLARE @o_libName char(255);
  DECLARE @o_driveName char(255);
  DECLARE @o_UsageHr char(255);
  DECLARE @o_UsageDay char(255);
  DECLARE @o_throughputGBHr char(255);
  DECLARE @o_throughputGBDay char(255);
  DECLARE @o_totBkpHr char(255);
  DECLARE @o_totBkpDay char(255);
  DECLARE @o_totRstHr char(255);
  DECLARE @o_totRstDay char(255);
  DECLARE @o_totErrHr char(255);
  DECLARE @o_totErrDay char(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId			integer
DECLARE @libOpt			integer
DECLARE @tblLibs		TABLE (t_libId int)
SET @userId		= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
INSERT INTO @tblLibs	EXEC rptOptGetObjectList @i_jobId, 412850839, @libOpt OUTPUT
IF object_id('tempdb.dbo.#tmpDriveList') is not null DROP TABLE #tmpDriveList
IF object_id('tempdb.dbo.#perDriveUsage') is not null DROP TABLE #perDriveUsage
IF object_id('tempdb.dbo.#perDriveBkp') is not null DROP TABLE #perDriveBkp
CREATE TABLE #tmpDriveList
(
	LibId	int,
	driveId	int,
LibName VARCHAR(255),
DriveName  VARCHAR(255),
DriveUsage_hr VARCHAR(255),
DriveUsage_24hr VARCHAR(255),
ThroughputGB_hr VARCHAR(255),
ThroughputGB_24hr VARCHAR(255),
Totalbackups_hr VARCHAR(255) NULL,
Totalbackups_24hr VARCHAR(255) NULL,
Totalrestores_hr VARCHAR(255) NULL,
Totalrestores_24hr VARCHAR(255) NULL,
Totalerrors_hr VARCHAR(255) NULL,
Totalerrors_24hr VARCHAR(255) NULL
)
CREATE TABLE #perDriveUsage
(	LibId int,
	driveId	int,
LibraryName VARCHAR(255),
DriveName  VARCHAR(255),
    DriveUsage_hr FLOAT(53),
	DriveUsage_24hr FLOAT(53),
	ThroughputGB_hr FLOAT(53),
	ThroughputGB_24hr FLOAT(53)
)
DECLARE @CUR_TIME INT
SET @CUR_TIME = dbo.GetUnixTime(GetUTCDate())
DECLARE @OneHourAgo DATETIME = DATEADD(HOUR, -1, GetUTCDate())
DECLARE @24HoursAgo DATETIME = DATEADD(HOUR, -24, GetUTCDate())
INSERT INTO #perDriveUsage
SELECT 	COALESCE(A.LibId ,B.LibId),
		COALESCE(A.driveId ,B.driveId),
		COALESCE(A.LibName,B.LibName),
        COALESCE(A.DrName,B.DrName),
		A.usage_hr,A.usage_24hr,
		B.Throughput_per_hr,B.Throughput_per_24hr
FROM
(
	-- This query give percentage of drive usage per hour and for twenty four hours
	SELECT l.LibraryId AS LibId,  l.AliasName AS LibName,d.AliasName AS DrName,
		   query3.id AS DriveId,query3.per_usage AS usage_24hr,
		   query4.per_usage AS usage_hr
	FROM
	(
		SELECT query1.DId AS id,
			   (query1.usage*100.0)/(24*3600) AS per_usage
		FROM
		(
			SELECT h.DriveId AS Did,
				   SUM(cast(DataWriteDurationSec as bigint) + cast(DataReadDurationSec as bigint)) AS usage
			FROM MMDriveHistory h WITH (READUNCOMMITTED)
			WHERE TimeStart > @24HoursAgo AND HistoryType = 2
			GROUP BY h.DriveId
		) query1, MMDrive d WITH (READUNCOMMITTED)
		WHERE query1.DId = d.DriveId
	)query3 LEFT JOIN
	(
		SELECT query2.DId AS id,
			   (query2.usage*100.0)/3600 AS per_usage
		FROM
		(
			SELECT h.DriveId AS Did,
					SUM(cast(DataWriteDurationSec as bigint) + cast(DataReadDurationSec as bigint)) AS usage
			FROM MMDriveHistory h WITH (READUNCOMMITTED)
			WHERE TimeStart > @OneHourAgo AND HistoryType = 2
			GROUP BY h.DriveId
		) query2, MMDrive d WITH (READUNCOMMITTED)
		WHERE query2.DId = d.DriveId
	)query4 ON query3.id = query4.id,MMDrive d WITH (READUNCOMMITTED),MMMasterPool m WITH (READUNCOMMITTED),MMLibrary l WITH (READUNCOMMITTED)
	WHERE query3.id = d.DriveId AND d.MasterPoolid = m.MasterPoolId AND m.Libraryid = l.LibraryId
)A FULL OUTER JOIN
(
	-- This gives the throughput of the drive in Giga Bytes Per Hour
	SELECT l.LibraryId AS LibId, l.AliasName AS LibName,d.AliasName AS DrName, query3.Drid AS DriveId,
		   query3.Throughput AS Throughput_per_24hr,
		   query4.Throughput AS Throughput_per_hr
	FROM
	(
		SELECT query1.Did AS Drid, (query1.total/(1024.0*24)) AS Throughput
		FROM
		(
			SELECT Driveid AS Did ,SUM(DataWritten+DataRead) AS total
			FROM mmdrivehistory WITH (READUNCOMMITTED)
			WHERE TimeStart > @24HoursAgo AND HistoryType = 2
			GROUP BY driveId
		)query1, MMDrive d WITH (READUNCOMMITTED)
		WHERE query1.Did = d.DriveId
	) query3 LEFT JOIN
	(
		SELECT query2.Did AS Drid, (query2.total/1024.0) AS Throughput
		FROM
		(
			SELECT Driveid AS Did,SUM(DataWritten+DataRead) AS total
			FROM mmdrivehistory WITH (READUNCOMMITTED)
			WHERE TimeStart > @OneHourAgo AND HistoryType = 2
			GROUP BY driveId
		) query2, MMDrive d WITH (READUNCOMMITTED)
		WHERE query2.Did = d.DriveId
	)query4 ON query3.Drid = query4.Drid ,MMDrive d WITH (READUNCOMMITTED),MMMasterPool m WITH (READUNCOMMITTED),MMLibrary l WITH (READUNCOMMITTED)
	WHERE d.DriveId =query3.Drid  AND d.MasterPoolid = m.MasterPoolId AND m.Libraryid = l.LibraryId
)B ON A.DriveId = B.DriveId
ORDER BY COALESCE(A.LibName,B.LibName),
        COALESCE(A.DrName,B.DrName)
-- get details like the total backups,restores and errors on a drive
CREATE TABLE #perDriveBkp ( LibId int,
							driveId int,
LibraryName VARCHAR(255),
DriveName  VARCHAR(255),
						Totalbackups_hr FLOAT NULL,
						Totalbackups_24hr FLOAT NULL,
						Totalrestores_hr FLOAT NULL,
						Totalrestores_24hr FLOAT NULL,
						Totalerrors_hr FLOAT NULL,
						Totalerrors_24hr FLOAT NULL)
INSERT INTO #perDriveBkp
SELECT  C.LibId,
		C.driveId,
		C.LibName,
        C.DrName,
		C.Totalbackups_hr, C.Totalbackups_24hr,
		C.Totalrestores_hr,C.Totalrestores_24hr,
		C.Totalerrors_hr,C.Totalerrors_24hr
FROM
(
	-- This query gives various other details like the total backups,restores and errors on a drive*/
	SELECT l.LibraryId AS LibId, l.AliasName AS LibName,d.AliasName AS DrName,query1.DriveId,
		   query1.Totalbackups_24hr,query2.Totalbackups_hr,
		   query1.Totalrestores_24hr,query2.Totalrestores_hr,
		   query1.Totalerrors_24hr,query2.Totalerrors_hr
	FROM
	(
		SELECT DriveId,SUM(NumberOfBackups) AS Totalbackups_24hr,
			           SUM(NumberOfRestores) AS Totalrestores_24hr,
					   SUM(NumberOfSoftErrors+NumberOfHardErrors) AS Totalerrors_24hr
		FROM MMDriveHistory WITH (READUNCOMMITTED)
		WHERE TimeStart > @24HoursAgo AND HistoryType = 2
		GROUP BY DriveId
	)query1 LEFT JOIN
	(
		SELECT DriveId,SUM(NumberOfBackups) AS Totalbackups_hr,
			           SUM(NumberOfRestores) AS Totalrestores_hr,
					   SUM(NumberOfSoftErrors+NumberOfHardErrors) AS Totalerrors_hr
		FROM MMDriveHistory WITH (READUNCOMMITTED)
		WHERE TimeStart > @OneHourAgo AND HistoryType = 2
		GROUP BY DriveId
	)query2 ON query1.DriveId = query2.DriveId,
	MMDrive d WITH (READUNCOMMITTED) ,MMMasterPool m WITH (READUNCOMMITTED) ,MMLibrary l WITH (READUNCOMMITTED)
	WHERE d.DriveId =query1.DriveId  AND d.MasterPoolid = m.MasterPoolId AND m.Libraryid = l.LibraryId
) C ORDER BY C.LibName,C.DrName
DECLARE @OneDayAgo BIGINT = dbo.getUnixTime(@24HoursAgo)
CREATE TABLE #tempDriveBkp (JobId int,LibraryId Int,servEndDate BigInt)
INSERT INTO #tempDriveBkp
select ACM.jobId, M.LibraryId, MAX(AC.createTime)
FROM MMMedia M WITH(NOLOCK)
       INNER JOIN MMVolume V WITH(NOLOCK) ON V.MediaId = M.MediaId
       INNER JOIN archChunk AC WITH(NOLOCK) ON V.VolumeId = AC.volumeId AND AC.createTime > @OneDayAgo
       INNER JOIN archChunkMapping ACM WITH(NOLOCK) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
GROUP BY ACM.jobId, M.LibraryId
UPDATE #perDriveBkp
SET  Totalbackups_24hr =  (select count(*) from (select T.jobid from #tempDriveBkp T where LibraryId = LibId group by T.JobId ) AS T1),
	 Totalbackups_hr =    (select count(*) from (select T.jobid from #tempDriveBkp T where LibraryId = LibId  AND servEndDate > dbo.getUnixTime(@OneHourAgo) group by T.JobId ) AS T2)
DROP TABLE #tempDriveBkp
IF @libOpt > 0
	DELETE FROM  #perDriveUsage
	WHERE  LibId NOT IN (select t_libId from @tblLibs)
INSERT INTO #tmpDriveList
SELECT t.LibId, t.driveId, t.LibraryName,t.DriveName,CAST(t.driveusage_hr as varchar(50)),CAST(t.driveusage_24hr as varchar(50)),CAST(t.throughputGB_hr as varchar(50)),CAST(t.throughputGB_24hr as varchar(50)),
'','','','','',''
FROM #perDriveUsage t
update #tmpDriveList
set Totalbackups_hr= cast(p.Totalbackups_hr as varchar(50)),
	Totalbackups_24hr=cast(p.Totalbackups_24hr as varchar(50)),
	Totalrestores_hr= cast(p.Totalrestores_hr as varchar(50)),
	Totalrestores_24hr =cast(p.Totalrestores_24hr as varchar(50)),
	Totalerrors_hr =cast(p.Totalerrors_hr as varchar(50)),
	Totalerrors_24hr=cast(p.Totalerrors_24hr as varchar(50))
from  #perDriveBkp p , #perDriveUsage n, #tmpDriveList d
where p.LibId = n.LibId and p.driveId =n.driveId
	and d.LibId= p.LibId and d.driveId =p.driveId
--got all qualified media, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @libOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2049, 0, '#rptUserObjects'	-- 2049 = LIBRARY_ITEM
	DELETE #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR clientId <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	DELETE #tmpDriveList
	WHERE NOT EXISTS (select * from #rptUserObjects where libraryId IN (0, libid))
	DROP TABLE #rptUserObjects
END
update #tmpDriveList set DriveName = c.MountPathName
from #tmpDriveList a, MMDrive b WITH (READUNCOMMITTED), MMS2getMountPathNameGUIView c WITH (READUNCOMMITTED)
where a.driveId = b.driveId
and b.mediaId = c.mediaId
SELECT * from #tmpDriveList
DROP TABLE #perDriveBkp
DROP TABLE #perDriveUsage
DROP TABLE #tmpDriveList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptLibNDrivePerformance')
	delete from GxQscripts where name = 'RptLibNDrivePerformance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLibNDrivePerformance')
	delete from GXDBVersions where aliasname = 'RptLibNDrivePerformance'
GO

insert into GXDBVersions values(2, 'RptLibNDrivePerformance',  '00010012004000060000', 'RptLibNDrivePerformance', '00010012004000060000')
GO

