

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptHealthCardSummary.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptHealthCardSummary.sp,v $ $Id: RptHealthCardSummary.sp,v 1.4.2.7 2017/01/20 23:01:37 bkharabe Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptHealthCardSummary <<<'

IF EXISTS (select * from sysobjects where name='RptHealthCardSummary')
	drop procedure RptHealthCardSummary
IF EXISTS (select * from GxQscripts where name='RptHealthCardSummary')
	delete from GxQscripts where name = 'RptHealthCardSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptHealthCardSummary')
	delete from GXDBVersions where aliasname = 'RptHealthCardSummary'
GO
print '... Creating Procedure: RptHealthCardSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptHealthCardSummary
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL
AS
BEGIN
SET NOCOUNT ON
IF object_id('tempdb.dbo.#HealthCheckTbl') is not null DROP TABLE #HealthCheckTbl
IF object_id('tempdb.dbo.#HealthGrpTbl') is not null DROP TABLE #HealthGrpTbl
CREATE TABLE #HealthCheckTbl
(
    CommServUniqueId INT NOT NULL,
    AsOf DATETIME NULL,
    CapacityPlanning VARCHAR(10) NULL,
    Client VARCHAR(10) NULL,
    CommCell VARCHAR(10) NULL,
    DeDuplication VARCHAR(10) NULL,
    IndexingAndSearch VARCHAR(10) NULL,
    Job VARCHAR(10) NULL,
    ScaleStatistics VARCHAR(10) NULL,
    UsageProfile VARCHAR(10) NULL
)
CREATE TABLE #HealthGrpTbl
(
    CommServUniqueId INT,
    GrpId INT,
    GrpName NVARCHAR(256),
    LogDate DATETIME,
    GrpHealthStatus VARCHAR(10)
)
DECLARE @CSUniqueId INT = 0
DECLARE @ErrorString NVARCHAR(MAX)
DECLARE @isPrivate INT = 0
SELECT	@isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF (@i_GroupId > 0)
	DECLARE SurveyResultCur
	CURSOR FOR
	SELECT ID FROM cf_CommcellIdNameMap c WITH (NOLOCK) INNER JOIN cf_CommCellGroupAssoc ca WITH (NOLOCK)
	ON c.ID = ca.CommcellIdNameMap_ID
	INNER JOIN dbo.cf_SurveyResultFuncV1(16, 0, 1, NULL, NULL, @i_UserId, @i_GroupId)AS RESULT ON
	c.ID = RESULT.CommServUniqueId
	and ca.CommCellGroupId = @i_GroupId
	AND (c.CommCellSurveyServices & 1) = 1
ELSE
	DECLARE SurveyResultCur
	CURSOR FOR
	SELECT ID FROM cf_CommcellIdNameMap c WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(16, 0, 1, NULL, NULL, @i_UserId, @i_GroupId)AS RESULT ON
	c.ID = RESULT.CommServUniqueId and (CommCellSurveyServices & 1) = 1
OPEN SurveyResultCur
FETCH FROM SurveyResultCur INTO @CSUniqueId
WHILE @@FETCH_STATUS = 0
BEGIN
	BEGIN TRY
		INSERT INTO #HealthCheckTbl(CommServUniqueId) VALUES (@CSUniqueId)
		DELETE FROM #HealthGrpTbl
		INSERT INTO #HealthGrpTbl
			SELECT
				CommServUniqueId,
				GroupId,
				GroupName,
				MAX(CASE WHEN LogDate IS NULL THEN '1969-01-01' ELSE LogDate END) ,
				CASE
					WHEN MAX(Status) = '2_Info' THEN MIN(Status)
					ELSE MAX(Status)
				END
			FROM RptGetServerHealthFunc(@CSUniqueId, @i_UserId, @i_GroupId, 0) AS hr
			GROUP BY CommServUniqueId, GroupId, GroupName
		UPDATE #HealthCheckTbl SET AsOf = LogDate FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 1 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET CommCell = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 1 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET Client = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 2 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET Job = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 3 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET DeDuplication = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 4 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET IndexingAndSearch = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 6 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET UsageProfile = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 13 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET CapacityPlanning = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 14 AND HC.CommServUniqueId = H.CommServUniqueId
		UPDATE #HealthCheckTbl SET ScaleStatistics = GrpHealthStatus FROM #HealthGrpTbl HC INNER JOIN #HealthCheckTbl H ON GrpId = 18 AND HC.CommServUniqueId = H.CommServUniqueId
	END TRY
	BEGIN CATCH
	
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

		DELETE FROM #HealthCheckTbl WHERE CommServUniqueId = @CSUniqueId
		SET @ErrorString = 'RptHealthCardSummary failed for CommServUniqueId [' + CAST(@CSUniqueId AS VARCHAR(20)) + '] with error :: ' + ERROR_MESSAGE()
		INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	END CATCH
    FETCH FROM SurveyResultCur INTO @CSUniqueId
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
SELECT
	CAST(HC.CommServUniqueId AS VARCHAR(10)) AS 'commCellId<DONOTSHOW>',
	dbo.ConvertBigIntToHexStr(ccMap.CommCellID) AS 'CommCell ID<HIDDEN>',
	CASE WHEN ISNULL(ccMap.DisplayName, '') <> '' THEN ccMap.DisplayName WHEN @isPrivate = 1 THEN ccMap.CommServName WHEN ccMap.CustomerName <> '' THEN ccMap.CustomerName + ' - ' + ccMap.CommServName ELSE ccMap.CommServName END AS 'CommCell Name<CC_DRILLDOWN>',
    HC.CommCell AS 'Configuration<DOT_STATUS>',
    HC.CapacityPlanning AS 'Capacity Planning<DOT_STATUS>',
    HC.Client AS 'Client<DOT_STATUS>',
    HC.Job AS 'Job<DOT_STATUS>',
    HC.DeDuplication AS 'DeDuplication<DOT_STATUS>',
    HC.IndexingAndSearch AS 'Indexing and Search<DOT_STATUS>',
    HC.ScaleStatistics AS 'Scale Statistics<DOT_STATUS>',
    DATEDIFF(s, '1970-01-01 00:00:00',HC.AsOf)  AS 'As Of<DATETIME>',
    HC.AsOf AS 'As_Of_Actual<ALTSORT><As Of><DONOTSHOW>'
FROM #HealthCheckTbl HC INNER JOIN cf_CommcellIdNameMap AS ccMap ON ccMap.ID = HC.CommServUniqueId
ORDER BY ccMap.CommServName
IF object_id('tempdb.dbo.#HealthCheckTbl') is not null DROP TABLE #HealthCheckTbl
IF object_id('tempdb.dbo.#HealthGrpTbl') is not null DROP TABLE #HealthGrpTbl
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'RptHealthCardSummary')
	delete from GxQscripts where name = 'RptHealthCardSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptHealthCardSummary')
	delete from GXDBVersions where aliasname = 'RptHealthCardSummary'
GO

insert into GXDBVersions values(2, 'RptHealthCardSummary',  '00010004000200070000', 'RptHealthCardSummary', '00010004000200070000')
GO

