

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetXMLJobOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetXMLJobOptions.sp,v $ $Id: RptGetXMLJobOptions.sp,v 1.1.2.4 2017/03/15 03:01:17 samrutkar Exp $";
-- =============================================
-- Author:		Sanket Amrutkar
-- Create date: 05/08/2016
-- Description:	Wrapper for GetXMLJobOptions
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetXMLJobOptions <<<'

IF EXISTS (select * from sysobjects where name='RptGetXMLJobOptions')
	drop procedure RptGetXMLJobOptions
IF EXISTS (select * from GxQscripts where name='RptGetXMLJobOptions')
	delete from GxQscripts where name = 'RptGetXMLJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetXMLJobOptions')
	delete from GXDBVersions where aliasname = 'RptGetXMLJobOptions'
GO
print '... Creating Procedure: RptGetXMLJobOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetXMLJobOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_jobId BIGINT,
  @i_commCellId BIGINT 
AS
  DECLARE @xmlValue XML
IF object_id('tempdb.dbo.#tmpJobOption') IS NOT NULL DROP TABLE #tmpJobOption
CREATE TABLE #tmpJobOption
(
	xmlValue XML
)
INSERT INTO #tmpJobOption (xmlValue) exec TM_GetXMLJobOptions  @i_jobId
SET @xmlValue=(SELECT top(1) xmlValue FROM #tmpJobOption)
-- OPTYPE  =  31 (ARCHIVECHECK Option) FOR DV JOBS WE WANT TO REMOVE SOME XML OPTIONS FOR THESE JOBS
IF ((select @xmlValue) IS NOT NULL)
BEGIN
IF EXISTS (SELECT * FROM JMAdminJobStatsTable (NOLOCK) WHERE jobId =@i_jobId AND opType =31 AND commCellId =@i_commCellId) OR EXISTS(SELECT * FROM JMAdminJobInfoTable  (NOLOCK) WHERE jobId =@i_jobId AND opType =31 AND commCellId =@i_commCellId)
BEGIN
	DECLARE @auxcopyJobOption XML = @xmlValue.query('(/TMMsg_JobOption/backupOpts/mediaOpt/auxcopyJobOption)[1]')
	DECLARE @archiveCheckOption XML =@xmlValue.query('(/TMMsg_JobOption/adminOpts/archiveCheckOption)[1]')
		SET @archiveCheckOption.modify('delete (/archiveCheckOption/@backupLevel)')
    SET @xmlValue.modify('delete (/TMMsg_JobOption/*)')
	SET @xmlValue.modify('insert  <backupOpts><mediaOpt/></backupOpts> into (/TMMsg_JobOption)[1]')
	SET @xmlValue.modify('insert sql:variable("@auxcopyJobOption") into (/TMMsg_JobOption/backupOpts/mediaOpt)[1]')
	SET @xmlValue.modify('insert <adminOpts/> into (/TMMsg_JobOption)[1]')
	SET @xmlValue.modify('insert sql:variable("@archiveCheckOption") into (/TMMsg_JobOption/adminOpts)[1]')
END
END
IF object_id('tempdb.dbo.#tmpJobOption') IS NOT NULL DROP TABLE #tmpJobOption
SELECT @xmlValue
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetXMLJobOptions')
	delete from GxQscripts where name = 'RptGetXMLJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetXMLJobOptions')
	delete from GXDBVersions where aliasname = 'RptGetXMLJobOptions'
GO

insert into GXDBVersions values(2, 'RptGetXMLJobOptions',  '00010001000200040000', 'RptGetXMLJobOptions', '00010001000200040000')
GO

