

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetUserOrGroupObject.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetUserOrGroupObject.sp,v $ $Id: RptGetUserOrGroupObject.sp,v 1.1.2.1 2019/10/09 07:16:09 jge Exp $";
--
--  +========================================================================+
--  |   Procedure:  RptGetUserOrGroupObject()
--  |
--  | Description:  Fetches a flattened list of objects the selected group or user has rights
--	|
--  |
--  |       Input:  userOrGroupId, nodeType, nodeId, outputTableArg, isUser
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetUserOrGroupObject')
BEGIN
	print '>>> Drop Stored Procedure: RptGetUserOrGroupObject <<<'
	drop procedure RptGetUserOrGroupObject
END
IF EXISTS (select * from GxQscripts where name='RptGetUserOrGroupObject')
	delete from GxQscripts where name = 'RptGetUserOrGroupObject'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetUserOrGroupObject')
	delete from GXDBVersions where aliasname = 'RptGetUserOrGroupObject'
GO
print '... Creating Procedure: RptGetUserOrGroupObject'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetUserOrGroupObject
  @userOrGroupId integer,
  @nodeType integer,
  @nodeId integer,
  @outputTableArg varchar(100),
  @isUser integer = 1
AS
SET NOCOUNT ON
if @isUser = 1
begin
	exec sec_getUserObjects @userOrGroupId, @nodeType, @nodeId, @outputTableArg
	return
end
IF OBJECT_ID ('tempdb.dbo.#RptGetUserOrGroupObjectResult') is not null
begin
	DROP TABLE #RptGetUserOrGroupObjectResult
end
create table  #RptGetUserOrGroupObjectResult ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
--#UserOrGroupIdTbl is the input table for sec_getUMEntityAssociations
IF OBJECT_ID ('tempdb.dbo.#UserOrGroupIdTbl') is not null
begin
	DROP TABLE #UserOrGroupIdTbl
end
create table #UserOrGroupIdTbl
(
	userOrGroupId int,
	isUser int
)
insert into #UserOrGroupIdTbl
select @userOrGroupId,0
union
select MAP.umgroupId,0
from UMDSGroupMaps as MAP
where MAP.umDSgroupId = @userOrGroupId
IF OBJECT_ID ('tempdb.dbo.#RawData') is not null
begin
	DROP TABLE #RawData
end
create table #RawData
(
	userOrGroupId int,
	isUser int,
	entityType1 int,
	entityTypeId1 int
)
insert into #RawData
exec sec_getUMEntityAssociations
--For group, we only support 28 CLIENT_GROUP_ENTITY, 3 CLIENT_ENTITY
insert into #RptGetUserOrGroupObjectResult
SELECT
0, 0, 2,
case when SA.entityType1 = 28 then SA.entityTypeId1 else 0 end, --clientGroupId
case when SA.entityType1 = 3 then SA.entityTypeId1 else 0 end, --clientId
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
FROM #RawData SA
join #UserOrGroupIdTbl GT
on SA.userOrGroupId = GT.userOrGroupId
where SA.isUser = GT.isUser
DECLARE @finalStmt nvarchar(max) = 'INSERT INTO '+@outputTableArg +' SELECT * FROM #RptGetUserOrGroupObjectResult'
EXEC (@finalStmt)
IF OBJECT_ID ('tempdb.dbo.#RawData') is not null
begin
	DROP TABLE #RawData
end
IF OBJECT_ID ('tempdb.dbo.#UserOrGroupIdTbl') is not null
begin
	DROP TABLE #UserOrGroupIdTbl
end
IF OBJECT_ID ('tempdb.dbo.#RptGetUserOrGroupObjectResult') is not null
begin
	DROP TABLE #RptGetUserOrGroupObjectResult
end
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetUserOrGroupObject')
	delete from GxQscripts where name = 'RptGetUserOrGroupObject'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetUserOrGroupObject')
	delete from GXDBVersions where aliasname = 'RptGetUserOrGroupObject'
GO

insert into GXDBVersions values(2, 'RptGetUserOrGroupObject',  '00010001000200010000', 'RptGetUserOrGroupObject', '00010001000200010000')
GO

