

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetUserGroups.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetUserGroups.sp,v $ $Id: rptGetUserGroups.sp,v 1.2.32.2 2018/03/22 02:59:05 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptGetUserGroups"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetUserGroups')
BEGIN
	print '>>> Drop Stored Procedure: rptGetUserGroups <<<'
	drop procedure rptGetUserGroups
END
IF EXISTS (select * from GxQscripts where name='rptGetUserGroups')
	delete from GxQscripts where name = 'rptGetUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetUserGroups')
	delete from GXDBVersions where aliasname = 'rptGetUserGroups'
GO
print '... Creating Procedure: rptGetUserGroups'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetUserGroups
  @i_type1 integer,
  @i_id1 integer,
  @i_type2 integer,
  @i_id2 integer,
  @i_type3 integer,
  @i_id3 integer,
  @i_type4 integer,
  @i_id4 integer
AS
  DECLARE @o_id integer;
  DECLARE @o_groupList varchar(2048);
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
SET NOCOUNT ON
DECLARE	@groupId		integer
DECLARE	@groupName		varchar(255)
DECLARE @tempGrpAssociationTbl	TABLE (gId INTEGER)
DECLARE @tempGrpCapabilityTbl	TABLE (gId INTEGER)
DECLARE @tempGroupTbl		TABLE (gId INTEGER, gName varchar(255))
SET @o_groupList = ''
SET @o_id = (case	when @i_type4>0 then @i_id4
			when @i_type3>0 then @i_id3
			when @i_type2>0 then @i_id2
			else @i_id1 end)
IF (dbo.isNewSecurity() = 0)
BEGIN
INSERT INTO @tempGrpAssociationTbl
SELECT groupId
FROM	UMGroupAssociation WITH (READUNCOMMITTED)
WHERE	@i_type1 in (2048, 2049, 2231, 2009, 2572) AND type1 = @i_type1 AND id1 = @i_id1 AND type2 = 0 AND id2 = 0 AND type3 = 0 AND id3 = 0 AND type4 = 0 AND id4 = 0
	OR
@i_type2 = 2230 AND type1 = @i_type1 AND id1 = @i_id1 AND type2 = @i_type2 AND id2 = @i_id2 AND type3 = 0 AND id3 = 0 AND type4 = 0 AND id4 = 0
	OR
@i_type3 in (2011, 2012) AND type1=@i_type1 AND id1=@i_id1 AND type2 = @i_type2 AND id2 = @i_id2 AND type3 = @i_type3 AND id3 = @i_id3 AND type4 = 0 AND id4 = 0
	OR
@i_type4 = 2013 AND type1 = @i_type1 AND id1 = @i_id1 AND type2 = @i_type2 AND id2 = @i_id2 AND type3 = @i_type3 AND id3 = @i_id3 AND type4 = @i_type4 AND id4 = @i_id4
INSERT INTO @tempGrpCapabilityTbl
SELECT groupId
FROM	UMGroupCapability WITH (READUNCOMMITTED)
WHERE	@i_type1 = 2048 AND capabilityId = 10 OR
@i_type1 = 2049 AND capabilityId = 8 OR
@i_type1 = 2231 AND capabilityId = 4 OR
@i_type1 in (2009,2572,2230,2011,2012,2013) AND capabilityId = 16
INSERT INTO @tempGroupTbl
SELECT DISTINCT id, name
FROM	UMGroups
WHERE	(groupFlags & 1 = 1) AND
	(allCapabilities>0 OR ID in (SELECT C.gId FROM @tempGrpCapabilityTbl C)) AND
	(allassociations>0 OR ID in (SELECT A.GID FROM @tempGrpAssociationTbl A))
DECLARE groupList CURSOR FOR
 SELECT gId, gName FROM @tempGroupTbl
OPEN groupList
FETCH NEXT FROM groupList INTO @groupId, @groupName
WHILE @@FETCH_STATUS <> -1
BEGIN
	IF LEN(@o_groupList) <> 0
		SET @o_groupList =  @o_groupList + ', '
	SET @o_groupList = @o_groupList + @groupName
	FETCH NEXT FROM groupList INTO @groupId, @groupName
END
CLOSE groupList
DEALLOCATE groupList
END
ELSE
BEGIN
	DECLARE @entityType1 INT = 0
    DECLARE @entityId1 INT = @i_id1
    DECLARE @entityType2 INT = 0
    DECLARE @entityId2 INT = @i_id2
    DECLARE @entityType3 INT = 0
    DECLARE @entityId3 INT = @i_id3
    DECLARE @entityType4 INT = 0
    DECLARE @entityId4 INT = @i_id4
    DECLARE @entityType5 INT = 0
    DECLARE @entityId5 INT = 0
if (@i_type1 = 2009)
	BEGIN
    SELECT @entityId1 = clientId, @entityId2 = appTypeId, @entityId3 = instanceId, @entityId4 = backupsetId,
                @entityId5 = subclientId
    FROM dbo.sec_convert4EntityTypeTo5EntityType(@i_type1, @i_type2, @i_type3, @i_type4, @i_id1, @i_id2, @i_id3, @i_id4)
	SET @entityType1 = dbo.sec_ObjectTypeToEntitytype  (@i_type1)
SET @entityType2 = CASE WHEN @entityId2 = 0 THEN 0 ELSE 4 END
SET @entityType3 = CASE WHEN @entityId3 = 0 THEN 0 ELSE 5 END
SET @entityType4 = CASE WHEN @entityId4 = 0 THEN 0 ELSE 6 END
SET @entityType5 = CASE WHEN @entityId5 = 0 THEN 0 ELSE 7 END
	END
	ELSE
	BEGIN
		SET @entityType1 = dbo.sec_ObjectTypeToEntitytype  (@i_type1)
	END
	DECLARE @i_entityList NVARCHAR(MAX)
	SET @i_entityList = '<entityList>'
	SET @i_entityList = @i_entityList +' <entity entityType1="' + CAST(@entityType1 AS NVARCHAR(MAX)) +'" entityId1="' + CAST(@entityId1 AS NVARCHAR(MAX))   +'" '
	SET @i_entityList = @i_entityList +' entityType2="' + CAST(@entityType2 AS NVARCHAR(MAX)) +'" entityId2="' + CAST(@entityId2 AS NVARCHAR(MAX))   +'" '
	SET @i_entityList = @i_entityList +' entityType3="' + CAST(@entityType3 AS NVARCHAR(MAX)) +'" entityId3="' + CAST(@entityId3 AS NVARCHAR(MAX))   +'" '
	SET @i_entityList = @i_entityList +' entityType4="' + CAST(@entityType4 AS NVARCHAR(MAX)) +'" entityId4="' + CAST(@entityId4 AS NVARCHAR(MAX))  +'"  />'
	SET @i_entityList = @i_entityList +' </entityList>'
    IF object_id('tempdb.dbo.#tgroupObjects') is not null
        DROP TABLE #tgroupObjects
CREATE TABLE #tgroupObjects ([userORGroupId] integer, [isUSer] integer, [roleId] integer, [permissionId] integer, [entitytype1]	 integer, [entityId1] integer, [entityType2] integer DEFAULT 0, [entityId2] integer DEFAULT 0, [entityType3] integer DEFAULT 0, [entityId3] integer DEFAULT 0, [entityType4] integer DEFAULT 0, [entityId4] integer DEFAULT 0, [entityType5] integer DEFAULT 0,  [entityId5] integer DEFAULT 0)
	DECLARE @capabilityId INTEGEr=0
if(@i_type1 = 2048)
	set 	@capabilityId = 10
else if(@i_type1 = 2049)
	set  @capabilityId = 8
else if (@i_type1 = 2231 )
	set  @capabilityId = 4
else if @i_type1 in (2009,2572,2230,2011,2012,2013)
	set  @capabilityId = 16
	exec sec_getUMEntityandPermissionOnEntity '#tgroupObjects' ,@entityType1, @i_entityList,0,0,@capabilityId,0
	SET @o_groupList = null
	SELECT @o_groupList = COALESCE(@o_groupList + ', ', '') + name from
	(select distinct name
	FROM	UMGroups UG INNER JOIN #tgroupObjects t ON
	UG.id = t.userORGroupId and t.isUSer = 0)X
	IF object_id('tempdb.dbo.#tgroupObjects') is not null
    DROP TABLE #tgroupObjects
END
SELECT @o_id, @o_groupList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetUserGroups')
	delete from GxQscripts where name = 'RptGetUserGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetUserGroups')
	delete from GXDBVersions where aliasname = 'RptGetUserGroups'
GO

insert into GXDBVersions values(2, 'RptGetUserGroups',  '00010002003200020000', 'RptGetUserGroups', '00010002003200020000')
GO

