

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetUserGroupInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetUserGroupInfo.sp,v $ $Id: RptGetUserGroupInfo.sp,v 1.11.60.2 2018/03/22 03:04:34 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetUserGroupInfo"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetUserGroupInfo <<<'

IF EXISTS (select * from sysobjects where name='RptGetUserGroupInfo')
	drop procedure RptGetUserGroupInfo
IF EXISTS (select * from GxQscripts where name='RptGetUserGroupInfo')
	delete from GxQscripts where name = 'RptGetUserGroupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetUserGroupInfo')
	delete from GXDBVersions where aliasname = 'RptGetUserGroupInfo'
GO
print '... Creating Procedure: RptGetUserGroupInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetUserGroupInfo
  @i_jobId integer,
  @i_hideOLUsers integer
AS
  DECLARE @o_userNum integer;
  DECLARE @o_isRestricted integer;
  DECLARE @o_groupId integer;
  DECLARE @o_groupName char(255);
  DECLARE @o_groupDescription char(255);
  DECLARE @o_allCapability integer;
  DECLARE @o_allAssociation integer;
  DECLARE @o_enabled integer;
  DECLARE @o_capabilityId integer;
  DECLARE @o_capabilityName char(255);
  DECLARE @o_capTokenId integer;
  DECLARE @o_asnItem1 integer;
  DECLARE @o_asnItemName1 integer;
  DECLARE @o_asnItem2 integer;
  DECLARE @o_asnItemName2 integer;
  DECLARE @o_asnItem3 integer;
  DECLARE @o_asnItemName3 integer;
  DECLARE @o_asnItem4 integer;
  DECLARE @o_asnItemName4 integer;
  DECLARE @o_userId integer;
  DECLARE @o_userName char(255);
  DECLARE @o_userEnabled integer;
  DECLARE @o_userFlags integer;
  DECLARE @o_userDescription varchar(MAX);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#tempUGCList') IS NOT null DROP TABLE #tempUGCList
IF object_id('tempdb.dbo.#tempUserList') IS NOT null DROP TABLE #tempUserList
DECLARE @tempUserGroups table (groupId int);
DECLARE @i_userId int, @locId int, @flags bigint, @i_forModification int = 0, @i_isRestrictedViewEnabled int = 1
EXEC RptOptGetUserFlags @i_jobId, @i_userId OUTPUT, @locId OUTPUT, @flags OUTPUT
IF (dbo.isNewSecurity() = 0)
BEGIN
	DECLARE @canManageAllUsers int = 0
		EXEC sec_canManageAllUsers @i_userId, @canManageAllUsers OUTPUT
	DECLARE @IsHideEnabled int = 0
	IF @canManageAllUsers = 0 AND @i_forModification = 0
		EXEC sec_isHideEnabled @i_userId, @i_isRestrictedViewEnabled, @IsHideEnabled OUTPUT
	DECLARE @userHasUserManagementCap int = 0
	DECLARE @ManageUserCapMask bigint = CAST(POWER(2.0, 14 - 1) AS bigint)
		IF @canManageAllUsers = 0 AND @i_forModification <> 0
			EXEC sec_userHasCapability @i_userId, @ManageUserCapMask, @userHasUserManagementCap OUTPUT
	DECLARE @ListAllUsers int = 0
	IF @canManageAllUsers <> 0	or
		(@i_forModification = 0 AND @IsHideEnabled = 0)
		SET @ListAllUsers = 1
	IF @ListAllUsers <> 0
	BEGIN
			INSERT INTO @tempUserGroups
			SELECT UMGroups.id groupId
			FROM UMGroups
			WHERE (	(@i_isRestrictedViewEnabled <> 0 OR UMGroups.name <> 'CV_Restricted_Visibility')
					AND UMGroups.name <> 'Common Outlook Add-Ins'
				)
			ORDER BY UMGroups.id
	END
	ELSE IF ( @i_forModification = 0 OR @userHasUserManagementCap <> 0  )
	BEGIN
		DECLARE @providerId INT = ( select umDSproviderId FROM UMUsers WHERE id = @i_userid )
		IF ( @providerId = 0 )
		BEGIN
			INSERT INTO @tempUserGroups
			SELECT UMGroups.id groupId
			FROM UMGroups INNER JOIN UMUserGroup ON UMGroups.id = UMUserGroup.groupId
			WHERE	(		UMUserGroup.userId = @i_userId
						AND UMGroups.name <> 'CV_Restricted_Visibility'
						AND UMGroups.name <> 'Common Outlook Add-Ins'
					)
			ORDER BY UMGroups.id
		END
		ELSE
		BEGIN
			INSERT INTO @tempUserGroups
			SELECT  DISTINCT  UMGroups.id groupId
			FROM         UMDSUserGroup INNER JOIN
								  UMDSGroupMaps ON UMDSUserGroup.groupId = UMDSGroupMaps.umDSgroupId INNER JOIN
								  UMGroups ON UMDSGroupMaps.umgroupId = UMGroups.id
			WHERE	(		UMDSUserGroup.userId = @i_userId
						AND UMGroups.name <> 'CV_Restricted_Visibility'
						AND UMGroups.name <> 'Common Outlook Add-Ins'
					)
			ORDER BY UMGroups.id
		END
	END
END
ELSE
BEGIN
	IF OBJECT_ID('tempdb.dbo.#rptGetUserGroupInfoTbl') IS NOT NULL
		DROP TABLE #rptGetUserGroupInfoTbl
	CREATE TABLE #rptGetUserGroupInfoTbl (userGroupId INT)
	EXEC sec_getUserGroupsForThisUser '#rptGetUserGroupInfoTbl', @i_userId, 0
	INSERT INTO @tempUserGroups
		SELECT DISTINCT userGroupId FROM #rptGetUserGroupInfoTbl
	IF OBJECT_ID('tempdb.dbo.#rptGetUserGroupInfoTbl') IS NOT NULL
		DROP TABLE #rptGetUserGroupInfoTbl
END
SELECT	* INTO #tempUserList
FROM	UMUsers
WHERE	login NOT LIKE '%(Deleted,%)' AND (@i_hideOLUsers = 0 OR (flags & 256) = 0)
AND ((flags & 0x004) = 0) --discarding all the users who are hidden
SELECT	groupId=(case when G.id>0 then G.id else 9999 END), groupName=G.name, groupDesc=G.description, G.allCapabilities, G.allAssociations, G.groupFlags,
	capId=(case when C.id>0 then C.id else 0 END),
	capName=(case when G.allCapabilities=1 then 'All Capabilities' when C.id>0 then C.Name ELSE 'No Capabilities' END),
	capNameId=(case when G.allCapabilities=1 then 0 when C.id>0 then C.tokenId ELSE -1 END),
	GA.type1, GA.id1, GA.type2, GA.id2, GA.type3, GA.id3, GA.type4, GA.id4,
	userId=U.id, userName=U.login, U.enabled, U.flags, U.description
INTO	#tempUGCList
FROM	UMGroups G LEFT OUTER JOIN UMUserGroup UG ON UG.groupId=G.Id
		 LEFT OUTER JOIN UMGroupCapability GC ON GC.groupId=G.Id
		 LEFT OUTER JOIN UMCapability C ON C.id=GC.capabilityId
		 LEFT OUTER JOIN UMGroupAssociation GA ON GA.groupId=G.Id AND G.allAssociations=0
		 FULL OUTER JOIN #tempUserList U ON U.id=UG.userId
WHERE @i_hideOLUsers = 0 OR G.id NOT IN (select UG.groupId from UMUserGroup UG, UMUsers U where U.id = UG.userId AND (U.flags & 256) <> 0 AND ((flags & 0x004) = 0))
delete from #tempUGCList where groupid not in (select groupId from @tempUserGroups)
SELECT	userNum=(select count(DISTINCT TT.userId) from #tempUGCList TT where TT.groupId=T.groupId),
	isRestricted=(select count(*) from #tempUGCList TT where TT.groupName='CV_Restricted_Visibility' and TT.userId=T.userId),
	T.*
FROM	#tempUGCList T
ORDER BY groupId, userName, capId, type1
DROP TABLE #tempUGCList
DROP TABLE #tempUserList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetUserGroupInfo')
	delete from GxQscripts where name = 'RptGetUserGroupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetUserGroupInfo')
	delete from GXDBVersions where aliasname = 'RptGetUserGroupInfo'
GO

insert into GXDBVersions values(2, 'RptGetUserGroupInfo',  '00010011006000020000', 'RptGetUserGroupInfo', '00010011006000020000')
GO

