

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetUserAccount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetUserAccount.sp,v $ $Id: rptGetUserAccount.sp,v 1.6.210.4 2018/12/28 20:05:52 dok Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptGetUserAccount"				|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetUserAccount')
BEGIN
	print '>>> Drop Stored Procedure: rptGetUserAccount <<<'
	drop procedure rptGetUserAccount
END
IF EXISTS (select * from GxQscripts where name='rptGetUserAccount')
	delete from GxQscripts where name = 'rptGetUserAccount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetUserAccount')
	delete from GXDBVersions where aliasname = 'rptGetUserAccount'
GO
print '... Creating Procedure: rptGetUserAccount'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetUserAccount
  @i_apptypeId integer,
  @i_clientId integer,
  @i_instanceId integer
AS
  DECLARE @o_instanceId integer;
  DECLARE @o_instanceName NVARCHAR(255);
  DECLARE @o_user NVARCHAR(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE	@instListTbl	TABLE (t_id int, t_UserName nvarchar(255))
DECLARE	@SqlAuthTbl	TABLE (instanceId integer, authType	integer, userName nvarchar(255), userPassword nvarchar(255), level integer)
IF @i_instanceId > 0
	INSERT INTO @instListTbl VALUES (@i_instanceId, '')
ELSE IF @i_clientId > 0
	INSERT INTO @instListTbl
	SELECT	DISTINCT instance, ''
	FROM	APP_application
	WHERE	clientId = @i_clientId AND appTypeId = @i_apptypeId
IF @i_apptypeId in (81, 4, 16, 70)
BEGIN
	DECLARE	@instanceId INT
	DECLARE instanceList CURSOR FOR
 		SELECT t_id FROM @instListTbl
	OPEN instanceList
	FETCH NEXT FROM instanceList INTO @instanceId
	WHILE @@FETCH_STATUS <> -1
	BEGIN
		DELETE @SqlAuthTbl
		INSERT INTO @SqlAuthTbl
		EXEC AppGetSqlAuth @instanceId, 0, 0, 0
		UPDATE @instListTbl
		SET t_UserName = (SELECT (case authType when 2 then userName else 'RPT_DATA_USE_LOCAL_SYSTEM_ACCOUNT' end) FROM	@SqlAuthTbl)
		WHERE t_id = @instanceId
		FETCH NEXT FROM instanceList INTO @instanceId
	END
	CLOSE instanceList
	DEALLOCATE instanceList
	SELECT	t_id, N.name, t_UserName
	FROM	@instListTbl JOIN APP_instanceName N ON t_id = N.id
END
ELSE
	SELECT	t_id, N.name, P.attrVal
	FROM	@instListTbl	JOIN APP_instanceProp P ON t_id = P.componentNameId
				JOIN APP_instanceName N ON t_id = N.id
	WHERE	attrName = 'User Name'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetUserAccount')
	delete from GxQscripts where name = 'RptGetUserAccount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetUserAccount')
	delete from GXDBVersions where aliasname = 'RptGetUserAccount'
GO

insert into GXDBVersions values(2, 'RptGetUserAccount',  '00010006021000040000', 'RptGetUserAccount', '00010006021000040000')
GO

