

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetUpdateCacheInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetUpdateCacheInfo.sp,v $ $Id: RptGetUpdateCacheInfo.sp,v 1.3.208.8 2018/11/18 03:52:25 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "RptGetUpdateCacheInfo"				            |
--	|									                                    |
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	    |
--	| AND RETURNING RESULTS							                        |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetUpdateCacheInfo')
BEGIN
	print '>>> Drop Stored Procedure: RptGetUpdateCacheInfo <<<'
	drop procedure RptGetUpdateCacheInfo
END
IF EXISTS (select * from GxQscripts where name='RptGetUpdateCacheInfo')
	delete from GxQscripts where name = 'RptGetUpdateCacheInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetUpdateCacheInfo')
	delete from GXDBVersions where aliasname = 'RptGetUpdateCacheInfo'
GO
print '... Creating Procedure: RptGetUpdateCacheInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetUpdateCacheInfo
  @i_jobId integer
AS
  DECLARE @o_updCachename nvarchar(255);
  DECLARE @o_nethostname nchar(255);
  DECLARE @o_OSId integer;
  DECLARE @o_OSName char(255);
  DECLARE @o_hwName char(255);
  DECLARE @o_release char(255);
  DECLARE @o_buildId char(255);
  DECLARE @o_isEnabled integer;
  DECLARE @o_atuoSyncWithCS integer;
  DECLARE @o_cacheStatus integer;
  DECLARE @o_CachePath char(255);
  DECLARE @o_clientList nvarchar(255);
  DECLARE @o_updCacheDisplayName nvarchar(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId			INTEGER
DECLARE @clOpt          INTEGER
DECLARE @appTypeOpt     INTEGER
DECLARE @tblClients     TABLE (t_clId int)
DECLARE @tblApptypes        TABLE (t_appTypeId int)
DECLARE @useClientDisplayName int= 1 -- Always true for R11 SP15 and greater.  -SK
-- csabjan: If the flag to use client display name is set, then query and use the client display name.
--IF EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'bUseClientDisplayName' AND relativePath = 'CommServDB.Console' AND type = 'BOOLEAN' AND cast([value] as nvarchar(32)) = N'true' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = 2)
--BEGIN
--    SET @useClientDisplayName = 1
--END
SET @userId         = dbo.GetOptionInt(140019, @i_jobId, 0, 0)
INSERT INTO @tblClients EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
INSERT INTO @tblApptypes EXEC rptOptGetAppTypes @i_jobId, @appTypeOpt OUTPUT
IF OBJECT_ID('tempdb..#tblClients') IS NOT NULL
DROP TABLE #tblClients
CREATE TABLE #tblClients (id INT)
IF @clOpt = 0
BEGIN
    IF  @appTypeOpt <= 0
        INSERT INTO #tblClients
        SELECT  DISTINCT clientId
        FROM    APP_Application A WITH (READUNCOMMITTED)
    ELSE
        INSERT INTO #tblClients
        SELECT  DISTINCT clientId
        FROM    APP_Application A WITH (READUNCOMMITTED)
                INNER JOIN @tblApptypes T ON A.appTypeId = T.t_appTypeId
END
ELSE
BEGIN
    IF  @appTypeOpt <= 0
        INSERT INTO #tblClients
        SELECT  DISTINCT clientId
        FROM    APP_Application A WITH (READUNCOMMITTED) INNER JOIN @tblClients CL ON A.clientId = CL.t_clId
    ELSE
        INSERT INTO #tblClients
        SELECT DISTINCT clientId
        FROM    APP_Application A WITH (READUNCOMMITTED) INNER JOIN @tblClients CL ON A.clientId = CL.t_clId
                INNER JOIN @tblApptypes T ON A.appTypeId = T.t_appTypeId
END
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @clOpt <= 0
BEGIN
    IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
    EXEC sec_getUserObjects @userId, 2013 , 0, '#rptUserObjects'    -- SUB_CLIENT_ITEM = to get SUB_CLIENT_ITEM it will be having client/appType/instance/backupSet/subclient/
    delete #rptUserObjects
    WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0
		OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0
		OR taskId <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0 OR vtShelfId <> 0 OR commcellId <> 2
    IF NOT EXISTS (SELECT * FROM #rptUserObjects sec WHERE(sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
	BEGIN
		delete T
		FROM #tblClients T
		WHERE T.id NOT IN (select clientId from #rptUserObjects)
	END
    DROP TABLE #rptUserObjects
END
DECLARE @clientName	varchar(255)
DECLARE @Id int
DECLARE @o_clientNameList varchar(255)
--list of clients associated with Update Cache
DECLARE @tmpClientCache	TABLE (	t_Id int,
t_name		nvarchar(255)
							   )
INSERT INTO @tmpClientCache
select pa.id, (CASE WHEN @useClientDisplayName = 1 THEN C.displayname ELSE C.name END)
from patchUpdateAgentInfo pa, app_clientprop cp, app_client c
where (cast(pa.id as varchar(255))=cp.attrval) and attrname like 'UPDATE CACHE AGENT ID'
and c.id =cp.componentnameid
DECLARE @tblClient	TABLE (	Id int,
cname		nvarchar(255) )
INSERT INTO @tblClient
select id,N'' from patchUpdateAgentInfo where clientId <> 2 AND isDeleted <> 1
DECLARE getClientListName CURSOR FOR SELECT t_Id FROM @tmpClientCache
OPEN getClientListName
FETCH NEXT FROM getClientListName INTO @Id
WHILE @@FETCH_STATUS = 0
BEGIN
		DECLARE getClientList CURSOR FOR
		SELECT t_name FROM @tmpClientCache WHERE t_Id = @Id
		SET @o_clientNameList = N''
		OPEN getClientList
		FETCH NEXT FROM getClientList INTO @clientName
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF @o_clientNameList <> N''
				SET @o_clientNameList = @o_clientNameList + ', '
			SET @o_clientNameList = @o_clientNameList + @clientName
			FETCH NEXT FROM getClientList INTO @clientName
		END
		CLOSE getClientList
		DEALLOCATE getClientList
UPDATE	@tblClient
SET	cname = @o_clientNameList
WHERE	Id = @Id
FETCH NEXT FROM getClientListName INTO @Id
END
CLOSE getClientListName
DEALLOCATE getClientListName
	UPDATE	@tblClient
	SET	cname = 'Commserve'
	WHERE	Id not in (select t_Id from   @tmpClientCache)
--------
SELECT  UpdCachename=C.name,
        C.net_hostname, OSID=S.id, OSName=S.name, --OSID=O.id, OSName=O.name,
        platform = dbo.GetClientHardwareName(C.id, NULL),
	    release = ISNULL((select release FROM simAllGalaxyRel where id= C.releaseId), ''),
	    buildId = ISNULL((select max(Build) from LicUsage where CId=C.id AND releaseId= C.releaseId), ''),
	    UA.isEnabled, UA.autoSyncWithCS, UA.inSyncWithCS, ISNULL(UA.cachePath,'N/A') , t.cname,
        UpdCacheDisplayname=C.displayname
FROM	APP_Client C
		INNER JOIN #tblClients TC           ON C.id = TC.id and C.id <> 2
		INNER JOIN PatchUpdateAgentInfo UA  ON C.id = UA.clientId
		INNER JOIN simOperatingSystem S     ON C.simOperatingSystemId=S.id
		INNER JOIN @tblClient t             ON t.id = UA.id
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetUpdateCacheInfo')
	delete from GxQscripts where name = 'RptGetUpdateCacheInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetUpdateCacheInfo')
	delete from GXDBVersions where aliasname = 'RptGetUpdateCacheInfo'
GO

insert into GXDBVersions values(2, 'RptGetUpdateCacheInfo',  '00010003020800080000', 'RptGetUpdateCacheInfo', '00010003020800080000')
GO

