

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetTopMostJobErrors.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetTopMostJobErrors.sp,v $ $Id: RptGetTopMostJobErrors.sp,v 1.8.88.2 2018/03/22 03:19:21 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  RptGetTopMostJobErrors()
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Gokul Pattabiraman   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetTopMostJobErrors <<<'

IF EXISTS (select * from sysobjects where name='RptGetTopMostJobErrors')
	drop procedure RptGetTopMostJobErrors
IF EXISTS (select * from GxQscripts where name='RptGetTopMostJobErrors')
	delete from GxQscripts where name = 'RptGetTopMostJobErrors'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetTopMostJobErrors')
	delete from GXDBVersions where aliasname = 'RptGetTopMostJobErrors'
GO
print '... Creating Procedure: RptGetTopMostJobErrors'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetTopMostJobErrors
  @i_jobId integer ,
  @outXmlResp XML	OUTPUT
AS
SET NOCOUNT ON
BEGIN
IF object_id('tempdb.dbo.#BKPXT') IS  NULL
BEGIN
	GOTO RptGetTopMostJobErrors_End
END
DECLARE @debug INT = 0
IF(@debug>0)
	SELECT * FROM #BKPXT
DECLARE @topCount	INTEGER
DECLARE @localeId INT = 0
SET @topCount = dbo.GetOptionInt(402475830, @i_jobId, 0, 0)
SET @localeId = dbo.GetOptionInt(407250767, @i_jobId, 0, 0)
IF (@topCount<0)
BEGIN
	GOTO RptGetTopMostJobErrors_End
END
ELSE IF (@topCount = 0)
BEGIN
	SET @topCount=3
END
	DECLARE @errorMessages TABLE
	(
		messageId INTEGER,
		jobId	  INTEGER,
		failureId INTEGER
	)
	DECLARE @errorMessageReasons TABLE
	(
		failureId INTEGER,
		jobId	  INTEGER,
		failureReason VARCHAR(MAX)
	)
	DECLARE @topWaitingReasons TABLE
	(
		numberOfJobs INTEGER,
		messageId	INTEGER,
		recentfailureID	nvarchar(64),
		errorCode nvarchar(64)
	)
	DECLARE @topPendingReasons TABLE
	(
		numberOfJobs INTEGER,
		messageId	INTEGER,
		recentfailureID	nvarchar(64),
		errorCode nvarchar(64)
	)
	DECLARE @topFailureReasons TABLE
	(
		numberOfJobs INTEGER,
		messageId	INTEGER,
		recentfailureID	nvarchar(64),
		errorCode nvarchar(64)
	)
	-- Variables
	DECLARE @type		INTEGER
	DECLARE @msgID INT = 0
	DECLARE @subsystemID INT = 0
	DECLARE @msgNum INT = 0
	DECLARE @errorCodeStr nvarchar(64)
	--  Get all error message IDs from Failure Table grouped by jobs os that repeating error for same job are considered only once
	INSERT INTO @errorMessageReasons
		SELECT DISTINCT A.id, A.jobId, CAST(A.id AS VARCHAR(MAX))+','
		FROM JMFailureReasonMsg A
		INNER JOIN #BKPXT B ON A.jobId = B.jobId
		AND B.failIds<>''
	INSERT INTO @errorMessages
		SELECT  0, A.jobId, A.failureId
		FROM @errorMessageReasons A
		INNER JOIN #BKPXT B ON A.jobId = B.jobId
		WHERE PATINDEX('%'+a.failureReason+'%',B.failIds) <> 0
		--AND B.failError>0
	UPDATE 	@errorMessages
		SET messageId  = A.messageId
		FROM JMFailureReasonMsg A,
		@errorMessages B
		WHERE
		A.id = B.failureId
		AND a.jobId = b.jobId
	IF 1 = 1  -- JOB_ACTIVE = 1
    BEGIN
		-- Find out the top 3 waiting errors among them
		INSERT INTO @topWaitingReasons
			SELECT TOP (@topCount) COUNT(*) AS Occurrences, messageId, CAST( MAX(failureId) as nvarchar(64)), ''
			FROM @errorMessages A
			INNER JOIN #BKPXT B ON A.jobId = B.jobId
			AND B.state = 3 -- waiting state
			GROUP BY messageId ORDER BY Occurrences DESC
		-- Append a comma so that JMGetLocalizedMessageMaxFunc can be used to localise
		UPDATE @topWaitingReasons
		SET recentfailureID = recentfailureID + ','
		-- Find out the top 3 pending errors among them
		INSERT INTO @topPendingReasons
			SELECT TOP (@topCount) COUNT(*) AS Occurrences, messageId, CAST( MAX(failureId) as nvarchar(64)), ''
			FROM @errorMessages A
			INNER JOIN #BKPXT B ON A.jobId = B.jobId
			AND B.state = 2 -- pending state
			GROUP BY messageId ORDER BY Occurrences DESC
		-- Append a comma so that JMGetLocalizedMessageMaxFunc can be used to localise
		UPDATE @topPendingReasons
		SET recentfailureID = recentfailureID + ','
	END
	IF 2 = 2 -- JOB_HISTORY = 2
	BEGIN
		-- Find out the top 3 waiting errors among them
		INSERT INTO @topFailureReasons
			SELECT TOP (@topCount) COUNT(*) AS Occurrences, messageId, CAST( MAX(failureId) as nvarchar(64)), ''
			FROM @errorMessages A
			INNER JOIN #BKPXT B ON A.jobId = B.jobId
			AND B.state NOT IN(2,3)
			--AND B.failError>0
			GROUP BY messageId ORDER BY Occurrences DESC
		-- Append a comma so that JMGetLocalizedMessageMaxFunc can be used to localise
		UPDATE @topFailureReasons
		SET recentfailureID = recentfailureID + ','
	END
IF(@debug>0)
	SELECT * FROM @errorMessages
	-- Form the exact errorCode
	DECLARE GetErrorCode CURSOR
	FOR SELECT messageId FROM @topWaitingReasons
		UNION SELECT messageId FROM @topPendingReasons
		UNION SELECT messageId FROM @topFailureReasons
	OPEN GetErrorCode
	FETCH GetErrorCode INTO @msgID
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @subsystemID = 0
		SET @msgNum = 0
		SET @errorCodeStr = ''
		SELECT @subsystemID = SubsystemID, @msgNum = MessageNum
		FROM EvLocaleMsgs
		WHERE MessageID = @msgID AND LocaleID = @localeId
		SET @errorCodeStr = CAST(@subsystemID AS nvarchar(12)) + ':' + CAST(@msgNum AS nvarchar(16))
		UPDATE @topWaitingReasons
		SET errorCode = @errorCodeStr
		WHERE messageId = @msgID
		UPDATE @topPendingReasons
		SET errorCode = @errorCodeStr
		WHERE messageId = @msgID
		UPDATE @topFailureReasons
		SET errorCode = @errorCodeStr
		WHERE messageId = @msgID
	FETCH GetErrorCode INTO @msgID
	END
	CLOSE GetErrorCode
	DEALLOCATE GetErrorCode
	-- Form the XML Response
IF(@debug>0)
	SELECT * FROM @topWaitingReasons
IF(@debug>0)
	SELECT * FROM @topPendingReasons
IF(@debug>0)
	SELECT * FROM @topFailureReasons
	SET @outXmlResp =
			(
				SELECT
				(
					SELECT errorCode AS '@errorCode',
					dbo.JMGetLocalizedMessageMaxFunc(@localeId, recentfailureID) AS '@errorDescription',
					numberOfJobs AS '@numberOfJobsAffected',
					messageId AS '@messageId'
					FROM @topWaitingReasons
					FOR XML PATH ('waitingErrorList'), TYPE
				),
				(
					SELECT errorCode AS '@errorCode',
					dbo.JMGetLocalizedMessageMaxFunc(@localeId, recentfailureID) AS '@errorDescription',
					numberOfJobs AS '@numberOfJobsAffected',
					messageId AS '@messageId'
					FROM @topPendingReasons
					FOR XML PATH ('pendingErrorList'), TYPE
				),
				(
					SELECT errorCode AS '@errorCode',
					dbo.JMGetLocalizedMessageMaxFunc(@localeId, recentfailureID) AS '@errorDescription',
					numberOfJobs AS '@numberOfJobsAffected',
					messageId AS '@messageId'
					FROM @topFailureReasons
					FOR XML PATH ('failedErrorList'), TYPE
				)
				FOR XML PATH('JobManager_TopMostJobErrorsResp'), TYPE
			)
RptGetTopMostJobErrors_End:
	IF ( @outXmlResp IS null )
			SET @outXmlResp = '<JobManager_TopMostJobErrorsResp />'
IF(@debug>0)
	SELECT @outXmlResp
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetTopMostJobErrors')
	delete from GxQscripts where name = 'RptGetTopMostJobErrors'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetTopMostJobErrors')
	delete from GXDBVersions where aliasname = 'RptGetTopMostJobErrors'
GO

insert into GXDBVersions values(2, 'RptGetTopMostJobErrors',  '00010008008800020000', 'RptGetTopMostJobErrors', '00010008008800020000')
GO

