

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetTmMediaXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetTmMediaXML.sp,v $ $Id: RptGetTmMediaXML.sp,v 1.12.48.5 2018/03/22 03:11:07 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetTmMediaXML"			|
--	||
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetTmMediaXML')
BEGIN
	print '>>> Drop Stored Procedure: RptGetTmMediaXML <<<'
	drop procedure RptGetTmMediaXML
END
IF EXISTS (select * from GxQscripts where name='RptGetTmMediaXML')
	delete from GxQscripts where name = 'RptGetTmMediaXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetTmMediaXML')
	delete from GXDBVersions where aliasname = 'RptGetTmMediaXML'
GO
print '... Creating Procedure: RptGetTmMediaXML'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetTmMediaXML
  @i_taskId int,
  @i_noLicense int
AS
  DECLARE @o_returnstring nvarchar(MAX);
SET NOCOUNT ON
CREATE TABLE #RETURN_MED_LIST(
	m_medId			integer,
	m_DueBack		bigint,
	m_barCode		varchar(256),
	m_policyId		integer,
	m_policy		nvarchar(64),
	m_userId		integer,
	m_user			varchar(64),
	m_actionId		integer,
	m_actionType		integer,
	m_jobId			integer,
	m_jobType		integer,
	m_sourceId		integer,
	m_source		nvarchar(64),
	m_destinationId		integer,
	m_destination		nvarchar(64),
	m_currentId		integer,
	m_current		nvarchar(144),
	m_containerId		integer,
	m_container		nvarchar(64),
	m_status		integer,
	m_startTime		integer,
	m_endTime		integer,
	m_libId			integer,
	m_libTypeId		integer,
	m_library		nvarchar(64),
	m_sgId			integer,
	m_spareGroup	nvarchar(192),
	m_mgId			integer,
	m_mediaStatus		integer,
	m_SP			nvarchar(144),
	m_incrSP		nvarchar(144),
	m_copyId		integer,
	m_copy			nvarchar(64),
	m_volNum		integer,
	m_medLoc		integer,
	m_expLocId		integer,
	v_volumeId		integer,
	v_volumeFlags		integer,
	v_lastBackupTime	integer,
	v_lastRestoreTime	integer,
	v_volumeFullReason	integer,
	v_volumeFullTime	integer,
	v_volumeFullJobId	bigint,
	v_physicalBytesGB	float,
	v_volStatus		integer,
	v_medId			integer
)
EXEC RptGetTMMedia @i_taskId, 1, @i_noLicense
IF OBJECT_ID('tempdb.dbo.#tempMediaList') IS NOT NULL DROP TABLE #tempMediaList
SELECT	DISTINCT	m_medId, m_DueBack, m_barCode, m_policyId, m_policy, m_userId, m_user, m_actionId, m_jobId, m_jobType, m_sourceId, m_source, 			m_destinationId, m_destination, m_currentId, m_current, m_containerId, m_container, m_status, m_startTime, m_endTime, m_libId, 			m_library, m_sgId, m_spareGroup, m_mgId, m_mediaStatus,m_SP, m_incrSP, m_copyId, m_copy, m_expLocId
INTO	#tempMediaList
FROM	#RETURN_MED_LIST
IF OBJECT_ID('tempdb.dbo.#tempMediaSideList') IS NOT NULL DROP TABLE #tempMediaSideList
SELECT	v_medId, m_actionId, m_sgId, m_volNum, v_volumeId, v_volumeFlags, v_lastBackupTime, v_lastRestoreTime, v_volumeFullReason, v_volumeFullTime, v_volumeFullJobId, v_physicalBytesGB, v_volStatus
INTO	#tempMediaSideList
FROM	#RETURN_MED_LIST
WHERE	v_medId is not null
DROP TABLE #RETURN_MED_LIST
IF OBJECT_ID('tempdb.dbo.#rXML') IS NOT NULL DROP TABLE #rXML
CREATE TABLE #rXML( rxml XML)
DECLARE @statement NVARCHAR(MAX)
SET  @statement = N'DECLARE @OUT XML
		SET @OUT =(SELECT
		M.m_barCode ''@barCode'',
		M.m_actionId ''@actionId'',
		m_library ''@library'',
		m_spareGroup ''@spareGroup'',
		m_policy ''@policy'',
		m_policyId ''@policyId'',
		m_DueBack ''@dueback'',
		CONVERT(varchar(20), dbo.GetDateTimeBig(m_dueback)) ''@duebackTime'',
		m_user ''@user'',
		m_jobId ''@jobId'',
		m_current ''@current'',
		(CASE WHEN m_containerId <= 0 THEN ''N/A'' ELSE m_container END) ''@container'',
		m_source ''@source'',
		m_destination ''@destination'',
		m_startTime ''@startTime'',
		(CASE WHEN m_startTime > 0 THEN CONVERT(char(20), dbo.GetDateTime(m_startTime)) ELSE '''' END)''@startTimeStr'',
		m_endTime ''@endTime'',
		(CASE WHEN m_endTime > 0 THEN CONVERT(char(20), dbo.GetDateTime(m_endTime)) ELSE '''' END) ''@endTimeStr'',
		m_status ''@jobStatus'',
		m_SP ''@SP'',
		m_copy ''@copy'',
		MS.m_volNum ''VTMediaSide/@side'',
		MS.v_VolumeFlags ''VTMediaSide/@status'',
		(CASE WHEN v_LastBackupTime > 0 THEN CONVERT(char(20), dbo.GetDateTime(v_LastBackupTime)) ELSE '''' END) ''VTMediaSide/@lastRead'',
		(CASE WHEN v_LastRestoreTime > 0 THEN CONVERT(char(20), dbo.GetDateTime(v_LastRestoreTime)) ELSE '''' END) ''VTMediaSide/@lastWrite'',
		MS.v_physicalBytesGB ''VTMediaSide/@totalData''
		FROM	#tempMediaList M INNER JOIN  #tempMediaSideList MS ON
		MS.m_actionId =M.m_actionId AND MS.v_medId = M.m_medId
		ORDER BY '
		DECLARE @orderBy 	integer
SET @orderBy 	= dbo.GetOptionInt(876626965, @i_taskId, 0, 0)
IF @orderBy = 9
		SET	@statement = @statement +' M.m_source, M.m_containerId, M.m_actionId, M.m_barCode'
ELSE IF @orderBy = 8
		SET	@statement = @statement +' M.m_destination, M.m_containerId, M.m_actionId, M.m_barCode'
ELSE IF @orderBy = 7
		SET	@statement = @statement +' M.m_actionId, M.m_containerId, M.m_barCode'
		ELSE
		SET	@statement = @statement + ' M.m_containerId, M.m_actionId,  M.m_barCode'
		SET @statement = @statement +' FOR XML PATH (''VTMedia''))
		DECLARE @RXML XML = (SELECT  @OUT FOR XML PATH(''VaultTrackingTable''))
		INSERT INTO #rXML(rXML)
		SELECT @RXML'
		 EXECUTE sp_executesql @statement
SELECT rXML FROM #rXML
DROP TABLE #rXML
DROP TABLE #tempMediaList
DROP TABLE #tempMediaSideList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetTmMediaXML')
	delete from GxQscripts where name = 'RptGetTmMediaXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetTmMediaXML')
	delete from GXDBVersions where aliasname = 'RptGetTmMediaXML'
GO

insert into GXDBVersions values(2, 'RptGetTmMediaXML',  '00010012004800050000', 'RptGetTmMediaXML', '00010012004800050000')
GO

