

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetTmMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetTmMedia.sp,v $ $Id: RptGetTmMedia.sp,v 1.54.2.12 2020/08/13 17:05:05 rsivadas Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Stored Procedure : "RptGetTmMedia"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetTmMedia')
BEGIN
	print '>>> Drop Stored Procedure: RptGetTmMedia <<<'
	drop procedure RptGetTmMedia
END
IF EXISTS (select * from GxQscripts where name='RptGetTmMedia')
	delete from GxQscripts where name = 'RptGetTmMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetTmMedia')
	delete from GXDBVersions where aliasname = 'RptGetTmMedia'
GO
print '... Creating Procedure: RptGetTmMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetTmMedia
  @i_jobId int,
  @i_isXML int,
  @i_noLicense int
AS
  DECLARE @o_mediaId integer;
  DECLARE @o_dueback bigint;
  DECLARE @o_barCode char(255);
  DECLARE @o_policyId integer;
  DECLARE @o_policy NVARCHAR(255);
  DECLARE @o_userId integer;
  DECLARE @o_user char(255);
  DECLARE @o_actionId integer;
  DECLARE @o_actionType integer;
  DECLARE @o_jobId integer;	
  DECLARE @o_jobType integer;	
  DECLARE @o_sourceId integer;
  DECLARE @o_source NVARCHAR(255);
  DECLARE @o_destinationId integer;
  DECLARE @o_destination NVARCHAR(255);
  DECLARE @o_currentId integer;
  DECLARE @o_current NVARCHAR(255);
  DECLARE @o_containerId integer;
  DECLARE @o_container NVARCHAR(255);
  DECLARE @o_status integer;	
  DECLARE @o_startTime integer;	
  DECLARE @o_endTime integer;	
  DECLARE @o_libId integer;	
  DECLARE @o_libTypeId integer;	
  DECLARE @o_library NVARCHAR(255);
  DECLARE @o_sgId integer;	
  DECLARE @o_spareGroup NVARCHAR(255);
  DECLARE @o_mgId integer;
  DECLARE @o_mediaStatus integer;
  DECLARE @o_SP NVARCHAR(255);
  DECLARE @o_incrSP NVARCHAR(255);
  DECLARE @o_copyId integer;
  DECLARE @o_copy NVARCHAR(255);
  DECLARE @o_volNum integer;
  DECLARE @o_medLoc integer;
  DECLARE @o_currentLocId integer;
  DECLARE @o_volumeId integer;
  DECLARE @o_volumeFlags integer;
  DECLARE @o_lastBackupTime integer;
  DECLARE @o_lastRestoreTime integer;
  DECLARE @o_volumeFullReason integer;
  DECLARE @o_volumeFullTime integer;
  DECLARE @o_volumeFullJobId bigint;
  DECLARE @o_physicalBytesGB float;
  DECLARE @o_t_medId integer;
SET NOCOUNT ON
DECLARE @sourceLibOpt		integer
DECLARE @sourceShelfOpt		integer
DECLARE @sourceLocOpt		integer
DECLARE @destLibOpt			integer
DECLARE @destShelfOpt		integer
DECLARE @destLocOpt			integer
DECLARE @copyOpt			integer
DECLARE @userId		integer
DECLARE @startTime	integer
DECLARE @endTime	integer
DECLARE @poOpt		integer
DECLARE @orderBy 	integer
DECLARE @order	 	integer
DECLARE @VTOption	integer
DECLARE @jobAbort	integer
DECLARE @jobAll	integer
DECLARE @jobComplete	integer
DECLARE @jobRollBack	integer
DECLARE @ruleId		integer
DECLARE @tblSourceLibs		TABLE (t_libId int)
DECLARE @tblSourceShelves	TABLE (t_shelfId int)
DECLARE @tblSourceLocations	TABLE (t_locId int)
DECLARE @tblDestLibs		TABLE (t_libId int)
DECLARE @tblDestShelves		TABLE (t_shelfId int)
DECLARE @tblDestLocations	TABLE (t_locId int)
DECLARE @tblCopies		TABLE (t_CopyId int)
DECLARE @tblVTPolicies	TABLE (t_VTPoId int)
DECLARE @tblObjectList	TABLE (t_id int)
DECLARE @tblVTLocList	TABLE (id int, type int default(0), name nvarchar(128) default(''))
DECLARE @tblMedLocation	TABLE (t_MediaId int, t_MediaLocation int)
DECLARE @returnToAnyLib	integer
DECLARE @excludeRecall	integer
DECLARE @excludeRetired	integer
DECLARE @CurrentTime		integer
SET @CurrentTime = dbo.getUnixTime(getUTCDate())
/****************************************************************************************/
	-- Add non existing exportlocation and library into VTLocation table
	-- "Any library" destination: type = TM_LOCATION_TYPE_SLOT and value = 0
	-- Shelf location: type = TM_LOCATION_TYPE_SLOT and value = LibraryId and LibraryTypeId = CV_LIB_SHELF
	INSERT	INTO VTLocation
SELECT	1, LibraryId
	FROM	MMLibrary WITH (NOLOCK)
WHERE	LibraryTypeId != 3
AND		LibraryId NOT IN (SELECT Value FROM VTLocation WITH (NOLOCK) WHERE Type = 1)
	INSERT	INTO VTLocation
SELECT	2, ExportLocationId
	FROM	MMExportLocation WITH (NOLOCK)
WHERE	ExportLocationId NOT IN (SELECT Value FROM VTLocation WITH (NOLOCK) WHERE Type = 2)
	INSERT	INTO VTLocation
SELECT	4, LibraryId
	FROM	MMLibrary WITH (NOLOCK)
	WHERE	LibraryId > 0
AND		LibraryTypeId != 3
AND		LibraryTypeId != 8
	AND		StartVMSElementAddress != 0
AND		LibraryId NOT IN (SELECT Value FROM VTLocation WITH (NOLOCK) WHERE Type = 4)
/****************************************************************************************/
-- get parameters
INSERT INTO @tblSourceLibs		EXEC RptOptGetObjectList @i_jobId, 412850839, @sourceLibOpt OUTPUT		-- #define LIBRARY_ITEM 2049
if @i_noLicense = 0
	SET @sourceShelfOpt = 0
else
INSERT INTO @tblSourceShelves	EXEC RptOptGetObjectList @i_jobId, 1241148410, @sourceShelfOpt OUTPUT	-- #define RPT_MEDIA_SHELF_ITEM	7706
INSERT INTO @tblSourceLocations	EXEC RptOptGetObjectList @i_jobId, 1582403349, @sourceLocOpt OUTPUT		-- #define MEDIA_LOCATION_PROPERTY_ITEM 2254
INSERT INTO @tblDestLibs		EXEC RptOptGetObjectList @i_jobId, 598183341, @destLibOpt OUTPUT		-- #define RPT_VT_DEST_LIB_ITEM	7751
if @i_noLicense = 0
	SET @destShelfOpt = 0
else
INSERT INTO @tblDestShelves		EXEC RptOptGetObjectList @i_jobId, 2021610652, @destShelfOpt OUTPUT		-- #define RPT_VT_DEST_SHELF_ITEM 7752
INSERT INTO @tblDestLocations	EXEC RptOptGetObjectList @i_jobId, 1262223681, @destLocOpt OUTPUT		-- #define RPT_VT_DEST_LOC_ITEM	7753
INSERT INTO @tblCopies			EXEC RptOptGetObjectList @i_jobId, 1242473090, @copyOpt OUTPUT			-- Storage Policy Copy List
INSERT INTO @tblVTPolicies		EXEC RptOptGetObjectList @i_jobId, 216330024, @poOpt OUTPUT				-- #define TM_POLICY_ITEM 8462
SET @excludeRecall = dbo.GetOptionInt(1380799151, @i_jobId, 0, 0)
SET @excludeRetired = dbo.GetOptionInt(1133665814, @i_jobId, 0, 0)
SET @returnToAnyLib = dbo.GetOptionInt(1116141349, @i_jobId, 0, 0)
SET @userId	= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
SET @VTOption	= dbo.GetOptionInt(2007361542, @i_jobId, 0, 0)
SET @orderBy 	= dbo.GetOptionInt(876626965, @i_jobId, 0, 0)
SET @order	 	= dbo.GetOptionInt(1341843504, @i_jobId, 0, 0)
SET @jobAll		= dbo.GetOptionInt(419624884, @i_jobId, 0, 0)
IF  @jobAll	 = 1
	BEGIN
		SET @jobAbort	 = 1
		SET @jobComplete = 1
		SET @jobRollBack = 1
	END
ELSE
	BEGIN
SET @jobAbort	= dbo.GetOptionInt(1508335714, @i_jobId, 0, 0)
SET @jobComplete= dbo.GetOptionInt(2128763422, @i_jobId, 0, 0)
SET @jobRollBack= dbo.GetOptionInt(1713742704, @i_jobId, 0, 0)
	END
IF @VTOption = 2
BEGIN
	EXEC RptOptGetTime @i_jobId, @endTime OUTPUT, @startTime OUTPUT
	-- Swap starttime and endtime due to logic used in RptOptGetTime
	IF @startTime > @endTime
	BEGIN
		  DECLARE @tempTime INTEGER
		  SET @tempTime = @endTime
		  SET @endTime = @startTime
		  SET @startTime = @tempTime
	END
	IF ( @startTime IS NULL AND @endTime IS NULL )
	BEGIN
		SET @startTime = 0
		SET @endTime =0
	END
END
ELSE
	EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
IF @i_jobId < 0
BEGIN
	SET @sourceLibOpt		=0
	SET @sourceShelfOpt		=0
	SET @sourceLocOpt		=0
	SET @destLibOpt			=0
	SET @destShelfOpt		=0
	SET @destLocOpt			=0
	SET @copyOpt			=0
	SET @userId				=0
	SET @startTime			=0
	SET @endTime			=0
	SET @poOpt				=0
	SET @jobAbort			=1
	SET @jobComplete		=1
	SET @jobRollBack		=1
	SET @returnToAnyLib		=1
	SET @excludeRecall		=0
	SET @excludeRetired		=0
	SET @orderBy 			=1
	SET @VTOption			= ABS(@i_jobId)
END
IF object_id('tempdb.dbo.#TEMP_MED_LIST') IS NOT NULL DROP TABLE #TEMP_MED_LIST
CREATE TABLE #TEMP_MED_LIST(
	t_medId		integer,
	t_DueBack	bigint		default(0),
t_barCode	varchar(256)	default('N/A'),
	t_policyId	integer		default(0),
t_policy	nvarchar(128)	default('N/A'),
	t_userId	integer		default(0),
t_user		varchar(255)	default('N/A'),
	t_actionId	integer		default(0),
	t_actionType	integer		default(0),
	t_jobId		integer		default(0),
	t_jobType	integer		default(0),
	t_sourceId	integer		default(0),
t_source	nvarchar(128)	default('N/A'),
	t_destinationId	integer		default(0),
t_destination	nvarchar(128)	default('N/A'),
	t_currentId	integer		default(0),
t_current	nvarchar(128)	default('N/A'),
	t_containerId	integer		default(0),
t_container	nvarchar(256)	default('N/A'),
	t_status	integer		default(0),
	t_startTime	integer		default(0),
	t_endTime	integer		default(0),
	t_libId		integer		default(0),
	t_libTypeId	integer		default(0),
t_library	nvarchar(128)	default('N/A'),
	t_sgId		integer		default(0),
t_spareGroup	nvarchar(192)	default('N/A'),
	t_mgId		integer		default(0),
	t_mediaStatus	integer		default(0),
	t_SP		nvarchar(144)	default('N/A'),
	t_incrSP	nvarchar(144)	default('N/A'),
	t_copyId	integer		default(0),
	t_copy		nvarchar(64)	default('N/A'),
	t_volNum	integer		default(0),
	t_medLoc	integer		default(0),
	t_expLocId	integer		default(-1)
)
IF @VTOption = 3
BEGIN
	IF @poOpt = 0	-- all selected
	BEGIN
		DELETE FROM @tblVTPolicies
		INSERT INTO @tblVTPolicies SELECT policyId FROM VTPolicy WITH (READUNCOMMITTED)
	END
	DELETE @tblVTPolicies
	FROM @tblVTPolicies A, VTPolicy B WITH (READUNCOMMITTED)
	WHERE A.t_VTPoId = B.policyId
AND B.flag & 1 <> 1
	DECLARE	@policyId INTEGER
	DECLARE poList CURSOR FOR
		SELECT t_VTPoId FROM @tblVTPolicies
	OPEN poList
	FETCH NEXT FROM poList INTO @policyId
	WHILE @@FETCH_STATUS <> -1
	BEGIN
		INSERT INTO #TEMP_MED_LIST (t_medId, t_DueBack)
		EXEC RunTMRule 0, @policyId, 0
		UPDATE #TEMP_MED_LIST
		SET	t_policyId=@policyId,
			t_destinationId=(select destinationId from VTPolicy where policyId=@policyId)
		WHERE t_policyId=0
		FETCH NEXT FROM poList INTO @policyId
	END
	CLOSE poList
	DEALLOCATE poList
END
IF @VTOption = 2
BEGIN
	INSERT INTO VTRule
	SELECT 'tmp rule on ' + CONVERT(char(28), GETDATE(), 9), 0
	SELECT @ruleId = @@IDENTITY
	/************************************ Create tmp rule to schema ******************************/
	INSERT INTO VTRuleToSchema
SELECT @ruleId, (select SchemaId FROM VTRuleSchema WITH (READUNCOMMITTED) WHERE Type=32), @endTime, 2
	/************************************ run the rule *************************/
	INSERT INTO #TEMP_MED_LIST (t_medId, t_DueBack)
EXEC RunTMRule 1024, 0, @ruleId
	/************************************ remove the rule *************************/
	DELETE FROM VTRuleToSchema WHERE RuleId = @ruleId
	DELETE FROM VTRule WHERE RuleId = @ruleId
END
IF @VTOption = 1
BEGIN
	INSERT INTO #TEMP_MED_LIST(t_medId, t_DueBack, t_policyId, t_actionId, t_actionType, t_jobId, t_jobType, t_sourceId, t_destinationId, t_currentId, t_status, t_startTime, t_userId)
	SELECT AM.MediaId,MM.retentionExpireTime,policyId,A.actionId, A.actionType, jobId_l,jobType,sourceId,destinationId,currentId,operationState,
			datediff(second, '01/01/1970', startTime), A.userId --+ @compsec
	FROM VTAction A, VTActionMedia AM WITH (READUNCOMMITTED), MMMedia MM WITH (READUNCOMMITTED)
	WHERE A.actionid=AM.actionId AND AM.mediaId = MM.mediaId
	IF @poOpt <> 0
	BEGIN
		DELETE FROM #TEMP_MED_LIST
		WHERE (@poOpt < 0 AND t_policyId > 0) OR (@poOpt > 0 AND t_policyId NOT IN (SELECT t_VTPoId FROM @tblVTPolicies))
	END
	UPDATE	#TEMP_MED_LIST
	SET		t_user = name
	FROM	#TEMP_MED_LIST a, UMUsers b
	WHERE	a.t_userId = b.id AND a.t_userId > 0
END
IF @VTOption = 4
BEGIN
	INSERT INTO #TEMP_MED_LIST(t_medId, t_DueBack, t_barCode, t_policyId, t_policy, t_actionId, t_actionType, t_jobId, t_jobType, t_sourceId, t_destinationId, t_status, t_startTime, t_endTime, t_userId, t_user)
	SELECT	MediaId,duebacktime,barCode,policyId,policyName,actionId, actionType, jobId_l,jobType,sourceId,destinationId,state,
			datediff(second, '01/01/1970', startTime), --+ @compsec,
			datediff(second, 'january 01, 1970',endTime), userId, userName --+ @compsec
	FROM	VTHistory WITH (READUNCOMMITTED)
WHERE	@jobComplete > 0 AND (state = 2) OR
@jobAbort > 0 AND (state & (1+8)) > 0 OR
@jobRollBack > 0 AND (state & 4) > 0
	IF @poOpt <> 0
	BEGIN
		DELETE FROM #TEMP_MED_LIST
		WHERE (@poOpt < 0 AND t_policyId > 0) OR (@poOpt > 0 AND t_policyId NOT IN (SELECT t_VTPoId FROM @tblVTPolicies))
	END
END
IF @startTime > 0 OR @endTime > 0
BEGIN
	DELETE	#TEMP_MED_LIST
WHERE	@VTOption = 1  AND (@endTime > 0 AND t_startTime > @endTime) OR
@VTOption = 2 AND (@endTime > @CurrentTime AND t_DueBack > @endTime OR @startTime > @CurrentTime AND t_DueBack < @startTime) OR
@VTOption = 4 AND ((@startTime > 0 AND t_endTime < @startTime) OR (@endTime > 0 AND t_startTime > @endTime))
END
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
UPDATE #TEMP_MED_LIST
SET t_libId		= M.LibraryId,
	t_libTypeId	= L.libraryTypeId,
	t_Library	= (CASE WHEN M.LibraryId>0 THEN L.AliasName ELSE '' END),
	t_barCode	= M.BarCode,
	t_sgId		= M.SpareGroupId,
	t_spareGroup = (case M.SpareGroupId when 0 then '' else (select SpareGroupName from MMSpareGroup where SpareGroupId=M.SpareGroupId) end),
	t_mgId		= (select TOP 1 mediaGroupId from MMVolume where mediaId=M.mediaId),
	t_containerId=M.ContainerId,
	t_container	= (case M.ContainerId when 0 then '' else (select ContainerName from MMContainer where ContainerId=M.ContainerId) end),
	t_medLoc	= M.MediaLocation,
	t_expLocId	= (case when t_currentId=0 AND M.MediaLocation=3 then M.ExportLocationId else -1 end)
FROM #TEMP_MED_LIST, MMMedia M, MMLibrary L
WHERE t_medId = M.MediaId AND M.LibraryId = L.LibraryId
IF @VTOption IN (3, 2)
	UPDATE	#TEMP_MED_LIST
	SET		t_currentId = Loc.LocationId, t_sourceId = Loc.LocationId
	FROM	#TEMP_MED_LIST tt, VTLocation Loc
	WHERE	((tt.t_libTypeId <> 8 AND tt.t_medLoc <> 3 AND Loc.Value = tt.t_libId AND Loc.Type = 1)
		OR   (tt.t_libTypeId = 8  AND tt.t_medLoc = 3 AND tt.t_expLocId = 0 AND Loc.Value = tt.t_libId AND Loc.Type = 1)
		OR   (tt.t_libTypeId <> 8 AND tt.t_medLoc = 3 AND tt.t_expLocId = 0 AND Loc.Value = 0 AND Loc.Type = 2)
		OR   (tt.t_medLoc = 3 AND tt.t_expLocId > 0 AND Loc.Value = tt.t_expLocId AND Loc.Type = 2))
UPDATE #TEMP_MED_LIST
SET	t_expLocId = -1
FROM	#TEMP_MED_LIST, MMLibrary
WHERE	t_expLocId = 0 AND t_libId = libraryId AND LibraryTypeId = 8
UPDATE #TEMP_MED_LIST
SET t_SP=G.name,t_incrSP=(select name from archGroup tt where tt.id=G.incrSP),t_copyId=C.id,t_copy=C.name
FROM #TEMP_MED_LIST, archStream S, archGroup G, archGroupCopy C
WHERE t_mgId>0 AND S.mediaGroupId=t_mgId AND G.id=S.archGroupId AND C.id=S.archGroupCopyId
AND C.extendedFlags & 2 = 0
INSERT INTO @tblMedLocation
SELECT	MediaId, MediaLocation
FROM	MMMedia, #TEMP_MED_LIST
WHERE	MediaId = t_medId
IF @VTOption = 1 AND @excludeRecall > 0
BEGIN
	-- Do not include media in library for recall action
	DELETE	FROM #TEMP_MED_LIST
WHERE	t_actionType = 2 and t_medLoc = 1
END
IF @VTOption = 2 AND @excludeRetired > 0
BEGIN
	-- Do not include retired media in library
	DELETE	FROM #TEMP_MED_LIST
	FROM #TEMP_MED_LIST a, MMMedia b, MMSpareGroup c
	WHERE	a.t_medId = b.mediaid
	and b.SpareGroupId = c.SpareGroupId
	and c.SpareGroupType = 8 and b.MediaFlags = 3
END
IF @VTOption = 2 AND @copyOpt > 0 and exists (select 1 FROM @tblCopies)
BEGIN
	-- Remove media not belongs to selected storage policy copy
	DELETE	FROM #TEMP_MED_LIST
	WHERE	t_copyId NOT IN (SELECT t_copyId FROM @tblCopies)
END
IF @VTOption = 2 AND @sourceLibOpt > 0 and exists (select 1 FROM @tblSourceLibs)
BEGIN
	-- Remove media not belongs to selected library
	DELETE	FROM #TEMP_MED_LIST
	WHERE	t_libId NOT IN (SELECT t_libId FROM @tblSourceLibs)
END
ELSE IF	@sourceLibOpt <> 0
BEGIN
	-- Remove media if source is library but not in selected library list
	-- Remove media if source is library but no library is selected
	DELETE	#TEMP_MED_LIST
	FROM	#TEMP_MED_LIST AS tt, VTLocation AS Loc, MMLibrary AS Lib
	WHERE	tt.t_sourceId = Loc.LocationId AND Loc.Type = 1 AND Loc.Value = Lib.LibraryId
	AND		Lib.LibraryId > 0 AND Lib.LibraryTypeId <> 8
	AND		(@sourceLibOpt < 0 OR @sourceLibOpt > 0 AND Lib.LibraryId NOT IN (select t_libId from @tblSourceLibs))
END
-- The following logic is same for all report
BEGIN
	-- Remove media if source is shelf but not in selected shelf list
	-- Remove media if source is shelf but no shelf is selected
	IF	@sourceShelfOpt <> 0
		DELETE	#TEMP_MED_LIST
		FROM	#TEMP_MED_LIST AS tt, VTLocation AS Loc, MMLibrary AS Lib
		WHERE	tt.t_sourceId = Loc.LocationId AND Loc.Type = 1 AND Loc.Value = Lib.LibraryId
		AND		Lib.LibraryId > 0 AND Lib.LibraryTypeId = 8
		AND		(@sourceShelfOpt < 0 OR @sourceShelfOpt > 0 AND Lib.LibraryId NOT IN (select t_shelfId from @tblSourceShelves))
	-- Remove media if source is export location but not in selected location list
	-- Remove media if source is export location but no location is selected
	IF @sourceLocOpt <> 0
		DELETE	#TEMP_MED_LIST
		FROM #TEMP_MED_LIST AS tt, VTLocation AS Loc, MMExportLocation as Exp
		WHERE	tt.t_sourceId = Loc.LocationId AND Loc.Type = 2 AND Loc.Value = Exp.ExportLocationId
		AND		(@sourceLocOpt < 0 OR @sourceLocOpt > 0 AND Exp.ExportLocationId NOT IN (select t_locId from @tblSourceLocations))
END
-- Destination location does not apply to due back report
IF @VTOption <> 2
BEGIN
	-- Remove media with destination is return to any library if this destination is not selected
	--IF NOT EXISTS (SELECT * FROM @tblDestLibs WHERE t_libId = -1)
	IF @returnToAnyLib = 0
	BEGIN
		DELETE	#TEMP_MED_LIST
		FROM	#TEMP_MED_LIST AS tt, VTLocation AS Loc
		WHERE	tt.t_destinationId = Loc.LocationId AND Loc.Type = 1 AND Loc.Value = 0
	END
	-- Remove media if destination is library but not in selected library list
	-- Remove media if destination is library but no library is selected
	IF	@destLibOpt <> 0
		DELETE	#TEMP_MED_LIST
		FROM	#TEMP_MED_LIST AS tt, VTLocation AS Loc, MMLibrary AS Lib
		WHERE	tt.t_destinationId = Loc.LocationId AND Loc.Type = 1 AND Loc.Value = Lib.LibraryId
		AND		Lib.LibraryId > 0 AND Lib.LibraryTypeId <> 8
		AND		(@destLibOpt < 0 OR @destLibOpt > 0 AND Lib.LibraryId NOT IN (select t_libId from @tblDestLibs))
	-- Remove media if destination is shelf but not in selected shelf list
	-- Remove media if destination is shelf but no shelf is selected
	IF	@destShelfOpt <> 0
		DELETE	#TEMP_MED_LIST
		FROM	#TEMP_MED_LIST AS tt, VTLocation AS Loc, MMLibrary AS Lib
		WHERE	tt.t_destinationId = Loc.LocationId AND Loc.Type = 1 AND Loc.Value = Lib.LibraryId
		AND		Lib.LibraryId > 0 AND Lib.LibraryTypeId = 8
		AND		(@destShelfOpt < 0 OR @destShelfOpt > 0 AND Lib.LibraryId NOT IN (select t_shelfId from @tblDestShelves))
	-- Remove media if destination is export location but not in selected location list
	-- Remove media if destination is export location but no location is selected
	IF @destLocOpt <> 0
		DELETE	#TEMP_MED_LIST
		FROM #TEMP_MED_LIST AS tt, VTLocation AS Loc, MMExportLocation as Exp
		WHERE	tt.t_destinationId = Loc.LocationId AND Loc.Type = 2 AND Loc.Value = Exp.ExportLocationId
		AND		(@destLocOpt < 0 OR @destLocOpt > 0 AND Exp.ExportLocationId NOT IN (select t_locId from @tblDestLocations))
END
--security check
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND (@destLibOpt = 0 OR @destShelfOpt = 0)
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 0, 0, '#rptUserObjects'
  IF @destLibOpt = 0
	DELETE #TEMP_MED_LIST
	WHERE 0 = (select count(*) from #rptUserObjects where libraryId IN (0, t_libId))
  IF @destShelfOpt = 0
	DELETE #TEMP_MED_LIST
	WHERE 0 = (select count(*) from #rptUserObjects where vtShelfId IN (0, t_libId))
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
END
UPDATE #TEMP_MED_LIST
SET	t_policy = (select policyName from VTPolicy where policyId=t_policyId)
WHERE	t_policyId > 0 and t_policy = 'N/A'
INSERT INTO @tblVTLocList(id) SELECT DISTINCT t_sourceId FROM #TEMP_MED_LIST
INSERT INTO @tblVTLocList(id) SELECT DISTINCT t_destinationId FROM #TEMP_MED_LIST WHERE t_destinationId NOT IN (select id from @tblVTLocList)
INSERT INTO @tblVTLocList(id) SELECT DISTINCT t_currentId FROM #TEMP_MED_LIST WHERE t_currentId NOT IN (select id from @tblVTLocList)
UPDATE @tblVTLocList
SET type=VTLocation.type, name=(CASE VTLocation.Type
	WHEN 1 THEN (CASE Value WHEN 0 THEN 'Inside Library' ELSE (SELECT AliasName FROM MMLibrary WHERE LibraryId=Value) END)
        WHEN 2 THEN (CASE Value WHEN 0 THEN 'Outside' ELSE (SELECT ExportLocation FROM MMExportLocation WHERE ExportLocationId=Value) END)
        WHEN 4 THEN (CASE Value WHEN 0 THEN 'At virtual mailslot' ELSE (SELECT AliasName+' virtual mailslot' FROM MMLibrary WHERE LibraryId=Value) END)
        ELSE 'Not Available'END)
from VTLocation, @tblVTLocList
WHERE id>0 and id=LocationId
UPDATE #TEMP_MED_LIST
SET 	t_source	=(select name from @tblVTLocList where id=t_sourceId),
	t_destination	=(select name from @tblVTLocList where id=t_destinationId),
	t_current	=(select name from @tblVTLocList where id=t_currentId)
UPDATE #TEMP_MED_LIST
SET t_current=	(CASE WHEN t_currentId>0 THEN t_current+' ' ELSE '' END) +
		(CASE MediaLocation
		when 1 then (select SlotName from MMSlot where MediaId=M.MediaId)
		when 2 then (select AliasName from MMDrive where MediaId=M.MediaId)
		when 3 then (select ExportLocation from MMExportLocation where exportLocationId=M.exportLocationId)
		else '' end)
FROM #TEMP_MED_LIST, MMMedia M, @tblVTLocList L
WHERE (t_currentId=0 OR t_currentId=L.id AND L.type IN (1, 4)) AND t_medId=M.MediaId
IF @VTOption <> 1 AND @VTOption <> 4
BEGIN
	IF @poOpt > 0
		UPDATE #TEMP_MED_LIST
		set t_sourceId=t_currentId,t_source=t_current
ELSE IF @VTOption = 2
		UPDATE #TEMP_MED_LIST
		set t_sourceId=t_currentId,t_source=t_current,t_destinationId=t_libId,t_destination=t_Library
END
SELECT DISTINCT V.VolumeId,V.VolumeFlags,V.LastBackupTime,V.LastRestoreTime,V.VolumeFullReason,V.VolumeFullTime,V.VolumeFullJobId,ROUND(V.physicalBytesMB/1024.0,2) AS physicalBytesGB,
	volStatus=(case VolumeFlags when 4 then 1 when 3 then 2 when 1 then 3 when 7 then 4 when 2 then 5 when 5 then 6 else 0 end), V.MediaId
INTO #TEMP_VOL_LIST
FROM MMVolume V, #TEMP_MED_LIST
WHERE V.MediaId=t_medId
UPDATE #TEMP_VOL_LIST
SET	physicalBytesGB = -1
FROM	#TEMP_VOL_LIST T, MMMedia M
WHERE	T.MediaId = M.MediaId AND M.isInMediaGroup=0
-- Return total capacity of tape for due back media
IF @VTOption = 2
	UPDATE #TEMP_VOL_LIST
	SET	physicalBytesGB = ROUND(MS.TotalSpaceMB/1024.0,2)
	FROM	#TEMP_VOL_LIST T, MMVolume V, MMMediaSide MS
	WHERE	T.VolumeId = V.VolumeId
	AND		V.MediaSideId = MS.MediaSideId
UPDATE #TEMP_MED_LIST
SET  t_mediaStatus=(select min(volStatus) from #TEMP_VOL_LIST where t_medId=mediaId),
	t_volNum=(select count(*) from #TEMP_VOL_LIST where t_medId=mediaId)
IF @i_isXML > 0
	INSERT INTO #RETURN_MED_LIST SELECT * FROM #TEMP_MED_LIST LEFT OUTER JOIN #TEMP_VOL_LIST ON t_MedId=MediaId
ELSE
BEGIN
	IF @orderBy = 1
	BEGIN
		IF object_id('tempdb.dbo.#tblMediaInfo') IS NOT NULL DROP TABLE #tblMediaInfo
		CREATE TABLE #tblMediaInfo (mediaId int, PhysicalBytesGB float, UnixLastBackupTime int, UnixLastRestoreTime int, LastBackupTime varchar(20), LastRestoreTime varchar(20))
		INSERT INTO #tblMediaInfo
		SELECT mediaId, SUM(physicalBytesGB), max(LastBackupTime), max(LastRestoreTime), '', ''
		FROM #TEMP_VOL_LIST
		GROUP BY mediaId
		UPDATE	#tblMediaInfo
		SET		LastBackupTime = (CASE WHEN UnixLastBackupTime > 0 THEN CONVERT(char(20), dbo.GetDateTime(UnixLastBackupTime)) ELSE 'N/A' END),
			    LastRestoreTime = (CASE WHEN UnixLastRestoreTime > 0 THEN CONVERT(char(20), dbo.GetDateTime(UnixLastRestoreTime)) ELSE 'N/A' END)
		SELECT	t_medId as MediaId,
				t_barCode as Barcode,
				t_policy as TrackingPolicy,
				t_jobId as JobId,
				t_jobType as JobType,
				t_actionId as ActionId,
				t_source as SourceLocation,
				t_destination as Destination,
				t_current as CurrentLocation,
				t_container as Container,
				t_libId as LibraryId,
				t_library as Library,
				t_status as [Status],
				t_SP as StoragePolicy,
				t_copy as Copy,
				t_spareGroup as SpareGroup,
				t_DueBack as UnixDueBackime,
				(CASE WHEN t_DueBack > 0 THEN CONVERT(char(20), dbo.GetDateTime(t_DueBack)) ELSE 'N/A' END) as DueBackTime,
				t_startTime as UnixStartTime,
				(CASE WHEN t_startTime > 0 THEN CONVERT(char(20), dbo.GetDateTime(t_startTime)) ELSE 'N/A' END) as StartTime,
				t_endTime as UnixEndTime,
				(CASE WHEN t_endTime > 0 THEN CONVERT(char(20), dbo.GetDateTime(t_endTime)) ELSE 'N/A' END) as EndTime,
				t_status as ActionStatus,
				t_mediaStatus as MediaStatus,
				PhysicalBytesGB,
				LastBackupTime,
				LastRestoreTime
		FROM #TEMP_MED_LIST INNER JOIN #tblMediaInfo ON t_MedId=MediaId
		DROP TABLE #tblMediaInfo
	END
	ELSE
IF @orderBy = 9
	BEGIN
		IF @order = 0 or @order is null
			SELECT * FROM #TEMP_MED_LIST LEFT OUTER JOIN #TEMP_VOL_LIST ON t_MedId=MediaId ORDER BY t_source, t_containerId, t_actionId, t_barcode
		ELSE
			SELECT * FROM #TEMP_MED_LIST LEFT OUTER JOIN #TEMP_VOL_LIST ON t_MedId=MediaId ORDER BY t_source DESC, t_containerId, t_actionId, t_barcode
	END
ELSE IF @orderBy = 8
	BEGIN
		IF @order = 0 or @order is null
			SELECT * FROM #TEMP_MED_LIST LEFT OUTER JOIN #TEMP_VOL_LIST ON t_MedId=MediaId ORDER BY t_destination, t_containerId, t_actionId, t_barcode
		ELSE
			SELECT * FROM #TEMP_MED_LIST LEFT OUTER JOIN #TEMP_VOL_LIST ON t_MedId=MediaId ORDER BY t_destination DESC, t_containerId, t_actionId, t_barcode
	END
ELSE IF @orderBy = 7
	BEGIN
		IF @order = 0 or @order is null
			SELECT * FROM #TEMP_MED_LIST LEFT OUTER JOIN #TEMP_VOL_LIST ON t_MedId=MediaId ORDER BY t_actionId, t_containerId, t_barcode
		ELSE
			SELECT * FROM #TEMP_MED_LIST LEFT OUTER JOIN #TEMP_VOL_LIST ON t_MedId=MediaId ORDER BY t_actionId DESC, t_containerId, t_barcode
	END
ELSE IF @orderBy = 17
	BEGIN
		IF @order = 0 or @order is null
			SELECT * FROM #TEMP_MED_LIST LEFT OUTER JOIN #TEMP_VOL_LIST ON t_MedId=MediaId ORDER BY t_barcode
		ELSE
			SELECT * FROM #TEMP_MED_LIST LEFT OUTER JOIN #TEMP_VOL_LIST ON t_MedId=MediaId ORDER BY t_barcode DESC
	END
	ELSE
	BEGIN
		IF @order = 0 or @order is null
			SELECT * FROM #TEMP_MED_LIST LEFT OUTER JOIN #TEMP_VOL_LIST ON t_MedId=MediaId ORDER BY t_containerId, t_actionId, t_barcode
		ELSE
			SELECT * FROM #TEMP_MED_LIST LEFT OUTER JOIN #TEMP_VOL_LIST ON t_MedId=MediaId ORDER BY t_containerId DESC, t_actionId, t_barcode
		END
END
DROP TABLE #TEMP_MED_LIST
DROP TABLE #TEMP_VOL_LIST
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetTmMedia')
	delete from GxQscripts where name = 'RptGetTmMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetTmMedia')
	delete from GXDBVersions where aliasname = 'RptGetTmMedia'
GO

insert into GXDBVersions values(2, 'RptGetTmMedia',  '00010054000200120000', 'RptGetTmMedia', '00010054000200120000')
GO

