

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetTiles.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "App_GetAuditedSessions"
--	|	This Procedure is used to modify/add/delete users
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetTiles <<<'

IF EXISTS (select * from sysobjects where name='RptGetTiles')
	drop procedure RptGetTiles
IF EXISTS (select * from GxQscripts where name='RptGetTiles')
	delete from GxQscripts where name = 'RptGetTiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetTiles')
	delete from GXDBVersions where aliasname = 'RptGetTiles'
GO
print '... Creating Procedure: RptGetTiles'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetTiles
  @i_RequestXML XML,
  @i_UserId INT = 0,
  @i_LocaleId INT = 0
AS
  DECLARE @response xml
SET NOCOUNT ON
DECLARE @commcell XML
SELECT @commcell = info.n.query('./commcell') FROM @i_RequestXML.nodes('/WebReport_GetTilesReq') AS info(n)
DECLARE @isAlarm INT
DECLARE @alarmId INT
DECLARE @tileId INT
DECLARE @alarmCriteriaId INT = 0
DECLARE @alarmOperationType INT
DECLARE @alarmParam NVARCHAR(MAX)
SELECT @isAlarm = ISNULL(info.n.value('@isAlarm', 'int'), 0) FROM @i_RequestXML.nodes('/WebReport_GetTilesReq') AS info(n)
SELECT @alarmId = ISNULL(info.n.value('@alarmId', 'int'), 0) FROM @i_RequestXML.nodes('/WebReport_GetTilesReq') AS info(n)
DECLARE @inputTiles TABLE(tileId INT, flags INT, CollectionQuery NVARCHAR(MAX))
DECLARE @inputStatus TABLE(statusId INT) --TODO: Severity set in input XML. Final response should contain only these status responses
IF (@isAlarm = 0)	--Regular response
BEGIN
	IF EXISTS(SELECT B.value('.', 'int') from @i_RequestXML.nodes('/WebReport_GetTilesReq/inclusion') T(C) CROSS APPLY C.nodes('tileId') AS N(B))
	BEGIN
		INSERT INTO @inputTiles SELECT TileId, Flags, CollectionQuery FROM RptTiles WHERE TileId IN
			(SELECT B.value('.', 'int') from @i_RequestXML.nodes('/WebReport_GetTilesReq/inclusion') T(C) CROSS APPLY C.nodes('tileId') AS N(B))
	END
	IF EXISTS(SELECT B.value('.', 'int') from @i_RequestXML.nodes('/WebReport_GetTilesReq/inclusion') T(C) CROSS APPLY C.nodes('categoryId') AS N(B))
	BEGIN
		INSERT INTO @inputTiles SELECT TileId, Flags, CollectionQuery FROM RptTiles WHERE TileCategoryId IN
			(SELECT B.value('.', 'int') from @i_RequestXML.nodes('/WebReport_GetTilesReq/inclusion') T(C) CROSS APPLY C.nodes('categoryId') AS N(B))
	END
	IF NOT EXISTS (SELECT * FROM @inputTiles)
	BEGIN
		INSERT INTO @inputTiles SELECT TileId, Flags, CollectionQuery FROM RptTiles
	END
END
ELSE	--Alarm response. Pickup the appropriate tileIds
	BEGIN
		DECLARE @alarmProps XML
		SELECT @alarmProps = extendedProps FROM CustomAlarmProps WITH (NOLOCK) WHERE AlarmId = @alarmId
		SET @tileId =  @alarmProps.value('(/alarmProps/@tileID)[1]', 'int')
		SET @alarmCriteriaId =  @alarmProps.value('(/alarmProps/@alertCriteriaIdForTile)[1]', 'int')
		SET @alarmOperationType =  ISNULL(@alarmProps.value('(/alarmProps/@alarmOperationType)[1]', 'int'), -1)
		SET @alarmParam =  @alarmProps.value('(/alarmProps/@paramValue)[1]', 'NVARCHAR(MAX)')
		IF  @tileId <> 0
			INSERT INTO @inputTiles SELECT TileId, Flags, CollectionQuery FROM RptTiles WITH(NOLOCK) WHERE TileId = @tileId
		ELSE IF @alarmCriteriaId = 0
			INSERT INTO @inputTiles SELECT TileId, Flags, CollectionQuery FROM RptTiles
	END
IF NOT EXISTS (SELECT * FROM @inputTiles)
BEGIN
	SET @response = NULL
	GOTO END_PROC
END
DELETE x FROM (
  SELECT *, rn=ROW_NUMBER() OVER (PARTITION BY tileId ORDER BY CollectionQuery)
  FROM @inputTiles
) x
where rn > 1;
IF  object_id('tempdb.dbo.#tileQueryOutcome') is not null
	DROP TABLE #tileQueryOutcome
IF  object_id('tempdb.dbo.#tileSeverityThresholds') is not null
	DROP TABLE #tileSeverityThresholds
IF  object_id('tempdb.dbo.#tileOutcomes') is not null
	DROP TABLE #tileOutcomes
IF  object_id('tempdb.dbo.#tileRecommendations') is not null
	DROP TABLE #tileRecommendations
IF  object_id('tempdb.dbo.#tileAlarmCriteria') is not null
	DROP TABLE #tileAlarmCriteria
CREATE TABLE #tileQueryOutcome(
	tileId INT,
	tileName NVARCHAR(512),
	tileMsgid BIGINT,
	categoryId INT,
	categoryName NVARCHAR(512),
	categoryMsgId BIGINT,
	severity INT,
	severityThresholdXML XML,
	outcomeXML XML,
	recommendationXML XML,
	detailedReportName NVARCHAR(1024),	--TODO: Use GUID instead of name
	alarmCriteriaXML XML
)
CREATE TABLE #tileSeverityThresholds(
	tileId INT,
	msgId BIGINT,
	value NVARCHAR(MAX),
	localizedValue NVARCHAR(MAX)
)
CREATE TABLE #tileOutcomes(
	tileId INT,
	outcomeKeyMsgId BIGINT,
	outcomeKeyMsgParams XML,
	localizedKey NVARCHAR(MAX),
	outcomeKey NVARCHAR(MAX),
	outcomeValue NVARCHAR(MAX),
	outcomeType INT,
	fixWFMsgId INT,
	fixWFLocalizedName NVARCHAR(MAX),
	fixWFName NVARCHAR(MAX),
	fixWFGUID NVARCHAR(512)
)
CREATE TABLE #tileRecommendations(
	tileId INT,
	msgId BIGINT,
	value NVARCHAR(MAX),
	localizedValue NVARCHAR(MAX)
)
CREATE TABLE #tileAlarmCriteria(
	tileId INT,
	criteriaId INT,
	msgId BIGINT,
	alarm NVARCHAR(MAX),
	localizedAlarm NVARCHAR(MAX),
	alarmValue NVARCHAR(MAX),
	defaultComparator NVARCHAR(10)
)
DECLARE @curTileIT INT
DECLARE @curCollectionQuery NVARCHAR(MAX)
DECLARE	tileCursor CURSOR FOR
SELECT TileId, CollectionQuery FROM @inputTiles
OPEN tileCursor
FETCH FROM tileCursor INTO @curTileIT, @curCollectionQuery
WHILE @@FETCH_STATUS = 0
BEGIN
	INSERT INTO #tileQueryOutcome
		EXECUTE sp_executesql @curCollectionQuery
	FETCH FROM tileCursor INTO @curTileIT, @curCollectionQuery
END
CLOSE tileCursor
DEALLOCATE tileCursor
ALTER TABLE #tileQueryOutcome ADD tileLocalizedName NVARCHAR(MAX)
ALTER TABLE #tileQueryOutcome ADD catLocalizedName NVARCHAR(MAX)
UPDATE #tileQueryOutcome SET tileLocalizedName = dbo.RptGetLocalizedString(@i_LocaleId, tileMsgid, '')
UPDATE #tileQueryOutcome SET catLocalizedName = dbo.RptGetLocalizedString(@i_LocaleId, categoryMsgId, '')
INSERT INTO #tileSeverityThresholds(tileId, msgId, value, localizedValue)
SELECT
	Q.tileId,
	info.n.value('@msgId', 'BIGINT'),
	info.n.value('@value', 'NVARCHAR(MAX)'),
	dbo.RptGetLocalizedString(@i_LocaleId, info.n.value('@msgId', 'BIGINT'), '')
FROM #tileQueryOutcome Q
	CROSS APPLY severityThresholdXML.nodes('/thresholds') AS info(n)
INSERT INTO #tileOutcomes(tileId, outcomeKeyMsgId, localizedKey, outcomeKey, outcomeValue,	outcomeType, outcomeKeyMsgParams, fixWFMsgId, fixWFLocalizedName, fixWFName, fixWFGUID)
SELECT
	Q.tileId,
	info.n.value('@outcomeKeyMsgId', 'BIGINT'),
	dbo.RptGetLocalizedString(@i_LocaleId, info.n.value('@outcomeKeyMsgId', 'BIGINT'), info.n.query('./outcomeKeyMsgParams/MsgParams')),
	info.n.value('@outcomeKey', 'NVARCHAR(MAX)'),
	info.n.value('@outcomeValue', 'NVARCHAR(MAX)'),
	info.n.value('@outcomeType', 'INT'),
	info.n.query('./outcomeKeyMsgParams/MsgParams'),
	info.n.value('@fixWFMsgId', 'BIGINT'),
	dbo.RptGetLocalizedString(@i_LocaleId, info.n.value('@fixWFMsgId', 'BIGINT'), ''),
	info.n.value('@fixWFName', 'NVARCHAR(MAX)'),
	info.n.value('@fixWFGUID', 'NVARCHAR(512)')
FROM #tileQueryOutcome Q
	CROSS APPLY outcomeXML.nodes('/outcomes') AS info(n)
INSERT INTO #tileRecommendations(tileId, msgId, value, localizedValue)
SELECT
	Q.tileId,
	info.n.value('@msgId', 'BIGINT'),
	info.n.value('@value', 'NVARCHAR(MAX)'),
	dbo.RptGetLocalizedString(@i_LocaleId, info.n.value('@msgId', 'BIGINT'), '')
FROM #tileQueryOutcome Q
	CROSS APPLY recommendationXML.nodes('/recommendations') AS info(n)
INSERT INTO #tileAlarmCriteria(tileId, criteriaId, msgId, alarm, localizedAlarm, alarmValue, defaultComparator)
SELECT
	Q.tileId,
	info.n.value('@criteriaId', 'INT'),
	info.n.value('@msgId', 'BIGINT'),
	info.n.value('@alarm', 'NVARCHAR(MAX)'),
	dbo.RptGetLocalizedString(@i_LocaleId, info.n.value('@msgId', 'BIGINT'), ''),
	info.n.value('@alarmValue', 'NVARCHAR(MAX)'),
	ISNULL(info.n.value('@defaultComparator', 'NVARCHAR(MAX)'), '')
FROM #tileQueryOutcome Q
	CROSS APPLY alarmCriteriaXML.nodes('/alarmCriteria') AS info(n)
--SELECT * FROM #tileQueryOutcome
--SELECT * FROM #tileSeverityThresholds
--SELECT * FROM #tileOutcomes
--SELECT * FROM #tileRecommendations
--SELECT * FROM #tileAlarmCriteria
DECLARE @tilesXML XML
IF (@isAlarm = 0)--Not Alarm
BEGIN
SET @tilesXML =
	(SELECT
		t.tileId AS '@tileId',
		CASE
			WHEN LEN(t.tileLocalizedName) > 0 THEN t.tileLocalizedName
			ELSE t.tileName
		END AS '@tileName',
		t.detailedReportName AS '@detailReportName',
		(
			SELECT
				t.categoryId AS '@categoryId',
				CASE
					WHEN LEN(t.catLocalizedName) > 0 THEN t.catLocalizedName
					ELSE t.categoryName
				END AS '@categoryName'
			FOR XML PATH('category'), TYPE
		),
		(
			SELECT
				ti.flags & 1 AS '@height'
			FOR XML PATH('tileProperty'), type
		),
		(
			SELECT
				t.severity AS '@status',
				(
					SELECT CASE ISNULL(ST.localizedValue, '') WHEN '' THEN ST.value ELSE ST.localizedValue END AS '@val' FROM #tileSeverityThresholds ST  WHERE ST.tileId = t.tileId
					FOR XML PATH('thresholds'), TYPE
				)
			FOR XML PATH('status'), TYPE
		),
		(
			SELECT
				OC.outcomeType AS '@outcomeType',
				CASE ISNULL(OC.localizedKey, '') WHEN '' THEN OC.outcomeKey ELSE OC.localizedKey END AS '@key',
				OC.outcomeValue AS '@value',
				OC.fixWFGUID AS '@fixWfGuid',
				OC.fixWFName AS '@fixName',
				CASE ISNULL(OC.fixWFLocalizedName, '') WHEN '' THEN OC.fixWFName ELSE OC.fixWFLocalizedName END AS '@fixDisplayName',
				(SELECT WorkflowId FROM WF_Definition WITH (NOLOCK) WHERE Name = OC.fixWFName) AS '@fixId'
			FROM #tileOutcomes OC WHERE OC.tileId = t.tileId
			FOR XML PATH('outcomes'), TYPE
		),
		(
			SELECT CASE ISNULL(TR.localizedValue, '') WHEN '' THEN TR.value ELSE TR.localizedValue END AS '@val' FROM #tileRecommendations TR WHERE TR.tileId = t.tileId
			FOR XML PATH('recommendations'), TYPE
		),
		(
			SELECT criteriaId AS '@criteriaId', CASE ISNULL(TA.localizedAlarm, '') WHEN '' THEN TA.alarm ELSE TA.localizedAlarm END AS '@criteriaValue' FROM #tileAlarmCriteria TA WHERE TA.tileId = t.tileId
			FOR XML PATH('alertCriteria'), TYPE
		)
	FROM #tileQueryOutcome t INNER JOIN @inputTiles ti
	ON t.tileId = ti.tileId
	FOR XML PATH('tiles'), TYPE)
DECLARE @infoCount INT, @goodCount INT, @warningCount INT, @criticalCount INT
SELECT
	@infoCount = SUM(CASE WHEN severity = 1 THEN 1 ELSE 0 END),
	@goodCount = SUM(CASE WHEN severity = 2 THEN 1 ELSE 0 END),
	@warningCount = SUM(CASE WHEN severity = 3 THEN 1 ELSE 0 END),
	@criticalCount = SUM(CASE WHEN severity = 4 THEN 1 ELSE 0 END)
FROM #tileQueryOutcome
SET @response =
(
	SELECT
		@infoCount AS '@info',
		@goodCount AS '@good',
		@warningCount AS '@warning',
		@criticalCount AS '@critical',
		@commcell,
		@tilesXML
	FOR XML PATH('WebReport_GetTilesResp')
)
END
ELSE --IF @isAlarm = 1
BEGIN
	--SELECT @alarmCriteriaId AS alarmCriteriaId, @alarmOperationType AS alarmOperationType, @alarmParam AS alarmParam
	DECLARE @isAlertConditionMet INT = 0
	IF @alarmCriteriaId = 0 --Check for status. It can have one or more tiles in this case.
	BEGIN
		DECLARE @ipSeverity INT
		SELECT @ipSeverity = CASE @alarmParam WHEN 'info' THEN 1 WHEN 'good' THEN 2 WHEN 'warning' THEN 3 WHEN 'critical' THEN 4 ELSE 5 END
		--Delete not matching condition
		DELETE FROM #tileQueryOutcome WHERE severity <> @ipSeverity
		DELETE FROM #tileOutcomes WHERE tileId NOT IN (SELECT tileId FROM #tileQueryOutcome)
		DELETE FROM #tileRecommendations WHERE tileId NOT IN (SELECT tileId FROM #tileQueryOutcome)
		DELETE FROM #tileAlarmCriteria WHERE tileId NOT IN (SELECT tileId FROM #tileQueryOutcome)
		IF EXISTS (SELECT * FROM #tileQueryOutcome WHERE severity >= @ipSeverity)
			SET @isAlertConditionMet = 1
		ELSE
			SET @isAlertConditionMet = 0
	END
	ELSE	--Check for alert condition. There can be only one tile in this case.
	BEGIN
		/*
		enum AlertOperationType
		{
			   @Text(text="Less Than")
			  LESSTHAN = 0,
			  @Text(text="More Than")
			  MORETHAN = 1,
			  @Text(text="Equals To")
			  EQUALTO = 2,
			  @Text(text="Not Equal To")
			  NOTEQUALTO = 8
		}
		*/
		--Delete Unnecessary criteria ids
		DELETE FROM #tileAlarmCriteria WHERE criteriaId <> @alarmCriteriaId
		IF @alarmOperationType = -1
			SELECT @alarmOperationType = CAST(tac.defaultComparator AS INT) FROM #tileAlarmCriteria tac
		IF (
			(@alarmOperationType = 0 AND EXISTS(SELECT * FROM #tileAlarmCriteria AC WHERE CAST(@alarmParam AS FLOAT) < CAST(AC.alarmValue AS FLOAT)))
			OR (@alarmOperationType = 1 AND EXISTS(SELECT * FROM #tileAlarmCriteria AC WHERE CAST(@alarmParam AS FLOAT) > CAST(AC.alarmValue AS FLOAT)))
			OR (@alarmOperationType = 2 AND EXISTS(SELECT * FROM #tileAlarmCriteria AC WHERE @alarmParam = AC.alarmValue))
			OR (@alarmOperationType = 8 AND EXISTS(SELECT * FROM #tileAlarmCriteria AC WHERE @alarmParam <> AC.alarmValue))
			)
			SET @isAlertConditionMet = 1
		ELSE
		BEGIN
			SET @isAlertConditionMet = 0
			DELETE FROM #tileAlarmCriteria
		END
	END
	--SELECT @isAlertConditionMet AS isAlertConditionMet
	IF (@isAlertConditionMet = 1)
	BEGIN
		DECLARE @alertResponse TABLE(Result NVARCHAR(MAX), CommServeName NVARCHAR(250), Reason NVARCHAR(MAX), Remarks NVARCHAR(MAX))
		IF (@alarmCriteriaId = 0)
		BEGIN
			INSERT INTO @alertResponse(Result, CommServeName, Reason, Remarks)
			SELECT
				(CASE WHEN LEN(t.tileLocalizedName) > 0 THEN t.tileLocalizedName ELSE t.tileName END) + ' - ' + (CASE t.severity WHEN 1 THEN 'Info' WHEN 2 THEN 'Good' WHEN 3 THEN 'Warning' WHEN 4 THEN 'Critical' ELSE 'Unknown' END) AS Result,
				(SELECT aliasName FROM APP_CommCell WHERE id = 2) AS CommServe,
				(Select CASE ISNULL(OC.localizedKey, '') WHEN '' THEN OC.outcomeKey ELSE OC.localizedKey END + ' MsgNewLine_  ' AS [text()] From #tileOutcomes OC WHERE OC.tileId = t.tileId For XML PATH ('')),
				(Select CASE ISNULL(TR.localizedValue, '') WHEN '' THEN TR.value ELSE TR.localizedValue END + ' MsgNewLine_  ' AS [text()] From #tileRecommendations TR WHERE TR.tileId = t.tileId For XML PATH (''))
			FROM #tileQueryOutcome t
		END
		ELSE
		BEGIN
			INSERT INTO @alertResponse(Result, CommServeName, Reason, Remarks)
			SELECT
				(CASE WHEN LEN(t.tileLocalizedName) > 0 THEN t.tileLocalizedName ELSE t.tileName END) + ' - ' + (CASE t.severity WHEN 1 THEN 'Info' WHEN 2 THEN 'Good' WHEN 3 THEN 'Warning' WHEN 4 THEN 'Critical' ELSE 'Unknown' END) AS Result,
				(SELECT aliasName FROM APP_CommCell WHERE id = 2) AS CommServe,
				(Select CASE ISNULL(OC.localizedKey, '') WHEN '' THEN OC.outcomeKey ELSE OC.localizedKey END + ' MsgNewLine_  ' AS [text()] From #tileOutcomes OC WHERE OC.tileId = t.tileId For XML PATH ('')),
				(Select CASE ISNULL(TR.localizedValue, '') WHEN '' THEN TR.value ELSE TR.localizedValue END + ' MsgNewLine_  ' AS [text()] From #tileRecommendations TR WHERE TR.tileId = t.tileId For XML PATH (''))
			FROM #tileQueryOutcome t
		END
		/*
		'<App_ExternalQueryResults>
				  <colList>
					<columnName val="Result"/>
					<columnName val="CommserveName"/>
					<columnName val="Reason"/>
					<columnName val="Remarks"/>
				  </colList>
				  <resultSet>
					<colValues val="ResultVal"/>
					<colValues val="CSVal"/>
					<colValues val="ReasonVal"/>
					<colValues val="RemarksVal"/>
				  </resultSet>
				  <resultSet>
					<colValues val="ResultVal1"/>
					<colValues val="CSVal1"/>
					<colValues val="ReasonVal1"/>
					<colValues val="RemarksVal1"/>
				  </resultSet>
		</App_ExternalQueryResults>'
		*/
		DECLARE @colList XML =
		'<colList>
					<columnName val="Result"/>
					<columnName val="CommserveName"/>
					<columnName val="Reason"/>
					<columnName val="Remarks"/>
		</colList>'
		SELECT @response =
		(
		SELECT
			@colList,
			 (SELECT
				(
				SELECT
					(SELECT Result AS '@val' FOR XML PATH('colValues'), TYPE),
					(SELECT CommServeName AS '@val' FOR XML PATH('colValues'), TYPE),
					(SELECT Reason AS '@val' FOR XML PATH('colValues'), TYPE),
					(SELECT Remarks AS '@val' FOR XML PATH('colValues'), TYPE)
					FOR XML PATH('resultSet'), TYPE
				)
			FROM @alertResponse)
		FOR XML PATH('App_ExternalQueryResults'), TYPE
		)
	END
END
IF  object_id('tempdb.dbo.#tileQueryOutcome') is not null
	DROP TABLE #tileQueryOutcome
IF  object_id('tempdb.dbo.#tileSeverityThresholds') is not null
	DROP TABLE #tileSeverityThresholds
IF  object_id('tempdb.dbo.#tileOutcomes') is not null
	DROP TABLE #tileOutcomes
IF  object_id('tempdb.dbo.#tileRecommendations') is not null
	DROP TABLE #tileRecommendations
IF  object_id('tempdb.dbo.#tileAlarmCriteria') is not null
	DROP TABLE #tileAlarmCriteria
SET NOCOUNT OFF
END_PROC:
SELECT @response AS 'response'
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetTiles')
	delete from GxQscripts where name = 'RptGetTiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetTiles')
	delete from GXDBVersions where aliasname = 'RptGetTiles'
GO

insert into GXDBVersions values(2, 'RptGetTiles',  '00000000000000000000', 'RptGetTiles', '00000000000000000000')
GO

