

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetTaskList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetTaskList.sp,v $ $Id: RptGetTaskList.sp,v 1.27.2.14.4.1 2021/01/13 14:35:23 mnatarajan Exp $";
-- =============================================
-- Description:	Get the list of schedules for report
-- This should be similar to TM_GetTaskList.sp, with rearranged rows of TM_Task table into temp table #tmTask
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptGetTaskList')
BEGIN
	print '>>> Drop Stored Procedure: RptGetTaskList <<<'
	drop procedure RptGetTaskList
END
IF EXISTS (select * from GxQscripts where name='RptGetTaskList')
	delete from GxQscripts where name = 'RptGetTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetTaskList')
	delete from GXDBVersions where aliasname = 'RptGetTaskList'
GO
print '... Creating Procedure: RptGetTaskList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptGetTaskList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId integer,
  @localeId_in integer,
  @i_jobId integer,
  @xmlText XML
AS
BEGIN
SET NOCOUNT ON
        DECLARE @clOpt INT
		DECLARE @appTypeOpt INT
        DECLARE @instanceId INT
        DECLARE @backupsetId INT
        DECLARE @subclientId INT
        DECLARE @appTypeId INT
        DECLARE @clientId INT
        DECLARE @clientGroupId INT
        DECLARE @srmReportSet INT
        DECLARE @srmReportType INT
        DECLARE @type INT
        DECLARE @spName NVARCHAR(255)
        DECLARE @position INT
        DECLARE @savedReports INT
        DECLARE @agentlessSRM INT
        DECLARE @policy INT
        DECLARE @schedules INT
        DECLARE @otherReports INT
        DECLARE @copyId INT
        DECLARE @policyId INT
        DECLARE @taskId INT
        DECLARE @subTaskId INT
		DECLARE @mediaAgentId INT
		DECLARE @trackingPolicyId INT
        DECLARE @agentlessPolicyId INT
		DECLARE @excludeHiddenSubclients INT = 0
        DECLARE @allBackup INT
SET @allBackup = 1
        DECLARE @allRestore INT
SET @allRestore = 8
        DECLARE @allAdmin INT
SET @allAdmin = 2000
        DECLARE @allTasks INT = 0
        DECLARE @showAllTasks INT = 0
		DECLARE @EZPolicyFilter INT = 0
DECLARE @subTaskTypeAdmin INT = 1
DECLARE @subTaskTypeBackup INT = 2
DECLARE @subTaskTypeRestore INT = 3
        DECLARE @jobXmlText XML = (SELECT dbo.GetXMLJobOptions(@i_jobid))
		DECLARE @clientGrpSelLst TABLE (clientGrpId INT)
		DECLARE @isUserAdmin int=0
        DECLARE @useClientDisplayName int=1 -- Always true for R11 SP15 and greater.  -SK
		EXECUTE sec_isUserAdmin   @userId ,@isUserAdmin  OUTPUT
	    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
        -- csabjan: If the flag to use client display name is set, then query and use the client display name.
--        IF EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'bUseClientDisplayName' AND relativePath = 'CommServDB.Console' AND type = 'BOOLEAN' AND cast([value] as nvarchar(32)) = N'true' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = 2)
--        BEGIN
--            SET @useClientDisplayName = 1
--        END
----
		--rearrange rows of TM_Task table into temp table #tmTask, to get xml order by client/next sched time
		DECLARE @orderBy INT
SET @orderBy = dbo.GetOptionInt(1180402940, @i_jobId, 0, 0)
SET @excludeHiddenSubclients = dbo.GetOptionInt(2142102290, @i_jobId, 0, 0)
		IF object_id('tempdb.dbo.#tmTask') is not null DROP TABLE #tmTask
		declare @tmpTaskTbl table (taskId int)
-- -- SP BODY BEGIN : TM_ComputeStartTimeForClientTbl.spb ----------------------------------------------------------------------------------------------------------------------------------
IF object_id('tempdb.dbo.#Clients_Timezone_StartTime') is NOT NULL
BEGIN
	DROP TABLE #Clients_Timezone_StartTime
END
CREATE TABLE #Clients_Timezone_StartTime(clientId INT, timezoneName NVARCHAR(MAX), jobStartTime INT DEFAULT -1, taskID INT DEFAULT 0, patternID INT DEFAULT 0 )
CREATE CLUSTERED INDEX Clients_Timezone_StartTime_clientId_taskID_Index ON #Clients_Timezone_StartTime (clientId, taskID)
IF object_id('tempdb.dbo.#SubClients_Timezone_StartTime') is NOT NULL
BEGIN
	DROP TABLE #SubClients_Timezone_StartTime
END
CREATE TABLE #SubClients_Timezone_StartTime(appId INT, timezoneName NVARCHAR(MAX), jobStartTime INT DEFAULT -1, taskID INT DEFAULT 0)
CREATE CLUSTERED INDEX SubClients_Timezone_StartTime_appId_Index ON #SubClients_Timezone_StartTime (appId)
-- -- SP BODY END : TM_ComputeStartTimeForClientTbl.spb ------------------------------------------------------------------------------------------------------------------------------------
		IF @orderBy = 6 --NEXT_SCHEDULE_TIME
		BEGIN
			insert into @tmpTaskTbl
			select taskid from
			(
				select taskId, nextSchedTime =max(nextRunTime)
				from TM_SubTask T
				left join  TM_PatternAssoc PA ON PA.subTaskId = T.subTaskId
				left join TM_RunTime R ON R.patternId = PA.patternId
				group by taskId
			) A order by nextSchedTime
		END
		ELSE
		BEGIN			--order by Client
			declare @tmpTable table (taskId int, clntName nvarchar(256))
			insert into @tmpTaskTbl
			select taskid from TM_Task
			where taskId not in (select taskId from TM_AssocEntity )
			insert into @tmpTable
			select Ta.taskId , C.name
			from TM_AssocEntity TA  left join  APP_Client C
			ON TA.clientId = C.id order by C.name
			insert into @tmpTaskTbl
			select distinct taskid from @tmpTable
		END
		select * into #tmTask
		FROM (select TM.* from TM_Task TM, @tmpTaskTbl t
		where TM.taskId = t.taskId) A
-----
	--INITIALIZATION
        DECLARE @taskTble TABLE ( taskId INT )
        DECLARE @clientTable TABLE ( clientId INT )
        DECLARE @appTypeTable TABLE ( appTypeId INT )
        DECLARE @operationFilter TABLE ( operationType INT )
        DECLARE @subTaskFilter TABLE ( subTaskType INT )
        DECLARE @entityCount TABLE ( taskId INT, nCount INT )
		INSERT INTO @clientTable EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
		INSERT INTO @appTypeTable EXEC rptOptGetAppTypes @i_jobId, @appTypeOpt OUTPUT
	--GET POLICY FLAG
        SET @policy = ISNULL(( SELECT   ref.value('@policy', 'int')
                               FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
                             ), 0)
	--GET SCHEDULE FLAG
        SET @schedules = ISNULL(( SELECT    ref.value('@schedules', 'int')
                                  FROM      @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
                                ), 0)
		--GET CLIENT GROUP
        SET @clientGroupId = ISNULL(( SELECT    ref.value('@clientGroupId',
                                                      'int')
                                      FROM      @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
                                    ), 0)
	--GET CLIENT
        SET @clientId = ISNULL(( SELECT ref.value('@clientId', 'int')
                                 FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
                               ), 0)
	--GET APPTYPE
        SET @apptypeId = ISNULL(( SELECT    ref.value('@applicationId',
                                                      'int')
                                  FROM      @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
                                ), 0)
	--GET INSTANCE
        SET @instanceId = ISNULL(( SELECT   ref.value('@instanceId',
                                                      'int')
                                   FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
                                 ), 0)
	--GET BACKUPSET
        SET @backupsetId = ISNULL(( SELECT  ref.value('@backupsetId',
                                                      'int')
                                    FROM    @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
                                  ), 0)
	--GET SUBCLIENT
        SET @subclientId = ISNULL(( SELECT  ref.value('@subclientId',
                                                      'int')
                                    FROM    @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
                                  ), 0)
	--GET SRM REPORT SET
        SET @srmReportSet = ISNULL(( SELECT ref.value('@srmReportSet',
                                                      'int')
                                     FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
                                   ), 0)
	--GET SRM REPORT TYPE
        SET @srmReportType = ISNULL(( SELECT    ref.value('@srmReportType',
                                                      'int')
                                      FROM      @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
                                    ), 0)
	--GET STORAGE POLICY ID
        SET @policyId = ISNULL(( SELECT ref.value('@storagePolicyId',
                                                  'int')
                                 FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
                               ), 0)
	--GET STORAGE COPY ID
        SET @copyId = ISNULL(( SELECT   ref.value('@copyId', 'int')
                               FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
                             ), 0)
		SET @mediaAgentId = ISNULL(( SELECT   ref.value('@mediaAgentId', 'int')
                               FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
                             ), 0)
		SET @trackingPolicyId =   ISNULL(( SELECT   ref.value('@trackingPolicyId', 'int')
                               FROM     @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
                             ), 0)
	--GET AGENTLESS POLICY ID
        SET @agentlessPolicyId = ISNULL(( SELECT ref.value('@agentlessPolicyId',
                                                  'int')
                                 FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter/entity') R ( ref )
                               ), 0)
	--GET TYPE
        SET @type = ISNULL(( SELECT ref.value('@type', 'int')
                             FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
                           ), 0)
	--GET SAVED REPORTS FLAG
        SET @savedReports = ISNULL(( SELECT ref.value('@savedReports',
                                                      'int')
                                     FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
                                   ), 0)
	--GET AGENTLESS SRM FLAG
        SET @agentlessSRM = ISNULL(( SELECT ref.value('@agentlessSRM',
                                                      'int')
                                     FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
                                   ), 0)
	--GET OTHER REPORTS FLAG
        SET @otherReports = ISNULL(( SELECT ref.value('@otherReports',
                                                      'int')
                                     FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
                                   ), 0)
	--GET EZPOLICY SCHEDULE
     SET @EZPolicyFilter  =   ISNULL(( SELECT ref.value('@EZPolicyFilter',
                                                      'int')
                                     FROM   @xmlText . nodes('TMMsg_GetTaskListReq/filter') R ( ref )
                                   ), 0)
	IF object_id('tempdb.dbo.#entitiesWithViewSchedCapability') is not null DROP TABLE #entitiesWithViewSchedCapability
create table  #entitiesWithViewSchedCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithViewSchedCapability'
	-- needed so that we can join on a user with no privilages
	INSERT INTO #entitiesWithViewSchedCapability (capabilities, flag, commCellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subClientId,
	mediaAgentId, libraryId, archGroupId, vtContainerId, vtPolicyId, vtShelfId, reviewSetId, querySetId, downloadSetId, ermId, legalHoldId, tagId, cdPolicyId, complianceReportId, taskId)
	VALUES (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
    --THIS IS VIEW SCHEDULES
        DECLARE @DATE DATETIME = GETDATE()
        IF ( @policy = 1 )
            AND ( @schedules = 0 )
            AND ( @savedReports = 0 )
            AND ( @otherReports = 0 )
            AND ( @agentlessSRM = 0 )
            BEGIN
                INSERT  INTO @entityCount
                        SELECT  taskId ,
                                0
                        FROM    #tmTask
                        WHERE   [#tmTask].[deleted] = 0
                                AND [#tmTask].[invalid] = 0
                                AND [#tmTask].[uninstalled] = 0
AND [#tmTask].[taskType] = 4
                DECLARE CalculateEntityCountCursor CURSOR
                FOR SELECT DISTINCT
                taskId
                FROM    @entityCount
                OPEN CalculateEntityCountCursor
                FETCH FROM CalculateEntityCountCursor INTO @taskId
                WHILE @@FETCH_STATUS = 0
                    BEGIN
                        SET @subTaskId = ( SELECT TOP 1
                                                    subTaskId
                                           FROM     TM_SubTask
                                           WHERE    taskId = @taskId
                                         )
						IF ( EXISTS ( SELECT    *
                                          FROM      TM_SubTask
                                          WHERE     subTaskId = @subTaskId
AND subTaskType = 1 )
                           )
                            BEGIN
                                UPDATE  @entityCount
                                SET     nCount = (SELECT count(*) from TM_AssocEntity where taskId = @taskId)
                                WHERE   taskId = @taskId
                            END
                        ELSE IF ( NOT EXISTS ( SELECT    *
                                          FROM      TM_SubTask
                                          WHERE     subTaskId = @subTaskId
AND subTaskType = 3 )
                           )
                            BEGIN
                                 DECLARE @o_count INT = 0
                                 EXEC TM_GetBackupEntityCount @taskId,
                                            @subTaskId, NULL, @o_count OUTPUT
                                UPDATE  @entityCount
                                SET     nCount = @o_count
                                WHERE   taskId = @taskId
                            END
                        FETCH FROM CalculateEntityCountCursor INTO @taskId
                    END
                CLOSE CalculateEntityCountCursor
                DEALLOCATE CalculateEntityCountCursor
                INSERT  INTO @operationFilter
				SELECT  ref.value('@val', 'int') AS operationType
				FROM    @xmlText.nodes('TMMsg_GetTaskListReq/filter/operationTypes') R ( ref )
				--BUILD SUBTASK FILTER FROM OPERATIONTYPE
				IF ( SELECT COUNT(operationType)
							 FROM   @operationFilter
							 WHERE  operationType = @allTasks
						   ) > 0 OR (SELECT COUNT(operationType)
										FROM	@operationFilter
							) = 0
							SET @showAllTasks = 1
				ELSE
					BEGIN
						INSERT  INTO @subtaskFilter
								SELECT  operationType
								FROM    @operationFilter
								WHERE   operationType IN ( @allBackup,
														   @allRestore,
														   @allAdmin )
						UPDATE  @subTaskFilter
						SET     subTaskType = CASE subTaskType
												WHEN @allAdmin
												THEN @subTaskTypeAdmin
												WHEN @allBackup
												THEN @subTaskTypeBackup
												ELSE @subTaskTypeRestore
											  END
						--REMOVE TYPES USED IN SUBTASKTYPE
						DELETE  FROM @operationFilter
						WHERE   operationType IN ( @allBackup, @allRestore,
												   @allAdmin )
					END
DECLARE @opTypeSRMSelected INT = (select COUNT(operationType) from @operationFilter where operationType = 5)
				DELETE #tmTask
				WHERE taskId IN ( SELECT  taskId
							  FROM TM_SubTask
							  WHERE ( ( @showAllTasks = 0
										  AND ( subTaskType NOT IN (SELECT subTaskType FROM @subTaskFilter )
												AND operationType NOT IN (SELECT operationType FROM @operationFilter )
											  )
									   )
OR ( @showAllTasks = 0 AND operationType = 5 AND @opTypeSRMSelected = 0 )
									)
								)
               --CREATE THE TEMP TABLE--
				IF OBJECT_ID('tempdb.dbo.#AsocEntity') IS NOT null
							DROP TABLE #AsocEntity
					SELECT  dbo.TM_AssocEntity.assocType ,
							dbo.TM_AssocEntity.exclude ,
							dbo.TM_AssocEntity.taskId ,
							dbo.TM_AssocEntity.clientGroupId ,
							dbo.TM_AssocEntity.clientId ,
							dbo.TM_AssocEntity.apptypeId ,
							dbo.TM_AssocEntity.instanceId ,
							dbo.TM_AssocEntity.backupsetId ,
							dbo.TM_AssocEntity.subclientId ,
							dbo.TM_AssocEntity.policyId ,
							dbo.archGroup.name AS policyName ,
							dbo.TM_AssocEntity.copyId ,
							dbo.TM_AssocEntity.mediaAgentId,
                            (CASE WHEN @useClientDisplayName = 1 THEN dbo.APP_Client.displayname ELSE dbo.APP_Client.name END) AS mediaAgentName,
							dbo.TM_AssocEntity.srmReportType AS srmReportType,
							dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
							dbo.archGroupCopy.name AS copyName ,
							dbo.APP_ClientGroup.name AS clientGroupName ,
                            (CASE WHEN @useClientDisplayName = 1 THEN dbo.APP_Client.displayname ELSE dbo.APP_Client.name END) AS clientName,
							dbo.APP_iDAType.name AS appTypeName ,
							dbo.APP_Application.subclientName ,
							dbo.APP_BackupSetName.name AS backupsetName ,
							dbo.APP_InstanceName.name AS instanceName,
							dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
							dbo.TM_AssocEntity.agentlessPolicyId,
							CASE WHEN assocType = 158 THEN entityID Else 0 END AS planId,
							App_Plan.name as PlanName
							INTO    #AsocEntity
					FROM    dbo.TM_AssocEntity
							LEFT OUTER JOIN dbo.APP_ClientGroup ON dbo.TM_AssocEntity.clientGroupId = dbo.APP_ClientGroup.id
							LEFT OUTER JOIN dbo.APP_Client ON dbo.TM_AssocEntity.clientId = dbo.APP_Client.id OR dbo.TM_AssocEntity.mediaAgentId = dbo.APP_Client.id
							LEFT OUTER JOIN dbo.APP_iDAType ON dbo.TM_AssocEntity.apptypeId = dbo.APP_iDAType.type
							LEFT OUTER JOIN dbo.APP_Application ON dbo.TM_AssocEntity.subclientId = dbo.APP_Application.id
							LEFT OUTER JOIN dbo.APP_BackupSetName ON dbo.TM_AssocEntity.backupsetId = dbo.APP_BackupSetName.id
							LEFT OUTER JOIN dbo.APP_InstanceName ON dbo.TM_AssocEntity.instanceId = dbo.APP_InstanceName.id
							LEFT OUTER JOIN dbo.archGroup ON dbo.TM_AssocEntity.policyId = dbo.archGroup.id
							LEFT OUTER JOIN dbo.archGroupCopy ON dbo.TM_AssocEntity.copyId = dbo.archGroupCopy.id
							LEFT OUTER JOIN dbo.App_Plan WITH (NOLOCK) ON TM_AssocEntity.entityID = App_Plan.Id AND
								TM_AssocEntity.assocType = 158
WHERE ( dbo.APP_Client.status & 2 <> 2 OR dbo.TM_AssocEntity.clientId = 0 ) AND ((@excludeHiddenSubclients = 1 AND dbo.APP_Application.subclientStatus & 0x00020 <> 0x00020 OR @excludeHiddenSubclients = 0) OR dbo.TM_AssocEntity.subclientId = 0)
                SET @xmlText = ( SELECT	 --TASKLIST
                                        ( SELECT 	--TASK
                                                    [#tmTask].taskId AS '@taskId' ,
                                                    [#tmTask].taskName AS '@taskName' ,
                                                    [#tmTask].taskType AS '@taskType' ,
                                                    [#tmTask].alertId AS '@alertId' ,
                                                    [#tmTask].ownerId AS '@ownerId' ,
                                                    [#tmTask].runUserId AS '@runUserId' ,
                                                    [#tmTask].description AS '@description' ,
                                                    USR.login AS '@ownerName' ,
                                                    [#tmTask].policyType AS '@policyType' ,
                                                   -- dbo.GetEntityCount([#tmTask].taskId) AS '@associatedObjects' ,
                                                    ( SELECT
                                                              nCount
                                                      FROM    @entityCount
                                                      WHERE   taskId = [#tmTask].taskId
                                                    ) AS '@associatedObjects' ,
                                                    [#tmTask].GUID ,
                                                    ( SELECT -- alert
                                                              [#tmTask].alertId AS '@alertId' ,
                                                              NT.notificationName AS '@alertName'
                                                      FROM    dbo.NTnotificationRule
                                                              AS NT
                                                      WHERE   NT.id = [#tmTask].alertId
                                                    FOR
                                                      XML PATH('alert') ,
                                                          TYPE
                                                    ) ,
                                                    ( SELECT-- origCC
                                                              [#tmTask].origCCId AS '@commCellId'
                                                    FOR
                                                      XML PATH('originalCC') ,
                                                          TYPE
                                                    ) ,
                                                    ( SELECT  --TaskFlags
                                                              [#tmTask].disabled AS '@disabled' ,
                                                              [#tmTask].uninstalled AS '@uninstalled' ,
                                                              [#tmTask].isEZOperation AS '@isEZOperation'
                                                    FOR
                                                      XML PATH('taskFlags') ,
                                                          TYPE
                                                    )
                                        FOR
                                          XML PATH('task') ,
                                              TYPE
                                        ) ,
                                        ( SELECT  --APPGROUP
                                                    ( SELECT  --GROUP SELECTED
                                                              TFIL.filter_value AS '@appGroupId'
                                                      FROM    TM_AssocFilter
                                                              AS TFIL
                                                      WHERE   TFIL.filter_type = 1
                                                              AND TFIL.taskId = [#tmTask].taskId
                                                    FOR
                                                      XML PATH('appGroups') ,
                                                          TYPE
                                                    ) ,
                                                    ( SELECT  --TYPES SELECTED
                                                              TFIL.filter_value AS '@appTypeId'
                                                      FROM    TM_AssocFilter
                                                              AS TFIL
                                                      WHERE   TFIL.filter_type = 2
                                                              AND TFIL.taskId = [#tmTask].taskId
                                                    FOR
                                                      XML PATH('appTypes') ,
                                                          TYPE
                                                    )
                                        FOR
                                          XML PATH('appGroup') ,
                                              TYPE
                                        ),
                                        ( SELECT --DISTINCT ASSOC
														ASSOC.assocType '@_type_' ,
														ASSOC.clientGroupId '@clientGroupId' ,
														ASSOC.clientGroupName '@clientGroupName' ,
														ASSOC.clientId '@clientId' ,
														ASSOC.clientName '@clientName' ,
														ASSOC.apptypeId '@applicationId' ,
														ASSOC.appTypeName '@appName' ,
														ASSOC.policyId '@storagePolicyId' ,
														ASSOC.policyName '@storagePolicyName' ,
														ASSOC.mediaAgentId '@mediaAgentId',
														ASSOC.mediaAgentName '@mediaAgentName',
														ASSOC.instanceId '@instanceId' ,
														REPLACE(ASSOC.instanceName,
																'', ' ') '@instanceName' ,
														ASSOC.backupsetId '@backupsetId' ,
														ASSOC.copyId '@copyId' ,
														ASSOC.copyName '@copyName' ,
														ASSOC.backupsetName '@backupsetName' ,
														ASSOC.subclientId '@subclientId' ,
														ASSOC.subclientName '@subclientName',
														ASSOC.agentlessPolicyId '@agentlessPolicyId',
														ASSOC.planId '@planId',
														ASSOC.planName '@planName',
														( SELECT ASSOC.exclude '@exclude' FOR XML PATH('flags') ,TYPE )
											  FROM      #AsocEntity AS ASSOC
											  WHERE     ASSOC.taskId = [#tmTask].taskId
											FOR
											  XML PATH('associations') ,
												  TYPE
											) ,
											( SELECT		--SUBTASKINFO
							--TASK RUN TIME FROM TM_RunTime Table
														NRT.nextTime AS '@nextScheduleTime' ,
														ABS(datediff(second, '01/01/1970', GETUTCDATE()) - datediff(second, '01/01/1970', NRT.nextRunTime)) '@relativeTime',
														( SELECT	DISTINCT --SUBTASK
																  STASK.subTaskId AS '@subTaskId' ,
																  STASK.subTaskType AS '@subTaskType' ,
																  STASK.operationType AS '@operationType' ,
																  STASK.flags AS '@flags' ,
																  STASK.subTaskOrder AS '@subTaskOrder' ,
																  STASK.subTaskName AS '@subTaskName'
														FOR
														  XML PATH('subTask') ,
															  TYPE
														) ,
														( SELECT --PATTERN
																  PAT.patternId '@patternId' ,
																  PAT.name '@name' ,
																  PAT.flags '@flags' ,
																  PAT.freq_type '@freq_type' ,
																  PAT.freq_interval '@freq_interval' ,
																  PAT.freq_relative_interval '@freq_relative_interval' ,
																  PAT.freq_recurrence_factor '@freq_recurrence_factor' ,
																  PAT.freq_subday_interval '@freq_subday_interval' ,
																  PAT.skipOccurence '@skipOccurence' ,
																  PAT.skipDayNumber '@skipDayNumber' ,
																  PAT.local_start_date '@active_start_date' ,
																  PAT.active_start_time '@active_start_time' ,
																  PAT.local_end_date '@active_end_date' ,
																  PAT.active_end_time '@active_end_time' ,
																  PAT.active_end_occurence '@active_end_occurence' ,
																  PAT.description '@description' ,
																  PAT.freq_restart_interval '@freq_restart_interval',
																  ( SELECT  --TimeZone
																  PAT.tzId AS '@TimeZoneID'
																  FOR
																  XML
																  PATH('timeZone') ,
																  TYPE
																  ) ,
																  ( SELECT  --Calendar
																  PAT.calendarId AS '@calendarId'
																  FOR
																  XML
																  PATH('calendar') ,
																  TYPE
																  )
														  FROM    TM_Pattern AS PAT ,
																  TM_PatternAssoc PASOC
														  WHERE   [PASOC].[patternId] = PAT.[patternId]
																  AND PASOC.subTaskId = STASK.subTaskId
														FOR
														  XML PATH('pattern') ,
															  TYPE
														)  ,
															( SELECT  --OPTIONS
																	  SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
															  FROM    TM_SubTaskXMLOptions SOPTIONS
															  WHERE   SOPTIONS.subTaskId = STASK.subTaskId
															FOR
															  XML PATH('') ,
																  TYPE
															)
												  FROM      TM_subTask AS STASK
															LEFT OUTER JOIN TM_PatternAssoc
																AS PAS ON PAS.subTaskId = STASK.subTaskId
															LEFT OUTER JOIN TM_Pattern
																AS PAT ON PAT.patternId = PAS.patternId
															LEFT OUTER JOIN TM_RunTime
																AS NRT ON NRT.patternId = PAS.patternId
																	  AND NRT.processed = 0
												  WHERE     STASK.subTaskId = PAS.subTaskId
															AND STASK.taskId = [#tmTask].taskId
															AND (( NRT.nextRunTime >= GETUTCDATE() )
																	AND ( ( NRT.flags & 1 ) = 0
																) OR PAT.freq_type = 512
															)
											FOR
											  XML PATH('subTasks') ,
												  TYPE
											)
                                 FROM   dbo.#tmTask
                                        LEFT OUTER JOIN dbo.UMUsers AS USR ON dbo.#tmTask.ownerId = USR.id
                                        LEFT OUTER JOIN dbo.NTnotificationRule ON dbo.NTnotificationRule.id = dbo.#tmTask.alertId
                                 WHERE  [#tmTask].[deleted] = 0
                                        AND [#tmTask].[invalid] = 0
                                        AND [#tmTask].[uninstalled] = 0
                                         --AND [TM_RunTime].[processed] = 0)
AND [#tmTask].[taskType] = 4
                               FOR
                                 XML PATH('taskDetail') ,
                                     ROOT('TMMsg_GetTaskListResp')
                               )
            END
        ELSE
            BEGIN
				-- CHECK FOR DIFFERENT ENTRY POINTS
				-- 1. Saved Reports
				IF  @clientGroupId = 0
					AND @clientId = 0
					AND @apptypeId = 0
					AND @instanceId = 0
					AND @backupsetId = 0
					AND @subclientId = 0
					AND @srmReportType = 0
					AND @srmReportSet = 0
					AND @policyId = 0
					AND @copyId = 0
					AND @mediaAgentId = 0
					AND @trackingPolicyId = 0
					AND @savedReports = 1
					AND @agentlessSRM = 0
					AND @policy = 0
					AND @schedules = 0
					AND @agentlessPolicyId = 0
					BEGIN
						SET @xmlText = ( SELECT	 --TASKLIST
											( SELECT 	--TASK
														[#tmTask].taskId AS '@taskId' ,
														[#tmTask].taskName AS '@taskName' ,
														[#tmTask].taskType AS '@taskType' ,
														[#tmTask].alertId AS '@alertId' ,
														[NTnotificationRule].notificationName AS '@alertName' ,
														[#tmTask].ownerId AS '@ownerId' ,
														[#tmTask].runUserId AS '@runUserId' ,
														[#tmTask].description AS '@description' ,
														USR.login AS '@ownerName' ,
														[#tmTask].policyType AS '@policyType' ,
														--dbo.GetEntityCount([#tmTask].taskId) AS '@associatedObjects' ,
														[#tmTask].GUID ,
														( SELECT -- alert
																  [#tmTask].alertId AS '@alertId' ,
																  NT.notificationName AS '@alertName'
														  FROM    dbo.NTnotificationRule
																  AS NT
														  WHERE   NT.id = [#tmTask].alertId
														FOR
														  XML PATH('alert') ,
															  TYPE
														) ,
														( SELECT-- origCC
																  [#tmTask].origCCId AS '@commCellId'
														FOR
														  XML PATH('originalCC') ,
															  TYPE
														) ,
														( SELECT  --TaskFlags
																  [#tmTask].disabled AS '@disabled' ,
																  [#tmTask].uninstalled AS '@uninstalled' ,
																  [#tmTask].isEZOperation AS '@isEZOperation'
														FOR
														  XML PATH('taskFlags') ,
															  TYPE
														)
											FOR
											  XML PATH('task') ,
												  TYPE
											),
											( SELECT		--SUBTASKINFO
														( SELECT	DISTINCT --SUBTASK
																  STASK.subTaskId AS '@subTaskId' ,
																  STASK.subTaskType AS '@subTaskType' ,
																  STASK.operationType AS '@operationType' ,
																  STASK.flags AS '@flags' ,
																  STASK.subTaskOrder AS '@subTaskOrder' ,
																  STASK.subTaskName AS '@subTaskName'
														FOR
														  XML PATH('subTask') ,
															  TYPE
														) ,
														( SELECT  --OPTIONS
																  SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
														  FROM    TM_SubTaskXMLOptions SOPTIONS
														  WHERE   SOPTIONS.subTaskId = STASK.subTaskId
														FOR
														  XML PATH('') ,
															  TYPE
														)
											  FROM      TM_subTask AS STASK
											  WHERE     STASK.taskId = [#tmTask].taskId
											FOR
											  XML PATH('subTasks') ,
												  TYPE
											)
									 FROM   dbo.#tmTask
											--INNER JOIN #entitiesWithViewSchedCapability sec ON
											--	(capabilities&16384) <> 0
											INNER JOIN dbo.UMUsers AS USR ON dbo.#tmTask.ownerId = USR.id
											LEFT OUTER JOIN dbo.NTnotificationRule ON dbo.NTnotificationRule.id = dbo.#tmTask.alertId
									 WHERE  [#tmTask].[deleted] = 0
												AND [#tmTask].[invalid] = 0
												AND [#tmTask].[uninstalled] = 0
												AND [#tmTask].[savedReport] = 1
												AND [#tmTask].[hidden] = 0
												AND [USR].[id] = @userId
								   FOR
									 XML PATH('taskDetail') ,
										 ROOT('TMMsg_GetTaskListResp')
								   )
					END
				-- Other Reports
				ELSE IF  @clientGroupId = 0
					AND @clientId = 0
					AND @apptypeId = 0
					AND @instanceId = 0
					AND @backupsetId = 0
					AND @subclientId = 0
					AND @srmReportType = 0
					AND @srmReportSet = 0
					AND @policyId = 0
					AND @copyId = 0
					AND @mediaAgentId = 0
					AND @trackingPolicyId = 0
					AND @otherReports = 1
					AND @policy = 0
					AND @schedules = 0
					AND @agentlessPolicyId = 0
					BEGIN
						SET @xmlText = ( SELECT	 --TASKLIST
											( SELECT 	--TASK
														[#tmTask].taskId AS '@taskId' ,
														[#tmTask].taskName AS '@taskName' ,
														[#tmTask].taskType AS '@taskType' ,
														[#tmTask].alertId AS '@alertId' ,
														[NTnotificationRule].notificationName AS '@alertName' ,
														[#tmTask].ownerId AS '@ownerId' ,
														[#tmTask].runUserId AS '@runUserId' ,
														[#tmTask].description AS '@description' ,
														USR.login AS '@ownerName' ,
														[#tmTask].policyType AS '@policyType' ,
														--dbo.GetEntityCount([#tmTask].taskId) AS '@associatedObjects' ,
														[#tmTask].GUID ,
														( SELECT -- alert
																  [#tmTask].alertId AS '@alertId' ,
																  NT.notificationName AS '@alertName'
														  FROM    dbo.NTnotificationRule
																  AS NT
														  WHERE   NT.id = [#tmTask].alertId
														FOR
														  XML PATH('alert') ,
															  TYPE
														) ,
														( SELECT-- origCC
																  [#tmTask].origCCId AS '@commCellId'
														FOR
														  XML PATH('originalCC') ,
															  TYPE
														) ,
														( SELECT  --TaskFlags
																  [#tmTask].disabled AS '@disabled' ,
																  [#tmTask].uninstalled AS '@uninstalled' ,
																  [#tmTask].isEZOperation AS '@isEZOperation'
														FOR
														  XML PATH('taskFlags') ,
															  TYPE
														)
											FOR
											  XML PATH('task') ,
												  TYPE
											),
											( SELECT		--SUBTASKINFO
														( SELECT	DISTINCT --SUBTASK
																  STASK.subTaskId AS '@subTaskId' ,
																  STASK.subTaskType AS '@subTaskType' ,
																  STASK.operationType AS '@operationType' ,
																  STASK.flags AS '@flags' ,
																  STASK.subTaskOrder AS '@subTaskOrder' ,
																  STASK.subTaskName AS '@subTaskName'
														FOR
														  XML PATH('subTask') ,
															  TYPE
														) ,
														( SELECT  --OPTIONS
																  SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
														  FROM    TM_SubTaskXMLOptions SOPTIONS
														  WHERE   SOPTIONS.subTaskId = STASK.subTaskId
														FOR
														  XML PATH('') ,
															  TYPE
														)
											  FROM      TM_subTask AS STASK
											  WHERE     STASK.taskId = [#tmTask].taskId
											FOR
											  XML PATH('subTasks') ,
												  TYPE
											)
									 FROM   dbo.#tmTask
											INNER JOIN #entitiesWithViewSchedCapability sec ON
												(capabilities&16384) <> 0
											LEFT OUTER JOIN dbo.UMUsers AS USR ON dbo.#tmTask.ownerId = USR.id
											LEFT OUTER JOIN dbo.NTnotificationRule ON dbo.NTnotificationRule.id = dbo.#tmTask.alertId
									 WHERE  [#tmTask].[deleted] = 0
												AND [#tmTask].[invalid] = 0
												AND [#tmTask].[uninstalled] = 0
												AND [#tmTask].[savedReport] = 1
												AND [#tmTask].[ownerId] <> @userId
												AND sec.commCellId = 2 AND sec.appTypeId=0 AND sec.backupsetId=0 AND sec.archGroupId=0
												AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.complianceReportId=0 AND sec.complianceReportId=0
												AND sec.archGroupId=0 AND sec.cdPolicyId=0 AND sec.downloadSetId=0 AND sec.ermId=0
												AND sec.instanceId=0 AND sec.legalHoldId=0 AND sec.libraryId=0 AND sec.mediaAgentId=0
												AND sec.querySetId=0 AND sec.reviewSetId=0 AND sec.subClientId=0 AND sec.tagId=0
												AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0
								   FOR
									 XML PATH('taskDetail') ,
										 ROOT('TMMsg_GetTaskListResp')
								   )
					END
				-- Agentless SRM
				ELSE IF  @clientGroupId = 0
					AND @clientId = 0
					AND @apptypeId = 0
					AND @instanceId = 0
					AND @backupsetId = 0
					AND @subclientId = 0
					AND @srmReportType = 0
					AND @srmReportSet = 0
					AND @policyId = 0
					AND @copyId = 0
					AND @mediaAgentId = 0
					AND @trackingPolicyId = 0
					AND @savedReports = 0
					AND @agentlessSRM = 1
					AND @policy = 0
					AND @schedules = 0
					AND @agentlessPolicyId = 0
					BEGIN
						SET @xmlText = ( SELECT	 --TASKLIST
											( SELECT 	--TASK
														[#tmTask].taskId AS '@taskId' ,
														[#tmTask].taskName AS '@taskName' ,
														[#tmTask].taskType AS '@taskType' ,
														[#tmTask].alertId AS '@alertId' ,
														[NTnotificationRule].notificationName AS '@alertName' ,
														[#tmTask].ownerId AS '@ownerId' ,
														[#tmTask].runUserId AS '@runUserId' ,
														[#tmTask].description AS '@description' ,
														USR.login AS '@ownerName' ,
														[#tmTask].policyType AS '@policyType' ,
														--dbo.GetEntityCount([#tmTask].taskId) AS '@associatedObjects' ,
														[#tmTask].GUID ,
														( SELECT -- alert
																  [#tmTask].alertId AS '@alertId' ,
																  NT.notificationName AS '@alertName'
														  FROM    dbo.NTnotificationRule
																  AS NT
														  WHERE   NT.id = [#tmTask].alertId
														FOR
														  XML PATH('alert') ,
															  TYPE
														) ,
														( SELECT-- origCC
																  [#tmTask].origCCId AS '@commCellId'
														FOR
														  XML PATH('originalCC') ,
															  TYPE
														) ,
														( SELECT  --TaskFlags
																  [#tmTask].disabled AS '@disabled' ,
																  [#tmTask].uninstalled AS '@uninstalled' ,
																  [#tmTask].isEZOperation AS '@isEZOperation'
														FOR
														  XML PATH('taskFlags') ,
															  TYPE
														)
											FOR
											  XML PATH('task') ,
												  TYPE
											),
											( SELECT		--SUBTASKINFO
														( SELECT	DISTINCT --SUBTASK
																  STASK.subTaskId AS '@subTaskId' ,
																  STASK.subTaskType AS '@subTaskType' ,
																  STASK.operationType AS '@operationType' ,
																  STASK.flags AS '@flags' ,
																  STASK.subTaskOrder AS '@subTaskOrder' ,
																  STASK.subTaskName AS '@subTaskName'
														FOR
														  XML PATH('subTask') ,
															  TYPE
														) ,
														( SELECT  --OPTIONS
																  SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
														  FROM    TM_SubTaskXMLOptions SOPTIONS
														  WHERE   SOPTIONS.subTaskId = STASK.subTaskId
														FOR
														  XML PATH('') ,
															  TYPE
														)
											  FROM      TM_subTask AS STASK
											  WHERE     STASK.taskId = [#tmTask].taskId
											FOR
											  XML PATH('subTasks') ,
												  TYPE
											)
									 FROM   dbo.#tmTask
											INNER JOIN dbo.UMUsers AS USR ON dbo.#tmTask.ownerId = USR.id
											LEFT OUTER JOIN dbo.NTnotificationRule ON dbo.NTnotificationRule.id = dbo.#tmTask.alertId
									 WHERE  [#tmTask].[deleted] = 0
												AND [#tmTask].[invalid] = 0
												AND [#tmTask].[uninstalled] = 0
												AND [#tmTask].[isAgentlessSRM] = 1
								   FOR
									 XML PATH('taskDetail') ,
										 ROOT('TMMsg_GetTaskListResp')
								   )
					END
				ELSE
					BEGIN
						--CREATE THE TEMP TABLE--
						IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
							DROP TABLE #AssocEntity
						--Making this change as per customers request like 200212-427, from now we will be showing the tasks associated at client group level as well.
						--INSERT INTO @clientGrpSelLst(clientGrpId)
						--SELECT TMMsg.n.value('@clientGroupId','INT')
						--FROM @jobXmlText.nodes('TMMsg_JobOption/adminOpts/reportOption/computerSelectionList/clientGroupList') TMMsg(n)
						-- For not considering tasks which are not associated at Client group level
						--INSERT INTO @clientGrpSelLst VALUES(0)
						IF object_id('tempdb.dbo.#TM_AssocEntityTmp') is NOT NULL
							DROP TABLE #TM_AssocEntityTmp
						SELECT assocId , assocType , taskId	,flags , created , clientGroupId , clientId , apptypeId , instanceId , backupsetId , subclientId , policyId	, copyId , srmReportSet	,srmReportType ,exclude	,trackingPolicyId ,MediaAgentId	,agentlessPolicyId ,workflowId,sidbStoreId	,libraryId, logMonitoringPolicyId, entityId
						INTO #TM_AssocEntityTmp
						FROM
						(
							SELECT assocId , assocType , taskId	,flags , created , clientGroupId , clientId , apptypeId , instanceId , backupsetId , subclientId , policyId	, copyId , srmReportSet	,srmReportType ,exclude	,trackingPolicyId ,MediaAgentId	,agentlessPolicyId ,workflowId,sidbStoreId	,libraryId, logMonitoringPolicyId, entityId
							FROM dbo.TM_AssocEntity WITH (NOLOCK)
WHERE assocType!=158
							UNION
							SELECT assocId , assocType , taskId	,flags , TM_AssocEntity.created , clientGroupId , App_Application.clientId , App_Application.apptypeId , App_Application.instance , App_Application.backupset, App_Application.Id , policyId	, copyId , srmReportSet	,srmReportType ,exclude	,trackingPolicyId ,MediaAgentId	,agentlessPolicyId ,workflowId,sidbStoreId	,libraryId, logMonitoringPolicyId, entityId
							FROM dbo.TM_AssocEntity WITH (NOLOCK)
							LEFT JOIN App_SubclientProp SCP WITH(NOLOCK) ON SCP.attrName = 'Associated Plan' AND SCP.cs_attrName = CHECKSUM(N'Associated Plan')
								AND CAST(TM_AssocEntity.entityId AS NVARCHAR(10)) = SCP.attrVal
								AND SCP.modified = 0
							LEFT JOIN App_Application (NOLOCK) ON App_Application.id = SCP.componentNameId
WHERE TM_AssocEntity.assocType = 158-- plan entity
						) T
					--DO BACKUP SCHEDULES SECURITY CHECK
					SELECT DISTINCT ASS.assocType ,
								ASS.exclude ,
								ASS.taskId ,
								ASS.clientGroupId ,
								-- OR @clopt>0 .. expand clients...
CASE WHEN assocType!=158 OR @clopt>0 THEN ASS.clientId ELSE 0 END AS clientId,
CASE WHEN assocType!=158 OR @clopt>0 THEN ASS.apptypeId ELSE 0 END AS apptypeId,
CASE WHEN assocType!=158 OR @clopt>0 THEN ASS.instanceId ELSE 0 END AS instanceId,
CASE WHEN assocType!=158 OR @clopt>0 THEN ASS.backupsetId ELSE 0 END AS backupsetId,
CASE WHEN assocType!=158 OR @clopt>0 THEN ASS.subclientId ELSE 0 END AS subclientId,
								ASS.policyId ,
								dbo.archGroup.name AS policyName ,
								ASS.copyId ,
								ASS.mediaAgentId,
(CASE WHEN (( (assocType!=158 OR @clopt>0) AND ASS.ClientId>0) OR ASS.mediaAgentID>0) THEN
									CASE WHEN @useClientDisplayName = 1 THEN dbo.APP_Client.displayname ELSE dbo.APP_Client.name END
								 ELSE NULL END) AS mediaAgentName,
								ASS.srmReportSet AS srmReportSet,
								ASS.srmReportType AS srmReportType,
				               '' AS srmReportName,
								dbo.archGroupCopy.name AS copyName ,
								dbo.APP_ClientGroup.name AS clientGroupName ,
CASE WHEN assocType!=158 OR @clopt>0 THEN
                                (CASE WHEN @useClientDisplayName = 1 THEN dbo.APP_Client.displayname ELSE dbo.APP_Client.name END)
								ELSE NULL END AS clientName,
CASE WHEN assocType!=158 OR @clopt>0 THEN dbo.APP_iDAType.name ELSE NULL END AS appTypeName ,
CASE WHEN assocType!=158 OR @clopt>0 THEN dbo.APP_Application.subclientName ELSE NULL END As subclientName,
CASE WHEN assocType!=158 OR @clopt>0 THEN dbo.APP_BackupSetName.name ELSE NULL END  AS backupsetName ,
CASE WHEN assocType!=158 OR @clopt>0 THEN dbo.APP_InstanceName.name ELSE NULL END AS instanceName,
								ASS.trackingPolicyId AS trackingPolicyId,
								ASS.agentlessPolicyId,
CASE WHEN assocType = 158 THEN ASS.entityID Else 0 END As planId,
								App_plan.name as planName
						INTO    #AssocEntity
						FROM #TM_AssocEntityTmp ASS
								INNER JOIN #tmTask TA ON TA.taskId = ASS.taskId
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = ASS.taskId AND SA.subTaskType=2
								INNER JOIN #entitiesWithViewSchedCapability sec ON
								((capabilities&1073743876) <> 0 OR @userId = TA.ownerId) AND
								(
									(
										(((capabilities&2048) <> 0) AND ((capabilities & 4) <> 0)) OR ((capabilities&1073741824) <> 0))
									AND
									(
										( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
										(((ASS.clientId = sec.clientId AND ASS.clientId <> 0 AND sec.clientId <> 0)  OR (sec.clientId = 0 AND sec.clientGroupId = 0
											--CLIENTID AND GROUPID WILL BE 0 WHEN SECURITY ASSOCIATION IS AT BELOW ENTITIES
											AND sec.archGroupId = 0 AND sec.libraryId = 0 AND sec.vtContainerId = 0 AND sec.vtPolicyId = 0 AND sec.vtShelfId = 0 AND sec.mediaAgentId = 0
											AND sec.querySetId = 0 AND sec.downloadSetId = 0 AND sec.ermId = 0 AND sec.legalHoldId = 0 AND sec.tagId = 0 AND sec.cdPolicyId = 0
											AND sec.complianceReportId = 0 AND sec.taskId = 0 AND sec.workflowId = 0 AND sec.logMonitoringPolicyId = 0 AND sec.arrayId = 0 AND sec.cloudId = 0
											AND sec.userGroupId = 0 AND sec.providerId = 0))
										OR
											(ASS.clientId = 0 AND
												(sec.clientGroupId = ASS.clientGroupId OR
													ASS.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId=sec.clientId)
												)
											)
										)
										AND (ASS.appTypeId     = sec.appTypeId   OR  ASS.appTypeId = 0  OR sec.appTypeId = 0 )
										AND (ASS.instanceId    = sec.instanceId  OR  ASS.instanceId  = 0  OR sec.instanceId = 0 )
										AND (ASS.backupsetId   = sec.backupSetId OR  ASS.backupsetId = 0  OR sec.backupSetId = 0 )
										AND (ASS.subclientId   = sec.subClientId OR  ASS.subclientId = 0  OR sec.subClientId = 0 )
									)
										OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
										(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
										)
									)
								)
								LEFT OUTER JOIN dbo.APP_ClientGroup WITH (NOLOCK) ON ASS.clientGroupId = dbo.APP_ClientGroup.id
								LEFT OUTER JOIN dbo.APP_Client WITH (NOLOCK) ON ASS.clientId = dbo.APP_Client.id OR ASS.mediaAgentId = dbo.APP_Client.id
								LEFT OUTER JOIN dbo.APP_iDAType WITH (NOLOCK) ON ASS.apptypeId = dbo.APP_iDAType.type
								LEFT OUTER JOIN dbo.APP_Application WITH (NOLOCK) ON ASS.subclientId = dbo.APP_Application.id
								LEFT OUTER JOIN dbo.APP_BackupSetName WITH (NOLOCK) ON ASS.backupsetId = dbo.APP_BackupSetName.id
								LEFT OUTER JOIN dbo.APP_InstanceName WITH (NOLOCK) ON ASS.instanceId = dbo.APP_InstanceName.id
								LEFT OUTER JOIN dbo.archGroup WITH (NOLOCK) ON ASS.policyId = dbo.archGroup.id
								LEFT OUTER JOIN dbo.archGroupCopy WITH (NOLOCK) ON ASS.copyId = dbo.archGroupCopy.id
								LEFT OUTER JOIN dbo.App_Plan WITH (NOLOCK) ON ASS.entityId = App_Plan.Id AND
ASS.assocType = 158
				        where ( dbo.APP_Client.status & 2 <> 2 OR ASS.clientId = 0 )
								AND (@clOpt = 0 OR ASS.clientId = 0 OR ASS.clientId IN (SELECT clientId FROM @clientTable))
								AND (@clOpt = 0 OR ASS.clientGroupId = 0 OR ASS.clientGroupId IN (
										SELECT DISTINCT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId IN (SELECT clientId FROM @clientTable))
									)
								AND (@appTypeOpt = 0 OR ASS.appTypeId = 0 OR ASS.appTypeId IN (SELECT appTypeId FROM @appTypeTable))
AND ((@excludeHiddenSubclients = 1 AND dbo.APP_Application.subclientStatus & 0x00020 <> 0x00020 OR @excludeHiddenSubclients = 0) OR ASS.subclientId = 0)
					-- List individual clients associated to a schedule via a client group when the report is for selected clients.
					IF @clOpt > 0
					BEGIN
						INSERT	INTO #AssocEntity
						SELECT	DISTINCT assocType, exclude, taskId, AE.clientGroupId, A.clientId, A.apptypeId, A.instance, A.backupset, A.id,
								policyId, policyName, copyId, mediaAgentId, mediaAgentName, srmReportSet, srmReportType, srmReportName,
								copyName, clientGroupName, CL.name,
								(SELECT name FROM APP_iDAType WHERE type = A.apptypeId),
								A.subclientName,
								(SELECT name FROM APP_BackupsetName WHERE id = A.backupset),
								(SELECT name FROM APP_InstanceName WHERE id = A.instance),
								trackingPolicyId, agentlessPolicyId, 0 ,NULL
						FROM	#AssocEntity AE
								INNER JOIN APP_ClientGroupAssoc CGA ON AE.clientGroupId = CGA.clientGroupId
								INNER JOIN APP_Client CL ON CGA.clientId = CL.id AND CL.status & 2 <> 2
								INNER JOIN APP_Application A ON CL.id = A.clientId AND A.subclientStatus & 2 <> 2 AND (A.dataArchGrpId > 1 OR A.logArchGrpId > 1)
						WHERE	AE.clientGroupId > 0 AND AE.clientId = 0
							AND (@appTypeOpt = 0 OR A.apptypeId IN (SELECT appTypeId FROM @appTypeTable)) AND A.appTypeId <> 1000
						UNION
						SELECT	DISTINCT assocType, exclude, taskId, AE.clientGroupId, A.clientId, A.appTypeId, A.instance, A.backupset, A.id,
								policyId, policyName, copyId, mediaAgentId, mediaAgentName, srmReportSet, srmReportType, srmReportName,
								copyName, clientGroupName, CL.name,
								(SELECT name FROM APP_iDAType WHERE type = A.apptypeId),
								A.subclientName,
								(SELECT name FROM APP_BackupsetName WHERE id = A.backupset),
								(SELECT name FROM APP_InstanceName WHERE id = A.instance),
								trackingPolicyId, agentlessPolicyId,planId, planName
						FROM	#AssocEntity AE
								INNER JOIN APP_Client CL ON AE.clientId = CL.id AND CL.status & 2 <> 2
								INNER JOIN APP_Application A ON CL.id = A.clientId AND A.subclientStatus & 2 <> 2 AND (A.dataArchGrpId > 1 OR A.logArchGrpId > 1)
						WHERE	AE.clientId > 0
							AND (AE.appTypeId = A.appTypeId OR AE.appTypeId = 0)
							AND (AE.instanceId = A.instance OR AE.instanceId = 0)
							AND (AE.backupsetId = A.backupset OR AE.backupsetId = 0)
							AND (AE.subclientId = A.id OR AE.subclientId = 0)
							AND (@appTypeOpt = 0 OR A.apptypeId IN (SELECT appTypeId FROM @appTypeTable)) AND A.appTypeId <> 1000
							AND AE.assocType!=158 -- plan entity
					END
					--select * from #AssocEntity
					--DO RESTORE SCHEDULES SECURITY CHECK
					INSERT INTO    #AssocEntity
					SELECT DISTINCT dbo.TM_AssocEntity.assocType ,
								dbo.TM_AssocEntity.exclude ,
								dbo.TM_AssocEntity.taskId ,
								dbo.TM_AssocEntity.clientGroupId ,
								dbo.TM_AssocEntity.clientId ,
								dbo.TM_AssocEntity.apptypeId ,
								dbo.TM_AssocEntity.instanceId ,
								dbo.TM_AssocEntity.backupsetId ,
								dbo.TM_AssocEntity.subclientId ,
								dbo.TM_AssocEntity.policyId ,
								dbo.archGroup.name AS policyName ,
								dbo.TM_AssocEntity.copyId ,
								dbo.TM_AssocEntity.mediaAgentId,
                                (CASE WHEN @useClientDisplayName = 1 THEN dbo.APP_Client.displayname ELSE dbo.APP_Client.name END) AS mediaAgentName,
								dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
								dbo.TM_AssocEntity.srmReportType AS srmReportType,
				                '' AS srmReportName,
								dbo.archGroupCopy.name AS copyName ,
								dbo.APP_ClientGroup.name AS clientGroupName ,
                                (CASE WHEN @useClientDisplayName = 1 THEN dbo.APP_Client.displayname ELSE dbo.APP_Client.name END) AS clientName,
								dbo.APP_iDAType.name AS appTypeName ,
								dbo.APP_Application.subclientName ,
								dbo.APP_BackupSetName.name AS backupsetName ,
								dbo.APP_InstanceName.name AS instanceName,
								dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
								dbo.TM_AssocEntity.agentlessPolicyId,
								0,
								NULL
						FROM    dbo.TM_AssocEntity
								INNER JOIN #tmTask TA ON TA.taskId = dbo.TM_AssocEntity.taskId
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.subTaskType=3
								INNER JOIN #entitiesWithViewSchedCapability sec ON
								((capabilities&1076363268) <> 0 OR @userId = TA.ownerId) AND
								(
									(
										(
											--((EV_RESTORE_IN_PLACE OR EV_RESTORE_OUTOF_PLACE) AND (EV_MANAGE_APPLICATION)) OR EV_VISIBILITY)
											(((capabilities&524288) <> 0) OR ((capabilities&2097152) <> 0)) AND ((capabilities & 4) <> 0))  OR ((capabilities&1073741824) <> 0)
										)
									AND
									(
										( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
										(((dbo.TM_AssocEntity.clientId = sec.clientId AND dbo.TM_AssocEntity.clientId <> 0 AND sec.clientId <> 0)  OR (sec.clientId = 0 AND sec.clientGroupId = 0
											--CLIENTID AND GROUPID WILL BE 0 WHEN SECURITY ASSOCIATION IS AT BELOW ENTITIES
											AND sec.archGroupId = 0 AND sec.libraryId = 0 AND sec.vtContainerId = 0 AND sec.vtPolicyId = 0 AND sec.vtShelfId = 0 AND sec.mediaAgentId = 0
											AND sec.querySetId = 0 AND sec.downloadSetId = 0 AND sec.ermId = 0 AND sec.legalHoldId = 0 AND sec.tagId = 0 AND sec.cdPolicyId = 0
											AND sec.complianceReportId = 0 AND sec.taskId = 0 AND sec.workflowId = 0 AND sec.logMonitoringPolicyId = 0 AND sec.arrayId = 0 AND sec.cloudId = 0
											AND sec.userGroupId = 0 AND sec.providerId = 0))
										OR
											(dbo.TM_AssocEntity.clientId = 0 AND
												(sec.clientGroupId = dbo.TM_AssocEntity.clientGroupId OR
													dbo.TM_AssocEntity.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId=sec.clientId)
												)
											)
										)
										AND (dbo.TM_AssocEntity.appTypeId     = sec.appTypeId   OR  dbo.TM_AssocEntity.appTypeId = 0  OR sec.appTypeId = 0 )
										AND (dbo.TM_AssocEntity.instanceId    = sec.instanceId  OR  dbo.TM_AssocEntity.instanceId  = 0  OR sec.instanceId = 0 )
										AND (dbo.TM_AssocEntity.backupsetId   = sec.backupSetId OR  dbo.TM_AssocEntity.backupsetId = 0  OR sec.backupSetId = 0 )
										AND (dbo.TM_AssocEntity.subclientId   = sec.subClientId OR  dbo.TM_AssocEntity.subclientId = 0  OR sec.subClientId = 0 )
									)
										OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
										(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
										)
									)
								)
								LEFT OUTER JOIN dbo.APP_ClientGroup WITH (NOLOCK) ON dbo.TM_AssocEntity.clientGroupId = dbo.APP_ClientGroup.id
								LEFT OUTER JOIN dbo.APP_Client WITH (NOLOCK) ON dbo.TM_AssocEntity.clientId = dbo.APP_Client.id OR dbo.TM_AssocEntity.mediaAgentId = dbo.APP_Client.id
								LEFT OUTER JOIN dbo.APP_iDAType WITH (NOLOCK) ON dbo.TM_AssocEntity.apptypeId = dbo.APP_iDAType.type
								LEFT OUTER JOIN dbo.APP_Application WITH (NOLOCK) ON dbo.TM_AssocEntity.subclientId = dbo.APP_Application.id
								LEFT OUTER JOIN dbo.APP_BackupSetName WITH (NOLOCK) ON dbo.TM_AssocEntity.backupsetId = dbo.APP_BackupSetName.id
								LEFT OUTER JOIN dbo.APP_InstanceName WITH (NOLOCK) ON dbo.TM_AssocEntity.instanceId = dbo.APP_InstanceName.id
								LEFT OUTER JOIN dbo.archGroup WITH (NOLOCK) ON dbo.TM_AssocEntity.policyId = dbo.archGroup.id
								LEFT OUTER JOIN dbo.archGroupCopy WITH (NOLOCK) ON dbo.TM_AssocEntity.copyId = dbo.archGroupCopy.id
				                WHERE ( dbo.APP_Client.status & 2 <> 2 OR dbo.TM_AssocEntity.clientId = 0 )
AND ((@excludeHiddenSubclients = 1 AND dbo.APP_Application.subclientStatus & 0x00020 <> 0x00020 OR @excludeHiddenSubclients = 0) OR dbo.TM_AssocEntity.subclientId = 0)
					--select * from #AssocEntity
					--DO ADMIN SCHEDULES SECURITY CHECK
					INSERT INTO    #AssocEntity
					SELECT DISTINCT dbo.TM_AssocEntity.assocType ,
								dbo.TM_AssocEntity.exclude ,
								dbo.TM_AssocEntity.taskId ,
								dbo.TM_AssocEntity.clientGroupId ,
								dbo.TM_AssocEntity.clientId ,
								dbo.TM_AssocEntity.apptypeId ,
								dbo.TM_AssocEntity.instanceId ,
								dbo.TM_AssocEntity.backupsetId ,
								dbo.TM_AssocEntity.subclientId ,
								dbo.TM_AssocEntity.policyId ,
								dbo.archGroup.name AS policyName ,
								dbo.TM_AssocEntity.copyId ,
								dbo.TM_AssocEntity.mediaAgentId,
                                (CASE WHEN @useClientDisplayName = 1 THEN dbo.APP_Client.displayname ELSE dbo.APP_Client.name END) AS mediaAgentName,
								dbo.TM_AssocEntity.srmReportSet AS srmReportSet,
								dbo.TM_AssocEntity.srmReportType AS srmReportType,
				                '' AS srmReportName,
								dbo.archGroupCopy.name AS copyName ,
								dbo.APP_ClientGroup.name AS clientGroupName ,
                                (CASE WHEN @useClientDisplayName = 1 THEN dbo.APP_Client.displayname ELSE dbo.APP_Client.name END) AS clientName,
								dbo.APP_iDAType.name AS appTypeName ,
								dbo.APP_Application.subclientName ,
								dbo.APP_BackupSetName.name AS backupsetName ,
								dbo.APP_InstanceName.name AS instanceName,
								dbo.TM_AssocEntity.trackingPolicyId AS trackingPolicyId,
								dbo.TM_AssocEntity.agentlessPolicyId,
								0,
								NULL
						FROM    dbo.TM_AssocEntity
								INNER JOIN #tmTask TA ON TA.taskId = dbo.TM_AssocEntity.taskId
INNER JOIN TM_SubTask SA WITH (NOLOCK) ON SA.taskId = dbo.TM_AssocEntity.taskId AND SA.subTaskType IN (1, 4, 5)
								INNER JOIN #entitiesWithViewSchedCapability sec ON
								((capabilities&1073741825) <> 0 OR @userId = TA.ownerId) AND
								(
									(((capabilities&1) <> 0) OR ((capabilities&1073741824) <> 0))
									AND
									(
										( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
									(
												((dbo.TM_AssocEntity.clientId = sec.clientId AND dbo.TM_AssocEntity.clientId <> 0 AND sec.clientId <> 0)  OR (sec.clientId = 0 AND sec.clientGroupId = 0
											--CLIENTID AND GROUPID WILL BE 0 WHEN SECURITY ASSOCIATION IS AT BELOW ENTITIES
											AND sec.archGroupId = 0 AND sec.libraryId = 0 AND sec.vtContainerId = 0 AND sec.vtPolicyId = 0 AND sec.vtShelfId = 0 AND sec.mediaAgentId = 0
											AND sec.querySetId = 0 AND sec.downloadSetId = 0 AND sec.ermId = 0 AND sec.legalHoldId = 0 AND sec.tagId = 0 AND sec.cdPolicyId = 0
											AND sec.complianceReportId = 0 AND sec.taskId = 0 AND sec.workflowId = 0 AND sec.logMonitoringPolicyId = 0 AND sec.arrayId = 0 AND sec.cloudId = 0
											AND sec.userGroupId = 0 AND sec.providerId = 0)
												)
										OR
											(dbo.TM_AssocEntity.clientId = 0 AND
												(sec.clientGroupId = dbo.TM_AssocEntity.clientGroupId OR
													dbo.TM_AssocEntity.clientGroupId IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId=sec.clientId)
												)
											)
										)
										AND (dbo.TM_AssocEntity.policyId      = sec.archGroupId OR  (dbo.TM_AssocEntity.policyId = 0  AND sec.archGroupId = 0) )
										AND (dbo.TM_AssocEntity.trackingPolicyId  = sec.vtPolicyId OR  (dbo.TM_AssocEntity.trackingPolicyId = 0  AND sec.vtPolicyId = 0 ))
										--IGNORE SECURITY CHECK FOR ADMIN TASK FOR NOW, IT WILL BE DONE AT THE VIEW LEVEL BELOW
										AND NOT (dbo.TM_AssocEntity.clientId = 0 AND dbo.TM_AssocEntity.clientGroupId = 0 AND dbo.TM_AssocEntity.appTypeId = 0 AND
											dbo.TM_AssocEntity.instanceId = 0 AND dbo.TM_AssocEntity.backupsetId = 0 AND dbo.TM_AssocEntity.subclientId = 0 AND
											dbo.TM_AssocEntity.MediaAgentId = 0 AND dbo.TM_AssocEntity.policyId = 0 AND dbo.TM_AssocEntity.trackingPolicyId = 0 AND TM_AssocEntity.copyId = 0)
									)
										OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
										(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
										)
									)
								)
								LEFT OUTER JOIN dbo.APP_ClientGroup ON dbo.TM_AssocEntity.clientGroupId = dbo.APP_ClientGroup.id
								LEFT OUTER JOIN dbo.APP_Client ON dbo.TM_AssocEntity.clientId = dbo.APP_Client.id OR dbo.TM_AssocEntity.mediaAgentId = dbo.APP_Client.id
								LEFT OUTER JOIN dbo.APP_iDAType ON dbo.TM_AssocEntity.apptypeId = dbo.APP_iDAType.type
								LEFT OUTER JOIN dbo.APP_Application ON dbo.TM_AssocEntity.subclientId = dbo.APP_Application.id
								LEFT OUTER JOIN dbo.APP_BackupSetName ON dbo.TM_AssocEntity.backupsetId = dbo.APP_BackupSetName.id
								LEFT OUTER JOIN dbo.APP_InstanceName ON dbo.TM_AssocEntity.instanceId = dbo.APP_InstanceName.id
								LEFT OUTER JOIN dbo.archGroup ON dbo.TM_AssocEntity.policyId = dbo.archGroup.id
								LEFT OUTER JOIN dbo.archGroupCopy ON dbo.TM_AssocEntity.copyId = dbo.archGroupCopy.id
				                WHERE ( dbo.APP_Client.status & 2 <> 2 OR dbo.TM_AssocEntity.clientId = 0 )
AND ((@excludeHiddenSubclients = 1 AND dbo.APP_Application.subclientStatus & 0x00020 <> 0x00020 OR @excludeHiddenSubclients = 0) OR dbo.TM_AssocEntity.subclientId = 0)
						--select * from #AssocEntity
						IF EXISTS(SELECT * FROM @clientGrpSelLst WHERE clientGrpId <> 0)
						DELETE A FROM #AssocEntity A LEFT OUTER JOIN @clientGrpSelLst ON clientGroupId= clientGrpId WHERE clientGrpId IS NULL
					-- 2. Commcell Level View Schedules
						IF @clientGroupId = 0
						AND @clientId = 0
						AND @apptypeId = 0
						AND @instanceId = 0
						AND @backupsetId = 0
						AND @subclientId = 0
						AND @srmReportType = 0
						AND @srmReportSet = 0
						AND @policyId = 0
						AND @copyId = 0
						AND @mediaAgentId = 0
						AND @trackingPolicyId = 0
						AND @savedReports = 0
						AND @otherReports = 0
						AND @agentlessSRM = 0
						AND @policy = 1
						AND @schedules = 1
						AND @agentlessPolicyId = 0
						BEGIN
							INSERT INTO #Clients_Timezone_StartTime(clientId , timezoneName , jobStartTime , taskID , patternID )
							SELECT DISTINCT AssocEntity.clientId, NULL, -1, AssocEntity.taskId, 0
							FROM #AssocEntity AssocEntity
							WHERE clientID > 0
							-- Call stored procedure to compute timezone and start time for clients.
							EXEC TM_ComputeStarttimeForClient
							SET @xmlText = ( SELECT	 --TASKLIST
											( SELECT 	--TASK
														[#tmTask].taskId AS '@taskId' ,
														[#tmTask].taskName AS '@taskName' ,
														[#tmTask].taskType AS '@taskType' ,
														[#tmTask].alertId AS '@alertId' ,
														[NTnotificationRule].notificationName AS '@alertName' ,
														[#tmTask].ownerId AS '@ownerId' ,
														[#tmTask].runUserId AS '@runUserId' ,
														[#tmTask].description AS '@description' ,
														USR.login AS '@ownerName' ,
														[#tmTask].policyType AS '@policyType' ,
														--dbo.GetEntityCount([#tmTask].taskId) AS '@associatedObjects' ,
														[#tmTask].GUID ,
														( SELECT -- alert
																  [#tmTask].alertId AS '@alertId' ,
																  NT.notificationName AS '@alertName'
														  FROM    dbo.NTnotificationRule
																  AS NT
														  WHERE   NT.id = [#tmTask].alertId
														FOR
														  XML PATH('alert') ,
															  TYPE
														) ,
														( SELECT-- origCC
																  [#tmTask].origCCId AS '@commCellId'
														FOR
														  XML PATH('originalCC') ,
															  TYPE
														) ,
														( SELECT  --TaskFlags
																  [#tmTask].disabled AS '@disabled' ,
																  [#tmTask].uninstalled AS '@uninstalled' ,
																  [#tmTask].isEZOperation AS '@isEZOperation'
														FOR
														  XML PATH('taskFlags') ,
															  TYPE
														)
											FOR
											  XML PATH('task') ,
												  TYPE
											) ,
											( SELECT  --APPGROUP
														( SELECT  --GROUP SELECTED
                                                              	  TFIL.filter_value AS '@appGroupId'
														  FROM    TM_AssocFilter
																  AS TFIL
														  WHERE   TFIL.filter_type = 1
																  AND TFIL.taskId = [#tmTask].taskId
														FOR
                                                      		XML PATH('appGroups') ,
															  TYPE
														) ,
														( SELECT  --TYPES SELECTED
                                                              	  TFIL.filter_value AS '@appTypeId'
														  FROM    TM_AssocFilter
																  AS TFIL
														  WHERE   TFIL.filter_type = 2
																  AND TFIL.taskId = [#tmTask].taskId
														FOR
                                                     	 XML PATH('appTypes') ,
															  TYPE
														)
											FOR
											  XML PATH('appGroup') ,
												  TYPE
											) ,
											( SELECT --NEXT SCHEDULES
														datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(dbo.ClientLocalToUTCTime(RAS.nextRunTime,2), ASSOC.clientId)) '@nextScheduleTime',
														--ABS(datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(GETDATE(), 2)) - datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(RAS.nextRunTime, 2))) '@relativeTime',
														ABS(datediff(second, '01/01/1970', RAS.nextRunTime) - datediff(second, '01/01/1970', GETDATE())) '@relativeTime',
														(SELECT ASSOC.clientId '@clientId'
															FOR
															XML PATH('client') ,
															  TYPE
														) ,
														(SELECT STASK.subTaskId '@subTaskId',
															STASK.taskId '@taskId'
															FOR
															XML PATH('subtask') ,
															  TYPE
														) ,
														(SELECT TimeZoneId '@TimeZoneID' FROM SchedTimeZone
															WHERE TimeZoneStdName = dbo.GetClientTimeZone(ASSOC.clientId)
															FOR
															XML PATH('timeZone') ,
															  TYPE
														)
											  FROM		(SELECT DISTINCT * FROM #AssocEntity) AS ASSOC
														INNER JOIN TM_SubTask AS STASK ON STASK.taskId = ASSOC.taskId
														INNER JOIN TM_PatternAssoc
																AS PAS ON PAS.subTaskId = STASK.subTaskId
														INNER JOIN TM_Pattern
																AS PAT ON PAT.patternId = PAS.patternId
														INNER JOIN TM_RunTime
																AS NRT ON NRT.patternId = PAS.patternId
														INNER JOIN TM_RunTimeAssoc
																AS RAS ON RAS.runTimeId = NRT.runTimeId
AND (PAT.tzId <> 1001 OR (PAT.tzId = 1001 AND RAS.timeZoneNames = dbo.GetClientTimeZone(ASSOC.clientId)))
																AND RAS.processed = 0
														INNER JOIN #Clients_Timezone_StartTime Clients_Timezone_StartTime ON
														Clients_Timezone_StartTime.clientID = ASSOC.clientId
														AND Clients_Timezone_StartTime.jobStartTime = RAS.jobStartTime
														AND Clients_Timezone_StartTime.taskId = STASK.taskId
														-- Pick the runtime association where jobStartTime matches.
											  WHERE		STASK.subTaskId = PAS.subTaskId
														AND STASK.taskId = [#tmTask].taskId
AND PAT.tzId = 1001
											FOR
											  XML PATH('nextScheduleTimes') ,
												  TYPE
											) ,
											( SELECT --ASSOC
														ASSOC.assocType '@_type_' ,
														ASSOC.clientGroupId '@clientGroupId' ,
														ASSOC.clientGroupName '@clientGroupName' ,
														ASSOC.clientId '@clientId' ,
														ASSOC.clientName '@clientName' ,
														ASSOC.apptypeId '@applicationId' ,
														ASSOC.appTypeName '@appName' ,
														ASSOC.policyId '@storagePolicyId' ,
														ASSOC.policyName '@storagePolicyName' ,
														ASSOC.mediaAgentId '@mediaAgentId',
														ASSOC.mediaAgentName '@mediaAgentName',
														ASSOC.instanceId '@instanceId' ,
														REPLACE(ASSOC.instanceName,
																'', ' ') '@instanceName' ,
														ASSOC.backupsetId '@backupsetId' ,
														ASSOC.copyId '@copyId' ,
														ASSOC.copyName '@copyName' ,
														ASSOC.srmReportSet '@srmReportSet',
														ASSOC.srmReportType '@srmTemplateId',
														ASSOC.srmReportName '@srmTemplateName',
														ASSOC.backupsetName '@backupsetName' ,
														ASSOC.subclientId '@subclientId' ,
														ASSOC.subclientName '@subclientName',
														ASSOC.agentlessPolicyId '@agentlessPolicyId',
														ASSOC.planId '@planId',
														ASSOC.planName '@planName',
														( SELECT ASSOC.exclude '@exclude' FOR XML PATH('flags') ,TYPE )
											  FROM      (SELECT DISTINCT * FROM #AssocEntity) AS ASSOC
											  WHERE     ASSOC.taskId = [#tmTask].taskId
											FOR
											  XML PATH('associations') ,
												  TYPE
											) ,
											( SELECT		--SUBTASKINFO
							--TASK RUN TIME FROM TM_RunTime Table
														NRT.nextTime AS '@nextScheduleTime' ,
														ABS(datediff(second, '01/01/1970', GETUTCDATE()) - datediff(second, '01/01/1970', NRT.nextRunTime)) '@relativeTime',
														( SELECT	DISTINCT --SUBTASK
																  STASK.subTaskId AS '@subTaskId' ,
																  STASK.subTaskType AS '@subTaskType' ,
																  STASK.operationType AS '@operationType' ,
																  STASK.flags AS '@flags' ,
																  STASK.subTaskOrder AS '@subTaskOrder' ,
																  STASK.subTaskName AS '@subTaskName'
														FOR
														  XML PATH('subTask') ,
															  TYPE
														) ,
														( SELECT --PATTERN
																  PAT.patternId '@patternId' ,
																  PAT.name '@name' ,
																  PAT.flags '@flags' ,
																  PAT.freq_type '@freq_type' ,
																  PAT.freq_interval '@freq_interval' ,
																  PAT.freq_relative_interval '@freq_relative_interval' ,
																  PAT.freq_recurrence_factor '@freq_recurrence_factor' ,
																  PAT.freq_subday_interval '@freq_subday_interval' ,
																  PAT.skipOccurence '@skipOccurence' ,
																  PAT.skipDayNumber '@skipDayNumber' ,
																  PAT.local_start_date '@active_start_date' ,
																  PAT.active_start_time '@active_start_time' ,
																  PAT.local_end_date '@active_end_date' ,
																  PAT.active_end_time '@active_end_time' ,
																  PAT.active_end_occurence '@active_end_occurence' ,
																  PAT.description '@description' ,
																  PAT.freq_restart_interval '@freq_restart_interval',
																  ( SELECT  --TimeZone
																  PAT.tzId AS '@TimeZoneID'
																  FOR
																  XML
																  PATH('timeZone') ,
																  TYPE
																  ) ,
																  ( SELECT  --Calendar
																  PAT.calendarId AS '@calendarId'
																  FOR
																  XML
																  PATH('calendar') ,
																  TYPE
																  )
														  FROM    TM_Pattern AS PAT ,
																  TM_PatternAssoc PASOC
														  WHERE   [PASOC].[patternId] = PAT.[patternId]
																  AND PASOC.subTaskId = STASK.subTaskId
														FOR
														  XML PATH('pattern') ,
															  TYPE
														) ,
														( SELECT  --OPTIONS
																  SOPTIONS.xmlValue.query('/TMMsg_JobOption/*') AS 'options'
														  FROM    TM_SubTaskXMLOptions SOPTIONS
														  WHERE   SOPTIONS.subTaskId = STASK.subTaskId
														FOR
														  XML PATH('') ,
															  TYPE
														)
												  FROM      TM_subTask AS STASK
															LEFT OUTER JOIN TM_PatternAssoc
																AS PAS ON PAS.subTaskId = STASK.subTaskId
															LEFT OUTER JOIN TM_Pattern
																AS PAT ON PAT.patternId = PAS.patternId
															LEFT OUTER JOIN TM_RunTime
																AS NRT ON NRT.patternId = PAS.patternId
																	  AND NRT.processed = 0
												  WHERE     STASK.subTaskId = PAS.subTaskId
															AND STASK.taskId = [#tmTask].taskId
															AND (
subTaskType <> 1 OR (subTaskType = 1
																  AND (
																		( EXISTS(SELECT * FROM #entitiesWithViewSchedCapability WHERE
																			--EV_SCHEDULE_ADMIN OR EV_VISIBILITY
(((capabilities & 1) <> 0) OR ((capabilities&1073741824) <> 0)) AND STASK.operationType NOT IN (4004)
																			AND ( commCellId = 2 AND appTypeId=0 AND backupsetId=0 AND archGroupId=0 AND clientGroupId=0 AND clientId=0 AND complianceReportId=0 AND complianceReportId=0
																				AND archGroupId=0 AND cdPolicyId=0 AND downloadSetId=0 AND ermId=0 AND instanceId=0 AND legalHoldId=0 AND libraryId=0 AND mediaAgentId=0
																				AND querySetId=0 AND reviewSetId=0 AND subClientId=0 AND tagId=0 AND vtContainerId=0 AND vtPolicyId=0 AND vtShelfId=0 AND taskId=0
																				)
																			)
																		)
																		OR
																		( EXISTS(SELECT * FROM #entitiesWithViewSchedCapability WHERE
																			--EV_SCHEDULE_ADMIN OR EV_RUN_REPORTS  OR EV_VISIBILITY
(((capabilities & 1) <> 0) OR ((capabilities & 16384) <> 0) OR ((capabilities&1073741824) <> 0)) AND STASK.operationType IN (4004)
																			AND ( commCellId = 2 AND appTypeId=0 AND backupsetId=0 AND archGroupId=0 AND clientGroupId=0 AND clientId=0 AND complianceReportId=0 AND complianceReportId=0
																				AND archGroupId=0 AND cdPolicyId=0 AND downloadSetId=0 AND ermId=0 AND instanceId=0 AND legalHoldId=0 AND libraryId=0 AND mediaAgentId=0
																				AND querySetId=0 AND reviewSetId=0 AND subClientId=0 AND tagId=0 AND vtContainerId=0 AND vtPolicyId=0 AND vtShelfId=0 AND taskId=0
																				)
																			)
																		)
																		OR ([#tmTask].ownerId = @userId)
																		OR
																		(
																			[#tmTask].taskId in (SELECT DISTINCT taskId FROM #AssocEntity)
																		)
																	)
																)
															)
															AND (( NRT.nextRunTime >= GETUTCDATE() )
																	AND ( ( NRT.flags & 1 ) = 0
) OR PAT.freq_type = 512
OR PAT.freq_type = 1024
															)
											FOR
											  XML PATH('subTasks') ,
												  TYPE
											)
									 FROM   dbo.#tmTask
											--INNER JOIN dbo.TM_AssocEntity ON dbo.TM_AssocEntity.taskId = dbo.#tmTask.taskId
											LEFT OUTER JOIN dbo.UMUsers AS USR ON dbo.#tmTask.ownerId = USR.id
											LEFT OUTER JOIN dbo.NTnotificationRule ON dbo.NTnotificationRule.id = dbo.#tmTask.alertId
									 WHERE  [#tmTask].[deleted] = 0
												AND [#tmTask].[invalid] = 0
												--AND [#tmTask].[uninstalled] = 0
												AND [#tmTask].[savedReport] = 0
												AND ( [#tmTask].taskId in (SELECT DISTINCT taskId FROM #AssocEntity)	--MR46115 Do not show schedule policy w/ 0 association on CS schedule tab
													OR (
														(@isUserAdmin = 1 OR dbo.#tmTask.ownerId = @userId) AND -- If user is admin, show all admin tasks else show only those which are created by that particular user.
														[#tmTask].taskId in (SELECT taskId FROM TM_SubTask WHERE subTaskType = 1)
													   )
													)
AND ( [#tmTask].[taskType] IN ( 2, 4 ) )
								   FOR
									 XML PATH('taskDetail') ,
										 ROOT('TMMsg_GetTaskListResp')
								   )
						END
					ELSE  -- 3. Schedules viewed at any other level in the tree
						BEGIN
						--GET OPERATION TYPES
						INSERT  INTO @operationFilter
								SELECT  ref.value('@val', 'int') AS operationType
								FROM    @xmlText.nodes('TMMsg_GetTaskListReq/filter/operationTypes') R ( ref )
						--BUILD SUBTASK FILTER FROM OPERATIONTYPE
						IF ( SELECT COUNT(*)
							 FROM   @operationFilter
						   ) > 1
							BEGIN
								INSERT  INTO @subtaskFilter
										SELECT  operationType
										FROM    @operationFilter
										WHERE   operationType IN ( @allBackup,
																   @allRestore,
																   @allAdmin )
								UPDATE  @subTaskFilter
								SET     subTaskType = CASE subTaskType
														WHEN @allAdmin
														THEN @subTaskTypeAdmin
												WHEN @allBackup
														THEN @subTaskTypeBackup
														ELSE @subTaskTypeRestore
													  END
								--REMOVE TYPES USED IN SUBTASKTYPE
								DELETE  FROM @operationFilter
								WHERE   operationType IN ( @allBackup, @allRestore,
														   @allAdmin )
							END
						ELSE
							BEGIN
								IF ( SELECT COUNT(operationType)
									 FROM   @operationFilter
									 WHERE  operationType = @allTasks
								   ) > 0 OR (SELECT COUNT(operationType)
												FROM	@operationFilter
									) = 0
									SET @showAllTasks = 1
							END
						--select 'debug10', * from @subtaskfilter
						--select 'debug11',* from @operationFilter
						--LIST OF BACKUP JOB TASK
						INSERT  INTO @taskTble
								SELECT DISTINCT
										taskId
								FROM #TM_AssocEntityTmp ASS
								WHERE   ( ( [clientId] = @clientId )
										  OR ( @clientId = 0 AND @clientGroupId = 0 )
										  OR ( [clientId] = 0 AND [clientGroupId] = @clientGroupId )
										  OR ( [clientId] = 0 AND [clientGroupId] IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId=@clientId))
										)
										AND ( [apptypeId] = @appTypeId
											  OR @appTypeId = 0
											  OR [apptypeId] = 0
											)
										AND ( [instanceId] = @instanceId
											  OR @instanceId = 0
											  OR [instanceId] = 0
											)
										AND ( [backupsetId] = @backupsetId
											  OR @backupsetId = 0
											  OR [backupsetId] = 0
											)
										AND ( [subclientId] = @subclientId
											  OR @subclientId = 0
											  OR [subclientId] = 0
											)
										AND ( [srmReportType] = @srmReportType
											  OR ( [srmReportType] = 0 AND @srmReportType = 0 )
											)
										AND ( [srmReportSet] = @srmReportSet
											  OR ( [srmReportSet] = 0 AND @srmReportSet = 0 )
											)
										AND ( [policyId] = @policyId
											  OR ( [policyId] = 0 AND @policyId = 0 )
											)
										AND ( [copyId] = @copyId
											  OR ( [copyId] = 0 AND [policyId] <> 0)
											  OR @copyId = 0
											)
										AND ( [trackingPolicyId] = @trackingPolicyId
											  OR ( [trackingPolicyId] = 0 AND @trackingPolicyId = 0 )
											)
										--AND ( [mediaAgentId] = @mediaAgentId
										--	  OR ( [mediaAgentId] = 0 AND @mediaAgentId = 0 )
										--	)
										AND ( [agentlessPolicyId] = @agentlessPolicyId
											  OR ( [agentlessPolicyId] = 0 AND @agentlessPolicyId = 0)
											)
						INSERT  INTO @taskTble
								SELECT --DISTINCT
										taskId
								FROM    [TM_AssocEntity] AS TA
								INNER JOIN VTPolicyToCopy AS VT ON VT.PolicyId = TA.trackingPolicyId
								WHERE   [VT].[ArchGroupId] = @policyId
										AND ( [VT].[copyId] = @copyId
											  OR ( [VT].[copyId] = 0 AND @copyId = 0 )
											)
						--ADD NON ADMIN SCHEDULES FOR STORAGE POLICY AND COPYID LEVEL
						INSERT  INTO @taskTble
								SELECT DISTINCT
										[TA].taskId
								FROM  #TM_AssocEntityTmp TA
								INNER JOIN #tmTask TK ON TK.taskId = [TA].taskId
								INNER JOIN APP_Application AS APP ON APP.dataArchGrpId = @policyId
								INNER JOIN #entitiesWithViewSchedCapability sec ON
								((capabilities&1076558735) <> 0 OR @userId = TK.ownerId) AND
								(
									((((capabilities&2048) <> 0) OR ((capabilities&524288) <> 0) OR ((capabilities&2097152) <> 0)) AND ((capabilities & 4) <> 0)) OR
									(
										(([TA].clientId  = sec.clientId  OR (sec.clientId = 0 AND sec.clientGroupId = 0
											AND sec.archGroupId = 0 AND sec.libraryId = 0 AND sec.vtContainerId = 0 AND sec.vtPolicyId = 0 AND sec.vtShelfId = 0
											AND sec.querySetId = 0 AND sec.downloadSetId = 0 AND sec.ermId = 0 AND sec.legalHoldId = 0 AND sec.tagId = 0 AND sec.cdPolicyId = 0
											AND sec.complianceReportId = 0))
										OR
										([TA].clientId = 0 AND sec.clientGroupId = [TA].clientGroupId))
										AND ([TA].appTypeId     = sec.appTypeId   OR  [TA].appTypeId = 0  OR sec.appTypeId = 0 )
										AND ([TA].instanceId    = sec.instanceId  OR  [TA].instanceId  = 0  OR sec.instanceId = 0 )
										AND ([TA].backupsetId   = sec.backupSetId OR  [TA].backupsetId = 0  OR sec.backupSetId = 0 )
										AND ([TA].subclientId   = sec.subClientId OR  [TA].subclientId = 0  OR sec.subClientId = 0 )
										AND NOT ([TA].clientId = 0 AND [TA].clientGroupId = 0 AND [TA].appTypeId = 0 AND
											[TA].instanceId = 0 AND [TA].backupsetId = 0 AND [TA].subclientId = 0 AND
											[TA].MediaAgentId = 0 AND [TA].policyId = 0 AND [TA].trackingPolicyId = 0)
									)
								)
								WHERE   ( ( [TA].[clientId] = [APP].[clientId] )
										  OR ( [TA].[clientId] = 0 AND [TA].[clientGroupId] IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId=[APP].[clientId]))
										)
										AND ( [TA].[apptypeId] = [APP].[appTypeId]
											  OR [TA].[apptypeId] = 0
											)
										AND ( [TA].[instanceId] = [APP].[instance]
											  OR [TA].[instanceId] = 0
											)
										AND ( [TA].[backupsetId] = [APP].[backupSet]
											  OR [TA].[backupsetId] = 0
											)
										AND ( [TA].[subclientId] = [APP].[id]
											  OR [TA].[subclientId] = 0
											)
						--select 'debug1',* from @tasktble
						--INSERT SCHEDULES FOR CLIENT GROUP CLIENT BELONGS TO
						INSERT  INTO @taskTble
								SELECT DISTINCT
										[TA].taskId
								FROM    TM_AssocEntity AS TA
								INNER JOIN APP_Application AS APP ON APP.clientId = @clientId
								WHERE   clientGroupId IN (
											SELECT  clientGroupId
											FROM    APP_ClientGroupAssoc CG
											WHERE   clientId = @clientId )
												AND ([TA].apptypeId = 0 OR
													[TA].apptypeId = APP.appNumber)
												AND taskId NOT IN ( SELECT  taskId
															FROM    @taskTble )
						--- PRUNE TASK WHICH DONOT HAVE VALID FILTER ASSOCIATIONS OR ARE FOR ONDEMAND BACKUPSET (MR-39351)
						--- THIS IS TRUE ONLY FOR POLICY
							DELETE @taskTble
FROM @taskTble T INNER JOIN [#tmTask] TSK ON T.taskId = TSK.taskId AND TSK.taskType = 4
								INNER JOIN #TM_AssocEntityTmp ASSC ON T.taskId = ASSC.taskId
							WHERE ( @backupsetId <> 0 AND
									EXISTS (SELECT componentNameId
											FROM App_BackupSetProp
											WHERE attrName = 'OnDemand Backupset' AND attrVal=1 AND componentNameId=@backupsetId
											)
									) OR
								( @appTypeId <> 0
								AND ASSC.apptypeId = 0
								AND EXISTS ( SELECT taskId
											 FROM [TM_AssocFilter]
											 WHERE taskId = T.taskId
											)
								AND NOT EXISTS
								   ( SELECT taskId
									 FROM [TM_AssocFilter] FLT
									 WHERE FLT.taskId = T.taskId AND
									  (
										( FLT.filter_type = 2 AND FLT.filter_value = @appTypeId )  -- filter_type, 1 is appgroup and 2 is individual apptype,
											OR
											( FLT.filter_type = 1 AND
													EXISTS ( SELECT FLT.filter_value
																FROM [APP_AppTypeGroupAssoc]
																WHERE appGroupId = FLT.filter_value
																AND appTypeId = @appTypeId
								 							)
											)
										)
								   )
								)
						--select 'debug5',* from @tasktble
						--FILTER BASED ON TYPE (Immediate or policy)
						IF ( @schedules <> 0 )
SET @type = @type | 2
						IF ( @policy <> 0 )
SET @type = @type | 4
						IF ( @type <> 0 )
							DELETE  FROM @taskTble
							WHERE   taskId IN ( SELECT  taskId
												FROM    [#tmTask]
												WHERE   ( taskType & @type = 0 ) )
						IF(@EZPolicyFilter <> 0)
							DELETE @taskTble
							WHERE taskId NOT IN ( SELECT  taskId
												FROM #tmTask
												WHERE #tmTask.isEZOperation <> 0)
						-- FILTER OUT SRM REPORTS FROM CLIENT LEVEL
						IF (@srmReportSet = 0) and (@srmReportType = 0)
							DELETE @taskTble
							WHERE taskId  IN ( SELECT taskId
												FROM [TM_SubTask]
WHERE TM_SubTask.operationType = 4021)
						-- FILTER OUT TASKS SUBTASKS BASED ON OPERATION TYPES
							DELETE @taskTble
							WHERE taskId IN ( SELECT  taskId
										FROM TM_SubTask
WHERE ( subTaskType = 1 AND ( operationType = 4002
OR operationType = 4018
																	  )
												)
												OR
subTaskType = 4 -- Workflow subtasks are filtered out execpt for recovery director MR41651
												AND taskId NOT IN
( SELECT taskId FROM TM_AssocEntity WHERE apptypeId IN (72))
										)
							-- FILTER OUT NON BACKUP TASKS THAT HAVE CLIENTID=0 AND CLIENTGROUPID=0
							DELETE @taskTble
							WHERE taskId IN ( SELECT A.taskId
										FROM TM_AssocEntity AS A
										INNER JOIN TM_SubTask S ON S.taskId = A.taskId
										WHERE (A.clientGroupId=0 AND A.clientId=0 AND A.policyId=0 AND A.copyId=0
										AND S.operationType<>2 AND @agentlessPolicyId=0 AND trackingPolicyId=0)
										)
							DELETE @taskTble
							WHERE taskId IN ( SELECT  taskId
										  FROM TM_SubTask
										  WHERE ( ( @showAllTasks = 0
													  AND ( subTaskType NOT IN (
															SELECT subTaskType FROM @subTaskFilter )
															AND operationType NOT IN (
															SELECT operationType FROM @operationFilter )
														  )
														 )
													)
												)
--						SELECT 'debug2',* from @tasktble
--						select 'debug3',* from #tmTask where taskid in ( select taskid from @tasktble)
							INSERT INTO #Clients_Timezone_StartTime(clientId , timezoneName , jobStartTime , taskID , patternID )
							SELECT DISTINCT AssocEntity.clientId, NULL, -1, AssocEntity.taskId, 0
							FROM #AssocEntity AssocEntity
							WHERE clientID > 0
							-- Call stored procedure to compute timezone and start time for clients.
							EXEC TM_ComputeStarttimeForClient
			--select * from #AssocEntity
			----------------------------
			--CONSTRUCT THE XML---------
			----------------------------
						IF OBJECT_ID('tempdb.dbo.#subTaskOptions') IS NOT NULL DROP TABLE #subTaskOptions
						CREATE TABLE #subTaskOptions(
							subTaskId INT,
							options XML
						)
						INSERT INTO #subTaskOptions
						SELECT subTaskId, xmlValue.query('/TMMsg_JobOption/*') FROM TM_SubTaskXMLOptions WITH (NOLOCK)
						SET @xmlText = ( SELECT	 --TASKLIST
												( SELECT 	--TASK
															[#tmTask].taskId AS '@taskId' ,
															[#tmTask].taskName AS '@taskName' ,
															[#tmTask].taskType AS '@taskType' ,
															[#tmTask].alertId AS '@alertId' ,
															[NTnotificationRule].notificationName AS '@alertName' ,
															[#tmTask].ownerId AS '@ownerId' ,
															[#tmTask].runUserId AS '@runUserId' ,
															[#tmTask].description AS '@description' ,
															USR.login AS '@ownerName' ,
															[#tmTask].policyType AS '@policyType' ,
															--dbo.GetEntityCount([#tmTask].taskId) AS '@associatedObjects' ,
															[#tmTask].GUID ,
															( SELECT -- alert
																	  [#tmTask].alertId AS '@alertId' ,
																	  NT.notificationName AS '@alertName'
															  FROM    dbo.NTnotificationRule
																	  AS NT
															  WHERE   NT.id = [#tmTask].alertId
															FOR
															  XML PATH('alert') ,
																  TYPE
															) ,
															( SELECT-- origCC
																	  [#tmTask].origCCId AS '@commCellId'
															FOR
															  XML PATH('originalCC') ,
																  TYPE
															) ,
															( SELECT  --TaskFlags
																	  [#tmTask].disabled AS '@disabled' ,
																	  [#tmTask].uninstalled AS '@uninstalled' ,
																	  [#tmTask].isEZOperation AS '@isEZOperation'
															FOR
															  XML PATH('taskFlags') ,
																  TYPE
															)
												FOR
												  XML PATH('task') ,
													  TYPE
												) ,
												( SELECT  --APPGROUP
															( SELECT  --GROUP SELECTED
                                                              		  TFIL.filter_value AS '@appGroupId'
															  FROM    TM_AssocFilter
																	  AS TFIL
															  WHERE   TFIL.filter_type = 1
																	  AND TFIL.taskId = [#tmTask].taskId
															FOR
                                                      			XML PATH('appGroups') ,
																  TYPE
															) ,
															( SELECT  --TYPES SELECTED
                                                              		  TFIL.filter_value AS '@appTypeId'
															  FROM    TM_AssocFilter
																	  AS TFIL
															  WHERE   TFIL.filter_type = 2
																	  AND TFIL.taskId = [#tmTask].taskId
															FOR
                                                    		  XML PATH('appTypes') ,
																  TYPE
															)
												FOR
												  XML PATH('appGroup') ,
													  TYPE
												) ,
												( SELECT --NEXT SCHEDULES
															datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(dbo.ClientLocalToUTCTime(RAS.nextRunTime,2), ASSOC.clientId)) '@nextScheduleTime',
															--ABS(datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(GETDATE(), 2)) - datediff(second, '01/01/1970', dbo.UTCToClientLocalTime(RAS.nextRunTime, 2))) '@relativeTime',
															ABS(datediff(second, '01/01/1970', RAS.nextRunTime) - datediff(second, '01/01/1970', GETDATE())) '@relativeTime',
															(SELECT ASSOC.clientId '@clientId'
																FOR
																XML PATH('client') ,
																  TYPE
															) ,
															(SELECT STASK.subTaskId '@subTaskId',
																STASK.taskId '@taskId'
																FOR
																XML PATH('subtask') ,
																  TYPE
															) ,
															(SELECT TimeZoneId '@TimeZoneID' FROM SchedTimeZone
																WHERE TimeZoneStdName = dbo.GetClientTimeZone(ASSOC.clientId)
																FOR
																XML PATH('timeZone') ,
																  TYPE
															)
												  FROM		(SELECT DISTINCT * FROM #AssocEntity) AS ASSOC
															INNER JOIN TM_SubTask AS STASK ON STASK.taskId = ASSOC.taskId
															INNER JOIN TM_PatternAssoc
																	AS PAS ON PAS.subTaskId = STASK.subTaskId
															INNER JOIN TM_Pattern
																	AS PAT ON PAT.patternId = PAS.patternId
															INNER JOIN TM_RunTime
																	AS NRT ON NRT.patternId = PAS.patternId
															INNER JOIN TM_RunTimeAssoc
																	AS RAS ON RAS.runTimeId = NRT.runTimeId
AND (PAT.tzId <> 1001 OR (PAT.tzId = 1001 AND RAS.timeZoneNames = dbo.GetClientTimeZone(ASSOC.clientId)))
																	AND RAS.processed = 0
															INNER JOIN #Clients_Timezone_StartTime Clients_Timezone_StartTime ON
																Clients_Timezone_StartTime.clientID = ASSOC.clientId
																AND Clients_Timezone_StartTime.jobStartTime = RAS.jobStartTime
																AND Clients_Timezone_StartTime.taskId = STASK.taskId
																-- Pick the runtime association where jobStartTime matches.
												  WHERE		STASK.subTaskId = PAS.subTaskId
															AND STASK.taskId = [#tmTask].taskId
AND PAT.tzId = 1001
													AND   ( ( [clientId] = @clientId )
															  OR ( @clientId = 0 AND @clientGroupId = 0 )
															  OR ( [clientId] = 0 AND [clientGroupId] = @clientGroupId )
															  OR ( [clientId] = 0 AND [clientGroupId] IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId=@clientId))
															)
															AND ( [apptypeId] = @appTypeId
																  OR @appTypeId = 0
																  OR [apptypeId] = 0
																)
															AND ( [instanceId] = @instanceId
																  OR @instanceId = 0
																  OR [instanceId] = 0
																)
															AND ( [backupsetId] = @backupsetId
																  OR @backupsetId = 0
																  OR [backupsetId] = 0
																)
															AND ( [subclientId] = @subclientId
																  OR @subclientId = 0
																  OR [subclientId] = 0
																)
															AND ( [srmReportType] = @srmReportType
																  OR ( [srmReportType] = 0 AND @srmReportType = 0 )
																)
															AND ( [srmReportSet] = @srmReportSet
																  OR ( [srmReportSet] = 0 AND @srmReportSet = 0 )
																)
															AND ( [policyId] = @policyId
																  OR ( [policyId] = 0 AND @policyId = 0 )
																)
															AND ( [copyId] = @copyId
																  OR ( [copyId] = 0 AND [policyId] <> 0)
																  OR @copyId = 0
																)
															AND ( [trackingPolicyId] = @trackingPolicyId
																  OR ( [trackingPolicyId] = 0 AND @trackingPolicyId = 0 )
																)
															--AND ( [mediaAgentId] = @mediaAgentId
															--	  OR ( [mediaAgentId] = 0 AND @mediaAgentId = 0 )
															--	)
															AND ( [agentlessPolicyId] = @agentlessPolicyId
																  OR ( [agentlessPolicyId] = 0 AND @agentlessPolicyId = 0)
																)
												FOR
												  XML PATH('nextScheduleTimes') ,
													  TYPE
												) ,
												( SELECT --ASSOC
															ASSOC.assocType '@_type_' ,
															ASSOC.clientGroupId '@clientGroupId' ,
															ASSOC.clientGroupName '@clientGroupName' ,
															ASSOC.clientId '@clientId' ,
															ASSOC.clientName '@clientName' ,
															ASSOC.apptypeId '@applicationId' ,
															ASSOC.appTypeName '@appName' ,
															ASSOC.policyId '@storagePolicyId' ,
															ASSOC.policyName '@storagePolicyName' ,
															ASSOC.mediaAgentId '@mediaAgentId',
															ASSOC.mediaAgentName '@mediaAgentName',
															ASSOC.instanceId '@instanceId' ,
															REPLACE(ASSOC.instanceName,
																	'', ' ') '@instanceName' ,
															ASSOC.backupsetId '@backupsetId' ,
															ASSOC.copyId '@copyId' ,
															ASSOC.copyName '@copyName' ,
															ASSOC.srmReportSet '@srmReportSet',
															ASSOC.srmReportType '@srmTemplateId',
															ASSOC.srmReportName '@srmTemplateName',
															ASSOC.backupsetName '@backupsetName' ,
															ASSOC.subclientId '@subclientId' ,
															ASSOC.subclientName '@subclientName',
															ASSOC.agentlessPolicyId '@agentlessPolicyId',
															ASSOC.planId '@planId',
															ASSOC.planName '@planName',
															( SELECT ASSOC.exclude '@exclude' FOR XML PATH('flags') ,TYPE )
												  FROM      (SELECT DISTINCT * FROM #AssocEntity) AS ASSOC
/* Jun Lu: Fix duplicate results
												  INNER JOIN APP_Application AS APP ON APP.dataArchGrpId = @policyId OR @policyId = 0
												  INNER JOIN APP_ClientGroupAssoc AS CA ON CA.clientId = APP.clientId OR CA.clientGroupId = ASSOC.clientGroupId
*/
												  WHERE     ASSOC.taskId = [#tmTask].taskId
													AND  ((( ( ASSOC.[clientId] = @clientId )
															  OR ( @clientId = 0 AND @clientGroupId = 0 )
															  OR ( ASSOC.[clientId] = 0 AND ASSOC.[clientGroupId] = @clientGroupId )
															  OR ( ASSOC.[clientId] = 0 AND ASSOC.[clientGroupId] IN (SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId=@clientId))
															)
															AND ( ASSOC.[apptypeId] = @appTypeId
																  OR @appTypeId = 0
																  OR ASSOC.[apptypeId] = 0
																)
															AND ( ASSOC.[instanceId] = @instanceId
																  OR @instanceId = 0
																  OR ASSOC.[instanceId] = 0
																)
															AND ( ASSOC.[backupsetId] = @backupsetId
																  OR @backupsetId = 0
																  OR ASSOC.[backupsetId] = 0
																)
															AND ( ASSOC.[subclientId] = @subclientId
																  OR @subclientId = 0
																  OR ASSOC.[subclientId] = 0
																)
															AND ( ASSOC.[srmReportType] = @srmReportType
																  OR ( ASSOC.[srmReportType] = 0 AND @srmReportType = 0 )
																)
															AND ( ASSOC.[srmReportSet] = @srmReportSet
																  OR ( ASSOC.[srmReportSet] = 0 AND @srmReportSet = 0 )
																)
															AND ( ASSOC.[policyId] = @policyId
																  OR ( ASSOC.[policyId] = 0 AND @policyId = 0 )
																)
															AND ( ASSOC.[copyId] = @copyId
																  OR ( ASSOC.[copyId] = 0 AND @copyId = 0 )
																)
															AND ( ASSOC.[trackingPolicyId] = @trackingPolicyId
																  OR ( ASSOC.[trackingPolicyId] = 0 AND @trackingPolicyId = 0 )
																)
															AND ( [agentlessPolicyId] = @agentlessPolicyId
																  OR ( [agentlessPolicyId] = 0 AND @agentlessPolicyId = 0)
																)
															)
/*															OR
															(
																(( ASSOC.[clientId] = [APP].[clientId] )
																  OR ( ASSOC.[clientId] = 0 AND [CA].[clientId] = ASSOC.[clientId])
																)
																AND ( ASSOC.[apptypeId] = [APP].[appTypeId]
																	  OR ASSOC.[apptypeId] = 0
																	)
																AND ( ASSOC.[instanceId] = [APP].[instance]
																	  OR ASSOC.[instanceId] = 0
																	)
																AND ( ASSOC.[backupsetId] = [APP].[backupSet]
																	  OR ASSOC.[backupsetId] = 0
																	)
																AND ( ASSOC.[subclientId] = [APP].[id]
																	  OR ASSOC.[subclientId] = 0
																	)
															)
Jun Lu: Fix duplicate results */
														)
												FOR
												  XML PATH('associations') ,
													  TYPE
												) ,
												( SELECT		--SUBTASKINFO
								--TASK RUN TIME FROM TM_RunTime Table
															NRT.nextTime AS '@nextScheduleTime' ,
															ABS(datediff(second, '01/01/1970', GETUTCDATE()) - datediff(second, '01/01/1970', NRT.nextRunTime)) '@relativeTime',
															( SELECT	DISTINCT --SUBTASK
																	  STASK.subTaskId AS '@subTaskId' ,
																	  STASK.subTaskType AS '@subTaskType' ,
																	  STASK.operationType AS '@operationType' ,
																	  STASK.flags AS '@flags' ,
																	  STASK.subTaskOrder AS '@subTaskOrder' ,
																	  STASK.subTaskName AS '@subTaskName'
															FOR
															  XML PATH('subTask') ,
																  TYPE
															) ,
															( SELECT --PATTERN
																	  PAT.patternId '@patternId' ,
																	  PAT.name '@name' ,
																	  PAT.flags '@flags' ,
																	  PAT.freq_type '@freq_type' ,
																	  PAT.freq_interval '@freq_interval' ,
																	  PAT.freq_relative_interval '@freq_relative_interval' ,
																	  PAT.freq_recurrence_factor '@freq_recurrence_factor' ,
																	  PAT.freq_subday_interval '@freq_subday_interval' ,
																	  PAT.skipOccurence '@skipOccurence' ,
																	  PAT.skipDayNumber '@skipDayNumber' ,
																	  PAT.local_start_date '@active_start_date' ,
																	  PAT.active_start_time '@active_start_time' ,
																	  PAT.local_end_date '@active_end_date' ,
																	  PAT.active_end_time '@active_end_time' ,
																	  PAT.active_end_occurence '@active_end_occurence' ,
																	  PAT.description '@description' ,
																	  PAT.freq_restart_interval '@freq_restart_interval',
																	  ( SELECT  --TimeZone
																	  PAT.tzId AS '@TimeZoneID'
																	  FOR
																	  XML
																	  PATH('timeZone') ,
																	  TYPE
																	  ) ,
																	  ( SELECT  --Calendar
																	  PAT.calendarId AS '@calendarId'
																	  FOR
																	  XML
																	  PATH('calendar') ,
																	  TYPE
																	  )
															  FROM    TM_Pattern AS PAT ,
																	  TM_PatternAssoc PASOC
															  WHERE   [PASOC].[patternId] = PAT.[patternId]
																	  AND PASOC.subTaskId = STASK.subTaskId
															FOR
															  XML PATH('pattern') ,
																  TYPE
															) ,
															SUB.options
												  FROM      TM_subTask AS STASK
															LEFT OUTER JOIN TM_PatternAssoc
																AS PAS ON PAS.subTaskId = STASK.subTaskId
															LEFT OUTER JOIN TM_Pattern
																AS PAT ON PAT.patternId = PAS.patternId
															LEFT OUTER JOIN TM_RunTime
																AS NRT ON NRT.patternId = PAS.patternId
																	  AND NRT.processed = 0
															LEFT OUTER JOIN #subTaskOptions
															    AS SUB ON SUB.subtaskId = STASK.subTaskId
												  WHERE     STASK.subTaskId = PAS.subTaskId
															AND STASK.taskId = [#tmTask].taskId
															AND (( NRT.nextRunTime >= GETUTCDATE() )
																	AND ( ( NRT.flags & 1 ) = 0
) OR PAT.freq_type = 512
															)
															-- Commented out as of now gui doesnt
															-- send this operationType
															-- In future we would need to handle
															-- this case, bmehta
															--AND ( @showAllTasks <> 0
															--	  OR ( @showAllTasks = 0
															--	  AND ( STASK.subTaskType IN (
															--		  SELECT
															--		  subTaskType
															--		  FROM
															--		  @subTaskFilter )
															--		  AND STASK.operationType NOT IN (
															--		  SELECT
															--		  operationType
															--		  FROM
															--		  @operationFilter )
															--		  )
															--		 )
															--	)
												FOR
												  XML PATH('subTasks') ,
													  TYPE
												)
										 FROM   dbo.#tmTask
												LEFT OUTER JOIN dbo.UMUsers AS USR ON dbo.#tmTask.ownerId = USR.id
												LEFT OUTER JOIN dbo.NTnotificationRule ON dbo.NTnotificationRule.id = dbo.#tmTask.alertId
										 WHERE  dbo.#tmTask.taskId IN ( SELECT
																	  taskId
																	  FROM
																	  @taskTble )
												AND ( [#tmTask].[deleted] = 0
													  AND [#tmTask].[invalid] = 0
													  AND [#tmTask].[uninstalled] = 0
													  AND [#tmTask].[savedReport] = 0
													) --AND [TM_RunTime].[processed] = 0)
AND ( [#tmTask].[taskType] IN ( 2, 4 ) )
									   FOR
										 XML PATH('taskDetail') ,
											 ROOT('TMMsg_GetTaskListResp')
									   )
									   IF OBJECT_ID('tempdb.dbo.#subTaskOptions') IS NOT NULL DROP TABLE #subTaskOptions
							END
					END
            END
        IF @xmlText IS null
            BEGIN
                SET @xmlText = '<TMMsg_GetTaskListResp/>'
            END
DROP table #tmTask
		IF object_id('tempdb.dbo.#Clients_Timezone_StartTime') is NOT NULL
			DROP TABLE #Clients_Timezone_StartTime
		IF object_id('tempdb.dbo.#TM_AssocEntityTmp') is NOT NULL
			DROP TABLE #TM_AssocEntityTmp
		IF OBJECT_ID('tempdb.dbo.#AssocEntity') IS NOT null
			DROP TABLE #AssocEntity
SET NOCOUNT OFF
    SELECT  @xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetTaskList')
	delete from GxQscripts where name = 'RptGetTaskList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetTaskList')
	delete from GXDBVersions where aliasname = 'RptGetTaskList'
GO

insert into GXDBVersions values(2, 'RptGetTaskList',  'v1.27.2.14.4.1', 'RptGetTaskList', 'v1.27.2.14.4.1')
GO

