

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetSubclientList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetSubclientList.sp,v $ $Id: rptGetSubclientList.sp,v 1.41.54.5 2018/11/18 03:51:25 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Cursor: "rptGetSubclientList"			|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetSubclientList')
BEGIN
	print '>>> Drop Stored Procedure: rptGetSubclientList <<<'
	drop procedure rptGetSubclientList
END
IF EXISTS (select * from GxQscripts where name='rptGetSubclientList')
	delete from GxQscripts where name = 'rptGetSubclientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetSubclientList')
	delete from GXDBVersions where aliasname = 'rptGetSubclientList'
GO
print '... Creating Procedure: rptGetSubclientList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetSubclientList
  @i_commCellId INTEGER,
  @i_clientId INTEGER,
  @i_appTypeId INTEGER
AS
  DECLARE @o_clientId integer;
  DECLARE @o_clientName nchar(255);
  DECLARE @o_appType integer;
  DECLARE @o_appTypeName char(255);
  DECLARE @o_instance integer;
  DECLARE @o_instanceName nchar(255);
  DECLARE @o_backupSet integer;
  DECLARE @o_backupSetName nchar(255);
  DECLARE @o_subClient integer;
  DECLARE @o_subClientName nchar(255);
  DECLARE @o_dataStoragePolicy integer;
  DECLARE @o_dataStoragePolicyName NVARCHAR(255);
  DECLARE @o_incrSP integer;
  DECLARE @o_incrSPName NVARCHAR(255);
  DECLARE @o_clEnabled integer;
  DECLARE @o_iDAEnabled integer;
  DECLARE @o_dataSize bigint;
  DECLARE @o_lastUpdate integer;
  DECLARE @o_jobCCId integer;
  DECLARE @o_jobId integer;
  DECLARE @o_compressionType integer;
  DECLARE @o_useGlobalFilter char(255);
  DECLARE @o_dataPathNum integer;
  DECLARE @o_dataPathId integer;
  DECLARE @o_dataPathFlag integer;
  DECLARE @o_drivePoolName NVARCHAR(255);
  DECLARE @o_mediaAgentName nvarchar(255);
  DECLARE @o_libraryAliasName NVARCHAR(255);
  DECLARE @o_clientInterface char(255);
  DECLARE @o_mediaAgentInterface char(255);
  DECLARE @o_isLogAG integer;
  DECLARE @o_useQSnap integer;
  DECLARE @o_useVSS integer;
  DECLARE @o_DataReaderNum integer;
  DECLARE @o_multiDataReader integer;
  DECLARE @o_encryption integer;
  DECLARE @o_isHWCompressed integer;
  DECLARE @o_isDeduplicate integer;
  DECLARE @o_isSystemState integer;
  DECLARE @o_description nchar(4000);
  DECLARE @o_mediaAgentDisplayName nvarchar(255);
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #TEMP_SUBCLIENT (
		subclientId		integer,
		clientId		integer,
		appTypeId		integer,
		instance		integer,
		backupSet		integer,
		subClientName	nvarchar(128),
		dataArchGrpID	integer,
		logArchGrpID	integer,
		lastUpdated		integer,
		jobCCId			integer,
		jobId			integer,
		compressionType	integer)
INSERT	INTO #TEMP_SUBCLIENT
SELECT	id, clientId, appTypeId, instance, backupSet, subClientName, dataArchGrpID, logArchGrpID,
		(case when refTime>0 then refTime else 0 end), 0, 0, 2
FROM	APP_Application
WHERE	clientId = @i_clientId AND appTypeId = @i_appTypeId
	AND subclientStatus&(2|4) = 0 AND (subclientStatus&(16|32) = 0 OR subclientStatus&64 > 0)
DELETE	T FROM #TEMP_SUBCLIENT T
		INNER JOIN APP_InstanceName INS ON T.instance = INS.id AND INS.status&(16|32) > 0
--update last modified time of subclient properties
UPDATE	T SET lastUpdated = S.lastUpdated
FROM	#TEMP_SUBCLIENT T
		INNER JOIN
		(SELECT componentNameId, MAX(CAST(attrval AS INT)) AS lastUpdated
		FROM	APP_SubClientProp
		WHERE	attrName LIKE 'last % change' AND modified = 0
		GROUP BY componentNameId
		) S ON T.subclientId = S.componentNameId
CREATE TABLE #lastSuccessfulFullJob (appId int, commcellId int, jobId int)
INSERT	INTO #lastSuccessfulFullJob
SELECT	B.appId, B.commcellId, max(B.jobId)
FROM	JMBkpStats B INNER JOIN #TEMP_SUBCLIENT T ON T.subclientId = B.appId
WHERE	B.bkplevel IN (1, 4096) AND B.status = 1
GROUP BY B.appId, B.commcellId
UPDATE	T SET jobCCId = B.commcellId, jobId = B.jobId
FROM	#TEMP_SUBCLIENT T
		INNER JOIN #lastSuccessfulFullJob B ON T.subclientId = B.appId
DROP TABLE #lastSuccessfulFullJob
INSERT	INTO #TEMP_SUBCLIENT (subclientId,clientId,appTypeId,instance,backupSet,subClientName,dataArchGrpID,logArchGrpID,lastUpdated,jobCCId,jobId,compressionType)
SELECT	subclientId,clientId,appTypeId,instance,backupSet,subClientName,logArchGrpID,0,lastUpdated,jobCCId,jobId,compressionType
FROM	#TEMP_SUBCLIENT
WHERE	dataArchGrpId <> logArchGrpId
--get compression type
UPDATE	T SET compressionType = P.CompressWhere
FROM	#TEMP_SUBCLIENT T
		INNER JOIN archPipeConfig P ON T.subclientId = P.appNumber
WHERE	T.dataArchGrpID > 1 AND T.logArchGrpID > 1
--get data path
CREATE TABLE #TEMP_DATAPATH (
		ClientId		integer,
		ArchGrpId		integer,
		DataPathId		integer,
		DataPathFlag	integer,
		HWCompression	integer,
		DrivePoolId		integer,
		DrivePoolName	nvarchar(256),
		DrivePoolType	integer,
		MasterPoolId	integer,
		MediaAgentId	integer,
		NDMPHostId		integer,
		MediaAgentName	nvarchar(256),
		LibraryId		integer,
		LibAliasName	nvarchar(256),
		LibraryType		integer,
		ClientInterface	varchar(256),
		MAInterface		varchar(256),
		NumDataPaths	integer,
        MediaAgentDisplayName  nvarchar(256)
        )
--get client & archGroup pair
CREATE TABLE #clientArchGroup (ClientId INT, ArchGrpId INT, NumDataPaths INT)
INSERT	INTO #clientArchGroup
SELECT	DISTINCT clientId, dataArchGrpId, 0
FROM	#TEMP_SUBCLIENT
WHERE	dataArchGrpId > 1
INSERT	INTO #TEMP_DATAPATH (ClientId, ArchGrpId, DataPathId, DataPathFlag, HWCompression, DrivePoolId, DrivePoolName, DrivePoolType, MasterPoolId, MediaAgentId, NDMPHostId)
SELECT	G.ClientId, G.ArchGrpId, PT.DataPathId, PT.flag, PT.IsHardwareCompressed, PL.DrivePoolId, PL.DrivePoolName, PL.DrivePoolType, PL.MasterPoolId, PL.ClientId, PL.NDMPHostId
FROM	MMDataPath PT
		INNER JOIN MMDrivePool PL ON PT.DrivePoolId = PL.DrivePoolId
		INNER JOIN archGroupCopy C ON PT.copyId = C.id
		INNER JOIN #clientArchGroup G ON C.archGroupId = G.archGrpId
WHERE	C.flags&(8|16|512) != 0 AND PT.flag&4 != 0
	 OR C.flags&(8|16|512) = 0 AND (PT.flag&1 != 0 OR PL.ClientId = G.ClientId)
UPDATE	T SET NumDataPaths = S.NumDataPaths
FROM	#clientArchGroup T
		INNER JOIN (
		SELECT	ClientId, ArchGrpId, COUNT(DataPathId) AS NumDataPaths
		FROM	#TEMP_DATAPATH
		WHERE	DrivePoolId > 0
		GROUP BY ClientId, ArchGrpId
		) S ON T.ClientId = S.ClientId AND T.ArchGrpId = S.ArchGrpId
UPDATE	T SET NumDataPaths = G.NumDataPaths
FROM	#TEMP_DATAPATH T
		INNER JOIN #clientArchGroup G ON T.ClientId = G.ClientId AND T.ArchGrpId = G.ArchGrpId
DROP TABLE #clientArchGroup
UPDATE	T SET LibraryId = L.LibraryId, LibAliasName = L.AliasName, LibraryType = L.LibraryTypeId
FROM	#TEMP_DATAPATH T
		INNER JOIN MMMasterPool M ON T.MasterPoolId = M.MasterPoolId
		INNER JOIN MMLibrary L ON M.LibraryId =L.LibraryId
UPDATE	#TEMP_DATAPATH SET HWCompression = 0
WHERE	LibraryType IN (2, 3, 5)
UPDATE	T SET ClientInterface = CP.attrVal
FROM	#TEMP_DATAPATH T
		INNER JOIN APP_ClientProp CP ON T.ClientId = CP.ComponentNameId AND CP.attrName = 'DataPipeInterface' AND CP.modified = 0
UPDATE	T SET MediaAgentId = N.ClientId
FROM	#TEMP_DATAPATH T
		INNER JOIN MMNDMPHostInfo N ON T.NDMPHostId = N.NDMPHostId
WHERE	T.NDMPHostId > 0
UPDATE  T SET MediaAgentName = CL.Net_HostName,MediaAgentDisplayName = CL.displayName
FROM	#TEMP_DATAPATH T
		INNER JOIN APP_Client CL ON T.MediaAgentId = CL.id
UPDATE	T SET MAInterface = CP.attrVal
FROM	#TEMP_DATAPATH T
		INNER JOIN APP_ClientProp CP ON T.MediaAgentId = CP.ComponentNameId AND CP.attrName = 'DataPipeInterface' AND CP.modified = 0
SELECT B.clientId,clientName=(select displayName from APP_Client where id=B.clientId),
	B.appTypeId,appTypeName=(select name from APP_iDAType where type=B.appTypeId),
	B.instance,instanceName=(select name from APP_InstanceName where id=B.instance),
	B.backupSet,backupSetName=(select name from APP_BackupSetName where id=B.backupSet),
	B.subclientId,B.subClientName,
	B.dataArchGrpID,dataArchGrpName=(select name from archGroup where id=B.dataArchGrpID),
	A.incrSP,incrName=(select name from archGroup tt where tt.id=A.incrSP),
	clEnable=(select J.action from JMJobAction J where J.clientId=B.clientId and J.appType=0 and J.mediaAgentId=1 and J.opType=4),
	iDAEnable=(select J.action from JMJobAction J where J.clientId=B.clientId and J.appType=B.appTypeId and J.mediaAgentId=1 and J.opType=4),
	dataSize=isnull((select sum(M.uncompbytes) from JMBkpAtmptStats M where M.jobId=B.jobId and M.commcellId=B.jobCCId),0),
	lastUpdated,jobCCId,jobId,compressionType,
	--ISNULL((SELECT CAST(attrVal AS int) FROM APP_SubClientProp WHERE attrName=N'use global filters' AND componentNameId=B.subclientId AND modified=0),0),
	CASE WHEN (SELECT CAST(attrVal AS int) FROM APP_SubClientProp WHERE attrName=N'use global filters' AND componentNameId=B.subclientId AND modified=0)>0
			THEN (SELECT CAST(attrVal AS int) FROM APP_SubClientProp WHERE attrName=N'use global filters' AND componentNameId=B.subclientId AND modified=0)
		 WHEN (SELECT CAST(attrVal AS int) FROM APP_SubClientProp WHERE attrName=N'use cs setting for global filters' AND componentNameId=B.subclientId AND modified=0 AND 1=(case when exists (select value from GXGlobalParam where name =N'Use Global Filters for all Subclients' and value like '%1%' AND modified =0 )THEN 1 ELSE 0 END))>-1
			 THEN (SELECT CAST(attrVal AS int) FROM APP_SubClientProp WHERE attrName=N'use cs setting for global filters' AND componentNameId=B.subclientId AND modified=0 AND 1=(case when exists (select value from GXGlobalParam where name =N'Use Global Filters for all Subclients' and value like '%1%'  AND modified =0 )THEN 1 ELSE 0 END))
		 WHEN (SELECT CAST(attrVal AS int) FROM APP_SubClientProp WHERE attrName=N'use global filters' AND modified=0 AND componentNameId=(	SELECT CAST(attrVal AS int) FROM APP_SubClientProp WHERE attrName=N'Associated subclient Policy' AND modified=0	AND componentNameId=B.subclientId ))>-1
			  THEN (SELECT CAST(attrVal AS int) FROM APP_SubClientProp WHERE attrName=N'use global filters' AND modified=0 AND componentNameId=(	SELECT CAST(attrVal AS int) FROM APP_SubClientProp WHERE attrName=N'Associated subclient Policy' AND modified=0	AND componentNameId=B.subclientId ))
		 WHEN (SELECT CAST(attrVal AS int) FROM APP_SubClientProp WHERE attrName=N'use cs setting for global filters' AND modified=0 AND componentNameId=(SELECT CAST(attrVal AS int) FROM APP_SubClientProp WHERE attrName=N'Associated subclient Policy' AND modified=0	AND componentNameId=B.subclientId )AND 1=(case when exists (select value from GXGlobalParam where name =N'Use Global Filters for all Subclients' and value like '%1%' AND modified =0)THEN 1 ELSE 0 END))>-1
			 THEN  (SELECT CAST(attrVal AS int) FROM APP_SubClientProp WHERE attrName=N'use cs setting for global filters' AND modified=0 AND componentNameId=(SELECT CAST(attrVal AS int) FROM APP_SubClientProp WHERE attrName=N'Associated subclient Policy' AND modified=0	AND componentNameId=B.subclientId )AND 1=(case when exists (select value from GXGlobalParam where name =N'Use Global Filters for all Subclients' and value like '%1%' AND modified =0)THEN 1 ELSE 0 END))
		 WHEN  exists (select value from GXGlobalParam where name =N'Use Global Filters for all Subclients' and value like '%1%'  AND modified =0 )then 1
		else 0
	END,
	NumDataPaths,dataPathId,DataPathFlag,drivePoolName,mediaAgentName,libAliasName,clientInterface,MAInterface,
	isLogAG=(case when logArchGrpID>0 then 0 else 1 end),
	ISNULL((select TOP 1 CAST(attrVal AS int) from APP_SubClientProp where componentNameId=B.subclientId and attrName=N'Use QSNAP' and modified=0),0),
CASE WHEN (SELECT releaseId FROM App_Client WHERE id = B.clientId) < 15
			THEN ISNULL((select TOP 1 CAST(attrVal AS int) from APP_SubClientProp where componentNameId=B.subclientId and attrName=N'Use Shadow Copy' and modified=0),0)
		 ELSE
			CASE WHEN (((select TOP 1 CAST(attrVal AS int) from App_SubClientProp where componentNameId=B.subclientId and attrName=N'Use VSS Enabled' and modified=0) = 1)
					  AND (((select TOP 1 CAST (attrVal AS int) from App_SubClientProp where componentNameId=B.subclientId and attrName=N'Use VSS Options' and modified=0) = 1)
							OR NOT EXISTS (select TOP 1 CAST (attrVal AS int) from App_SubclientProp where componentNameId=B.subclientId and attrName=N'Use VSS Options')))
					THEN 1
				ELSE
					0
			END
		END,
	ISNULL((select TOP 1 CAST(attrVal AS int) from APP_SubClientProp where componentNameId=B.subclientId and attrName=N'sys:nStreams' and modified=0),0),
	ISNULL((select TOP 1 CAST(attrVal AS int) from APP_SubClientProp where componentNameId=B.subclientId and attrName=N'sys:UseMultipleStreamsWithinDrive' and modified=0),0),
	ISNULL((select TOP 1 CAST(attrVal AS int) from APP_SubClientProp where componentNameId=B.subclientId and attrName=N'Encrypt: encryption' and modified=0 and
			exists (select * from APP_ClientProp where attrName ='Encrypt: encryption' and attrVal ='1' and modified =0 and componentNameId = (select clientId from APP_Application where id = B.subclientId))),0),
	ISNULL((select TOP 1 MDP.isHardwareCompressed from MMDataPath MDP where MDP.datapathId=T.datapathId),0),
	ISNULL((select TOP 1 CAST(attrVal AS int) from APP_SubClientProp where componentNameId=B.subclientId and attrName = N'Single Instancing Option' and modified = 0),0),
	ISNULL((select TOP 1 CAST(attrVal AS int) from APP_SubClientProp where componentNameId=B.subclientId and attrName=N'System State' and modified=0),0),
	ISNULL((select TOP 1 attrVal from APP_SubClientProp where componentNameId=B.subclientId and attrName=N'User Description' and modified=0),N''),
    MediaAgentDisplayName
FROM	#TEMP_SUBCLIENT B
		LEFT OUTER JOIN #TEMP_DATAPATH T ON B.clientId=T.clientId AND B.dataArchGrpId=T.archGrpId
		LEFT OUTER JOIN ArchGroup A ON B.dataArchGrpID=A.id
ORDER BY clientName, appTypeName, instanceName, backupSetName, subClientName, isLogAG
DROP TABLE #TEMP_SUBCLIENT
DROP TABLE #TEMP_DATAPATH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetSubclientList')
	delete from GxQscripts where name = 'RptGetSubclientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetSubclientList')
	delete from GXDBVersions where aliasname = 'RptGetSubclientList'
GO

insert into GXDBVersions values(2, 'RptGetSubclientList',  '00010041005400050000', 'RptGetSubclientList', '00010041005400050000')
GO

