

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetSubClientContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetSubClientContent.sp,v $ $Id: rptGetSubClientContent.sp,v 1.42.2.7 2018/11/18 03:49:22 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		Cursor: "rptGetSubClientContent"			|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetSubClientContent')
BEGIN
	print '>>> Drop Stored Procedure: rptGetSubClientContent <<<'
	drop procedure rptGetSubClientContent
END
IF EXISTS (select * from GxQscripts where name='rptGetSubClientContent')
	delete from GxQscripts where name = 'rptGetSubClientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetSubClientContent')
	delete from GXDBVersions where aliasname = 'rptGetSubClientContent'
GO
print '... Creating Procedure: rptGetSubClientContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure rptGetSubClientContent
  @i_appTypeId INTEGER,
  @i_subClientId INTEGER,
  @i_refTime INTEGER
AS
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_content nvarchar(MAX)
  DECLARE @o_ContentType integer
  DECLARE @o_returnOrder integer
  DECLARE @o_volId integer
  DECLARE @o_delimPos integer
  DECLARE @o_capacity bigint
  DECLARE @o_mountPoint char(128)		
  DECLARE @o_appTypeName nchar(1024)
  DECLARE @o_field1 nchar(1024)
  DECLARE @o_field2 nchar(1024)
  DECLARE @o_field3 nchar(1024)
  DECLARE @o_field4 nchar(1024)
  DECLARE @o_field5 nchar(1024)
  DECLARE @o_attrType integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
 SET NOCOUNT ON
	DECLARE	@QRdelim	char
	DECLARE	@EXdelim	char
	SET	@QRdelim	= 0x15
IF @i_appTypeId IN (69)
		SET	@Exdelim	= 0x7c
	ELSE
		SET	@Exdelim	= 0x12
	DECLARE	@VMdelim	char
	SET	@VMdelim	= 0x20
	IF object_id('tempdb.dbo.#tempContentList') IS NOT null DROP TABLE #tempContentList
	CREATE TABLE #tempContentList(
		content		nvarchar(MAX),
		type		INT,
		returnOrder	INT,
		volId		INT		default(0),
		delimPos	INT		default(0),
		capacity	BIGINT		default(0),
		mountPoint	varchar(1024)	default(''),
		appTypeName	nvarchar(1024)	default(''),
		field1		nvarchar(1024)	default(''),
		field2		nvarchar(1024)	default(''),
		field3		nvarchar(1024)	default(''),
		field4		nvarchar(1024)	default(''),
		field5		nvarchar(1024)	default(''),
		attrType        INT             default(0)
	)
IF @i_appTypeId IN (4, 16, 70, 81)
	BEGIN
		INSERT INTO #tempContentList(content,type,returnOrder,attrType)
		SELECT	attrName, 1, 1,attrType
		FROM	APP_subclientProp WITH(NOLOCK)
		WHERE	componentNameId = @i_subClientId AND attrType in (118,119) AND
			(@i_refTime = 0 AND modified = 0 OR
			(@i_refTime > 0 AND created <= @i_refTime AND (modified = 0 OR modified > @i_refTime)))
	END
	ELSE
	BEGIN
IF @i_appTypeId not in (53,54,59,60,78,90,104, 106, 128)
			AND NOT EXISTS (select * from APP_Application WITH(NOLOCK) where id=@i_subClientId and (subclientStatus&0x10000)=0x10000) --CV_STATUS_REFCOPY_SUB
			BEGIN
					INSERT INTO #tempContentList(content,type,returnOrder)
					SELECT DISTINCT content COLLATE Latin1_General_BIN, --Making content case sensitive
								 type,
								 returnOrder
					FROM (
						SELECT	case @i_appTypeId
when 89 then replace(substring(filename,5,len(filename)),0x13,'/')
								else replace(filename,0x13,'/') end as content
								, type,
							returnOrder=(CASE type
								when 1	then 1
								when 2	then 3
								when 4	then 3
								ELSE 2	END)
						FROM	APP_ScFilterFile WITH(NOLOCK)
						WHERE	componentNameId = @i_subClientId AND type > 0 AND
							(@i_refTime = 0 AND modified = 0 OR
							(@i_refTime > 0 AND created <= @i_refTime AND (modified = 0 OR modified > @i_refTime)))
						UNION ALL
						SELECT	case @i_appTypeId
								when 89 then replace(substring(filename,5,len(filename)),0x13,'/')
								else replace(filename,0x13,'/') end
								, type,
							returnOrder=(CASE type
								when 1	then 1
								when 2	then 3
								when 4	then 3
								ELSE 2	END)
						FROM	APP_ScFilterFile F WITH(NOLOCK)
							INNER JOIN APP_Application S WITH(NOLOCK) ON S.id = F.componentNameId
							INNER JOIN APP_BackupSetProp B WITH(NOLOCK) ON B.attrVal = S.backupSet AND B.attrName = 'Associated subclient Policy' AND B.modified = 0
							INNER JOIN APP_Application sub WITH(NOLOCK) ON sub.id = @i_subClientId AND B.componentNameId = sub.backupSet AND sub.subclientName = S.subclientName
						WHERE type > 0
								AND (@i_refTime = 0 AND F.modified = 0
									OR	(@i_refTime > 0 AND F.created <= @i_refTime
										AND (F.modified = 0 OR F.modified > @i_refTime)))
					) AS T
		END
ELSE IF @i_appTypeId in (60,90)
			BEGIN
						INSERT INTO #tempContentList(content,type,returnOrder,field2)
						SELECT  attrName , 1,
						returnOrder=(CASE 1
								WHEN 1	THEN 1
								WHEN 2	THEN 3
								WHEN 4	THEN 3
								ELSE 2	END),REPLACE(substring(attrval,1,CHARINDEX(' ',attrval) -1),'+1',' ')
						FROM APP_subclientProp WITH(NOLOCK)
						WHERE attrType = 101 AND componentNameId = @i_subClientId  AND
						(@i_refTime = 0 AND modified = 0 OR
						(@i_refTime > 0 AND created <= @i_refTime AND (modified = 0 OR modified > @i_refTime)))
			END
ELSE IF @i_appTypeId in (53)
			BEGIN
						INSERT INTO #tempContentList(content,type,returnOrder)
						SELECT  '\'+attrName , 1,
						returnOrder=(CASE 1
								WHEN 1	THEN 1
								WHEN 2	THEN 3
								WHEN 4	THEN 3
								ELSE 2	END)
						FROM APP_subclientProp WITH(NOLOCK)
						WHERE attrType = 112 AND componentNameId = @i_subClientId  AND
						(@i_refTime = 0 AND modified = 0 OR
						(@i_refTime > 0 AND created <= @i_refTime AND (modified = 0 OR modified > @i_refTime)))
			END
ELSE IF @i_appTypeId in (104)
			BEGIN
						INSERT INTO #tempContentList(content,type,returnOrder)
						SELECT  '\'+attrName , 1,
						returnOrder=(CASE 1
								WHEN 1	THEN 1
								WHEN 2	THEN 3
								WHEN 4	THEN 3
								ELSE 2	END)
						FROM APP_subclientProp WITH(NOLOCK)
						WHERE attrType = 120 AND componentNameId = @i_subClientId  AND
						(@i_refTime = 0 AND modified = 0 OR
						(@i_refTime > 0 AND created <= @i_refTime AND (modified = 0 OR modified > @i_refTime)))
			END
ELSE IF @i_appTypeId = 59
			BEGIN
					   INSERT INTO #tempContentList(content,type,returnOrder,field1,field2)
						SELECT  attrName , 1,
						returnOrder=(CASE 1
								WHEN 1	THEN 1
								WHEN 2	THEN 3
								WHEN 4	THEN 3
								ELSE 2	END),
							   REPLACE(substring(attrval,1,CHARINDEX(' ',attrval) -1),'+1',' '),
							   SUBSTRING(attrval,CHARINDEX(' ',attrval)+1,7)
						FROM APP_subclientProp WITH(NOLOCK)
						WHERE attrType = 102 AND componentNameId = @i_subClientId  AND
						(@i_refTime = 0 AND modified = 0 OR
						(@i_refTime > 0 AND created <= @i_refTime AND (modified = 0 OR modified > @i_refTime)))
			  END
ELSE IF @i_appTypeId = 128
			BEGIN
					INSERT INTO #tempContentList(content,type,returnOrder)
					SELECT	(SELECT displayName FROM APP_CLIENT WHERE ID = SUBSTRING(filename, 1, CHARINDEX(' ', filename)-1)) + ' '
							+ REPLACE(substring(filename, CHARINDEX(' ', filename) + 1, len(filename) - CHARINDEX(filename, ' ')), '+1',' ')
					        , type,
						returnOrder=(CASE type
							when 1	then 1
							when 2	then 3
							when 4	then 3
							ELSE 2	END)
					FROM	APP_ScFilterFile WITH(NOLOCK)
					WHERE	componentNameId = @i_subClientId AND type > 0 AND
						(@i_refTime = 0 AND modified = 0 OR
						(@i_refTime > 0 AND created <= @i_refTime AND (modified = 0 OR modified > @i_refTime)))
			END
ELSE IF @i_appTypeId = 78
				 BEGIN
					IF object_id('tempdb.dbo.#tempContent') IS NOT null DROP TABLE #tempContent
					CREATE TABLE #tempContent(
					content		nvarchar(MAX),
					type		INT,
					returnOrder	INT,
					contentxml		xml
					)
					INSERT INTO #tempContent(content,type,returnOrder)
					SELECT
					CASE
WHEN   subclientStatus & 0x00008 = 0x00008  THEN
case   WHEN  B.status & 0x8000 = 0x8000   THEN replace(replace(filename,'contentPath="\MB"','contentPath="|\MB\All Folders."'),'|#13!','/')
WHEN B.status & 0x0800 = 0x0800  THEN replace(replace(filename,'contentPath="\MB"','contentPath="|\MB\Farm."'),'|#13!','/')
WHEN  B.status & 0x80000 = 0x80000   THEN replace(replace(filename,'contentPath="\MB"','contentPath="|\MB\All Folders."'),'|#13!','/')
						   else  replace(replace(filename,'contentPath="\MB"','contentPath="|\MB\All Folders."'),'|#13!','/')
					END
					ELSE
					 REPLACE(fileName,'|#13!','/')
					 END
							        , type,
						returnOrder=(CASE type
							when 21	then 1
							when 22	then 3
							when 23	then 2
							ELSE 2	END)
					FROM	APP_ScFilterFile AS A WITH (NOLOCK)
					INNER JOIN APP_Application AS O WITH (NOLOCK)  ON O.id = A.componentNameId
					INNER JOIN APP_BackupSetName AS B WITH (NOLOCK) ON B.id = O.backupSet
					WHERE	componentNameId = @i_subClientId
										AND type > 0
										AND (@i_refTime = 0 AND A.modified = 0
										OR	(@i_refTime > 0 AND created <= @i_refTime
										AND (A.modified = 0 OR A.modified > @i_refTime)))
					 UPDATE #tempContent
					 SET contentxml = cast(content as xml)
					 UPDATE #tempContent
					 SET contentxml =( SELECT T.C.value('@contentPath', 'VARCHAR(MAX)') AS '@contentPath'
								FROM contentxml.nodes('EVGui_SharePointItem') T(C)
								FOR XML PATH('EVGui_SharePointItem'))
					UPDATE #tempContent
					 SET content = cast(contentxml as nvarchar(max))
					 INSERT INTO #tempContentList(content,type,returnOrder)
					 select (SELECT T.C.value('@contentPath', 'VARCHAR(MAX)') AS '@contentPath'
								FROM contentxml.nodes('EVGui_SharePointItem') T(C)),type,returnOrder from  #tempContent
					IF object_id('tempdb.dbo.#tempContent') IS NOT null DROP TABLE #tempContent
			END
-- For CDR following are equivalent
-- 				BackupSet   --> replicationset
-- 				subClientId --> pairId
-- For Replication pairs the content will be stored in APP_scReplicationPair.
-- proptye 10003 is Application list  and 10001 is source path.
-- we will select application list if it is not null other wise we will select the source path if application list
-- not selected for that pairId
-- Filters for the replication set  is stored in APP_Application table
-- Filters  will get selected in the above if blocks
IF @i_appTypeId = 84
	BEGIN
		DECLARE @repsetId INTEGER
		set @repsetId=(select backupSet from APP_Application WITH(NOLOCK) where id=@i_subClientId)
      	INSERT INTO #tempContentList(content,type,field1)
		SELECT  distinct stringVal , 1, 1
		FROM APP_scReplicationPair rep1 WITH(NOLOCK)
			WHERE pairId in (select id from APP_Application WITH(NOLOCK) where backupSet = @repsetId) AND
				((propType = 10003 AND stringVal <> '') OR (propType = 10001 and (select stringVal from APP_scReplicationPair rep2 WITH(NOLOCK) where rep1.pairId= rep2.pairId and propType = 10003) = '')) AND
				(@i_refTime = 0 AND modified = 0 OR
				(@i_refTime > 0 AND created <= @i_refTime AND (modified = 0 OR modified > @i_refTime)))
	END
	/*INSERT INTO #tempContentList(content,type,returnOrder)
	SELECT	filename, type,
		returnOrder=(CASE type
			when 1	then 1
			when 2	then 3
			when 4	then 3
			ELSE 2	END)
	FROM	APP_ScFilterFile
	WHERE	componentNameId = @i_subClientId AND type > 0 AND
		(@i_refTime = 0 AND modified = 0 OR
		(@i_refTime > 0 AND created <= @i_refTime AND (modified = 0 OR modified > @i_refTime)))*/
	END
IF @i_appTypeId = 29
	BEGIN
		UPDATE	#tempContentList
		SET	delimPos = CHARINDEX('\/\/', content)
		UPDATE	#tempContentList
		SET	content = substring(content, 1, delimPos-1)
		WHERE	delimPos > 0 AND len(content) > 1
	END
	-- get subclient content from APP_subclientProp for the following EXCH agents
IF @i_appTypeId IN (	67, 68,
54, 8, 14,
56, 45, 57, 105)
	BEGIN
		INSERT INTO #tempContentList(content,type,returnOrder,attrType)
		SELECT	attrName, 1, 1,attrType
		FROM	APP_subclientProp WITH(NOLOCK)
		WHERE	componentNameId = @i_subClientId AND attrType in (111) AND
			(@i_refTime = 0 AND modified = 0 OR
			(@i_refTime > 0 AND created <= @i_refTime AND (modified = 0 OR modified > @i_refTime)))
			and attrName not in (select content from #tempContentList)
		--total no of contents
		UPDATE	#tempContentList
		SET	capacity = (select count( *) from #tempContentList WHERE attrType IN (0, 111))
		WHERE	attrType in (0, 111)
	END
	--virtual server
IF @i_appTypeId IN (106)
	BEGIN
		DECLARE @releaseId INT = (SELECT RELEASEID FROM APP_CLIENT WITH(NOLOCK) WHERE id = (SELECT CLIENTID FROM APP_APPLICATION WITH(NOLOCK) WHERE id = @i_subClientId));
		IF (@releaseId >= 15)
		BEGIN
			INSERT INTO #tempContentList(content,type,returnOrder,attrType)
			SELECT CASE	when T.c.exist('children')=1
								then 'Rule:'+ CASE WHEN attrName = 'Virtual Server Dyanimc Content' THEN ' Backup VM whose' ELSE '' END +
									 dbo.GetVSAContentAsString((SELECT T.c.query('.') FOR XML PATH('VirtualServer_VMSubClientEntity')))
						else
								case (T.c.value('@type','INT'))
									when 1 then 'Server Host'
									when 2 then 'Resource Pool'
									when 3 then 'vApp'
									when 4 then 'Datacenter'
									when 5 then 'Folder'
									when 6 then 'Cluster'
									when 7 then 'Datastore'
									when 8 then 'DatastoreCluster'
									when 9 then 'VirtualMachine'
									when 10 then 'VirtualMachine Name'
									when 11 then 'VirtualMachine GuestOS'
									when 12 then 'VirtualMachine Guest Host Name'
									when 13 then 'Cluster Shared Volumes'
									when 14 then 'Local Disk'
									when 15 then 'Cluster Disk'
									when 16 then ''
									when 17 then 'All'
									when 28 then 'PoweredState'
									when 29 then 'Notes'
									when 30 then 'Name contains '+T.c.value('@name','NVARCHAR(255)')
									else (case when LEN(T.c.value('@name','NVARCHAR(255)')) > 1 THEN T.c.value('@name','NVARCHAR(255)') ELSE 'Unknown' END)
								end
								+ ' : '
								+ case (T.c.value('@type','INT'))
										when 30 then 'Value contains '+T.c.value('@value','NVARCHAR(MAX)')
										else T.c.value('@displayName', 'nvarchar(MAX)')
								  end
							END,
							CASE WHEN attrName = 'Virtual Server Dyanimc Content' THEN 1 ELSE 0 END,
							1,1
							FROM
							(
								SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) x, attrName
								FROM APP_SubClientProp WITH(NOLOCK) where attrName IN ('Virtual Server Dyanimc Content', 'Virtual Server Filters')
								AND componentNameId = @i_subClientId
								AND (@i_refTime = 0 AND modified = 0 OR (@i_refTime > 0 AND created <= @i_refTime AND (modified = 0 OR modified > @i_refTime)))
							) tmp
							CROSS APPLY x.nodes('/VirtualServer_VMSubClientEntity/children') AS T(c)
			DECLARE @numberOfFilters INT = 0
			DECLARE @filterXML XML =  (SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) AS X
				FROM APP_SubClientProp WITH(NOLOCK) where attrName = 'Virtual Server Filters'
				AND componentNameId = @i_subClientId
				AND (@i_refTime = 0 AND modified = 0 OR (@i_refTime > 0 AND created <= @i_refTime AND (modified = 0 OR modified > @i_refTime))) )
			SET @numberOfFilters += ISNULL((SELECT count(*) FROM @filterXML.nodes('/VirtualServer_VMSubClientEntity/children') AS c(x)),0)
			SET @filterXML = (SELECT CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) x
				FROM APP_SubClientProp WITH(NOLOCK) where attrName = 'Virtual Server Disk Filters'
				AND componentNameId = @i_subClientId
				AND (@i_refTime = 0 AND modified = 0 OR (@i_refTime > 0 AND created <= @i_refTime AND (modified = 0 OR modified > @i_refTime))) )
			IF @filterXML IS NOT NULL AND  @filterXML.exist('/EVGui_VMSubclientDiskFilterList/filters') = 1
				INSERT INTO #tempContentList(content, type, returnOrder,attrType)
				SELECT 'VM Disk Filters: '+STUFF((SELECT ' and '+ (case c.x.value('@filterType','INT')
									when 2  then 'VMDK Name/Pattern'
									when 3  then 'Virtual Device Node'
									when 4 then 'Datastore'
									when 5 then 'Hard disk Label'
									else 'Unknown' end)
									+ ' equals '
									+c.x.value('@filter', 'nvarchar(MAX)')
									FROM @filterXML.nodes('/EVGui_VMSubclientDiskFilterList/filters') AS c(x)
									FOR xml path ('')),1,5,''),
						0, 1, 1
			SET @numberOfFilters += ISNULL((SELECT count(*) FROM @filterXML.nodes('/EVGui_VMSubclientDiskFilterList/filters') AS c(x)),0)
			UPDATE T
			SET capacity = (CASE WHEN T.type = 0 THEN @numberOfFilters
								ELSE (select COUNT(*) from #tempContentList T1 WHERE T1.type = T.type)
							END)
			FROM #tempContentList T
		END
		ELSE
		BEGIN
			INSERT INTO #tempContentList(content,type,returnOrder,attrType)
			SELECT	attrVal, 1, 1,attrType
			FROM	APP_subclientProp WITH(NOLOCK)
			WHERE	componentNameId = @i_subClientId AND attrType in (121) AND
				(@i_refTime = 0 AND modified = 0 OR
				(@i_refTime > 0 AND created <= @i_refTime AND (modified = 0 OR modified > @i_refTime)))
			UPDATE	#tempContentList
			SET	delimPos = CHARINDEX(@VMdelim, content)
			UPDATE	#tempContentList
			SET	content = substring(content, 1, delimPos-1)
			WHERE	delimPos > 0 AND len(content) > 1
			UPDATE #tempContentList
			SET content = REPLACE(content, N'+1', N' ');
			UPDATE #tempContentList
			SET content = REPLACE(content, N'+2', N'+');
			UPDATE	#tempContentList
			SET	capacity = (select count( *) from #tempContentList WHERE	attrType = 121)
			WHERE	attrType = 121
		END
	END
IF @i_appTypeId IN (47, 50)
	BEGIN
		UPDATE	#tempContentList
		SET	delimPos = CHARINDEX(@QRdelim, content)
		UPDATE	#tempContentList
		SET	volId = CONVERT(INT,substring(content, 1, delimPos-1)), appTypeName = substring(content, delimPos+1, len(content)-delimPos)
		WHERE	delimPos > 0 AND len(content) > 1
		UPDATE	#tempContentList
		SET	mountPoint=(select	TOP 1 path
						from	QRPhysicalDevice D, QRMountPoint M
						where	D.SNRVolumeId = volId
								and D.id=M.DeviceNameId
								and ClientId = (select clientId from APP_Application WITH(NOLOCK) where id = @i_subClientId)),
			capacity=(select blockSize*blockCount from QRPhysicalVolume WITH(NOLOCK) where id=volId)
	END
	ELSE
	BEGIN
		UPDATE	#tempContentList
		SET	delimPos = CHARINDEX(@Exdelim, content)
		UPDATE	#tempContentList
		SET	field1 = substring(content, delimPos+1, len(content)-delimPos)
		WHERE	delimPos > 0 AND len(content) > 1
		UPDATE	#tempContentList
		SET	content = substring(content, 1, delimPos-1),
			delimPos = CHARINDEX(@Exdelim, field1)
		WHERE	delimPos > 0
		UPDATE	#tempContentList
		SET	field2 = substring(field1, delimPos+1, len(field1)-delimPos), field1 = substring(field1, 1, delimPos-1)
		WHERE	delimPos > 0 AND len(field1) > 1
		UPDATE	#tempContentList
		SET	delimPos = CHARINDEX(@Exdelim, field2)
		WHERE	len(field2) > 1
		UPDATE	#tempContentList
		SET	field3 = substring(field2, delimPos+1, len(field2)-delimPos),
			field2 = substring(field2, 1, delimPos-1)
		WHERE	delimPos > 0 AND len(field2) > 1
		UPDATE	#tempContentList
		SET	delimPos = CHARINDEX(@Exdelim, field3)
		WHERE	len(field3) > 1
		UPDATE	#tempContentList
		SET	field4 = substring(field3, delimPos+1, len(field3)-delimPos),
			field3 = substring(field3, 1, delimPos-1)
		WHERE	delimPos > 0 AND len(field3) > 1
IF  @i_appTypeId = 60
		BEGIN
			UPDATE  #tempContentList
			SET field5 = ( select
			SUBSTRING(REPLACE(SUBSTRING(attrval,1,CHARINDEX(' \',attrval)-1),'+1',' '),len(field2)+2,len(attrval) )
			from APP_subclientProp P
			where content=P.attrname and modified=0 and P.componentNameId = @i_subClientId )
		END
	END
	declare @returnContent int
	set @returnContent = 0
	declare @retVal integer
	declare @retVal1 integer
	declare @retVal2 varchar
	select @retVal = attrVal from APP_SubClientProp WITH(NOLOCK) where attrName = 'use global filters' and ((@i_refTime > created)and ((@i_refTime < modified) or (modified = 0))) and (componentNameId = @i_subClientId)
	if(@retVal = 1)
	begin
		set @returnContent = 1
	end
	else
	begin
		select @retVal1 = attrVal from APP_SubClientProp WITH(NOLOCK) where attrName = 'use cs setting for global filters' and ((@i_refTime > created)and ((@i_refTime < modified) or (modified = 0))) and (componentNameId = @i_subClientId)
		if (@retVal1 = 1)
		begin
			select @retVal2 = value from GXGlobalParam WITH(NOLOCK) where name = 'Use Global Filters for all Subclients' and (created <= @i_refTime AND  ( modified = 0 OR modified > @i_refTime))
			if (@retVal2 = '1')
			begin
				set @returnContent = 1
			end
		end
	end
	if (@returnContent = 1)
	begin
		declare @paramName			varchar(MAX)
		set @paramName = ''
		declare @insertContent		varchar(MAX)
		set @insertContent = ''
if (@i_appTypeId = 93)
		begin
			set @paramName = 'Content Indexing Exclude Filters'
		end
else if (@i_appTypeId = 54)
		begin
			set @paramName = 'Exchange Mailbox Exclude Filters'
		end
else if (@i_appTypeId = 105)
		begin
			set @paramName = 'Exchange Online CI Exclude Filters'
		end
else if (@i_appTypeId = 1068)
		begin
			set @paramName = 'FSDM Exclude Filters'
		end
else if (@i_appTypeId = 12)
		begin
			set @paramName = 'Netware FS Exclude Filters'
		end
else if (@i_appTypeId = 106)
		begin
			set @paramName = 'Virtual Server Exclude Filters'
		end
else if (@i_appTypeId = 33)
		begin
			set @paramName = 'Windows FS Exclude Filters'
		end
else if ((@i_appTypeId = 21) or
(@i_appTypeId = 17)  or
(@i_appTypeId = 19)  or
(@i_appTypeId = 29)  or
(@i_appTypeId = 36)  or
(@i_appTypeId = 63)  or
(@i_appTypeId = 64)  or
(@i_appTypeId = 74)  or
(@i_appTypeId = 86))
		begin
			set @paramName = 'Unix FS Exclude Filters'
		end
		if (@paramName <> '')
		begin
			select @insertContent =	value from GxGlobalParam WITH(NOLOCK) where name = @paramName and (created <= @i_refTime AND  ( modified = 0 OR modified > @i_refTime))
		end
		if (@insertContent <> '')
		begin
			insert into #tempContentList(content, type, returnOrder)
			select REPLACE(Data, '+1', ' '), 13, 5
			from dbo.SplitString(@insertContent, ' ')
		end
	end
	SELECT	* FROM #tempContentList ORDER BY returnOrder
	DROP TABLE #tempContentList
 SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetSubClientContent')
	delete from GxQscripts where name = 'RptGetSubClientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetSubClientContent')
	delete from GXDBVersions where aliasname = 'RptGetSubClientContent'
GO

insert into GXDBVersions values(2, 'RptGetSubClientContent',  '00010042000200070000', 'RptGetSubClientContent', '00010042000200070000')
GO

