

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetServiceAccountsUsers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetServiceAccountsUsers.sp,v $ $Id: RptGetServiceAccountsUsers.sp,v 1.1.2.4 2020/02/11 10:59:19 scheppuri Exp $";
--  +-----------------------------------------------------------------------+
--  |           Procedure : "RptGetServiceAccountsUsers"           |
--  |                                   |
--  | TO GET SERVICE ACCOUNTS USED FOR BACKUP AD,VSA,SHAREPOINT etc AGENT |
--  | AND RETURNING RESULTS                         |
--  +-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetServiceAccountsUsers')
BEGIN
	print '>>> Drop Stored Procedure: RptGetServiceAccountsUsers <<<'
	drop procedure RptGetServiceAccountsUsers
END
IF EXISTS (select * from GxQscripts where name='RptGetServiceAccountsUsers')
	delete from GxQscripts where name = 'RptGetServiceAccountsUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetServiceAccountsUsers')
	delete from GXDBVersions where aliasname = 'RptGetServiceAccountsUsers'
GO
print '... Creating Procedure: RptGetServiceAccountsUsers'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetServiceAccountsUsers
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @unixTime bigint =  dbo.GetUnixTime(GetUTCDate())
IF OBJECT_ID('tempdb.dbo.#tmpCredentials') IS NOT NULL
DROP TABLE #tmpCredentials
CREATE TABLE #tmpCredentials
(
	vsaInstanceId INT,
	credentialAssocId INT,
	userName VARCHAR(1024),
	userPassword VARCHAR(2048)
)
INSERT INTO #tmpCredentials
	SELECT componentNameId,CAST(attrVal AS INT),'','' FROM APP_InstanceProp
	WHERE attrName = 'Virtual Server Credential Assoc Id' and modified=0
-- Update user name and password
DECLARE @dummyUserName NVARCHAR(512)
DECLARE @dummyUserPassword NVARCHAR(1024)
EXEC GetCredentialsFromCredentialAssocIds 0,@dummyUserName OUTPUT,@dummyUserPassword OUTPUT
MERGE App_InstanceProp AS T1
USING #tmpCredentials T2
ON T1.componentNameId = T2.vsaInstanceId  AND T1.attrName='Virtual Server User' and T1.modified=0
WHEN MATCHED THEN
    UPDATE SET T1.attrVal =T2.userName
WHEN NOT MATCHED THEN
    INSERT(componentNameId, attrName, attrType, attrVal, created, modified)
    VALUES(T2.vsaInstanceId,'Virtual Server User',1,T2.userName,@unixTime,0);
DECLARE @SUMMARY INT = 1 -- 1 will just list the accounts used, 0 will list the clients they are used on as well
,@INCLUDE_DELETED_SUBCLIENTS INT = 0
,@INCLUDE_DELETED_CLIENTS INT = 0
,@INCLUDE_DECONFIGURED_OR_AGENTLESS_CLIENTS INT = 0
IF OBJECT_ID('TEMPDB.DBO.#ACCOUNT_TABLE') IS NOT NULL  DROP TABLE #ACCOUNT_TABLE
CREATE TABLE #ACCOUNT_TABLE ( Agent NVARCHAR(MAX),	[Account] NVARCHAR(MAX),	[Client Name] NVARCHAR(MAX),	[Client Status] int, [Object Status] int, [Subclient Status] int)
INSERT INTO #ACCOUNT_TABLE
SELECT DISTINCT
                      simAppTypeLicTypeMap.display_name AS 'Agent', APP_IDAProp.attrVal AS 'Account', APP_Client.displayName AS [Client Name], APP_Client.status AS [Client Status],
                      APP_IDAName.status AS [Object Status], '0' AS [Subclient Status]
FROM         APP_IDAProp INNER JOIN
                      APP_IDAName ON APP_IDAProp.componentNameId = APP_IDAName.id INNER JOIN
                      simAppTypeLicTypeMap ON APP_IDAName.appTypeId = simAppTypeLicTypeMap.appTypeId INNER JOIN
                      APP_Client ON APP_IDAName.clientId = APP_Client.id
WHERE     (APP_IDAProp.modified = 0) AND (APP_IDAProp.attrName LIKE '%User Name%') AND (APP_IDAProp.attrVal NOT LIKE '')
UNION
SELECT DISTINCT
                      simAppTypeLicTypeMap.display_name AS 'Agent', APP_InstanceProp.attrVal AS 'Account', APP_Client.displayName AS [Client Name], APP_Client.status AS [Client Status],
                      APP_InstanceName.status AS [Object Status], '0' AS [Subclient Status]
FROM         APP_InstanceProp INNER JOIN
                      APP_InstanceName ON APP_InstanceProp.componentNameId = APP_InstanceName.id INNER JOIN
                      APP_Application ON APP_InstanceName.id = APP_Application.instance INNER JOIN
                      simAppTypeLicTypeMap ON APP_Application.appTypeId = simAppTypeLicTypeMap.appTypeId INNER JOIN
                      APP_Client ON APP_Application.clientId = APP_Client.id
WHERE     (APP_InstanceProp.modified = 0) AND (APP_InstanceProp.attrName LIKE '%User Name%' OR
                      APP_InstanceProp.attrName LIKE 'Virtual Server User') AND (APP_InstanceProp.attrVal NOT LIKE '')
UNION
SELECT DISTINCT
                      simAppTypeLicTypeMap.display_name AS Agent, APP_SubClientProp.attrVal AS 'Account', APP_Client.displayName AS [Client Name], APP_Client.status AS [Client Status],
                      APP_Application.subclientStatus AS [Subclient Status], '0' AS [Object Status]
FROM         APP_SubClientProp INNER JOIN
                      APP_Application ON APP_SubClientProp.componentNameId = APP_Application.id INNER JOIN
                      simAppTypeLicTypeMap ON APP_Application.appTypeId = simAppTypeLicTypeMap.appTypeId INNER JOIN
                      APP_Client ON APP_Application.clientId = APP_Client.id
WHERE     (APP_SubClientProp.attrName LIKE '%user name%' OR
                      APP_SubClientProp.attrName LIKE '%username%') AND (NOT (APP_SubClientProp.attrName LIKE 'prepost username')) AND
                      (NOT (APP_SubClientProp.attrName LIKE 'UNCPath user name')) AND (APP_SubClientProp.attrName LIKE 'Virtual Server ESX User Name') AND
                      (NOT (APP_SubClientProp.attrName LIKE 'use prepost username')) AND (APP_SubClientProp.modified = 0) AND (APP_SubClientProp.attrVal <> '')
UNION
SELECT      Agent = 'Single Sign On', Account = (domainName + '\' + login), 'N/A' AS [Client Name], '0' AS [Client Status], '0' AS [Object Status], '0' AS [Subclient Status]
FROM         UMDSProviders
WHERE     (id > 0)
UNION
SELECT Agent,Account,[Client Name],[Client Status],[Object Status],[Subclient Status]
FROM (SELECT      'Alerts' AS Agent,NTnotificationAction.runAsUserLogin AS Account,'N/A' AS [Client Name],'0' AS [Client Status], NTnotificationRule.status AS [Object Status], '0' AS [Subclient Status]
FROM         NTnotificationAction INNER JOIN
                      NTnotificationRule ON NTnotificationAction.NTnotificationID = NTnotificationRule.id
                      WHERE runAsUserLogin NOT LIKE '') AS ALERTS
UNION
SELECT   DISTINCT   Agent = 'Mount Path', UserName AS Account, 'N/A' AS [Client Name], '0' AS [Client Status], '0' AS [Object Status], '0' AS [Subclient Status]
FROM         MMMountPath
WHERE     NOT(UserName = 'N/A') AND (NOT (UserName LIKE ''))
UNION
SELECT DISTINCT 'DR Backup' AS Agent, userName AS Account, 'N/A' AS [Client Name], '0' AS [Client Status], '0' AS [Object Status], '0' AS [Subclient Status]
FROM         APP_CommCell
WHERE     (id = 2) AND (userName NOT LIKE '')
UNION
SELECT DISTINCT Agent = 'Exchange DAG',APP_ClientProp.attrVal AS 'Account', APP_Client.displayName AS [Client Name], APP_Client.status AS [Client Status], '0' AS [Object Status], '0' AS [Subclient Status]
FROM         APP_ClientProp INNER JOIN
                      APP_Client ON APP_ClientProp.componentNameId = APP_Client.id
WHERE     (APP_ClientProp.attrName = N'DAG Associated AD User Name') AND (APP_ClientProp.attrVal NOT LIKE '')
AND (APP_ClientProp.modified = 0)
UNION
SELECT DISTINCT
                      simAppTypeLicTypeMap.display_name AS Agent, APP_ClientProp.attrVal AS 'Account', APP_Client.displayName AS [Client Name], APP_Client.status AS [Client Status]
                      , '0' AS [Object Status],APP_Application.subclientStatus AS [Subclient Status]
FROM         APP_ClientProp INNER JOIN
                      APP_Client ON APP_ClientProp.componentNameId = APP_Client.id INNER JOIN
                      APP_Application ON APP_Client.id = APP_Application.clientId INNER JOIN
                      simAppTypeLicTypeMap ON APP_Application.appTypeId = simAppTypeLicTypeMap.appTypeId
WHERE     (APP_ClientProp.attrName LIKE '%User Name%') AND (NOT (APP_ClientProp.attrName = N'DAG Associated AD User Name'))  AND
                        (APP_ClientProp.modified = 0)     AND (APP_ClientProp.attrVal NOT LIKE '')
UNION
SELECT DISTINCT 'NDMP' AS Agent, MMNDMPHostInfo.Login AS Account, APP_Client.displayName AS [Client Name], APP_Client.status AS [Client Status], '0' AS [Object Status], '0' AS [Subclient Status]
FROM         MMNDMPHostInfo INNER JOIN
                      APP_Client ON MMNDMPHostInfo.ClientId = APP_Client.id
WHERE     (MMNDMPHostInfo.NDMPHostId <> 0) AND (MMNDMPHostInfo.Login NOT LIKE '')
UNION
SELECT DISTINCT
                      'IntelliSnap Controller Management' AS 'Agent', SMHostUserName AS 'Account', 'N/A' AS [Client Name], SMHostStatus AS [Client Status], '0' AS [Object Status],
                      '0' AS [Subclient Status]
FROM         SMControlHost
WHERE     (SMHostUserName <> '') AND (SMHostUserName <> 'N/A') AND (SMHostUserName <> '')
UNION
SELECT DISTINCT
                      'Pre\Post User' AS Agent, APP_SubClientProp.attrVal AS 'Account', APP_Client.displayName AS [Client Name], APP_Client.status AS [Client Status]
                     , '0' AS [Object Status] , APP_Application.subclientStatus AS [Subclient Status]
FROM         APP_SubClientProp INNER JOIN
                      APP_Application ON APP_SubClientProp.componentNameId = APP_Application.id INNER JOIN
                      simAppTypeLicTypeMap ON APP_Application.appTypeId = simAppTypeLicTypeMap.appTypeId INNER JOIN
                      APP_Client ON APP_Application.clientId = APP_Client.id
WHERE     (APP_SubClientProp.attrName LIKE '%user name%' OR
                      APP_SubClientProp.attrName LIKE '%username%') AND (APP_SubClientProp.attrName = 'prepost username') AND (APP_SubClientProp.modified = 0) AND
                      (APP_SubClientProp.attrVal <> '')
UNION
SELECT DISTINCT
                      'UNCPath user name' AS Agent, APP_SubClientProp.attrVal, APP_Client.displayName AS [Client Name], APP_Client.status AS [Client Status]
                      , '0' AS [Object Status],APP_Application.subclientStatus AS [Subclient Status]
FROM         APP_SubClientProp INNER JOIN
                      APP_Application ON APP_SubClientProp.componentNameId = APP_Application.id INNER JOIN
                      simAppTypeLicTypeMap ON APP_Application.appTypeId = simAppTypeLicTypeMap.appTypeId INNER JOIN
                      APP_Client ON APP_Application.clientId = APP_Client.id
WHERE     (APP_SubClientProp.attrName LIKE '%user name%' OR
                      APP_SubClientProp.attrName LIKE '%username%') AND (APP_SubClientProp.attrName = 'UNCPath user name') AND (APP_SubClientProp.modified = 0) AND
                      (APP_SubClientProp.attrVal <> '')
UNION
SELECT DISTINCT
                      simAppTypeLicTypeMap.display_name + ' - ' + APP_SubClientProp.attrName AS Agent, APP_SubClientProp.attrVal AS 'Account', APP_Client.displayName AS [Client Name],
                      APP_Client.status AS [Client Status], '0' AS [Object Status], APP_Application.subclientStatus AS [Subclient Status]
FROM         APP_SubClientProp INNER JOIN
                      APP_Application ON APP_SubClientProp.componentNameId = APP_Application.id INNER JOIN
                      simAppTypeLicTypeMap ON APP_Application.appTypeId = simAppTypeLicTypeMap.appTypeId INNER JOIN
                      APP_Client ON APP_Application.clientId = APP_Client.id
WHERE     (APP_SubClientProp.attrName LIKE '%user name%' OR
                      APP_SubClientProp.attrName LIKE '%username%') AND (NOT (APP_SubClientProp.attrName LIKE 'prepost username')) AND
                      (NOT (APP_SubClientProp.attrName LIKE 'UNCPath user name')) AND (NOT (APP_SubClientProp.attrName LIKE 'Virtual Server ESX User Name')) AND
                      (NOT (APP_SubClientProp.attrName LIKE 'use prepost username')) AND (APP_SubClientProp.modified = 0) AND (APP_SubClientProp.attrVal <> '')
UNION
SELECT     simAppTypeLicTypeMap.display_name AS 'Agent', APP_BackupSetProp.attrVal AS 'Account', APP_Client.displayName AS [Client Name], APP_Client.status AS [Client Status],
                      APP_BackupSetName.status AS [Object Status], APP_Application.subclientStatus AS [Subclient Status]
FROM         APP_BackupSetProp INNER JOIN
                      APP_BackupSetName ON APP_BackupSetProp.componentNameId = APP_BackupSetName.id INNER JOIN
                      APP_Application ON APP_BackupSetName.id = APP_Application.backupSet INNER JOIN
                      simAppTypeLicTypeMap ON APP_Application.appTypeId = simAppTypeLicTypeMap.appTypeId INNER JOIN
                      APP_Client ON APP_Application.clientId = APP_Client.id
WHERE     (APP_BackupSetProp.attrName LIKE '%user name%') AND (APP_BackupSetProp.modified = 0)  AND  (APP_BackupSetProp.attrVal <> '')
			OR (APP_BackupSetProp.attrName LIKE '%username%')
UNION
SELECT DISTINCT Agent = 'New Agent',APP_ClientProp.attrVal AS 'Account', APP_Client.displayName AS [Client Name], APP_Client.status AS [Client Status], '0' AS [Object Status], '0' AS [Subclient Status]
FROM         APP_ClientProp INNER JOIN
                      APP_Client ON APP_ClientProp.componentNameId = APP_Client.id
WHERE     (APP_ClientProp.attrName = N'RodExtra2Add') AND (APP_ClientProp.attrVal <> '')
IF @INCLUDE_DELETED_CLIENTS = 0
BEGIN
DELETE #ACCOUNT_TABLE
WHERE ([Client Status] & 4) > 0
END
IF @INCLUDE_DECONFIGURED_OR_AGENTLESS_CLIENTS = 0
BEGIN
DELETE #ACCOUNT_TABLE
WHERE ([Client Status] & 2) > 0
END
IF @INCLUDE_DELETED_SUBCLIENTS = 0
BEGIN
DELETE #ACCOUNT_TABLE
WHERE ([Subclient Status] & 2) > 0
END
IF @SUMMARY = 1
BEGIN
SELECT DISTINCT Agent,Account,
Description =
CASE Agent
WHEN 'Active Directory' THEN 'Account given Full Rights in Active Directory to access all Objects'
WHEN 'DR Backup' THEN 'Account used to access DR share for automatic backup of CommServe for DR.This account will have full rights to the location and also Local Admin Rights on the CommServe'
WHEN 'Exchange Compliance Archiver' THEN 'Account that is Mail Enabled and given Full Rights to access all mailboxes and items'
WHEN 'Exchange DAG' THEN 'Account Used for initial discovery and Setup of Exchange'
WHEN 'Exchange Database' THEN 'Account Used for initial discovery and Setup of Exchange'
WHEN 'Exchange Mailbox' THEN 'Account that is Mail Enabled and given Full Rights to access all mailboxes and items'
WHEN 'Exchange Mailbox Archiver' THEN 'Account that is Mail Enabled and given Full Rights to access all mailboxes and items'
WHEN 'Mount Path' THEN 'Account Used to access Disk Libraries, This account will have full rights to the mount location and also Local Admin Rights on the MediaAgents'
WHEN 'Sharepoint Server' THEN 'Account given Full Rights to access to all subdirectories and items with Full Control'
WHEN 'Single Sign On' THEN 'Account that has connectivity to Active Directory to authenticate users via Single Sign On'
WHEN 'Virtual Server' THEN 'Account used to connect to the Virtualization Host With Full Access.'
WHEN 'NDMP' THEN 'Account Used to Perform NDMP Backups from NAS device'
WHEN 'Lotus Notes DB' THEN ''
WHEN 'Lotus Notes Documents' THEN ''
WHEN 'Lotus Notes Archiver' THEN ''
WHEN 'MS SQL' THEN ''
WHEN 'MySQL' THEN ''
WHEN 'Oracle' THEN ''
WHEN 'MS Sharepoint Archiver' THEN 'Account given Full Rights to access to all subdirectories and items with Full Control'
WHEN 'IntelliSnap Controller Management' THEN 'Account Used to Control and manage Snaps'
WHEN 'Documentum' THEN ''
WHEN 'PostgreSQL' THEN ''
WHEN 'UNCPath user name' THEN 'User Account Used to Connect and Backup a UNC Path'
WHEN 'SAP' THEN ''
WHEN 'Pre\Post User' THEN 'User Account Used to Run a Script Before or after a Backup Phase'
WHEN 'Alerts' THEN 'Account Used to Impersonate a User to Run a command'
WHEN 'Exchange Public Folder' THEN 'Account that is Mail Enabled and given Full Rights to access all items'
WHEN 'Exchange PF Archiver' THEN 'Account that is Mail Enabled and given Full Rights to access all items'
ELSE '' END
FROM #ACCOUNT_TABLE
END
ELSE
BEGIN
SELECT
Agent,Account,[Client Name]
FROM #ACCOUNT_TABLE
END
DROP TABLE #ACCOUNT_TABLE
IF OBJECT_ID('tempdb.dbo.#tmpCredentials') IS NOT NULL
DROP TABLE #tmpCredentials
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetServiceAccountsUsers')
	delete from GxQscripts where name = 'RptGetServiceAccountsUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetServiceAccountsUsers')
	delete from GXDBVersions where aliasname = 'RptGetServiceAccountsUsers'
GO

insert into GXDBVersions values(2, 'RptGetServiceAccountsUsers',  '00010001000200040000', 'RptGetServiceAccountsUsers', '00010001000200040000')
GO

