

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetScratchPoolMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetScratchPoolMedia.sp,v $ $Id: RptGetScratchPoolMedia.sp,v 1.28.200.4 2018/03/22 02:57:17 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetScratchPoolMedia"		|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetScratchPoolMedia <<<'

IF EXISTS (select * from sysobjects where name='RptGetScratchPoolMedia')
	drop procedure RptGetScratchPoolMedia
IF EXISTS (select * from GxQscripts where name='RptGetScratchPoolMedia')
	delete from GxQscripts where name = 'RptGetScratchPoolMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetScratchPoolMedia')
	delete from GXDBVersions where aliasname = 'RptGetScratchPoolMedia'
GO
print '... Creating Procedure: RptGetScratchPoolMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetScratchPoolMedia
  @i_jobId integer
AS
  DECLARE @o_spId integer
  DECLARE @o_scratchPool NVARCHAR(255)
  DECLARE @o_spareGroupType integer
  DECLARE @o_libId integer
  DECLARE @o_library NVARCHAR(255)
  DECLARE @o_libType integer
  DECLARE @o_lowWatermark integer
  DECLARE @o_highWatermark integer
  DECLARE @o_spAttributes integer
  DECLARE @o_mediaTypeName char(255)
  DECLARE @o_mediaInNum integer
  DECLARE @o_mediaOutNum integer
  DECLARE @o_barCode char(255)
  DECLARE @o_location NVARCHAR(255);
  DECLARE @o_numberOfMounts integer;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#TEMP_SG_LIST') IS NOT null DROP TABLE #TEMP_SG_LIST
IF object_id('tempdb.dbo.#TEMP_MEDIA_LIST') IS NOT null DROP TABLE #TEMP_MEDIA_LIST
CREATE TABLE #TEMP_SG_LIST (
SpareGroupId int, SpareGroupName nvarchar(192), SpareGroupType int,
LibId int , AliasName nvarchar(128), LibraryTypeId int,
		LowWaterMark int, HighWaterMark int, Attributes int,
mediaTypeName varchar(32), MediaIn int, MediaOut int)
DECLARE @tblSpareGroups	TABLE (SpareGroupId int)
DECLARE @locId			integer
DECLARE @userId			integer
DECLARE @formatId		integer
DECLARE @option			integer
DECLARE @lessThan		integer
DECLARE @includeMedia	integer
DECLARE @spareGrpOpt	integer
DECLARE @excludeStandaloneLib	integer
SET		@excludeStandaloneLib = 0
SET @userId		= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
SET @formatId	= dbo.GetOptionInt(1310074675, @i_jobId, 0, 0)
SET @option		= dbo.GetOptionInt(1469831208, @i_jobId, 0, 0)
SET @lessThan	= dbo.GetOptionInt(1973738810, @i_jobId, 0, 0)
SET @includeMedia = dbo.GetOptionInt(2085223948, @i_jobId, 0, 0)
-- TBD: define RPTCOMMONOPTIONS_EXCLUDE_STANDALONE_LIBRARIES and SPAREGROUPLIST_SPAREGROUP_ID
SET @excludeStandaloneLib = dbo.GetOptionInt(1009634698, @i_jobId, 0, 0)
INSERT INTO @tblSpareGroups EXEC rptOptGetObjectList @i_jobId, 929249166, @spareGrpOpt OUTPUT
IF	EXISTS (SELECT * FROM @tblSpareGroups)
	INSERT	INTO #TEMP_SG_LIST
	SELECT	S.SpareGroupId, S.SpareGroupName, S.SpareGroupType,
			L.libraryId, L.AliasName, L.LibraryTypeId,
			S.LowWaterMark, S.HighWaterMark, S.Attributes,
			ISNULL((select MediaTypeName from MMMediaType where MediaTypeId = S.MediaTypeId), ''), 0, 0
	FROM	MMSpareGroup S, MMLibrary L, @tblSpareGroups T
	WHERE	S.SpareGroupId = T.SpareGroupId
		AND S.libraryId = L.libraryId AND S.SpareGroupType IN (1,2,32)
AND (@excludeStandaloneLib = 0 OR L.LibraryTypeId NOT IN (4, 5))
ELSE IF (@lessThan > 0 OR @option = 3)
	INSERT	INTO #TEMP_SG_LIST
	SELECT	S.SpareGroupId, S.SpareGroupName, S.SpareGroupType,
			L.libraryId, L.AliasName, L.LibraryTypeId,
			S.LowWaterMark, S.HighWaterMark, S.Attributes,
			ISNULL((select MediaTypeName from MMMediaType where MediaTypeId = S.MediaTypeId), ''), 0, 0
	FROM	MMSpareGroup S, MMLibrary L
	WHERE	S.LibraryId = L.libraryId AND S.SpareGroupType IN (1, 2, 32)
AND (@excludeStandaloneLib = 0 OR L.LibraryTypeId NOT IN (4, 5))
SELECT	sgId=M.spareGroupId, M.Attributes, barcode, MediaLocation,
	loc=(	case MediaLocation
		when 1 then (select SlotName from MMSlot S where S.MediaId=M.MediaId)
		when 2 then (select AliasName from MMDrive D where D.MediaId=M.MediaId)
		else (select ExportLocation from MMExportLocation E where E.ExportLocationId=M.ExportLocationId) end),
	slotId=(case MediaLocation when 1 then (select SlotId from MMSlot S where S.MediaId=M.MediaId) else 0 end),
	MS.numberOfMounts
INTO	#TEMP_MEDIA_LIST
FROM	MMMedia M join MMMediaSide MS on M.MediaId = MS.MediaId, #TEMP_SG_LIST T
WHERE	M.spareGroupId = T.spareGroupId AND IsInMediaGroup = 0
IF @lessThan > 0
	DELETE	#TEMP_SG_LIST
	WHERE	@lessThan <= (select count(*) from #TEMP_MEDIA_LIST where sgId=spareGroupId)
ELSE IF @option = 3
	DELETE	#TEMP_SG_LIST
	WHERE   lowWaterMark <= (select count(*) from #TEMP_MEDIA_LIST where sgId=spareGroupId)
--security check
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @spareGrpOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2049, 0, '#rptUserObjects'	-- 2049 = LIBRARY_ITEM
	DELETE #rptUserObjects
	WHERE clientGroupId <> 0 OR clientId <> 0 OR mediaAgentId <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0
	DELETE #TEMP_SG_LIST
	WHERE 0 = (select count(*) from #rptUserObjects where libraryId IN (0, Libid))
	DROP TABLE #rptUserObjects
END
UPDATE	#TEMP_SG_LIST
SET	mediaIn=(select count(*) from #TEMP_MEDIA_LIST where sgId=spareGroupId and MediaLocation IN (1,2)),
	mediaOut=(select count(*) from #TEMP_MEDIA_LIST where sgId=spareGroupId and MediaLocation NOT IN (1,2))
IF @includeMedia > 0 AND @formatId <> 3
 	SELECT	S.*, barcode, isnull(loc,''), numberOfMounts
 	FROM	#TEMP_SG_LIST S LEFT OUTER JOIN #TEMP_MEDIA_LIST ON sgId=spareGroupId
 	ORDER BY AliasName, SpareGroupName, MediaLocation, slotId, loc, barcode
 ELSE
 	SELECT	*, '', '',0
 	FROM	#TEMP_SG_LIST
 	ORDER BY AliasName, SpareGroupName
DROP TABLE #TEMP_SG_LIST
DROP TABLE #TEMP_MEDIA_LIST
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetScratchPoolMedia')
	delete from GxQscripts where name = 'RptGetScratchPoolMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetScratchPoolMedia')
	delete from GXDBVersions where aliasname = 'RptGetScratchPoolMedia'
GO

insert into GXDBVersions values(2, 'RptGetScratchPoolMedia',  '00010028020000040000', 'RptGetScratchPoolMedia', '00010028020000040000')
GO

