

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetSQLDBNamesByJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetSQLDBNamesByJob.sp,v $ $Id: rptGetSQLDBNamesByJob.sp,v 1.3.88.3 2018/03/22 03:15:34 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptGetSQLDBNamesByJob"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetSQLDBNamesByJob')
BEGIN
	print '>>> Drop Stored Procedure: rptGetSQLDBNamesByJob <<<'
	drop procedure rptGetSQLDBNamesByJob
END
IF EXISTS (select * from GxQscripts where name='rptGetSQLDBNamesByJob')
	delete from GxQscripts where name = 'rptGetSQLDBNamesByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetSQLDBNamesByJob')
	delete from GXDBVersions where aliasname = 'rptGetSQLDBNamesByJob'
GO
print '... Creating Procedure: rptGetSQLDBNamesByJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetSQLDBNamesByJob
  @i_ccId integer,
  @i_jobId integer,
  @i_dbNameOnly integer
AS
  DECLARE @o_Size BIGINT
  DECLARE @o_DBName NVARCHAR(255);
  DECLARE @o_FileName NVARCHAR(255);
  DECLARE @o_LogicalFileName NVARCHAR(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE	@aFileTbl	TABLE	(id int)
DECLARE	@dbFileTbl	TABLE	(id int)
DECLARE	@dbFileNameTbl	TABLE	(id int, name nvarchar(1024))
INSERT INTO @aFileTbl
SELECT	id
FROM	archFile
WHERE	jobId = @i_jobId AND commcellId = @i_ccId
INSERT INTO @dbFileTbl
SELECT	sqlDBBackupFileId
FROM	SQLArchiveInfo
WHERE	commcellId = @i_ccId AND aFileId in (select id from @aFileTbl)
IF @i_dbNameOnly = 0
BEGIN
	INSERT INTO @dbFileNameTbl
	SELECT	C.id, A.name
	FROM	SQLNames2 A, SQLNames B, SQLDBBackupInfo C
	WHERE	A.id = B.sqlId AND B.id = C.sqlNameId and C.id in (select id from @dbFileTbl)
	SELECT	0, name AS DatabaseFileName, '' AS PhysicalPath, '' AS LogicalName
	FROM	@dbFileNameTbl
	WHERE	id NOT IN (select sqldbBackupinfoid from sqlfilebackupinfo where sqlNamePhyId > 0)
	UNION
	SELECT	DISTINCT 0, D.name, P2.name, L2.name
	FROM @dbFileNameTbl D INNER JOIN sqlFileBackupInfo F ON F.sqlDbBackupInfoId = D.id
		INNER JOIN sqlNames P1 ON P1.id = F.sqlNamePhyId
		INNER JOIN sqlNames2 P2 ON P1.sqlId = P2.id
		INNER JOIN sqlNames L1 ON L1.id = F.sqlNameLogId
		INNER JOIN sqlNames2 L2 ON L1.sqlId = L2.id
END
ELSE
BEGIN
	SELECT	C.backup_size, A.name, '', ''
	FROM	SQLNames2 A, SQLNames B, SQLDBBackupInfo C
	WHERE	A.id = B.sqlId AND B.id = C.sqlNameId and C.id in (select id from @dbFileTbl)
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetSQLDBNamesByJob')
	delete from GxQscripts where name = 'RptGetSQLDBNamesByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetSQLDBNamesByJob')
	delete from GXDBVersions where aliasname = 'RptGetSQLDBNamesByJob'
GO

insert into GXDBVersions values(2, 'RptGetSQLDBNamesByJob',  '00010003008800030000', 'RptGetSQLDBNamesByJob', '00010003008800030000')
GO

