

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetSLAOfEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetSLAOfEntities.sp,v $ $Id: RptGetSLAOfEntities.sp,v 1.1.2.8 2020/12/19 05:12:19 junlu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptGetSLAOfEntities')
BEGIN
	print '>>> Drop Stored Procedure: RptGetSLAOfEntities <<<'
	drop procedure RptGetSLAOfEntities
END
IF EXISTS (select * from GxQscripts where name='RptGetSLAOfEntities')
	delete from GxQscripts where name = 'RptGetSLAOfEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetSLAOfEntities')
	delete from GXDBVersions where aliasname = 'RptGetSLAOfEntities'
GO
print '... Creating Procedure: RptGetSLAOfEntities'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptGetSLAOfEntities
  @i_EntityLevel INT = 1 -- 1-Client, 2-Agent, 3-Instance, 4-Backupset, 5-Subclient
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
/* temp table created by caller
CREATE TABLE #SLA_EntityInfo (
	clientId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT, -- entity IDs to set
	status INT, category INT, slaDays INT) -- values to return
*/
UPDATE	#SLA_EntityInfo
    SET appTypeId = ISNULL(appTypeId, 0), instanceId = ISNULL(instanceId, 0), backupsetId = ISNULL(backupsetId, 0), appId = 0
WHERE	appId IS NULL
CREATE TABLE #SLA_DBEntityInfo (
	clientId INT, appTypeId INT, instanceId INT, backupsetId INT, status INT, category INT, slaDays INT)
IF @i_EntityLevel IN (2,3,4) AND EXISTS (SELECT 1 FROM #SLA_EntityInfo WHERE appTypeId IN (3,5,22,61,79,80,104,128))
BEGIN
	INSERT	INTO #SLA_DBEntityInfo
	SELECT	T.clientId, T.appTypeId, T.instance, 0, MIN(T.status), MIN(T.category), MIN(T.slaDays)
	FROM	(
			SELECT	A.clientId, A.appTypeId, A.instance,
					CASE WHEN A.subclientStatus&(64|4096) > 0 THEN 1 ELSE 0 END AS isCmdLine,
					MIN(S.status) AS status,
					MIN(CASE WHEN S.category = 1 THEN 101 ELSE S.category END)%100 AS category,
					MIN(S.slaDays) AS slaDays
			FROM	#SLA_EntityInfo E
					INNER JOIN APP_Application A ON E.clientId = A.clientId AND E.appTypeId = A.appTypeId
						AND (E.instanceId <= 0 OR E.instanceId = A.instance)
						AND (E.backupsetId <= 0 OR E.backupsetId = A.backupset)
					INNER JOIN RptSLASubclient S ON A.id = S.appId AND S.status IN (1,2) AND S.fullJobsOnly = 0
			WHERE	A.appTypeId IN (3,5,22,61,79,80,104,128)
			GROUP BY A.clientId, A.appTypeId, A.instance,
					CASE WHEN A.subclientStatus&(64|4096) > 0 THEN 1 ELSE 0 END
			) T
	GROUP BY T.clientId, T.appTypeId, T.instance
END
IF @i_EntityLevel IN (2,3,4) AND EXISTS (SELECT 1 FROM #SLA_EntityInfo WHERE appTypeId IN (37,62,103,135))
BEGIN
	INSERT	INTO #SLA_DBEntityInfo
	SELECT	T.clientId, T.appTypeId, T.instance, T.backupset, MIN(T.status), MIN(T.category), MIN(T.slaDays)
	FROM	(
			SELECT	A.clientId, A.appTypeId, A.instance, A.backupset,
					CASE WHEN (A.subclientStatus&64 > 0 OR A.subclientStatus&4096 > 0 AND A.appTypeId <> 135)
					     THEN 1 ELSE 0 END AS isCmdLine,
					MIN(S.status) AS status,
					MIN(CASE WHEN S.category = 1 THEN 101 ELSE S.category END)%100 AS category,
					MIN(S.slaDays) AS slaDays
			FROM	#SLA_EntityInfo E
					INNER JOIN APP_Application A ON E.clientId = A.clientId AND E.appTypeId = A.appTypeId
						AND (E.instanceId <= 0 OR E.instanceId = A.instance)
						AND (E.backupsetId <= 0 OR E.backupsetId = A.backupset)
					INNER JOIN RptSLASubclient S ON A.id = S.appId AND S.status IN (1,2) AND S.fullJobsOnly = 0
			WHERE	A.appTypeId IN (37,62,103,135)
			GROUP BY A.clientId, A.appTypeId, A.instance, A.backupset,
					CASE WHEN (A.subclientStatus&64 > 0 OR A.subclientStatus&4096 > 0 AND A.appTypeId <> 135)
					     THEN 1 ELSE 0 END
			) T
	GROUP BY T.clientId, T.appTypeId, T.instance, T.backupset
END
IF @i_EntityLevel = 5 -- (appId)
BEGIN
	UPDATE	T SET status = S.status, category = S.category, slaDays = S.slaDays
	FROM	#SLA_EntityInfo T
			INNER JOIN RptSLASubclient S ON T.appId = S.appId AND S.fullJobsOnly = 0
END
ELSE
IF @i_EntityLevel = 1 -- (clientId)
BEGIN
	UPDATE	T SET status = C.status, category = C.category, slaDays = S.slaDays
	FROM	#SLA_EntityInfo T
			INNER JOIN RptSLAClient C ON T.clientId = C.clientId
			INNER JOIN (
				SELECT clientId, MIN(slaDays) AS slaDays FROM RptSLASubclient GROUP BY clientId
			) S ON T.clientId = S.clientId
	WHERE	C.days = -1 AND C.fullJobsOnly = 0
END
ELSE
IF @i_EntityLevel = 2 -- (clientId, appTypeId)
BEGIN
	UPDATE	T SET status = S.status, category = S.category, slaDays = S.slaDays
	FROM	#SLA_EntityInfo T
			INNER JOIN (
				SELECT	A.clientId, A.appTypeId, MAX(B.status) AS status,
						MIN(CASE WHEN B.category = 1 THEN 101 ELSE B.category END)%100 AS category,
						MIN(B.slaDays) AS slaDays
				FROM	#SLA_EntityInfo A
						INNER JOIN RptSLASubclient B ON A.clientId = B.clientId AND A.appTypeId = B.appTypeId AND B.status IN (1,2) AND B.fullJobsOnly = 0
				WHERE	A.appTypeId NOT IN (3,5,22,61,79,80,104,128, 37,62,103,135)
				GROUP BY A.clientId, A.appTypeId
			) S ON T.clientId = S.clientId AND T.appTypeId = S.appTypeId
	UPDATE	T SET status = S.status, category = S.category, slaDays = S.slaDays
	FROM	#SLA_EntityInfo T
			INNER JOIN (
				SELECT	A.clientId, A.appTypeId, MAX(B.status) AS status,
						MIN(CASE WHEN B.category = 1 THEN 101 ELSE B.category END)%100 AS category,
						MIN(B.slaDays) AS slaDays
				FROM	#SLA_EntityInfo A
						INNER JOIN #SLA_DBEntityInfo B ON A.clientId = B.clientId AND A.appTypeId = B.appTypeId
				GROUP BY A.clientId, A.appTypeId
			) S ON T.clientId = S.clientId AND T.appTypeId = S.appTypeId
END
ELSE
IF @i_EntityLevel = 3 -- (clientId, appTypeId, instanceId)
BEGIN
	UPDATE	T SET status = S.status, category = S.category, slaDays = S.slaDays
	FROM	#SLA_EntityInfo T
			INNER JOIN (
				SELECT	E.clientId, E.appTypeId, E.instanceId, MAX(B.status) AS status,
						MIN(CASE WHEN B.category = 1 THEN 101 ELSE B.category END)%100 AS category,
						MIN(B.slaDays) AS slaDays
				FROM	#SLA_EntityInfo E
						INNER JOIN APP_Application A ON E.clientId = A.clientId AND E.appTypeId = A.appTypeId
							AND E.instanceId = A.instance
						INNER JOIN RptSLASubclient B ON A.id = B.appId AND B.status IN (1,2) AND B.fullJobsOnly = 0
				WHERE	E.appTypeId NOT IN (3,5,22,61,79,80,104,128, 37,62,103,135)
				GROUP BY E.clientId, E.appTypeId, E.instanceId
			) S ON T.clientId = S.clientId AND T.appTypeId = S.appTypeId AND T.instanceId = S.instanceId
	UPDATE	T SET status = S.status, category = S.category, slaDays = S.slaDays
	FROM	#SLA_EntityInfo T
			INNER JOIN (
				SELECT	E.clientId, E.appTypeId, E.instanceId, MAX(B.status) AS status,
						MIN(CASE WHEN B.category = 1 THEN 101 ELSE B.category END)%100 AS category,
						MIN(B.slaDays) AS slaDays
				FROM	#SLA_EntityInfo E
						INNER JOIN #SLA_DBEntityInfo B ON E.clientId = B.clientId AND E.appTypeId = B.appTypeId
							AND E.instanceId = B.instanceId
				GROUP BY E.clientId, E.appTypeId, E.instanceId
			) S ON T.clientId = S.clientId AND T.appTypeId = S.appTypeId AND T.instanceId = S.instanceId
END
ELSE
IF @i_EntityLevel = 4 -- (clientId, appTypeId, instanceId, backupsetId)
BEGIN
	UPDATE	T SET status = S.status, category = S.category, slaDays = S.slaDays
	FROM	#SLA_EntityInfo T
			INNER JOIN (
				SELECT	E.clientId, E.appTypeId, E.instanceId, E.backupsetId, MAX(B.status) AS status,
						MIN(CASE WHEN B.category = 1 THEN 101 ELSE B.category END)%100 AS category,
						MIN(B.slaDays) AS slaDays
				FROM	#SLA_EntityInfo E
						INNER JOIN APP_Application A ON E.clientId = A.clientId AND E.appTypeId = A.appTypeId
							AND E.instanceId = A.instance AND E.backupsetId = A.backupset
						INNER JOIN RptSLASubclient B ON A.id = B.appId AND B.status IN (1,2) AND B.fullJobsOnly = 0
				WHERE	E.appTypeId NOT IN (3,5,22,61,79,80,104,128, 37,62,103,135)
				GROUP BY E.clientId, E.appTypeId, E.instanceId, E.backupsetId
			) S ON T.clientId = S.clientId AND T.appTypeId = S.appTypeId AND T.instanceId = S.instanceId AND T.backupsetId = S.backupsetId
	UPDATE	T SET status = S.status, category = S.category, slaDays = S.slaDays
	FROM	#SLA_EntityInfo T
			INNER JOIN #SLA_DBEntityInfo S ON T.clientId = S.clientId AND T.appTypeId = S.appTypeId
				AND T.instanceId = S.instanceId AND T.backupsetId = S.backupsetId
END
IF @i_EntityLevel = 5
	UPDATE	T SET status = 3, category = X.category, slaDays = CASE WHEN ISNULL(T.slaDays, 0) > 0 THEN T.slaDays ELSE X.slaDays END
	FROM	#SLA_EntityInfo T
			INNER JOIN RptSLAExclusion X ON T.clientId = X.clientId AND T.appId = X.appId
	WHERE	ISNULL(T.status, 0) IN (0,2)
IF @i_EntityLevel IN (4,5)
	UPDATE	T SET status = 3, category = X.category, slaDays = CASE WHEN ISNULL(T.slaDays, 0) > 0 THEN T.slaDays ELSE X.slaDays END
	FROM	#SLA_EntityInfo T
			INNER JOIN RptSLAExclusion X ON T.clientId = X.clientId AND T.appTypeId = X.appTypeId
				AND T.instanceId = X.instanceId AND T.backupsetId = X.backupsetId AND X.appId = 0
	WHERE	ISNULL(T.status, 0) IN (0,2)
IF @i_EntityLevel IN (3,4,5)
	UPDATE	T SET status = 3, category = X.category, slaDays = CASE WHEN ISNULL(T.slaDays, 0) > 0 THEN T.slaDays ELSE X.slaDays END
	FROM	#SLA_EntityInfo T
			INNER JOIN RptSLAExclusion X ON T.clientId = X.clientId AND T.appTypeId = X.appTypeId
				AND T.instanceId = X.instanceId AND X.backupsetId = 0
	WHERE	ISNULL(T.status, 0) IN (0,2)
IF @i_EntityLevel IN (2,3,4,5)
	UPDATE	T SET status = 3, category = X.category, slaDays = CASE WHEN ISNULL(T.slaDays, 0) > 0 THEN T.slaDays ELSE X.slaDays END
	FROM	#SLA_EntityInfo T
			INNER JOIN RptSLAExclusion X ON T.clientId = X.clientId AND T.appTypeId = X.appTypeId
				AND X.instanceId = 0
	WHERE	ISNULL(T.status, 0) IN (0,2)
IF @i_EntityLevel IN (1,2,3,4,5)
	UPDATE	T SET status = 3, category = X.category, slaDays = CASE WHEN ISNULL(T.slaDays, 0) > 0 THEN T.slaDays ELSE X.slaDays END
	FROM	#SLA_EntityInfo T
			INNER JOIN RptSLAExclusion X ON T.clientId = X.clientId AND X.appTypeId = 0
	WHERE	ISNULL(T.status, 0) IN (0,2)
IF EXISTS (SELECT 1 FROM #SLA_EntityInfo WHERE ISNULL(status, 0) = 0)
	UPDATE	T SET status = 3, category = 7, slaDays = 0
	FROM	#SLA_EntityInfo T
			INNER JOIN APP_Client C ON T.clientId = C.id AND C.status&(2|4) > 0
	WHERE	T.appTypeId <> 106 AND ISNULL(T.status, 0) IN (0,2)
IF EXISTS (SELECT 1 FROM #SLA_EntityInfo WHERE ISNULL(status, 0) = 0)
	UPDATE	#SLA_EntityInfo SET status = 3, category = 0, slaDays = 0
	WHERE	ISNULL(status, 0) = 0
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetSLAOfEntities')
	delete from GxQscripts where name = 'RptGetSLAOfEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetSLAOfEntities')
	delete from GXDBVersions where aliasname = 'RptGetSLAOfEntities'
GO

insert into GXDBVersions values(2, 'RptGetSLAOfEntities',  '00010001000200080000', 'RptGetSLAOfEntities', '00010001000200080000')
GO

