

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetSLAConfigurationOfEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetSLAConfigurationOfEntity.sp,v $ $Id: RptGetSLAConfigurationOfEntity.sp,v 1.1.2.4 2020/09/17 18:31:02 samrutkar Exp $";
--	+===============================================================================+
--	|  							RptGetSLAConfigurationOfEntity								|
--	|																				|
--  |  PARAMETERS			  														|
--  |    i_userId	  = id of the requestor											|
--  |    x_xmlData	  = input Api_SLAOptions request xml							|
--	|					output App_GenericResp xml									|
--	+===============================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetSLAConfigurationOfEntity')
BEGIN
	print '>>> Drop Stored Procedure: RptGetSLAConfigurationOfEntity <<<'
	drop procedure RptGetSLAConfigurationOfEntity
END
IF EXISTS (select * from GxQscripts where name='RptGetSLAConfigurationOfEntity')
	delete from GxQscripts where name = 'RptGetSLAConfigurationOfEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetSLAConfigurationOfEntity')
	delete from GXDBVersions where aliasname = 'RptGetSLAConfigurationOfEntity'
GO
print '... Creating Procedure: RptGetSLAConfigurationOfEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetSLAConfigurationOfEntity
  @xml XML OUTPUT 
AS
DECLARE @errorCode                  INT = 0,
        @errorString                NVARCHAR(1024) = '',
		@entityType					INT  = 0,
		@slaDays					INT = 0,
		@entityId					INT = 0,
		@excludeFromSLA				INT = 0,
		@exludedReason				NVARCHAR(MAX) ='',
		@reIncludeSLAInterval		INT = 0,
		@useSystemDefaultSLA		INT = 0,
		@inheritedEntityType		INT = 0,
		@inheritedEntityExcluded	INT = 0,
		@inheritedEntitySLADays		INT = 0
SELECT @entityType = ISNULL(csInfo.n.value('@_type_','INT'),0)
FROM @xml.nodes('/App_GetSLAPropertyReq/entities/entity') AS csInfo(n)
IF (@entityType = 0)
BEGIN
	 SET @errorCode = 1
     SET @errorString = N'Invalid Entity Type.'
END
IF @errorCode <> 0
    GOTO ERROR_EXIT
IF (@entityType = 1 /* COMMCELL_ENTITY */)
BEGIN
	SELECT @slaDays = longVal
	FROM    APP_ComponentProp WITH (NOLOCK)
WHERE   componentType = 1 AND componentId = 2 AND propertyTypeId = 3300
    AND  modified = 0
	IF (@slaDays = 0)
SET @slaDays = 30
END
IF (@entityType = 28 /*  CLIENT_GROUP_ENTITY = 28 */)
BEGIN
	SELECT @entityId = csInfo.n.value('@clientGroupId','INT')
	FROM @xml.nodes('/App_GetSLAPropertyReq/entities/entity') AS csInfo(n)
	SELECT @slaDays = longVal
	FROM    APP_ComponentProp WITH (NOLOCK)
WHERE   componentType = 8 AND propertyTypeId = 3300
    AND modified = 0
	AND componentId = @entityId
	SELECT @excludeFromSLA=  ISNULL(longVal,0)
	FROM    APP_ComponentProp WITH (NOLOCK)
WHERE   componentType = 8 AND propertyTypeId = 3301
    AND modified = 0 AND componentId = @entityId
	SELECT @exludedReason=  ISNULL(stringVal,'')
	FROM    APP_ComponentProp WITH (NOLOCK)
WHERE   componentType = 8 AND propertyTypeId = 3326
    AND modified = 0 AND componentId = @entityId
	SELECT @reIncludeSLAInterval=  ISNULL(longVal,0)
	FROM    APP_ComponentProp WITH (NOLOCK)
WHERE   componentType = 8 AND propertyTypeId = 3325
    AND modified = 0 AND componentId = @entityId
	SELECT @useSystemDefaultSLA=  ISNULL(longVal,0)
	FROM    APP_ComponentProp WITH (NOLOCK)
WHERE   componentType = 8 AND propertyTypeId = 3327
    AND modified = 0 AND componentId = @entityId
	SELECT @inheritedEntitySLADays = longVal
	FROM    APP_ComponentProp WITH (NOLOCK)
WHERE   componentType = 1 AND componentId = 2 AND propertyTypeId = 3300
    AND  modified = 0
	IF (@inheritedEntitySLADays = 0)
SET @inheritedEntitySLADays = 30
	SET @inheritedEntityType = 0 -- EntityType_CommCell
END
IF (@entityType = 3 /*  CLIENT_ENTITY = 3,*/)
BEGIN
	SELECT @entityId = csInfo.n.value('@clientId','INT')
		FROM @xml.nodes('/App_GetSLAPropertyReq/entities/entity') AS csInfo(n)
	SELECT @excludeFromSLA=  ISNULL(attrVal,0)
	FROM    App_clientprop WITH (NOLOCK)
	where attrname = 'Exclude from SLA'
    AND modified = 0 AND componentNameId = @entityId
	SELECT @exludedReason =  ISNULL(attrVal,0)
	FROM    App_clientprop WITH (NOLOCK)
	where attrname = 'Exclude From SLA Reason'
	AND modified = 0 AND componentNameId = @entityId
	DECLARE @SLADaysForClient INT = 0,
	@ExcludedFromSLAForClient INT = 0,
	@systemDefaultSLAClient INT = 0
	SELECT
	@systemDefaultSLAClient = CAST(P.attrVal AS INT)
    FROM    APP_PlanProp P WITH (NOLOCK)
            INNER JOIN APP_ClientProp C WITH (NOLOCK) ON P.componentNameId = CAST(C.attrVal AS INT)
WHERE   P.attrName = 'SLA option' AND P.attrVal = '1' AND P.modified = 0
AND C.attrName =  'Associated Plan' AND C.modified = 0 AND C.componentNameId = @entityId
	IF (ISNULL(@systemDefaultSLAClient,0) = 0)
	SELECT
	@SLADaysForClient = CAST(P.attrVal AS INT)
    FROM    APP_PlanProp P WITH (NOLOCK)
            INNER JOIN APP_ClientProp C WITH (NOLOCK) ON P.componentNameId = CAST(C.attrVal AS INT)
WHERE   P.attrName = 'SLA option in days' AND P.attrVal <> '0' AND P.modified = 0
AND C.attrName = 'Associated Plan' AND C.modified = 0 AND C.componentNameId = @entityId
	SELECT @ExcludedFromSLAForClient = CAST(P.attrVal AS INT)
	FROM    APP_PlanProp P WITH (NOLOCK)
            INNER JOIN APP_ClientProp C WITH (NOLOCK) ON P.componentNameId = CAST(C.attrVal AS INT)
WHERE   P.attrName = 'SLA option excluded' AND P.attrVal <> '0' AND P.modified = 0
AND C.attrName = 'Associated Plan' AND C.modified = 0 AND C.componentNameId = @entityId
	SET @inheritedEntityType = 28 -- Plan
	IF (ISNULL(@SLADaysForClient,0) = 0 AND ISNULL(@ExcludedFromSLAForClient,0) = 0)
	BEGIN
		IF OBJECT_ID('tempdb..#ClientGroupSLA') IS NOT NULL DROP TABLE #ClientGroupSLA
		CREATE TABLE #ClientGroupSLA (clientGroupId INT, SlaDays INT)
		INSERT INTO #ClientGroupSLA
		SELECT DISTINCT Ap.componentId,AP.longVal
		FROM    APP_ComponentProp AP WITH (NOLOCK)
				INNER JOIN App_clientgroupAssoc AGA WITH (NOLOCK) ON AP.componentId = AGA.clientGroupId
AND   AP.componentType = 8 AND AP.propertyTypeId = 3300 AND AGA.clientId = @entityId
				AND AP.modified = 0
		DELETE TCG FROM #ClientGroupSLA TCG
		INNER JOIN APP_ComponentProp P WITH (NOLOCK) ON P.componentId = TCG.clientGroupId
WHERE   P.componentType = 8 AND P.propertyTypeId = 3327
		AND P.modified = 0 AND P.longVal = '1'
		IF NOT EXISTS (select clientGroupId from #ClientGroupSLA)
		SELECT @systemDefaultSLAClient=  1
		SELECT @SLADaysForClient = T.slaDays
		FROM (SELECT AP.slaDays , AP.clientGroupId , ROW_NUMBER() OVER (PARTITION BY @entityId ORDER BY AP.slaDays) AS rowId
		FROM    #ClientGroupSLA AP WITH (NOLOCK)) T
		WHERE   T.rowId = 1
		IF OBJECT_ID('tempdb..#ClientGroupSLA') IS NOT NULL DROP TABLE #ClientGroupSLA
		SELECT @ExcludedFromSLAForClient = longVal
		FROM    APP_ComponentProp AP WITH (NOLOCK)
				INNER JOIN App_clientgroupAssoc AGA WITH (NOLOCK) ON AP.componentId = AGA.clientGroupId
WHERE   AP.componentType = 8 AND AP.propertyTypeId = 3301
					AND AP.modified = 0 AND AGA.clientId = @entityId AND AP.longVal = 1
		SET @inheritedEntityType = 4 -- ClientGroup
	END
	IF (ISNULL(@SLADaysForClient,0) = 0 AND ISNULL(@ExcludedFromSLAForClient,0) = 0)
	BEGIN
		SELECT @SLADaysForClient = longVal
			FROM    APP_ComponentProp WITH (NOLOCK)
WHERE   componentType = 1 AND componentId = 2 AND propertyTypeId = 3300
			AND  modified = 0
		IF (@SLADaysForClient = 0)
SET @SLADaysForClient = 30
		SET @inheritedEntityType = 0 -- EntityType_CommCell
	END
	SET @inheritedEntitySLADays = @SLADaysForClient
	SET @inheritedEntityExcluded = @ExcludedFromSLAForClient
END
IF (@entityType = 7 /*  SUBCLIENT_ENTITY = 7,*/)
BEGIN
	SELECT @entityId = csInfo.n.value('@subclientId','INT')
		FROM @xml.nodes('/App_GetSLAPropertyReq/entities/entity') AS csInfo(n)
	SELECT @excludeFromSLA=  ISNULL(attrVal,0)
	FROM    App_subclientprop WITH (NOLOCK)
	where attrname = 'Exclude from SLA'
    AND modified = 0 AND componentNameId = @entityId
	SELECT @exludedReason =  ISNULL(attrVal,0)
	FROM    App_subclientprop WITH (NOLOCK)
	where attrname = 'Exclude From SLA Reason'
	AND modified = 0 AND componentNameId = @entityId
	DECLARE @ExcludeFromSLAInherited INT  = 0
	SELECT @ExcludeFromSLAInherited = P.attrVal
    FROM    APP_PlanProp P WITH (NOLOCK)
            INNER JOIN APP_SubClientProp S WITH (NOLOCK) ON P.componentNameId = CAST(S.attrVal AS INT)
WHERE   P.attrName = 'SLA option excluded' AND P.attrVal <> '0' AND P.modified = 0
			AND S.componentNameId = @entityId
AND S.cs_attrName = CHECKSUM(N'Associated Plan') AND S.attrName LIKE 'Associated Plan' AND S.modified = 0
	IF (@ExcludeFromSLAInherited = 0)
	SELECT  @ExcludeFromSLAInherited = P.attrVal
    FROM    APP_PlanProp P WITH (NOLOCK)
            INNER JOIN APP_BackupsetProp S WITH (NOLOCK) ON P.componentNameId = CAST(S.attrVal AS INT)
            INNER JOIN APP_Application A WITH (NOLOCK) ON S.componentNameId = A.backupset AND A.backupset > 1
			AND A.id = @entityId
WHERE   P.attrName = 'SLA option excluded' AND P.attrVal <> '0' AND P.modified = 0
AND S.attrName LIKE 'Associated Plan' AND S.modified = 0
	IF (@ExcludeFromSLAInherited = 0)
	SELECT  @ExcludeFromSLAInherited = P.attrVal
    FROM    APP_PlanProp P WITH (NOLOCK)
            INNER JOIN APP_ClientProp C WITH (NOLOCK) ON P.componentNameId = CAST(C.attrVal AS INT)
WHERE   P.attrName = 'SLA option excluded' AND P.attrVal <> '0' AND P.modified = 0
AND C.attrName LIKE 'Associated Plan' AND C.modified = 0
	IF (@ExcludeFromSLAInherited = 1)
		 SET @inheritedEntityType = 28 -- EntityType_Plan
	ELSE
	IF (@ExcludeFromSLAInherited = 0)
	BEGIN
		SELECT @ExcludeFromSLAInherited = ACP.attrVal
		FROM    App_clientprop ACP WITH (NOLOCK)
		INNER JOIN App_Application AP WITH (NOLOCK)
		ON AP.clientId = ACP.componentNameId and AP.Id = @entityId
		WHERE ACP.attrname = 'Exclude from SLA' AND ACP.attrVal = '1' and ACP.modified = 0
		IF (@ExcludeFromSLAInherited = 1)
		SET @inheritedEntityType = 1 -- EntityType_Client
	END
	ELSE
	IF (@ExcludeFromSLAInherited = 0)
	BEGIN
		SELECT @ExcludeFromSLAInherited = ACP.longVal
		FROM    APP_ComponentProp ACP WITH (NOLOCK)
		INNER JOIN APP_ClientGroupAssoc ACG WITH (NOLOCK)
		ON ACG.clientGroupId = ACP.componentId
		INNER JOIN App_Application AP WITH (NOLOCK)
		ON AP.clientId = ACG.clientId and AP.Id = @entityId
		WHERE componentType = 8 AND propertyTypeId = 3301   and ACP.modified = 0 -- CV_COMPONENT_CG_EXCLUDE_FROM_SLA
		IF (@ExcludeFromSLAInherited = 1)
		SET @inheritedEntityType = 4 -- EntityType_ClientGroup
	END
	--Calculate SLA Days
	IF (@ExcludeFromSLAInherited = 0)
	BEGIN
		DECLARE @clientId INT,@appTypeId INT
		SELECT @clientId = clientId,@appTypeId = appTypeId from App_Application AP WITH(NOLOCK)
		WHERE AP.Id = @entityId
		SELECT  @inheritedEntitySLADays = slaDays, @inheritedEntityType =
		CASE	WHEN slaDaysLevel like '%Plan' THEN 28
				WHEN slaDaysLevel = 'Client Group' THEN 4
				WHEN slaDaysLevel = 'CommCell' THEN 0
		 END
		 from dbo.GetSLADays (@clientId,@appTypeId, @entityId)
	END
	SET @inheritedEntityExcluded = @ExcludeFromSLAInherited
END
ERROR_EXIT:
	DECLARE @errResponse XML
	SET @errResponse= (SELECT @errorCode as '@errorCode' , @errorString as '@errorMessage' FOR XML PATH('errorResp')    )
	DECLARE @inheritedSLA XML
	SET @inheritedSLA = '<inheritedSLA excludeFromSLA="'+CAST (@inheritedEntityExcluded AS VARCHAR(8))+'" slaDays="'+CAST (@inheritedEntitySLADays AS VARCHAR(8))+'" entityType= "'+CAST (@inheritedEntityType AS VARCHAR(8))+'" />'
    SET @xml =
			'<WebReport_GetSLAPropertyResp><entities excludeFromSLA="'+CAST(@excludeFromSLA AS NVARCHAR(8))+'" excludedReason="'+CAST(@exludedReason AS NVARCHAR(MAX))
			+'" slaDays="'+CAST(@slaDays AS NVARCHAR(16))+'" useSystemDefaultSLA="'+CAST(@useSystemDefaultSLA AS NVARCHAR(8))+'" delayInterval="'+CAST(@reIncludeSLAInterval AS NVARCHAR(16))+'" >'
			+CAST (@xml.query('/WebReport_GetSLAPropertyReq/entities/entity') AS NVARCHAR(MAX))+' '+CAST(@inheritedSLA AS NVARCHAR(MAX))+'</entities>'
			+CAST (@errResponse AS NVARCHAR(1024))+'</WebReport_GetSLAPropertyResp>'
SELECT @xml AS xml

IF EXISTS (select * from GxQscripts where name = 'RptGetSLAConfigurationOfEntity')
	delete from GxQscripts where name = 'RptGetSLAConfigurationOfEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetSLAConfigurationOfEntity')
	delete from GXDBVersions where aliasname = 'RptGetSLAConfigurationOfEntity'
GO

insert into GXDBVersions values(2, 'RptGetSLAConfigurationOfEntity',  '00010001000200040000', 'RptGetSLAConfigurationOfEntity', '00010001000200040000')
GO

