

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetSIStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetSIStore.sp,v $ $Id: RptGetSIStore.sp,v 1.57.66.10 2019/02/20 21:33:05 pnara Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetSIStore"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetSIStore')
BEGIN
	print '>>> Drop Stored Procedure: RptGetSIStore <<<'
	drop procedure RptGetSIStore
END
IF EXISTS (select * from GxQscripts where name='RptGetSIStore')
	delete from GxQscripts where name = 'RptGetSIStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetSIStore')
	delete from GXDBVersions where aliasname = 'RptGetSIStore'
GO
print '... Creating Procedure: RptGetSIStore'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetSIStore
  @i_policyIdsXml xml
AS
  DECLARE @o_policyId integer;
  DECLARE @o_policyName NVARCHAR(255);
  DECLARE @o_copyId integer;
  DECLARE @o_copyName NVARCHAR(255);
  DECLARE @o_copyFlags integer;
  DECLARE @o_dedupeFlags integer;
  DECLARE @o_SIDBStoreId integer;
  DECLARE @o_SIDBStoreName NVARCHAR(255);
  DECLARE @o_NumOfPartitions integer;
  DECLARE @o_clientName NVARCHAR(255);
  DECLARE @o_accessPath varchar(255);
  DECLARE @o_SIDBStoreFlags integer
  DECLARE @o_CreatedTime integer
  DECLARE @o_LastDDBBackupJobId integer
  DECLARE @o_LastDDBBackupTime integer
  DECLARE @o_LastRecoveryTime integer
  DECLARE @o_SealedTime integer
  DECLARE @o_SealedReason integer
  DECLARE @o_sizeOfApplication bigint;
  DECLARE @o_sizeOfStore bigint;
  DECLARE @o_sizeOfNotSiloedData bigint;
  DECLARE @o_sizeOfSiloedData bigint;
  DECLARE @o_sizeOffDisk bigint;
  DECLARE @o_sizeOfSIDB bigint;
  DECLARE @o_retainUntil bigint;
  DECLARE @o_retainedByJobId integer;
  DECLARE @o_SizeForBaseline bigint;
  DECLARE @o_AppSizeToBeFreed bigint;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @MAXINT	INT
SET		@MAXINT = 0x7FFFFFFF
DECLARE @tblPolicy		TABLE (policyId int)
INSERT	INTO @tblPolicy
SELECT	T.c.value('@policyId', 'int')
FROM	@i_policyIdsXml.nodes('/r/h') T(c)
CREATE	TABLE #SICopy(
		copyId INT, dedupeFlags INT
		)
CREATE	TABLE #SIStore(
		CopyId INT, SIDBStoreId INT,
		sizeOfApplication BIGINT, SizeOfStoreMB BIGINT, SizeToBeInSiloMB BIGINT, SizeInSiloMB BIGINT, SizeOffDiskMB BIGINT,
		RetainUntil BIGINT, RetainedByJobId INT, baseLineSize BIGINT, AppSizeToFree BIGINT
		)
CREATE	TABLE #SIJob(
		jobId INT, commCellId INT, SIDBStoreId INT, copyId INT, appId INT, backupLevel INT,
		startTime INT, retentionDays BIGINT, retentionFlags INT, retainUntil BIGINT, totalBackupSize BIGINT, totalAppSize BIGINT
		)
CREATE	TABLE #SIAppSizeToFree(
		SIDBStoreId INT, sizeOfApplication BIGINT
		)
CREATE	TABLE #AgingRules(
		copyId INT, retentionDays INT, archiverRetDays INT
		)
CREATE	TABLE #AgingRulesExt(
		copyId INT, retentionDays INT, retentionRule INT
		)
IF EXISTS (SELECT policyId FROM @tblPolicy)
	INSERT	INTO #SICopy
	SELECT	DISTINCT C.id, C.dedupeFlags
	FROM	@tblPolicy P
			INNER JOIN archGroupCopy C ON C.archGroupId = P.policyId
WHERE	(C.dedupeFlags & 262144) <> 0
ELSE
	INSERT	INTO #SICopy
	SELECT	DISTINCT AGC.id, AGC.dedupeFlags
	FROM	archGroupCopy AGC
WHERE	(AGC.dedupeFlags & 262144) <> 0
INSERT	INTO #SICopy
SELECT	DISTINCT GDSPC.id, GDSPC.dedupeFlags
FROM	#SICopy C
		INNER JOIN archCopyToGlobalPolicy GP ON C.CopyId = GP.CopyId
INNER JOIN archGroup GDSP ON GDSP.id = GP.globalPolicyId AND ((GDSP.Flags & 256 /*CVA_SP_GLOBAL_DEDUP_FLAG*/) > 0)
		INNER JOIN archGroupCopy GDSPC ON GDSP.defaultCopy = GDSPC.id
WHERE	((C.dedupeFlags & 134217728) <> 0)
		AND NOT EXISTS (SELECT copyId FROM  #SICopy WHERE copyId = GDSPC.id)
DELETE	#SICopy
WHERE	(dedupeFlags & 134217728) <> 0
INSERT	INTO #SIStore
SELECT	S.CopyId, S.SIDBStoreId, 0,
		SUM(CAST(PhysicalBytesMB AS BIGINT)),
		SUM(CASE WHEN SiloStatus = 1 THEN CAST(PhysicalBytesMB AS BIGINT) ELSE 0 END),
		SUM(CASE WHEN SiloStatus = 2 THEN CAST(PhysicalBytesMB AS BIGINT) ELSE 0 END),
		SUM(CASE WHEN SiloStatus = 3 THEN CAST(PhysicalBytesMB AS BIGINT) ELSE 0 END),
		0, 0, 0, 0
FROM	#SICopy C
INNER JOIN archCopySIDBStore S ON S.CopyId = C.copyId AND (C.dedupeFlags & 134217728) = 0
		INNER JOIN MMVolume V ON V.SIDBStoreId = S.SIDBStoreId AND V.PhysicalBytesMB > 0 AND (V.Attributes & 512) = 0
GROUP BY S.CopyId, S.SIDBStoreId
INSERT	INTO #SIStore
SELECT	S.CopyId, S.SIDBStoreId, 0, 0, 0, 0, 0, 0, 0, 0, 0
FROM	#SICopy C
INNER JOIN archCopySIDBStore S ON S.CopyId = C.copyId AND (C.dedupeFlags & 134217728) = 0
		LEFT OUTER JOIN #SIStore T ON S.CopyId = T.copyId AND S.SIDBStoreId = T.SIDBStoreId
WHERE	T.SIDBStoreId IS NULL
INSERT INTO #SIJob
SELECT	AF.jobId, AF.commCellId, AFD.SIDBStoreId, AFD.archCopyId, AF.appId, AF.backupLevel, MIN(AF.cTime), 0, 0, 0, SUM(ACM.physicalSize),
		(CASE WHEN MIN(ACM.unCompSize) = -1 THEN -1 ELSE SUM(ACM.unCompSize) END)
FROM	archFile AF, archFileCopyDedup AFD, archChunkMapping ACM WITH (NOLOCK), #SIStore S
WHERE	AF.id = AFD.archFileId AND AF.commCellId = AFD.commCellId AND AF.isValid = 1
	AND AFD.SIDBStoreId = S.SIDBStoreId
	AND AFD.archFileId = ACM.archFileId AND AFD.commCellId = ACM.commCellId AND ACM.archCopyId = AFD.archCopyId
AND (ACM.flags & 256) = 0
GROUP BY AF.jobId, AF.commCellId, AFD.SIDBStoreId, AFD.archCopyId, AF.appId, AF.backupLevel
CREATE INDEX #SIJob_SIDBStoreId_idx ON #SIJob (SIDBStoreId)
CREATE TABLE #tmpJobSizeInfo (
			  JobId INT, CommCellId INT, totalBackupSize BIGINT, totalAppSize BIGINT, totalIndexSize BIGINT
			  PRIMARY KEY (JobId, CommCellId))
INSERT INTO #tmpJobSizeInfo
SELECT  DISTINCT jobId, CommCellId, 0, 0, 0
FROM    #SIJob
WHERE   totalAppSize = -1
EXEC  archGetJobSizeInfo 0
UPDATE #SIJob
SET     #SIJob.totalAppSize = (CASE WHEN J.totalBackupSize > 0 THEN CAST(((1.0 * (J.totalAppSize+J.totalIndexSize)*#SIJob.totalBackupSize)/J.totalBackupSize) AS BIGINT) ELSE #SIJob.totalBackupSize END)
FROM    #tmpJobSizeInfo J
WHERE   #SIJob.JobId = J.JobId
		AND #SIJob.CommCellId = J.CommCellId
		AND #SIJob.totalAppSize = -1
UPDATE 	S
SET		sizeOfApplication = totalAppSize
FROM	#SIStore S,
		(
			SELECT	SIDBStoreId, SUM(totalAppSize) totalAppSize
			FROM	#SIJob
			GROUP BY SIDBStoreId
		) T
WHERE	S.SIDBStoreId = T.SIDBStoreId
-- The baseline size is not the actual total size of distinct data blocks of a store.
-- It is the estimated size that is required on the disk for backup data when the existing deduplication database is sealed.
-- Calculate baseline size of store as same as shown in Deduplication Engine Properties.
-- The calculation may not be correct for IndexBackup subclients.
IF object_id('tempdb.dbo.#SIAppID') is not null DROP TABLE #SIAppID
IF object_id('tempdb.dbo.#tblAppID') is not null DROP TABLE #tblAppID
CREATE TABLE #SIAppID(
  SIDBStoreId INT, appId INT, archGrpId INT
)
CREATE TABLE #tblAppID(
  appId INT, MaxFullJobId INT, BaseLineSize BIGINT,
  primary key (appId)
)
--
-- Get associated subclients to calculate baseline
--
INSERT  INTO #SIAppID
SELECT  B.SIDBStoreId, A.appId, A.archGrpId
FROM    JMJobDatastats A WITH (READUNCOMMITTED),
		archSubclientCopyDDBMap ACS WITH (READUNCOMMITTED), #SIStore B
WHERE   ACS.SIDBStoreId = B.SIDBStoreId
		AND A.appId = ACS.appId
		AND A.status IN (100, 101, 102, 103)
		AND (A.disabled & (1 + 256)) = 0
GROUP BY B.SIDBStoreId, A.appId, A.archGrpId
INSERT  INTO #tblAppID
SELECT  A.id, 0, 0
FROM    APP_Application A WITH (READUNCOMMITTED), #SIAppID S
WHERE   S.appId = A.id
		AND (S.archGrpId = A.dataArchGrpID OR S.archGrpId = A.logArchGrpID)
GROUP BY A.id
UPDATE  A
SET     MaxFullJobID = T.MaxFullJobID
FROM    #tblAppID A,
		(
			SELECT  A.appId, MAX(BS.jobId) MaxFullJobID
			FROM    JMBkpStats BS WITH (NOLOCK), #tblAppID A
			WHERE   BS.bkpLevel IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000)
					AND BS.status IN (1, 3, 14)
					AND BS.appId = A.appId
			GROUP BY A.appId
		) T
WHERE   A.appId = T.appId
UPDATE  A
SET     BaseLineSize = BS.totalBackupSize
FROM    JMBkpStats BS WITH (READUNCOMMITTED), #tblAppID A
WHERE   BS.appId = A.appId
		AND BS.jobId = A.MaxFullJobID
--
-- Set baseline size for Stores
--
UPDATE  S
SET     baseLineSize = B.baseLineSize * 1.2
FROM    #SIStore S,
		(
			SELECT  SA.SIDBStoreId,
					SUM(A.baseLineSize) baseLineSize
			FROM    #tblAppID A, (SELECT DISTINCT SIDBStoreId, appId FROM #SIAppID) SA
			WHERE   A.appId = SA.appId
			GROUP BY SA.SIDBStoreId
		) B
WHERE   S.SIDBStoreId = B.SIDBStoreId
IF object_id('tempdb.dbo.#SIAppID') is not null DROP TABLE #SIAppID
IF object_id('tempdb.dbo.#tblAppID') is not null DROP TABLE #tblAppID
INSERT INTO #SIAppSizeToFree
SELECT	SIDBStoreId, SUM(ISNULL(appSizeFreedBytes,0))
FROM	MMDeletedAF
WHERE	SIDBStoreId > 0
GROUP BY SIDBStoreId
UPDATE	#SIStore
SET		AppSizeToFree = #SIAppSizeToFree.SizeOfApplication
FROM	#SIAppSizeToFree
WHERE	#SIStore.SIDBStoreId = #SIAppSizeToFree.SIDBStoreId
-- Get store retention time and retained-by jobId
UPDATE	#SIJob
SET		retentionFlags = J.retentionFlags, retainUntil = J.manualRetentionEndTime
FROM	JMJobDataStats J WITH (NOLOCK)
WHERE	J.jobId = #SIJob.jobId AND J.commCellId = #SIJob.commCellId AND J.archGrpCopyId = #SIJob.copyId
AND (J.disabled & 256) = 0 AND (J.retentionFlags > 0 OR J.manualRetentionEndTime > 0)
INSERT	INTO #AgingRules
SELECT	AR.copyId,
		(case when AR.retentionDays < 0 then @MAXINT else AR.retentionDays end),
		(case when AR.archiverRetDays < 0 then @MAXINT else AR.archiverRetDays end)
FROM	archAgingRule AR WITH (NOLOCK), #SICopy C
WHERE	AR.copyId = C.copyId
UPDATE	#SIJob
SET		retentionDays = (CASE WHEN T.isDMAppType = 1 THEN AR.archiverRetDays ELSE AR.retentionDays END)
FROM	#AgingRules AR,
		(SELECT A.appId, ISNULL(C.isDMAppType, 0) AS isDMAppType
		FROM	(SELECT DISTINCT appId FROM #SIJob) A
				INNER JOIN APP_Application B WITH (NOLOCK) ON B.id = A.appId
				LEFT OUTER JOIN APP_IDATypeHandlingInfo C WITH (NOLOCK) ON C.appTypeId = B.appTypeId) T
WHERE	#SIJob.copyId = AR.copyId AND #SIJob.appId = T.appId
INSERT	INTO #AgingRulesExt
SELECT	ARE.copyId, (CASE WHEN ARE.retentionDays < 0 THEN @MAXINT ELSE ARE.retentionDays END), ARE.retentionRule
FROM	archAgingRuleExtended ARE WITH (NOLOCK), #SICopy T
WHERE	ARE.copyId = T.copyId
CREATE TABLE #SIJobExtRet (jobId INT, commCellId INT, copyId INT, retentionDays INT)
INSERT	INTO #SIJobExtRet
SELECT	J.jobId, J.commCellId, J.copyId, MAX(ARE.retentionDays)
FROM	#SIJob J INNER JOIN #AgingRulesExt ARE ON J.copyId = ARE.copyId AND J.retentionFlags > 0 AND J.retainUntil <> -1
WHERE	(J.retentionFlags & ARE.retentionRule) > 0
GROUP BY J.jobId, J.commCellId, J.copyId
UPDATE	J SET retentionDays = T.retentionDays
FROM	#SIJob J INNER JOIN #SIJobExtRet T ON J.copyId = T.copyId AND J.jobId = T.jobId AND J.commCellId = T.commCellId
WHERE	J.retentionDays < @MAXINT
DROP TABLE #SIJobExtRet
UPDATE	#SIJob
SET		retainUntil = (CASE WHEN retentionDays = @MAXINT THEN @MAXINT ELSE (startTime + retentionDays*24*3600) END)
WHERE	retainUntil < @MAXINT
UPDATE	#SIStore
SET		RetainUntil = (CASE WHEN T.retainUntil = @MAXINT THEN -1 ELSE T.retainUntil END),
		RetainedByJobId = T.jobId
FROM	(SELECT SIDBStoreId, jobId, retainUntil, ROW_NUMBER() OVER (PARTITION BY SIDBStoreId ORDER BY retainUntil DESC, jobId ASC) AS RowNo
		FROM #SIJob) T
WHERE	#SIStore.SIDBStoreId = T.SIDBStoreId AND T.RowNo = 1
IF object_id('tempdb.dbo.#SIAppSizeToFree') is not null DROP TABLE #SIAppSizeToFree
IF object_id('tempdb.dbo.#SIJob') is not null DROP TABLE #SIJob
IF object_id('tempdb.dbo.#SICopy') is not null DROP TABLE #SICopy
IF object_id('tempdb.dbo.#AgingRules') is not null DROP TABLE #AgingRules
IF object_id('tempdb.dbo.#AgingRulesExt') is not null DROP TABLE #AgingRulesExt
IF object_id('tempdb.dbo.#tmpJobSizeInfo') is not null DROP TABLE #tmpJobSizeInfo
SELECT	C.archGroupId, PolicyName = (SELECT name FROM archGroup WHERE id = C.archGroupId),
		T.CopyId, CopyName = C.name, CopyFlags = C.flags, C.dedupeFlags,
		S.SIDBStoreId, S.SIDBStoreName,
		NumOfPartitions = (SELECT COUNT(SubStoreId) FROM IdxSIDBSubStore WHERE SIDBStoreId = T.SIDBStoreId),
		ClientName = (SELECT displayName FROM APP_Client WHERE id = AP.clientId), AccessPath = AP.path,
		S.Flags, S.CreatedTime, SS.LastSnapJobId, SS.LastSnapTime,
		LastRecoveryTime = ISNULL((SELECT MAX(EndTime) FROM IdxSIDBRecoveryHistory
									WHERE SIDBStoreId = SS.SIDBStoreId AND SubStoreId = SS.SubStoreId AND Status = 1), 0),
		S.SealedTime, S.SealedReason,
		T.SizeOfApplication, SizeOfStore = T.SizeOfStoreMB*1024*1024,
		SizeToBeInSilo = T.SizeToBeInSiloMB*1024*1024,
		SizeInSilo = (T.SizeInSiloMB + T.SizeOffDiskMB)*1024*1024,
		SizeOffDisk = T.SizeOffDiskMB*1024*1024,
		SizeOfSIDB = CAST(IC.DiskUsageMB AS BIGINT)*1024*1024,
		T.RetainUntil, T.RetainedByJobId, T.baseLineSize, T.AppSizeToFree
FROM	#SIStore T
		INNER JOIN archGroupCopy C WITH (NOLOCK) ON C.id = T.CopyId
		INNER JOIN IdxSIDBStore S WITH (NOLOCK) ON S.SIDBStoreId = T.SIDBStoreId
		INNER JOIN IdxSIDBSubStore SS WITH (NOLOCK) ON SS.SIDBStoreId = T.SIDBStoreId
		INNER JOIN IdxAccessPath AP ON AP.IdxAccessPathId = SS.IdxAccessPathId
		INNER JOIN IdxCache IC WITH (NOLOCK) ON IC.IdxCacheId = SS.IdxCacheId
ORDER BY PolicyName ASC, CopyName ASC, S.AppTypeGroupId ASC, S.SIDBStoreId DESC, ClientName ASC
IF object_id('tempdb.dbo.#SIStore') is not null DROP TABLE #SIStore
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetSIStore')
	delete from GxQscripts where name = 'RptGetSIStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetSIStore')
	delete from GXDBVersions where aliasname = 'RptGetSIStore'
GO

insert into GXDBVersions values(2, 'RptGetSIStore',  '00010057006600100000', 'RptGetSIStore', '00010057006600100000')
GO

