

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetReplicaStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetReplicaStats.sp,v $ $Id: RptGetReplicaStats.sp,v 1.16.208.6 2018/07/06 01:41:29 prakash Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetReplicaStats"			|
--	||
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetReplicaStats <<<'

IF EXISTS (select * from sysobjects where name='RptGetReplicaStats')
	drop procedure RptGetReplicaStats
IF EXISTS (select * from GxQscripts where name='RptGetReplicaStats')
	delete from GxQscripts where name = 'RptGetReplicaStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetReplicaStats')
	delete from GXDBVersions where aliasname = 'RptGetReplicaStats'
GO
print '... Creating Procedure: RptGetReplicaStats'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetReplicaStats
  @i_jobId int
AS
  DECLARE @o_jobId integer;
  DECLARE @o_pairId integer;
  DECLARE @o_clientId integer;
  DECLARE @o_clientName nvarchar(255);
  DECLARE @o_clientNetHostName nvarchar(255);
  DECLARE @o_destHostId integer;
  DECLARE @o_destHostName nvarchar(255);
  DECLARE @o_destNetHostName nvarchar(255);
  DECLARE @o_replicaSetId integer;
  DECLARE @o_replicaSetName nvarchar(255);
  DECLARE @o_sourcePath nvarchar(255);
  DECLARE @o_destPath nvarchar(255);
  DECLARE @o_appList nvarchar(255);
  DECLARE @o_lastError nvarchar(255);
  DECLARE @o_lastFileNameSent nvarchar(255);
  DECLARE @o_lastFileNameRecvd nvarchar(255);
  DECLARE @o_pairState integer;
  DECLARE @o_pairRequestState integer;
  DECLARE @o_dataXferTotal bigint;
  DECLARE @o_startTime integer;
  DECLARE @o_fileXferedCount bigint;
  DECLARE @o_clientDisplayName nvarchar(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId		integer
DECLARE @startTime	integer
DECLARE @refTime	integer
DECLARE @clOpt		integer
DECLARE @useCSTime	integer
DECLARE	@jobDesc	nvarchar(4000)
DECLARE @tblClients	TABLE (	t_clId int )
DECLARE @tblJobList	TABLE (	t_jobId			int,
				t_currentPhase		int,
				t_currentAttempt	int,
				t_pairId		int,
				t_currentStatus		int,
t_currentFile		nvarchar(255),
				t_BytesTransfered	bigint,
				t_clId			int,
				t_appTypeId		int,
				t_instId		int,
				t_bkpsetId		int,
				t_destHostId		int,
				t_startTime		int )
SET @jobDesc		= dbo.GetOptionString(305418106, @i_jobId, 0, 0)
SET @userId = dbo.GetOptionInt(140019, @i_jobId, 0, 0)
SET @useCSTime = dbo.GetOptionInt(695030402, @i_jobId, 0, 0)
EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @refTime OUTPUT
INSERT INTO @tblClients EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
INSERT INTO @tblJobList
SELECT	J.jobId, J.currentPhase, J.currentAttempt, J.pairId, J.currentStatus, J.currentFileBeingTransfered, J.BytesReplicated,
	A.clientId, A.appTypeId, A.instance, A.backupset, 0, 0
FROM	JMCDRJobs J
	INNER JOIN APP_Application A ON  A.id=J.pairId AND ((A.subclientStatus & (2|4|16|32|64)) = 0)  	  -- uninstalled ,deleted, dummy, hidden, cmdline
	INNER JOIN APP_InstanceName I ON A.instance = I.id AND ((I.status & (16|32)) = 0 )
WHERE
(@clOpt = 0 OR A.clientId in (select t_clId from @tblClients))
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
--got all qualified entries, do the security check before more details and summary
IF @userId > 0 AND @isUserAdmin = 0 AND @clOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2009, 0, '#rptUserObjects'	-- 2009 = CLIENT_ITEM
	delete #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0
	DELETE @tblJobList
	WHERE NOT EXISTS (	select	* from #rptUserObjects
				where	clientId IN (0, t_clId) AND
					appTypeId IN (0,t_apptypeId) AND
					instanceId IN (0,t_instId) AND
					backupsetId IN (0,t_bkpSetId))
	DROP TABLE #rptUserObjects
END
IF object_id('tempdb.dbo.#tempPairs') IS NOT NULL DROP TABLE #tempPairs
SELECT * INTO #tempPairs
FROM	APP_ScReplicationPair
WHERE	pairId in (select t_pairId from @tblJobList) AND
	(@refTime = 0 AND modified = 0 OR
	(@refTime > 0 AND created <= @refTime AND (modified = 0 OR modified > @refTime)))
ORDER BY modified
DELETE @tblJobList WHERE t_pairId NOT IN (select DISTINCT pairId from #tempPairs)
DELETE @tblJobList WHERE t_pairId IN (select pairId from APP_scReplicationPair where propType = 18 and intVal > 0)
UPDATE	@tblJobList
SET	t_destHostId=convert(integer, attrVal)
FROM	@tblJobList, APP_BackupSetProp
WHERE	componentNameId = t_bkpSetId AND attrName = N'FLR Destination HostId' AND
	(@refTime = 0 AND modified = 0 OR
	(@refTime > 0 AND created <= @refTime AND (modified = 0 OR modified > @refTime)))
UPDATE	@tblJobList
SET	t_startTime = ISNULL((select TOP 1 startTime from JMCDRAttempts where jobId=t_jobId order by phaseNum asc, attemptNum asc),0)
--	MR#: 52954
IF @jobDesc <> N'' OR @jobDesc IS NULL	--	DELETE EVERY ROW FROM RESULT SET BECAUSE...
	DELETE @tblJobList					--	JOB DESCRIPTION IS NOT APPLICABLE FOR THIS REPORT
SELECT	t_jobId, t_pairId, t_clId,ClientName=(select name from APP_Client where id=t_clId),
	clNethostName=(select net_hostname from APP_Client where id=t_clId),
	t_destHostId,(CASE t_destHostId WHEN 0 THEN '' ELSE (select name from APP_Client where id=t_destHostId) END),
	(CASE t_destHostId WHEN 0 THEN '' ELSE (select net_hostname from APP_Client where id=t_destHostId) END),
	t_bkpSetId,replicSetName=(select name from APP_BackupSetName where id=t_bkpSetId),
	sourcePath=(select TOP 1 StringVal from #tempPairs where propType=10001 and pairId=t_pairId),
	destPath=(select TOP 1 StringVal from #tempPairs where propType=10002 and pairId=t_pairId),
	appList=(select TOP 1 StringVal from #tempPairs where propType=10003 and pairId=t_pairId),
	lastError=ISNULL((select failureReason from JMCDRAttempts where jobId=t_jobId and phaseNum=t_currentPhase and attemptNum=t_currentAttempt),''),
	lastFileNameSent=t_currentFile,
	lastFileNameRecvd=(select TOP 1 StringVal from #tempPairs where propType=10006 and pairId=t_pairId),
	pairState=t_currentStatus,
	pairRequestState=ISNULL((select TOP 1 intVal from #tempPairs where propType=2 and pairId=t_pairId),0),
	dataXferTotal=t_BytesTransfered,
	startTime=(case @useCSTime when 0 then DBO.rptgetJobClientTime(t_clId, ISNULL(t_startTime,0)) else t_startTime end),
	fileXferedCount=ISNULL((select noFilesTransfered from JMCDRAttempts where jobId=t_jobId and phaseNum=t_currentPhase and attemptNum=t_currentAttempt),0),
    ClientDisplayName=(select displayname from APP_Client where id=t_clId)
FROM	@tblJobList
ORDER BY ClientName, replicSetName, sourcePath, destPath
DROP TABLE #tempPairs
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetReplicaStats')
	delete from GxQscripts where name = 'RptGetReplicaStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetReplicaStats')
	delete from GXDBVersions where aliasname = 'RptGetReplicaStats'
GO

insert into GXDBVersions values(2, 'RptGetReplicaStats',  '00010016020800060000', 'RptGetReplicaStats', '00010016020800060000')
GO

