

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetRepSetReadiness.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetRepSetReadiness.sp,v $ $Id: RptGetRepSetReadiness.sp,v 1.11.88.7 2018/11/18 03:52:55 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "rptGetRepSetReadiness"							|
--	|		Returns replication sets and readiness							|
--	|																		|
--	| 																		|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetRepSetReadiness')
BEGIN
	print '>>> Drop Stored Procedure: RptGetRepSetReadiness <<<'
	drop procedure RptGetRepSetReadiness
END
IF EXISTS (select * from GxQscripts where name='RptGetRepSetReadiness')
	delete from GxQscripts where name = 'RptGetRepSetReadiness'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetRepSetReadiness')
	delete from GXDBVersions where aliasname = 'RptGetRepSetReadiness'
GO
print '... Creating Procedure: RptGetRepSetReadiness'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetRepSetReadiness
  @i_jobId integer
AS
  DECLARE @o_repSetName char(255);
  DECLARE @o_sourceClientName nchar(255);
  DECLARE @o_destClientName nchar(255);
  DECLARE @o_CStoSourceErr integer
  DECLARE @o_SourceToCSErr integer
  DECLARE @o_CSToDestErr integer
  DECLARE @o_DestToCSErr integer
  DECLARE @o_SourceToDestErr integer
  DECLARE @o_DestToSourceErr integer
  DECLARE @o_DIPErrorCodes char(255);
  DECLARE @o_resultFlag integer;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId		integer
DECLARE @errorOnly	integer
DECLARE @clOpt		integer
DECLARE @appTypeOpt	integer
DECLARE @tblClients	TABLE (t_clId int)
DECLARE @tblApptypes	TABLE (t_appTypeId int)
IF object_id('tempdb.dbo.#tmpRepSetInfo') IS NOT NULL drop table #tmpRepSetInfo
	create table #tmpRepSetInfo( 	repSetId		integer,
					repSetName		nvarchar(128),
					sourceClientId		integer,
					destClientId		integer,
					CSToSourceErr		integer,
					SourceToCSErr		integer,
					CSToDestErr			integer,
					DestToCSErr			integer,
					SourceToDestErr		integer,
					DestToSourceErr		integer,
					resultFlag			integer,
					DIPErrorCodes		varchar(255)
					)
SET @userId	= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
SET @errorOnly 	= dbo.GetOptionInt(1474670120, @i_jobId, 0, 0)
INSERT INTO @tblClients EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
INSERT INTO @tblApptypes EXEC rptOptGetObjectList @i_jobId, 444361887, @appTypeOpt OUTPUT
IF @appTypeOpt != 0 AND NOT EXISTS(SELECT t_appTypeId FROM @tblApptypes where t_appTypeId = 84)
BEGIN
	SELECT repSetName
			, '' AS sourceClientName
			, '' AS destClientName
			, CSToSourceErr,SourceToCSErr,CSToDestErr,DestToCSErr
			, SourceToDestErr,DestToSourceErr,DIPErrorCodes,resultFlag
	FROM	#tmpRepSetInfo
	RETURN
END
	INSERT INTO #tmpRepSetInfo
	SELECT DISTINCT APP.backupSet,BSN.name,APP.clientId,destClientId,0,0,0,0,0,0,0,Null
	FROM	APP_Application APP, APP_BackupSetName BSN,
			(SELECT componentNameId as backupSetId,attrVal as destClientId FROM APP_BackupSetProp WHERE attrName = 'FLR Destination HostId') AS DEST
	WHERE	( @clOpt = 0 OR APP.clientId in (select t_clId from @tblClients)) AND
			APP.backupSet = BSN.id AND BSN.id = DEST.backupSetId AND APP.appTypeId = 84
AND (APP.subclientStatus & 0x00020) = 0  AND
(APP.subclientStatus & 0x00004) = 0 AND
(APP.subclientStatus & 0x00002) = 0 AND
(APP.subclientStatus & 0x0040) = 0 AND
(APP.subclientStatus & 0x04000) = 0
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @clOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2009, 0, '#rptUserObjects'	-- 2009 = CLIENT_ITEM
	delete #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0
	delete	#tmpRepSetInfo
	FROM	#tmpRepSetInfo T
	WHERE	0 = (	select	count(*) from #rptUserObjects
			where	clientId IN (0, T.sourceClientId) AND
				backupsetId IN (0,T.repSetId))
	DROP TABLE #rptUserObjects
END
 declare @CommServe_Id	integer
 set @CommServe_Id = (select top(1)clientId from APP_Platform WITH (READUNCOMMITTED) where (platformType & 1) = 1 order by clientId asc)
-- CommServ To Source
	UPDATE #tmpRepSetInfo
	SET CSToSourceErr = CCR.errorCode,resultFlag = resultFlag | 1
	from CCRClientToClient CCR
	where CCR.flag = 0 AND CCR.FromClientId = @CommServe_Id AND CCR.ToClientId   = sourceClientId AND
		  CCR.serviceType  = 1	AND CCR.isDip = 0
-- Source To Commserv
	UPDATE #tmpRepSetInfo
	SET SourceToCSErr = CCR.errorCode,resultFlag = resultFlag | 2
	from CCRClientToClient CCR
	where CCR.flag = 0 AND CCR.FromClientId = sourceClientId AND  CCR.ToClientId  = @CommServe_Id AND
		  CCR.serviceType = 0	AND CCR.isDip = 0
-- CommServ To Destination
	UPDATE #tmpRepSetInfo
	SET CSToDestErr = CCR.errorCode,resultFlag = resultFlag | 4
	from CCRClientToClient CCR
	where CCR.flag = 0 AND CCR.FromClientId = @CommServe_Id AND CCR.ToClientId = destClientId AND
		  CCR.serviceType = 1 AND CCR.isDip = 0
-- Destination To Commserv
	UPDATE #tmpRepSetInfo
	SET DestToCSErr = CCR.errorCode,resultFlag = resultFlag | 8
	FROM CCRClientToClient CCR
	WHERE CCR.flag = 0 AND CCR.FromClientId = destClientId AND CCR.ToClientId  =  @CommServe_Id AND
		  CCR.serviceType =  0	AND CCR.isDip = 0
-- Source To Destination
	UPDATE #tmpRepSetInfo
	SET SourceToDestErr = CCR.errorCode,resultFlag = resultFlag | 16
	FROM CCRClientToClient CCR
	WHERE CCR.flag = 0 AND CCR.FromClientId = sourceClientId AND CCR.ToClientId  = destClientId  AND
		  CCR.serviceType = 1	AND  CCR.isDip = 0
-- Destination To Source
	UPDATE #tmpRepSetInfo
	SET DestToSourceErr = CCR.errorCode,resultFlag = resultFlag | 32
	FROM CCRClientToClient CCR
	WHERE CCR.flag = 0 AND CCR.FromClientId =  destClientId AND CCR.ToClientId   =  sourceClientId AND
		  CCR.serviceType = 1	AND CCR.isDip = 0
-- Update The DataInterface Pairs Error codes
-- DIP error codes will be repeseneted as cln1interface1/cl2interface1*(errorcode for cln1interface1->cl2interface1) * (errorcode for cl2interface1->cln1interface1)
	declare @source integer
	declare @destination integer
	DECLARE tmpRepSetCur CURSOR
	FOR SELECT DISTINCT sourceClientId,destClientId from #tmpRepSetInfo
	OPEN tmpRepSetCur
	FETCH NEXT FROM tmpRepSetCur
	INTO @source,@destination
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @srcIntFace varchar(255)
		DECLARE @destIntFace varchar(255)
		DECLARE	@DIPError varchar(1024)
		DECLARE @errorCode integer
		DECLARE	@Flag	   integer
		SET @DIPError = null
		SET @Flag	  = 0
		DECLARE archPipeLineCur CURSOR
		FOR SELECT srcInterface,destInterface
			FROM (select srcClientId,srcInterface,destClientId,destInterface,isActive from archPipeLine
				  union
				  select destClientId,destInterface,srcClientId,srcInterface,isActive from archPipeLine) as ap
			WHERE ap.isActive = 1 AND ap.srcClientId = @source and ap.destClientId = @destination
		OPEN archPipeLineCur
		FETCH NEXT FROM archPipeLineCur
		INTO @srcIntFace,@destIntFace
		WHILE @@FETCH_STATUS = 0
		BEGIN
				SET @DIPError = isnull(@DIPError+','+@srcIntFace+'/'+@destIntFace,@srcIntFace+'/'+@destIntFace)
				SET @errorCode = (SELECT errorCode FROM CCRClientToClient
				WHERE isDip = 1 and serviceType = 1 and (fromClientId = @source and FromClientInterfaceName = @srcIntface and
					  ToClientId = @destination and ToClientInterfaceName = @destIntFace))
				SET @DIPError = @DIPError + '*' + cast(@errorCode as varchar)
				IF @errorCode != 0
					SET @Flag = @Flag | 1
				SET @errorCode = (SELECT errorCode FROM CCRClientToClient
				WHERE isDip = 1 and serviceType = 1 and (fromClientId = @destination  and FromClientInterfaceName = @destIntFace and
					  ToClientId = @source and ToClientInterfaceName = @srcIntface))
				SET @DIPError = @DIPError + '*' + cast(@errorCode as varchar)
				IF @errorCode != 0
					SET @Flag = @Flag | 1
				FETCH NEXT FROM archPipeLineCur
				INTO @srcIntFace,@destIntFace
		END
		CLOSE archPipeLineCur
		DEALLOCATE archPipeLineCur
		update #tmpRepSetInfo
		set DIPErrorCodes = @DIPError,
			resultFlag = case @Flag when 1 then resultFlag|64 else resultFlag end
		where sourceClientId = @source and destClientId = @destination
		FETCH NEXT FROM tmpRepSetCur
		INTO @source,@destination
	END
	CLOSE tmpRepSetCur
	DEALLOCATE tmpRepSetCur
 -- Delete repsets which are ready if the option "Show Failed Components only" is selected
  IF @errorOnly > 0
 BEGIN
	DELETE #tmpRepSetInfo
	WHERE resultFlag = 0
 END
-- Returning Rows
 SELECT repSetName,sourceClientName=(select displayname from APP_Client where id=sourceClientId),
		destClientName=(select displayname from APP_Client where id=destClientId),CSToSourceErr,SourceToCSErr,CSToDestErr,DestToCSErr,
		SourceToDestErr,DestToSourceErr,DIPErrorCodes,resultFlag
 FROM	#tmpRepSetInfo
 drop table #tmpRepSetInfo
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetRepSetReadiness')
	delete from GxQscripts where name = 'RptGetRepSetReadiness'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetRepSetReadiness')
	delete from GXDBVersions where aliasname = 'RptGetRepSetReadiness'
GO

insert into GXDBVersions values(2, 'RptGetRepSetReadiness',  '00010011008800070000', 'RptGetRepSetReadiness', '00010011008800070000')
GO

