

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetPrePostInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetPrePostInfo.sp,v $ $Id: RptGetPrePostInfo.sp,v 1.7.36.3 2018/07/06 01:40:44 prakash Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "rptGetPrePostInfo"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: rptGetPrePostInfo <<<'

IF EXISTS (select * from sysobjects where name='rptGetPrePostInfo')
	drop procedure rptGetPrePostInfo
IF EXISTS (select * from GxQscripts where name='rptGetPrePostInfo')
	delete from GxQscripts where name = 'rptGetPrePostInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetPrePostInfo')
	delete from GXDBVersions where aliasname = 'rptGetPrePostInfo'
GO
print '... Creating Procedure: rptGetPrePostInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetPrePostInfo
  @jobId integer
AS
  DECLARE @o_client integer;
  DECLARE @o_clientName nchar(255);
  DECLARE @o_appType integer;
  DECLARE @o_appTypeName nchar(255);
  DECLARE @o_backupSet integer;
  DECLARE @o_bsName nchar(255);
  DECLARE @o_instance integer;
  DECLARE @o_instanceName nchar(255);
  DECLARE @o_subclient integer;
  DECLARE @o_subclientName nchar(255);
  DECLARE @o_preifind nchar(255);
  DECLARE @o_postifind nchar(255);
  DECLARE @o_prebackup nchar(255);
  DECLARE @o_postbackup nchar(255);
  DECLARE @o_presnap nchar(255);
  DECLARE @o_postsnap nchar(255);
  DECLARE @o_user nchar(255);
  DECLARE @o_clientDisplayName nchar(255);
SET NOCOUNT ON;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#PPE') IS NOT null DROP TABLE #PPE
select componentNameId, isnull([sys:pre PreIfind],'Not Selected') as PreIfind, isnull([sys:post PostIfind],'Not Selected') as PostIfind,
	   isnull([sys:pre PreBackup],'Not Selected') as PreBackup, isnull([sys:post PostBackup],'Not Selected') as PostBackup,
	   isnull([sys:pre PreSnap],'Not Selected') as PreSnap, isnull([sys:post PostSnap],'Not Selected') as PostSnap
into #PPE
from
(select componentNameId, attrName, attrVal from APP_SubClientProp
where (attrName like '%PreIfind' or attrName like '%PostIfind' or
	  attrName like '%PreBackup' or attrName like '%PostBackup' or
	  attrName like '%PreSnap' or attrName like '%PostSnap') and modified = 0 and attrVal <> '') as T1
pivot(max(attrVal) for attrName
	  in ([sys:pre PreIfind], [sys:post PostIfind], [sys:pre PreBackup], [sys:post PostBackup], [sys:pre PreSnap], [sys:post PostSnap])) as P
DECLARE @clientSelLst TABLE (clientId INT)
DECLARE @appTypeSelLst TABLE (appTypeId INT)
DECLARE @output INT = 0
DECLARE @userId INT = dbo.GetOptionInt(140019, @jobId, 0, 0)
INSERT INTO @clientSelLst
EXEC dbo.rptOptGetClients @jobId,@output
INSERT INTO @appTypeSelLst
EXEC dbo.rptOptGetAppTypes @jobId,@output
IF @userId > 1 --SECURITY
BEGIN
IF object_id('tempdb.dbo.#tmpObjByUser') IS NOT NULL DROP TABLE #tmpObjByUser
create table  #tmpObjByUser ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
insert into #tmpObjByUser
exec sec_getUserCredsByType @userId, 1 --1->client
if not exists (select * from #tmpObjByUser where clientId = 0)
delete from #PPE
where componentNameId not in (select A.ID from #tmpObjByUser T join APP_Application A on T.clientId = A.clientId)
drop table #tmpObjByUser
END
IF EXISTS(SELECT * FROM @clientSelLst)
DELETE P FROM #PPE P INNER JOIN APP_Application APP ON P.componentNameId=APP.id
					 LEFT OUTER JOIN @clientSelLst CL ON APP.clientId=CL.clientId
					 WHERE CL.clientId IS NULL
IF EXISTS(SELECT * FROM @appTypeSelLst)
DELETE P FROM #PPE P INNER JOIN APP_Application APP ON P.componentNameId=APP.id
					 LEFT OUTER JOIN @appTypeSelLst AL ON APP.appTypeId=AL.appTypeId
					 WHERE AL.appTypeId IS NULL
select APP.clientId,
	   clientName = (select name from APP_Client where id=APP.clientId),
	   APP.appTypeId,
	   appTypeName = (select name from APP_iDAType where type=APP.appTypeId),
	   APP.backupSet,
	   backupSetName=(select name from APP_BackupSetName where id=APP.backupSet),
	   APP.instance,
	   instanceName= (select name from APP_InstanceName where id=APP.instance),
	   APP.id, subclientName, PreIfind, PostIfind, PreBackup, PostBackup, PreSnap, PostSnap,
       usr = (case (select cast(attrVal as integer) from APP_SubClientProp where componentNameId = #PPE.componentNameId and attrName = 'use prepost username' and modified = 0) when 1
			  then 'Local System Account'
			  else (select attrVal from APP_SubClientProp where componentNameId = #PPE.componentNameId and attrName = 'prepost username' and modified = 0) end),
       clientDisplayName = (select displayname from APP_Client where id=APP.clientId)
from #PPE join APP_Application APP on #PPE.componentNameId = APP.id
DROP TABLE #PPE
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetPrePostInfo')
	delete from GxQscripts where name = 'RptGetPrePostInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetPrePostInfo')
	delete from GXDBVersions where aliasname = 'RptGetPrePostInfo'
GO

insert into GXDBVersions values(2, 'RptGetPrePostInfo',  '00010007003600030000', 'RptGetPrePostInfo', '00010007003600030000')
GO

