

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetPatchCacheInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetPatchCacheInfo.sp,v $ $Id: RptGetPatchCacheInfo.sp,v 1.10.12.7 2018/07/06 01:41:51 prakash Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetPatchCacheInfo"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetPatchCacheInfo <<<'

IF EXISTS (select * from sysobjects where name='RptGetPatchCacheInfo')
	drop procedure RptGetPatchCacheInfo
IF EXISTS (select * from GxQscripts where name='RptGetPatchCacheInfo')
	delete from GxQscripts where name = 'RptGetPatchCacheInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetPatchCacheInfo')
	delete from GXDBVersions where aliasname = 'RptGetPatchCacheInfo'
GO
print '... Creating Procedure: RptGetPatchCacheInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetPatchCacheInfo
  @i_jobId integer
AS
  DECLARE @o_relId integer;
  DECLARE @o_clientId integer;
  DECLARE @o_clientName nvarchar(255);
  DECLARE @o_release varchar(64);
  DECLARE @o_OSPacCount integer;
  DECLARE @o_OSType integer;
  DECLARE @o_pacCount integer;
  DECLARE @o_totRowCount integer;
  DECLARE @o_package varchar(64);
  DECLARE @o_SP varchar(MAX);
  DECLARE @o_patch varchar(MAX);
  DECLARE @o_clientDisplayName nvarchar(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @clientId	INT
DECLARE @relId		INT
DECLARE @OSId		INT
DECLARE @packageId	INT
DECLARE @sp			varchar(MAX)
DECLARE @addUpdate	nvarchar(MAX)
DECLARE @packages	varchar(MAX)
DECLARE @patchName	varchar(MAX)
declare @patchList	varchar(MAX)
----parsing addupdates list from patchMultiCache --
IF OBJECT_ID('tempdb..#tblUpdList') IS NOT NULL
	DROP TABLE #tblUpdList
CREATE TABLE #tblUpdList (
		t_clientId	int,
		t_relId		int,
		t_OsId		int,
		t_sp		varchar(255),
		t_patchId	nvarchar(150),
		t_appTypeList nvarchar(max) )
DECLARE @csSPVersionID INT = NULL
SELECT @csSPVersionID = psp.id
FROM app_client ac WITH(NOLOCK)
JOIN app_clientprop acp WITH(NOLOCK) ON ac.id = acp.componentnameid
JOIN app_client cs WITH(NOLOCK) ON acp.attrval = cs.id
JOIN simInstalledPackages sip WITH(NOLOCK) ON cs.id = sip.clientid
JOIN PatchSPVersion psp WITH(NOLOCK) ON sip.spversionID = psp.id
WHERE ac.id = 2 AND acp.attrname = 'CS Active Physical Node' AND sip.simpackageid = 20
DECLARE getaddUpdList CURSOR FOR
SELECT pmc.ClientId, pmc.ReleaseId, pmc.OSId, pmc.HighestSP, pmc.Addupdates
FROM PatchMultiCache pmc WITH(NOLOCK)
JOIN PatchSPVersion spver WITH(NOLOCK) ON pmc.SPVersionId = spver.id
JOIN PatchSPVersion csVer WITH(NOLOCK) ON @csSPVersionID = csVer.id
WHERE dbo.CompareServicePackLevel(spver.SPMajor, spver.SPMinor, spver.TransactionID, csVer.SPMajor, csVer.SPMinor, csVer.TransactionId) <= 0
OPEN getaddUpdList
FETCH NEXT FROM getaddUpdList INTO @clientid, @relId, @OSId, @sp, @addUpdate
WHILE @@FETCH_STATUS = 0
BEGIN
	INSERT	INTO #tblUpdList
	SELECT	@clientid, @relId, @OSId, '', _ID , ''
	FROM	SplitIDString(@addUpdate)
	WHERE ISNUMERIC(_ID) = 0
	FETCH NEXT FROM getaddUpdList INTO @clientid, @relId, @OSId, @sp, @addUpdate
END
CLOSE getaddUpdList
DEALLOCATE getaddUpdList
--insert rows for highestSP
INSERT	INTO #tblUpdList
SELECT pmc.clientid, pmc.releaseId, pmc.OSId, pmc.HighestSP, 0 , ''
FROM PatchMultiCache pmc WITH(NOLOCK)
JOIN PatchSPVersion spver WITH(NOLOCK) ON pmc.SPVersionId = spver.id
JOIN PatchSPVersion csVer WITH(NOLOCK) ON @csSPVersionID = csVer.id
WHERE dbo.CompareServicePackLevel(spver.SPMajor, spver.SPMinor, spver.TransactionID, csVer.SPMajor, csVer.SPMinor, csVer.TransactionId) <= 0
----fetch package / apptype list from patchINI--
UPDATE t
SET t_appTypeList = P.AppTypeList
FROM #tblUpdList t INNER JOIN PatchINI P
	ON t.t_relId = p.releaseid AND t.t_OsId = p.osid AND ( t_patchId = '0' OR ( t_patchId <> '0' AND PatchName like '%'+t_patchId))
DECLARE	@appList TABLE (
	packages	varchar(MAX),
	packageId	bigint )
DECLARE getPatchList CURSOR FOR
SELECT	DISTINCT t_appTypeList
FROM	#tblUpdList
OPEN getPatchList
FETCH NEXT FROM getPatchList INTO @packages
WHILE @@FETCH_STATUS = 0
BEGIN
	INSERT	INTO @appList
	SELECT	@packages, _ID
	FROM	SplitIDs(@packages)
	FETCH NEXT FROM getPatchList INTO @packages
END
CLOSE getPatchList
DEALLOCATE getPatchList
DELETE L FROM @appList l LEFT OUTER JOIN simPackage P ON p.id=l.packageId WHERE p.id IS NULL
----get applist for all additional updates--
DECLARE @tmpPatchCache	TABLE (
		t_clientId	int,
		t_relId		int,
		t_OsId		int,
		t_sp		varchar(255),
		t_patchId	varchar(255),
		t_OsGroup	int,
		t_packageId bigint )
INSERT INTO @tmpPatchCache
SELECT	DISTINCT  t.t_clientId, t.t_relId, t.t_OsId, t.t_sp, t.t_patchId,
		(CASE	WHEN t.t_OsId = 7 THEN 3
				WHEN t.t_OsId >= 8 AND t.t_OsId <= 15 THEN 2
	 			ELSE 1 END),
	 	ISNULL(l.packageId, 0)
FROM	#tblUpdList t
		LEFT JOIN @appList l ON t.t_appTypeList = l.packages
IF OBJECT_ID('tempdb..#tblUpdList') IS NOT NULL
	DROP TABLE #tblUpdList
----concat updates by package name--
DECLARE @tblPatchCache	TABLE (
		t_clientId	int,
		t_relId		int,
		t_OSId		int,
		t_OSGroup	int,
		t_packageId	int,
		t_sp		varchar(255),
		t_patch		varchar(MAX))
INSERT	INTO @tblPatchCache
SELECT	DISTINCT t_clientId, t_relId, t_OSID, t_OSGroup, t_packageId, t_sp,
		STUFF((SELECT	', ' + t_patchId
			FROM	@tmpPatchCache I
			WHERE	I.t_clientId = T.t_clientId
					AND I.t_relId = T.t_relId
					AND I.t_OSID = T.t_OsId
					AND I.t_packageId = T.t_packageId
					AND I.t_sp = T.t_sp
					AND t_OSGroup = T.t_OsGroup
			ORDER BY t_patchId
			FOR XML PATH('')),1,2,'')
FROM @tmpPatchCache T
WHERE t_patchId <> '0' AND (ISNUMERIC(t_patchId) = 0)
GROUP BY t_clientId, t_relId, t_OSID, t_OSGroup, t_packageId, t_sp
INSERT	INTO @tblPatchCache
SELECT	DISTINCT t_clientId, t_relId, t_OSID, t_OSGroup, t_packageId, t_sp, ''
FROM	@tmpPatchCache
WHERE	(ISNUMERIC(t_patchId) = 1 AND CAST(t_patchId AS BIGINT) = 0)
DECLARE @clOpt			integer
DECLARE @tblClients			TABLE (t_clId int)
INSERT INTO @tblClients EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
DELETE  t
FROM @tblPatchCache t LEFT OUTER JOIN @tblClients A
ON t_clientId=t_clId
WHERE A.t_clId IS NULL AND  @clOpt != 0
DECLARE @userId			integer
SET @userId			= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
IF @userId > 0
BEGIN
    IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
    EXEC sec_getUserObjects @userId, 2009 , 0, '#rptUserObjects'    -- CLIENT_ITEM = to get
IF NOT EXISTS(SELECT * FROM #rptUserObjects sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
delete from @tblPatchCache
			where t_clientId not in (select clientId from #rptUserObjects  u where clientId > 0)
    DROP TABLE #rptUserObjects
END
----get counts group by clientid, relId, OSId----
declare @tblOSCounts TABLE
(
	clientId	int,
	relId		int,
	OsId		int,
	counts		int
)
INSERT	INTO @tblOSCounts
SELECT	t_clientid, t_relId, t_OSId, COUNT(*)
FROM	@tblPatchCache
GROUP BY t_clientid, t_relId, t_OSId
declare @tblRelCounts TABLE
(
	clientId	int,
	relId		int,
	counts		int
)
INSERT	INTO @tblRelCounts
SELECT	clientId, relId, SUM(counts)
FROM	@tblOSCounts
GROUP BY clientId, relId
declare @tblClientCounts TABLE
(
	clientId	int,
	counts		int
)
INSERT	INTO @tblClientCounts
SELECT	clientId, SUM(counts)
FROM	@tblRelCounts
GROUP BY clientId
--output
SELECT	ReleaseId = t_relId, ClientId = t_clientId,
		ClientName = (select name from app_client where id =t_clientId),
		ReleaseName = (select release from simAllGalaxyRel where id = t_relId),
		ReleaseCounts = T2.counts, OSId = t_OSId, OSCounts = T3.counts, ClientCounts = T1.counts,
		PackageName = (select name from simPackage where id = t_packageId),
		HighestSP = t_sp, PatchList = t_patch,
        ClientDisplayName = (select displayname from app_client where id =t_clientId)
FROM	@tblPatchCache T
		INNER JOIN @tblClientCounts T1 ON T1.clientId = T.t_clientid
		INNER JOIN @tblRelCounts T2 ON T2.relId = T.t_relId AND T2.clientId = T.t_clientid
		INNER JOIN @tblOSCounts T3 ON T3.relId = T.t_relId AND T3.OSId = T.t_OSId AND T3.clientId = T.t_clientid
ORDER BY ClientId, ReleaseName DESC, t_OSGroup, OSId, PackageName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetPatchCacheInfo')
	delete from GxQscripts where name = 'RptGetPatchCacheInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetPatchCacheInfo')
	delete from GXDBVersions where aliasname = 'RptGetPatchCacheInfo'
GO

insert into GXDBVersions values(2, 'RptGetPatchCacheInfo',  '00010010001200070000', 'RptGetPatchCacheInfo', '00010010001200070000')
GO

