

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetOraContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetOraContent.sp,v $ $Id: RptGetOraContent.sp,v 1.1.2.3 2018/03/20 00:34:39 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "RptGetOraContent"				|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetOraContent <<<'

IF EXISTS (select * from sysobjects where name='RptGetOraContent')
	drop procedure RptGetOraContent
IF EXISTS (select * from GxQscripts where name='RptGetOraContent')
	delete from GxQscripts where name = 'RptGetOraContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetOraContent')
	delete from GXDBVersions where aliasname = 'RptGetOraContent'
GO
print '... Creating Procedure: RptGetOraContent'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetOraContent
  @i_jobId integer,
  @i_commcellId integer
AS
  DECLARE @o_pdbName VARCHAR(256);
  DECLARE @o_tblSpaceName VARCHAR(256);
  DECLARE @o_datafileName VARCHAR(2048);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @instanceID INT
DECLARE @pointInTime INT
SELECT	@instanceID = A.instance,
		@pointInTime = B.servEndDate
FROM	JMBkpStats B
	INNER JOIN APP_Application A
		ON B.appId = A.id
WHERE	B.jobId = @i_jobId
	AND	B.commCellId = @i_commcellId
SELECT	distinct isnull(pdbs.name, '') AS PDBName, tblspace.name AS 'TablespaceName', datafiles.name AS 'DatafileName'
FROM	oracleTableSpaces tblspace
	LEFT JOIN OraclePluggableDBs pdbs
		ON	pdbs.instId = @instanceID AND tblspace.pdbId = pdbs.pdbId
	LEFT JOIN oracleObjects obj
		ON obj.instId = @instanceID AND ((obj.objId = pdbs.pdbId AND obj.type = 20 /* ORAOBJ_PDB */)
			OR (ISNULL(tblspace.pdbId, 0) <> 0 AND obj.objId = pdbs.pdbId AND obj.type = 5 /* ORAOBJ_TABLESPACE */))
	INNER JOIN oracleDataFiles datafiles
		ON datafiles.instId = @instanceID AND datafiles.tblId = tblspace.id
WHERE	tblspace.created < @pointInTime
	AND	(tblspace.deleted = 0 OR tblspace.deleted > @pointInTime)
	AND pdbs.created IS NULL OR (pdbs.created < @pointInTime
		AND	(pdbs.deleted = 0 OR pdbs.deleted > @pointInTime))
	AND datafiles.created < @pointInTime
	AND	(datafiles.deleted = 0 OR datafiles.deleted > @pointInTime)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetOraContent')
	delete from GxQscripts where name = 'RptGetOraContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetOraContent')
	delete from GXDBVersions where aliasname = 'RptGetOraContent'
GO

insert into GXDBVersions values(2, 'RptGetOraContent',  '00010001000200030000', 'RptGetOraContent', '00010001000200030000')
GO

