

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetNonMagLibs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetNonMagLibs.sp,v $ $Id: RptGetNonMagLibs.sp,v 1.20.64.5 2018/03/22 03:10:23 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetNonMagLibs"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetNonMagLibs <<<'

IF EXISTS (select * from sysobjects where name='RptGetNonMagLibs')
	drop procedure RptGetNonMagLibs
IF EXISTS (select * from GxQscripts where name='RptGetNonMagLibs')
	delete from GxQscripts where name = 'RptGetNonMagLibs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetNonMagLibs')
	delete from GXDBVersions where aliasname = 'RptGetNonMagLibs'
GO
print '... Creating Procedure: RptGetNonMagLibs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetNonMagLibs
  @i_jobId integer
AS
  DECLARE @o_type integer;
  DECLARE @o_libId integer;
  DECLARE @o_libName NVARCHAR(255);
  DECLARE @o_driveCount integer;
  DECLARE @o_LibSoftState integer;
  DECLARE @o_LibEnabled integer;
  DECLARE @o_LibBroken integer;
  DECLARE @o_libType integer;
  DECLARE @o_BarCodeReaderPresent integer;
  DECLARE @o_libVendor char(255);
  DECLARE @o_libModel char(255);
  DECLARE @o_firmwareRevision char(255);
  DECLARE @o_attribute integer;
  DECLARE @o_DefaultMediaTypeId integer;
  DECLARE @o_OfflineReason integer;
  DECLARE @o_installtime integer;
  DECLARE @o_NumberOfSoftErrors integer;
  DECLARE @o_NumberOfHardErrors integer;
  DECLARE @o_mounttimeoutsec integer;
  DECLARE @o_unmounttimeoutsec integer;
  DECLARE @o_UseWithinDaysInSec integer;
  DECLARE @o_DriveCleanInterval integer;
  DECLARE @o_StartVMS integer;
  DECLARE @o_VMSDirection integer;
  DECLARE @o_cacheMountPeriodInSec integer;
  DECLARE @o_StdAlnMedRetentionTime integer;
  DECLARE @o_defaultScratchPool NVARCHAR(255);
  DECLARE @o_mediaTypeName char(255);
  DECLARE @o_mailSlotNum integer;
  DECLARE @o_slotNum integer;
  DECLARE @o_occupiedSlotNum integer;
  DECLARE @o_mediInDriveNum integer;
  DECLARE @o_mediaNum integer;
  DECLARE @o_readretryIntervalInSec integer;
  DECLARE @o_readRetryAttempts integer;
  DECLARE @o_extendedAttributes integer;
  DECLARE @o_TURIntervalInSec integer;
  DECLARE @o_configParams char(255);
  DECLARE @o_description nchar(2048);
  DECLARE @o_t_libId integer;
  DECLARE @o_userGroups varchar(MAX);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId 		integer
DECLARE @libId 			integer
DECLARE @tblLibs		TABLE (t_libId int)
DECLARE @summary		TABLE (t_libId int, t_libName varchar(255), t_driveCount int)
DECLARE @tempLibList		TABLE (	type			int,
					libId			int,
AliasName		nvarchar(255) default(''),
					totalDrives		int default(0),
					LibSoftState	int default(0),
					LibEnabled		int default(0),
					LibBroken		int default(0),
					libType			int default(0),
					BarCodeReaderPresent	int default(0),
libVendor		varchar(255) default(''),
libModel		varchar(255) default(''),
firmwareRevision	varchar(255) default(''),
					attribute			int default(0),
					DefaultMediaTypeId	int default(0),
					OfflineReason		int default(0),
					installtime			int default(0),
					NumberOfSoftErrors	int default(0),
					NumberOfHardErrors	int default(0),
					mounttimeoutsec		int default(0),
					unmounttimeoutsec	int default(0),
					UseWithinDaysInSec	int default(0),
					DriveCleanInterval	int default(0),
					StartVMS			int default(0),
					VMSDirection		int default(0),
					cacheMountPeriodInSec	int default(0),
					StdAlnMedRetentionTime	int default(0),
defaultScratchPool	nvarchar(255) default(''),
mediaTypeName		varchar(255) default(''),
					mailSlotNum			int default(0),
					slotNum				int default(0),
					occupiedSlotNum		int default(0),
					mediInDriveNum		int default(0),
					mediaNum			int default(0),
					readretryIntervalInSec	int default(0),
					readRetryAttempts	int default(0),
					extendedAttributes	int default(0),
					TURIntervalInSec	int default(0),
configParams		varchar(255) default(''),
					descript			nchar(2048) default(N''))
SET @userId = dbo.GetOptionInt(140019, @i_jobId, 0, 0)
INSERT INTO @tblLibs	EXEC rptOptGetObjectList @i_jobId, 412850839, @libId OUTPUT
INSERT INTO @tempLibList
SELECT	0,LibraryId,AliasName,totalDrives=(select sum(totalDrives) from MMMasterPool where libraryId=L.LibraryId),
	LibrarySoftState,LibraryEnabled,LibraryBroken,LibraryTypeId,BarCodeReaderPresent,
	LibraryVendor,LibraryModel,firmwarerevision,LibraryAttribute,DefaultMediaTypeId,LibraryStatusReason,
	libraryinstalltime, NumberOfSoftErrors,NumberOfHardErrors,mounttimeoutsec,unmounttimeoutsec,
	UseWithinDaysInSec,DriveCleanIntervalInSec,StartVMSElementAddress,VMSDirection,cacheMountPeriodInSec,StdAlnMedRetentionTime,
	defaultScratchPool=(select TOP 1 ms.sparegroupname from MMSpareGroup ms where ms.libraryid=L.libraryid and ms.sparegrouptype=2),
mediaTypeName=(case when ((LibraryAttribute & 8) > 0) then (select MediaTypeName from MMMediaType where mediaTypeId=DefaultMediaTypeId) else '' END),
	mailslotNum=(select count(*) from MMSlot ms, MMBay mb where ms.bayid=mb.bayid and mb.libraryid=L.libraryid and slotType=2),
	slotNum=(select count(*) from MMSlot ms, MMBay mb where ms.bayid=mb.bayid and mb.libraryid=L.libraryid and slotType=1),
	occupiedSlotNum=(select count(*) from MMSlot ms, MMBay mb where ms.bayid=mb.bayid and mb.libraryid=L.libraryid and IsOccupied=1 and slotType=1),
	mediaInDriveNum=(select count(*) from MMMedia mm where mm.medialocation=2 and mm.libraryid=L.libraryid),
	mediaNum=(select count(*) from MMSlot ms, MMBay mb where ms.bayid=mb.bayid and mb.libraryid=L.libraryid and IsGalaxyMedia=1 and IsOccupied=1),
	readretryIntervalInSec,readRetryAttempts,extendedAttributes,TURIntervalInSec,configParams,Descript
FROM	MMLibrary L
WHERE	(@libId = 0 OR LibraryId in (select t_libId from @tblLibs)) AND LibraryId>0 and LibraryTypeId NOT IN (0, 3, 8, 9)
--got all qualified media, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @libId <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2049, 0, '#rptUserObjects'	-- 2049 = LIBRARY_ITEM
	DELETE #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR clientId <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0
	DELETE @tempLibList
	WHERE NOT EXISTS (select * from #rptUserObjects where libraryId IN (0, libid))
	DROP TABLE #rptUserObjects
END
INSERT INTO @summary
SELECT DISTINCT LibId,AliasName,totalDrives FROM @tempLibList
IF object_id('tempdb.dbo.#tempUserGroupList') is not null	DROP TABLE #tempUserGroupList
CREATE TABLE #tempUserGroupList (t_libId integer, t_groupList text)
--get list of user UMGroups that have permissions on each SP
IF (dbo.isNewSecurity() = 0)
BEGIN
DECLARE nonMagLibUserGroupList CURSOR FOR
	SELECT DISTINCT LibId FROM @tempLibList
OPEN nonMagLibUserGroupList
FETCH NEXT FROM nonMagLibUserGroupList INTO @libId
WHILE @@FETCH_STATUS = 0
BEGIN
	INSERT INTO #tempUserGroupList
	EXEC rptGetUserGroups 2049, @libId, 0, 0, 0, 0, 0, 0
	FETCH NEXT FROM nonMagLibUserGroupList INTO @libId
END
CLOSE nonMagLibUserGroupList
DEALLOCATE nonMagLibUserGroupList
END
ELSE
BEGIN
DECLARE @entityType1 INT = 9
	DECLARE @i_entityList XML
	SET @i_entityList = (SELECT
9  as '@entityType1',
	LibId  as '@entityId1'
	FROM   (SELECT DISTINCT LibId FROM @tempLibList) f
	for xml path('entity'),root('entityList') )
	IF object_id('tempdb.dbo.#tgroupObjects') is not null
        DROP TABLE #tgroupObjects
--	THIS WILL GIVE ALL USERGROUP ASSOCIATED WITH THESE CLIENT WITHOUT USER SECURITY CHECK (USER ID IS NOT PASSED)
CREATE TABLE #tgroupObjects ([userORGroupId] integer, [isUSer] integer, [roleId] integer, [permissionId] integer, [entitytype1]	 integer, [entityId1] integer, [entityType2] integer DEFAULT 0, [entityId2] integer DEFAULT 0, [entityType3] integer DEFAULT 0, [entityId3] integer DEFAULT 0, [entityType4] integer DEFAULT 0, [entityId4] integer DEFAULT 0, [entityType5] integer DEFAULT 0,  [entityId5] integer DEFAULT 0)
exec sec_getUMEntityandPermissionOnEntity '#tgroupObjects' ,9, @i_entityList,0,0,0,0
	-- USER SECURITY CHECK FOR THIS USER
	IF object_id('tempdb.dbo.#entityTable') is not null
		drop table #entityTable
	create table #entityTable
	(
		entityId int
	)
	 exec sec_getUserGroupsForThisUser '#entityTable', @userID
	IF object_id('tempdb.dbo.#usergroups') is not null
		drop table #usergroups
	CREATE table #usergroups (name nvarchar(max),t_libId INT )
	INSERT INTO #usergroups
		select distinct UG.name,t.entityId1
	FROM	UMGroups UG INNER JOIN #tgroupObjects t ON
	UG.id = t.userORGroupId and t.isUSer = 0
	INNER JOIN #entityTable E ON
	UG.id = E.entityId
	drop table #entityTable
	INSERT INTO #tempUserGroupList
	Select distinct cg2.t_libId,
    substring(
        (
            Select ','+cg1.name  AS [text()]
            From #usergroups cg1
            Where cg1.t_libId = cg2.t_libId
            ORDER BY cg1.t_libId
            For XML PATH ('')
        ), 2, 1000) [groups]
	From #usergroups cg2
	IF object_id('tempdb.dbo.#tgroupObjects') is not null
    DROP TABLE #tgroupObjects
	IF object_id('tempdb.dbo.#usergroups') is not null
		drop table #usergroups
END
INSERT INTO @tempLibList (type,LibId,AliasName,totalDrives)
SELECT  1,t_libId,t_libName,t_driveCount
FROM	@summary
INSERT INTO @tempLibList (type,LibId,AliasName,totalDrives)
SELECT  2,(select count(*) from @summary),'', (select sum(t_driveCount) from @summary)
SELECT *
FROM @tempLibList LEFT OUTER JOIN #tempUserGroupList ON t_libId=LibId
ORDER BY type DESC, AliasName
IF object_id('tempdb.dbo.#tempUserGroupList') is not null	DROP TABLE #tempUserGroupList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetNonMagLibs')
	delete from GxQscripts where name = 'RptGetNonMagLibs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetNonMagLibs')
	delete from GXDBVersions where aliasname = 'RptGetNonMagLibs'
GO

insert into GXDBVersions values(2, 'RptGetNonMagLibs',  '00010020006400050000', 'RptGetNonMagLibs', '00010020006400050000')
GO

