

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetMediaListByCopyOrJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetMediaListByCopyOrJob.sp,v $ $Id: rptGetMediaListByCopyOrJob.sp,v 1.14.208.3 2018/03/22 03:04:28 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptGetMediaListByCopyOrJob"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetMediaListByCopyOrJob')
BEGIN
	print '>>> Drop Stored Procedure: rptGetMediaListByCopyOrJob <<<'
	drop procedure rptGetMediaListByCopyOrJob
END
IF EXISTS (select * from GxQscripts where name='rptGetMediaListByCopyOrJob')
	delete from GxQscripts where name = 'rptGetMediaListByCopyOrJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetMediaListByCopyOrJob')
	delete from GXDBVersions where aliasname = 'rptGetMediaListByCopyOrJob'
GO
print '... Creating Procedure: rptGetMediaListByCopyOrJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetMediaListByCopyOrJob
  @copyId integer,
  @commCellId integer,
  @jobId_l integer
AS
  DECLARE @o_isMag integer;
  DECLARE @o_barcode varchar(256);
  DECLARE @o_mountPath NVARCHAR(1024);
  DECLARE @o_hasIndex integer;
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
SET NOCOUNT ON
CREATE TABLE #MediaSide (
	MediaId			INT,
	MediaSideId		INT,
	HasIndexFile	INT
)
IF @copyId > 0
	INSERT	INTO #MediaSide
	SELECT	V.MediaId, V.MediaSideId, SUM(CASE AF.fileType WHEN 2 THEN 1 ELSE 0 END)
	FROM	MMVolume V WITH(NOLOCK)
			INNER JOIN archChunk AC WITH(NOLOCK) ON V.VolumeId = AC.volumeId
			INNER JOIN archChunkMapping ACM WITH(NOLOCK) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
			INNER JOIN archFile AF WITH(NOLOCK) ON ACM.archFileId = AF.id AND ACM.commCellId = AF.commCellId AND AF.isValid = 1
	WHERE	ACM.archCopyId = @copyId
	GROUP BY V.MediaId, V.MediaSideId
ELSE
	INSERT	INTO #MediaSide
	SELECT	V.MediaId, V.MediaSideId, SUM(CASE AF.fileType WHEN 2 THEN 1 ELSE 0 END)
	FROM	MMVolume V WITH(NOLOCK)
			INNER JOIN archChunk AC WITH(NOLOCK) ON V.VolumeId = AC.volumeId
			INNER JOIN archChunkMapping ACM WITH(NOLOCK) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.chunkCommCellId
			INNER JOIN archFile AF WITH(NOLOCK) ON ACM.archFileId = AF.id AND ACM.commCellId = AF.commCellId AND AF.isValid = 1
	WHERE	AF.jobId = @jobId_l AND AF.commCellId = @commCellId
	GROUP BY V.MediaId, V.MediaSideId
SELECT	magMediaSideId = CASE M.MediaTypeId WHEN 10001 THEN MS.MediaSideId ELSE 0 END,
		barcode = M.Barcode,
		mountPath = ISNULL(MP.MountPathName, ''),
		IndexMedia = CASE WHEN HasIndexFile > 0 THEN 1 ELSE 0 END
FROM	#MediaSide MS
		INNER JOIN MMMedia M WITH(NOLOCK) ON MS.MediaId = M.MediaId
		LEFT OUTER JOIN MMS2getMountPathNameGUIView MP WITH (READUNCOMMITTED)
			ON MS.MediaSideId = MP.MediaSideId
ORDER BY barcode, mountPath
DROP TABLE #MediaSide
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetMediaListByCopyOrJob')
	delete from GxQscripts where name = 'RptGetMediaListByCopyOrJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMediaListByCopyOrJob')
	delete from GXDBVersions where aliasname = 'RptGetMediaListByCopyOrJob'
GO

insert into GXDBVersions values(2, 'RptGetMediaListByCopyOrJob',  '00010014020800030000', 'RptGetMediaListByCopyOrJob', '00010014020800030000')
GO

