

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetMediaList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetMediaList.sp,v $ $Id: RptGetMediaList.sp,v 1.77.2.22 2020/12/21 23:27:06 cliu Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetMediaList"			|
--	||
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptGetMediaList')
BEGIN
	print '>>> Drop Stored Procedure: RptGetMediaList <<<'
	drop procedure RptGetMediaList
END
IF EXISTS (select * from GxQscripts where name='RptGetMediaList')
	delete from GxQscripts where name = 'RptGetMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMediaList')
	delete from GXDBVersions where aliasname = 'RptGetMediaList'
GO
print '... Creating Procedure: RptGetMediaList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptGetMediaList
  @i_jobId int
AS
  DECLARE @o_type integer;
  DECLARE @o_loc integer;
  DECLARE @o_isMag integer;
  DECLARE @o_mediaGroupId integer;
  DECLARE @o_groupType integer;
  DECLARE @o_mediaStatus integer;
  DECLARE @o_statusReason integer;
  DECLARE @o_lastExportTime integer;
  DECLARE @o_volNum integer;
  DECLARE @o_magLastBkpT integer;
  DECLARE @o_magLastRstT integer;
  DECLARE @o_magBytesGB float;
  DECLARE @o_mediaFlag integer;
  DECLARE @o_attributes integer;
  DECLARE @o_libId integer;
  DECLARE @o_library NVARCHAR(255);
  DECLARE @o_policyId integer;
  DECLARE @o_policy NVARCHAR(255);
  DECLARE @o_location NVARCHAR(255);
  DECLARE @o_containerId integer;
  DECLARE @o_containerName char(255);
  DECLARE @o_mediaId integer;
  DECLARE @o_spareGroupId integer;
  DECLARE @o_spareGroup NVARCHAR(255);
  DECLARE @o_barCode char(255);
  DECLARE @o_copy NVARCHAR(255);
  DECLARE @o_UseWithinDaysInSec integer;
  DECLARE @o_volumeId integer;
  DECLARE @o_volumeFlags integer;
  DECLARE @o_lastBackupTime integer;
  DECLARE @o_lastRestoreTime integer;
  DECLARE @o_volumeFullReason integer;
  DECLARE @o_volumeFullTime integer;
  DECLARE @o_volumeFullJobId bigint;
  DECLARE @o_physicalBytesGB float;
  DECLARE @o_volStatus integer;
  DECLARE @o_isErasable integer;
  DECLARE @o_NumberOfRestores integer;
  DECLARE @o_NumberOfBackups integer;
  DECLARE @o_NumberOfMounts integer;
  DECLARE @o_NumberOfSoftErrors integer;
  DECLARE @o_NumberOfHardErrors integer;
  DECLARE @o_NumberOfReUses integer;
  DECLARE @o_creationTime integer;
  DECLARE @o_monthsUsed integer;
  DECLARE @o_monthsInUseThreshold integer;
  DECLARE @o_reusesThreshold integer;
  DECLARE @o_shortLenDurThreshold integer;
  DECLARE @o_softErrorThreshold integer;
  DECLARE @o_hardErrorThreshold integer;
  DECLARE @o_totalSlots integer;
  DECLARE @o_isMediaWithError integer;
  DECLARE @o_retentionFlags integer;
  DECLARE @o_retentionExpireTime bigint;
  DECLARE @o_isOutside integer;
  DECLARE @o_expLocation NVARCHAR(70);
  DECLARE @o_slotId integer;
  DECLARE @o_slotName varchar(255);
  DECLARE @o_lastWriteTime integer;
  DECLARE @o_pinExpireTime integer;
  DECLARE @o_isPartOfVtRecall integer;
  DECLARE @o_maNames NVARCHAR(255);
  DECLARE @o_mediaType varchar(255);
  DECLARE @o_encrypted integer;
  DECLARE @o_jobIDs VARCHAR(MAX);
  DECLARE @o_description NVARCHAR(MAX);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId		integer
DECLARE @locId		integer
DECLARE @startTime	integer
DECLARE @endTime	integer
DECLARE @libOpt		integer
DECLARE @shelfOpt	integer
DECLARE @locOpt		integer
DECLARE @SPOpt		integer
DECLARE @allCopies	integer
DECLARE @timeOpt 	integer
DECLARE @orderBy 	integer
DECLARE @locIn	 	integer
DECLARE @locOut	 	integer
DECLARE @errorOnly 	integer
DECLARE @extRetainedOnly integer
DECLARE @basicRetainedOnly integer
DECLARE @preventExportOnly integer
DECLARE @deconfigClientOnly integer
DECLARE @includeJobIDs integer
DECLARE @includeAgedData integer
DECLARE @includeOrphanedMedia integer
DECLARE @includeAllStatusMedia integer
DECLARE @includeActiveMedia integer
DECLARE @includeSpareMedia integer
DECLARE @includeReadOnlyMedia integer
DECLARE @includeBadMedia integer
DECLARE @includeRetiredMedia integer
DECLARE @includeCleaningMedia integer
DECLARE @includeFullMedia integer
DECLARE @includeAppendableMedia integer
DECLARE @includeUndiscoveredMedia integer
DECLARE @includeForeignMedia integer
DECLARE @includeOverwriteProtectedMedia integer
DECLARE @tblLibs	TABLE (t_libId int)
DECLARE @tblShelves	TABLE (t_shelfId int)
DECLARE @tblLocations	TABLE (t_locId int)
DECLARE @tblSPs		TABLE (t_policyId int, t_copyId int)
DECLARE @tblObjectList	TABLE (t_id int)
DECLARE @tblLocList	TABLE (t_name nvarchar(70))
DECLARE @useClientDisplayName int= 1 -- Always true for R11 SP15 and higher
SET		@deconfigClientOnly = 0
SET @userId	= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
SET @orderBy 	= dbo.GetOptionInt(1632651330, @i_jobId, 0, 0)
SET @timeOpt	= dbo.GetOptionInt(1258973078, @i_jobId, 0, 0)
SET @locIn	= dbo.GetOptionInt(1522453899, @i_jobId, 0, 0)
SET @locOut	= dbo.GetOptionInt(48575486, @i_jobId, 0, 0)
SET @errorOnly 	= dbo.GetOptionInt(1416525214, @i_jobId, 0, 0)
SET @extRetainedOnly = dbo.GetOptionInt(292857567, @i_jobId, 0, 0)
SET @basicRetainedOnly = dbo.GetOptionInt(2138023947, @i_jobId, 0, 0)
SET @preventExportOnly = dbo.GetOptionInt(1832264894, @i_jobId, 0, 0)
SET @includeOrphanedMedia = dbo.GetOptionInt(2095363284, @i_jobId, 0, 0)
-- TBD: define RPTMEDIAINFORMATION_RETAINED_BY_DECONFIGURED_CLIENTS
SET @deconfigClientOnly = dbo.GetOptionInt(1030863489, @i_jobId, 0, 0)
SET @includeJobIDs = dbo.GetOptionInt(1416861244, @i_jobId, 0, 0)
SET @includeAgedData = dbo.GetOptionInt(24745219, @i_jobId, 0, 0)
SET @includeAllStatusMedia			= dbo.GetOptionInt(842531987, @i_jobId, 0, 0)
SET @includeActiveMedia				= dbo.GetOptionInt(73578196, @i_jobId, 0, 0)
SET @includeSpareMedia				= dbo.GetOptionInt(2058843831, @i_jobId, 0, 0)
SET @includeReadOnlyMedia			= dbo.GetOptionInt(1517506896, @i_jobId, 0, 0)
SET @includeBadMedia				= dbo.GetOptionInt(842532599, @i_jobId, 0, 0)
SET @includeRetiredMedia			= dbo.GetOptionInt(245872027, @i_jobId, 0, 0)
SET @includeCleaningMedia			= dbo.GetOptionInt(140365127, @i_jobId, 0, 0)
SET @includeFullMedia				= dbo.GetOptionInt(348845533, @i_jobId, 0, 0)
SET @includeAppendableMedia			= dbo.GetOptionInt(446163010, @i_jobId, 0, 0)
SET @includeUndiscoveredMedia		= dbo.GetOptionInt(225523439, @i_jobId, 0, 0)
SET @includeForeignMedia			= dbo.GetOptionInt(1529920826, @i_jobId, 0, 0)
SET @includeOverwriteProtectedMedia = dbo.GetOptionInt(109920377, @i_jobId, 0, 0)
EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
IF	@endTime <= 0
	SET	@endTime = 0x7FFFFFFF
INSERT INTO @tblLibs		EXEC rptOptGetObjectList @i_jobId, 412850839, @libOpt OUTPUT
IF @includeOrphanedMedia = 1 AND @libOpt > 0
   INSERT INTO @tblLibs Values (0)
INSERT INTO @tblShelves		EXEC rptOptGetObjectList @i_jobId, 1241148410, @shelfOpt OUTPUT
INSERT INTO @tblLocations	EXEC rptOptGetObjectList @i_jobId, 1582403349, @locOpt OUTPUT
INSERT INTO @tblSPs		EXEC rptOptGetStoragePolicies @i_jobId, @SPOpt OUTPUT
DECLARE @xmlText XML;
DECLARE @handle INT;
SET @xmlText = (SELECT dbo.GetXMLJobOptions(@i_jobid))
EXEC sp_xml_preparedocument @handle OUTPUT, @xmlText
SET @allCopies = ISNULL((SELECT TOP 1 allCopies FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/storagePolicyCopyList', 1) WITH (allCopies int)), 0)
EXEC sp_xml_removedocument @handle
CREATE TABLE #TEMP_MEDIA_LIST(
	isSum		INT	default(0),
	loc		INT,
	libId		INT,
	isMag		INT	default(0),
	medId		INT,
	barCode		varchar(256),
	Location	nvarchar(1024),
	expLocation	nvarchar(70)	default(''),
	mgId		INT	default(0),
	sgId		INT	default(0),
	groupType	INT	default(0),
	mediaStatus	INT	default(0),
	statusReason	INT	default(0),
	lastExpTime	INT	default(0),
	volNum		INT	default(1),
	magLastBkpT	INT	default(0),
	magLastRstT	INT	default(0),
	magBytesMB	BIGINT	default(0),
	policyId	INT	default(0),
	isOutside	INT	default(0),
	ctId		INT	default(0),
	typeId		INT	default(0),
	slotId		INT	default(0),
	medFlag		INT	default(0),
	medAttribute	INT	default(0),
	UseSec		INT	default(0),
	crTime		INT	default(0),
	hasMediaError	INT	default(0),
	slotName	varchar(144)	default(''),
	policy		nvarchar(144)	default('N/A'),
	copy		nvarchar(64)	default('N/A'),
	IsInMediaGroup	INT	default(0),
	retentionFlags	INT	default(0),
	retentionExpireTime	BIGINT	default(0),
	--Added new coloumn for new option group by "last right time"  by vnirala on 10-Oct-2006
	lastWriteTime   INT     default(0),
	pinExpireTime	INT     default(0),
	-- Is this media part of VaultTracker Recall action
	isPartOfVtRecall  INT	  default(0),
	mountPathId		INT 	default(0),
	maNames		nvarchar(1024) default(''),
	copyId	INT	default(0),
	encrypted integer default (0),
	jobIDs varchar(max) default ' ',
	Descript nvarchar(max) default ''
)
IF @locIn > 0 AND @libOpt >= 0
BEGIN
	INSERT INTO #TEMP_MEDIA_LIST (loc,libId,medId,barCode,location,groupType,mediaStatus,slotId)
	SELECT DISTINCT 1,B.LibraryId,S.MediaId,S.BarCode,S.slotname,-1,S.MediaStatus,slotId
	FROM MMSlot S,MMBay B
	WHERE	((@libOpt = 0 AND (@IncludeOrphanedMedia = 1 OR (@IncludeOrphanedMedia = 0 AND LibraryId <> 0)))  OR LibraryId in (select t_libId from @tblLibs )) AND
		S.IsGalaxyMedia = 1 AND (S.MediaId = 0 OR S.MediaStatus > 2) AND S.IsOccupied = 1 AND S.BayId = B.BayId AND B.LibraryId > 0
	--nonmagnetic
	INSERT INTO #TEMP_MEDIA_LIST (loc,libId,medId,barCode,location,sgId,statusReason,lastExpTime,typeId,slotId,medFlag,medAttribute,slotName,
			IsInMediaGroup,retentionFlags,retentionExpireTime,pinExpireTime)
	SELECT DISTINCT 1, LibraryId, MediaId, BarCode,
		(case MediaLocation	when 1 then (select TOP 1 SlotName from MMSlot where MediaId=M.MediaId)
					when 2 then (select TOP 1 AliasName from MMDrive where MediaId=M.MediaId) else '' end),
		SpareGroupId, MediaStatusReason, lastExportTime, mediaTypeId,
		(case MediaLocation when 1 then (select TOP 1 SlotId from MMSlot where MediaId=M.MediaId) else 0 end),
		mediaFlags, Attributes,
		(case MediaLocation	when 2 then
				(select	TOP 1 S.slotname
				 from	MMSlot S, MMDrive D, MMBay B
-- Jun Lu: Need to change index MMS2Slot_bayId on MMSlot (BayId) into an index on MMSlot (BayId, ElementAddress)
				 where	S.elementAddress=D.SlotElementAddress and S.BayId=B.BayId and D.MediaId=M.MediaId and B.LibraryId=M.LibraryId)
					else '' end),
		M.IsInMediaGroup, M.retentionFlags, M.retentionExpireTime, M.PinMediaExpireTime
	FROM	MMMedia M
	WHERE	((@libOpt = 0 AND (@IncludeOrphanedMedia = 1 OR (@IncludeOrphanedMedia = 0 AND LibraryId <> 0)))  OR LibraryId in (select t_libId from @tblLibs )) AND mediaTypeId <> 10001
		AND MediaLocation <> 3
		AND MediaId > 0
	--media in wrong library
	--UPDATE #TEMP_MEDIA_LIST
	--SET groupType=-1, mediaStatus=mediaStatus|4
	--FROM MMMedia, #TEMP_MEDIA_LIST
	--WHERE	MediaId=medId and libraryId <> LastWriteLibraryId and LastWriteLibraryId > 0
	--magnetic
	--Added policy insertion condition by  vnirala on 10-Oct-2006
	CREATE TABLE #CopyMountPathSize (CopyId INT, MediaSideId INT, PhysicalBytesMB BIGINT)
	INSERT	INTO #CopyMountPathSize
	SELECT	archGroupCopyId, MediaSideId, SUM(CAST(PhysicalBytesMB AS BIGINT))
	FROM	archStream A JOIN MMVolume V ON A.mediaGroupId = V.MediaGroupId AND V.RecordingFormatId = 10001 AND V.PhysicalBytesMB > 0
	GROUP BY archGroupCopyId, MediaSideId
	INSERT INTO #TEMP_MEDIA_LIST (copyId,copy,policyId,policy,loc,libId,isMag,medId,barCode,location,sgId,mediaStatus,magLastBkpT,magLastRstT,magBytesMB,IsInMediaGroup,retentionFlags,retentionExpireTime,mountPathId)
    SELECT	AGC.id, AGC.name, AG.id, AG.name, 1, M.LibraryId, 1, M.MediaId, 'Magnetic', P.MountPathName, SpareGroupId,
			(CASE WHEN P.isOffline = 0 and P.isEnabled = 1 THEN 3 ELSE 5 END),
			S.LastBackupTime, S.LastRestoreTime, X.PhysicalBytesMB,
			M.IsInMediaGroup, M.retentionFlags, M.retentionExpireTime, P.MountPathId
	FROM	MMMedia M
			JOIN MMMediaSide S ON M.MediaId = S.MediaId AND M.MediaTypeId = 10001
			JOIN MMS2getMountPathNameGUIView P ON S.MediaSideId = P.MediaSideId
			JOIN #CopyMountPathSize X ON X.MediaSideId = S.MediaSideId
			JOIN archGroupCopy AGC ON AGC.id = X.CopyId
			JOIN archGroup AG ON AG.id = AGC.archGroupId
	WHERE	((@libOpt = 0 AND (@IncludeOrphanedMedia = 1 OR (@IncludeOrphanedMedia = 0 AND M.LibraryId <> 0)))  OR M.LibraryId in (select t_libId from @tblLibs ))
	DROP TABLE #CopyMountPathSize
END
IF @locOut > 0 AND @libOpt >= 0
BEGIN
	INSERT INTO #TEMP_MEDIA_LIST (loc,libId,medId,barCode,location,expLocation,sgId,statusReason,lastExpTime,isOutside,ctId,typeId,medFlag,medAttribute,IsInMediaGroup,retentionFlags,retentionExpireTime)
	SELECT DISTINCT 2,L.libraryId,MediaId,BarCode,ExportLocation,ExportLocation,SpareGroupId,MediaStatusReason,lastExportTime,1,M.containerId,M.MediaTypeId,M.MediaFlags,M.Attributes,M.IsInMediaGroup,M.retentionFlags,M.retentionExpireTime
	FROM	MMMedia M, MMLibrary L, MMExportLocation E
	WHERE	M.mediaTypeId <> 10001 AND M.MediaLocation = 3 AND M.MediaId > 0 AND
L.libraryTypeId <> 8 AND M.ExportLocationId = E.ExportLocationId AND
		((@libOpt = 0 AND (@IncludeOrphanedMedia = 1 OR (@IncludeOrphanedMedia = 0 AND M.LibraryId <> 0)))  OR M.LibraryId in (select t_libId from @tblLibs )) AND
		M.LibraryId = L.LibraryId
END
IF @locOut > 0 AND @shelfOpt >= 0
BEGIN
	INSERT INTO #TEMP_MEDIA_LIST (loc,libId,medId,barCode,location,expLocation,sgId,statusReason,lastExpTime,isOutside,ctId,typeId,medFlag,medAttribute,IsInMediaGroup,retentionFlags,retentionExpireTime)
	SELECT DISTINCT 2,M.LibraryId,MediaId,BarCode,ExportLocation,ExportLocation,SpareGroupId,MediaStatusReason,lastExportTime,1,M.containerId,M.MediaTypeId,M.MediaFlags,M.Attributes,M.IsInMediaGroup,M.retentionFlags,M.retentionExpireTime
	FROM	MMMedia M	JOIN MMLibrary L	ON M.LibraryId=L.LibraryId
				JOIN MMExportLocation E	ON M.ExportLocationId=E.ExportLocationId
WHERE	(@shelfOpt = 0 OR M.LibraryId in (select t_shelfId from @tblShelves)) AND M.MediaLocation = 3 AND L.libraryTypeId = 8
END
IF @extRetainedOnly > 0
	DELETE FROM #TEMP_MEDIA_LIST WHERE retentionFlags = 0
IF @basicRetainedOnly > 0
	DELETE FROM #TEMP_MEDIA_LIST WHERE retentionFlags > 0
IF @preventExportOnly > 0
DELETE FROM #TEMP_MEDIA_LIST WHERE (medAttribute & (16777216 | 536870912)) = 0
IF @locOpt <> 0
	DELETE #TEMP_MEDIA_LIST
	FROM	MMMedia
	WHERE	isOutside > 0 AND MediaId = medId AND
		(@locOpt = -1 OR ExportLocationID NOT IN (select t_locId from @tblLocations))
--Delete all the media that are at shelves if shelves are not selected
--If shelves are selected, look for the media that are exported and are at the selected shelves
--
DELETE #TEMP_MEDIA_LIST
FROM	MMMedia M	JOIN MMLibrary L	ON M.LastWriteLibraryId=L.LibraryId
				JOIN MMExportLocation E	ON M.ExportLocationId=E.ExportLocationId
WHERE	(M.MediaLocation = 3 AND (
(@shelfOpt = 0 AND M.LibraryId in (select LibraryId from MMlibrary where LibraryTypeId = 8))
			OR
			(@shelfOpt > 0 AND M.LibraryId in (select t_shelfId from @tblShelves))
			)
		AND M.LastWriteLibraryId > 0 AND M.LastWriteLibraryId =libid AND M.mediaId = medId)
CREATE CLUSTERED INDEX TEMP_MEDIA_LIST_IDX ON #TEMP_MEDIA_LIST (medId)
--Update mgId for tapes. One tape media has only one volume.
UPDATE	T SET mgId = V.MediaGroupId
FROM	#TEMP_MEDIA_LIST T INNER JOIN MMVolume V ON V.MediaId = T.medId AND V.RecordingFormatId <> 10001
UPDATE	T SET crTime = M.CreationTime
FROM	#TEMP_MEDIA_LIST T INNER JOIN MMMedia M ON T.medId = M.MediaId
IF @errorOnly > 0
	DELETE	#TEMP_MEDIA_LIST
	FROM	#TEMP_MEDIA_LIST, MMMediaSide
	WHERE	medId=mediaId AND NumberOfSoftErrors<=0 AND NumberOfHardErrors<=0
ELSE
	UPDATE	#TEMP_MEDIA_LIST
	SET	hasMediaError=1
	FROM	#TEMP_MEDIA_LIST, MMMediaSide
	WHERE	medId=mediaId AND (NumberOfSoftErrors>0 OR NumberOfHardErrors>0)
IF @timeOpt = 1 OR @timeOpt = 2
	DELETE	#TEMP_MEDIA_LIST
	FROM	#TEMP_MEDIA_LIST T, MMMedia M
 	WHERE		(T.isMag = 1 AND
				((T.magLastBkpT = 0 OR T.magLastBkpT < @startTime OR T.magLastBkpT > @endTime) AND
(@timeOpt = 1 OR T.magLastRstT = 0 OR T.magLastRstT < @startTime OR T.magLastRstT > @endTime)))
			OR
 				(T.isMag = 0 AND T.medId = M.MediaId AND
				((M.LastBackupTime = 0 OR M.LastBackupTime < @startTime OR M.LastBackupTime > @endTime) AND
(@timeOpt = 1 OR M.LastRestoreTime = 0 OR M.LastRestoreTime < @startTime OR M.LastRestoreTime > @endTime)))
ELSE IF @timeOpt = 3
	DELETE	#TEMP_MEDIA_LIST
	WHERE	LastExpTime = 0 OR LastExpTime < @startTime OR LastExpTime > @endTime
IF @deconfigClientOnly > 0
BEGIN
	CREATE TABLE #TEMP_MEDIA_CLIENT(MediaId INT, VolumeId INT, AppId INT, ClientId INT, Deconfigured INT)
	INSERT	INTO #TEMP_MEDIA_CLIENT
	SELECT	DISTINCT T.MediaId, T.VolumeId, AF.appId, 0, 0
	FROM	archFile AF, archChunkMapping ACM, archChunk AC,
			(SELECT	DISTINCT V.VolumeId, V.MediaId
			FROM	MMVolume V, #TEMP_MEDIA_LIST M
			WHERE	V.MediaId = M.medId) T
	WHERE	AF.id = ACM.archFileId AND AF.commCellId = ACM.commCellId AND AF.isValid = 1
AND ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId AND (ACM.flags & 256) = 0
AND AC.volumeId = T.VolumeId AND (AC.flags & 256) = 0
	UPDATE	#TEMP_MEDIA_CLIENT
	SET		ClientId = A.clientId
	FROM	APP_Application A
	WHERE	#TEMP_MEDIA_CLIENT.AppId = A.id
	UPDATE #TEMP_MEDIA_CLIENT
	SET		Deconfigured = 1
	WHERE	ClientId IN (
			SELECT	T.ClientId
			FROM	APP_Client C
					INNER JOIN (SELECT DISTINCT ClientId FROM #TEMP_MEDIA_CLIENT) T ON C.id = T.ClientId
					LEFT OUTER JOIN LicUsage L ON C.id = L.CId AND AppType < 1000 AND OpType = 'Install'
			WHERE	L.CId IS NULL)
	DELETE	#TEMP_MEDIA_LIST
	FROM	#TEMP_MEDIA_LIST LEFT OUTER JOIN
			(SELECT DISTINCT MediaId FROM #TEMP_MEDIA_CLIENT WHERE Deconfigured = 1) T
			ON	#TEMP_MEDIA_LIST.medId = T.MediaId
	WHERE	T.MediaId IS NULL
	DROP TABLE #TEMP_MEDIA_CLIENT
END
--got all qualified media, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @libOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2049, 0, '#rptUserObjects'	-- 2049 = LIBRARY_ITEM
	DELETE #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR clientId <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	DELETE #TEMP_MEDIA_LIST
	WHERE NOT EXISTS (select * from #rptUserObjects where libraryId IN (0, libid))
	DROP TABLE #rptUserObjects
END
SELECT	V.VolumeId,V.VolumeFlags,V.LastBackupTime,V.LastRestoreTime,V.VolumeFullReason,V.VolumeFullTime,V.VolumeFullJobId,V.physicalBytesMB,
	volStatus=(case VolumeFlags when 4 then 1 when 3 then 2 when 1 then 3 when 8 then 3 when 7 then 4
		when 2 then 5 when 5 then 6 else 0 end), S.MediaId, S.isErasable,
	S.NumberOfRestores, S.NumberOfBackups, S.NumberOfMounts, S.NumberOfSoftErrors, S.NumberOfHardErrors, S.NumberOfReUses
INTO #TEMP_VOL_LIST
FROM MMVolume V
	JOIN MMMediaSide S ON V.MediaSideId = S.MediaSideId
	JOIN #TEMP_MEDIA_LIST M ON M.medId = S.MediaId AND M.isMag = 0 AND M.medId > 0
IF @timeOpt = 4
BEGIN
	CREATE TABLE #ChunkVolMed (volId int, medId int)
	INSERT INTO #ChunkVolMed
	SELECT	DISTINCT V.VolumeId, V.MediaId
	FROM	archChunk AC INNER JOIN MMVolume V ON AC.volumeId = V.VolumeId
	WHERE	AC.CreateTime > @startTime AND AC.CreateTime < @endTime
	DELETE	#TEMP_VOL_LIST
	FROM	#TEMP_VOL_LIST V LEFT OUTER JOIN #ChunkVolMed C ON V.volumeId = C.volId
	WHERE	C.volId IS NULL
	DELETE	#TEMP_MEDIA_LIST
	FROM	#TEMP_MEDIA_LIST M LEFT OUTER JOIN (SELECT DISTINCT medId FROM #ChunkVolMed) C ON M.medId = C.medId
	WHERE	C.medId IS NULL
	DROP TABLE #ChunkVolMed
END
CREATE INDEX TEMP_VOL_LIST_IDX ON #TEMP_VOL_LIST (MediaId)
UPDATE	#TEMP_MEDIA_LIST
SET		magBytesMB = V.physicalBytesMB
FROM	#TEMP_MEDIA_LIST M INNER JOIN
	(SELECT	MediaId, SUM(CAST(physicalBytesMB AS BIGINT)) AS physicalBytesMB
	FROM	#TEMP_VOL_LIST
	GROUP BY MediaId
	) V ON M.medId = V.MediaId AND M.isMag = 0
-- Update Policy id and name for Non Megnatic Updated by vnirala on 10-Oct-2006
UPDATE	#TEMP_MEDIA_LIST
SET		policyId = G.id, policy = G.name, copy = C.name, copyid = C.id
FROM	#TEMP_MEDIA_LIST M
		INNER JOIN archStream S	ON S.mediaGroupId = mgId
		INNER JOIN archGroup G ON G.id = S.archGroupId
		INNER JOIN archGroupCopy C ON C.id = S.archGroupCopyId
WHERE	M.mgId > 0 AND M.isMag = 0 AND M.IsInMediaGroup > 0
--media in wrong library
UPDATE #TEMP_MEDIA_LIST
SET	groupType=-1
WHERE	isMag=0 and (mediaStatus & 4) > 0
UPDATE #TEMP_MEDIA_LIST
SET	groupType=ISNULL((SELECT SpareGroupType FROM MMSpareGroup WHERE SpareGroupId=sgId), groupType)
WHERE	sgId > 0 AND groupType <> -1 AND IsInMediaGroup = 0
UPDATE #TEMP_MEDIA_LIST
SET	UseSec=UseWithinDaysInSec
FROM	MMLibrary
WHERE	isMag=0 and libId=LibraryId
UPDATE #TEMP_MEDIA_LIST
SET	mediaStatus = (select min(volStatus) from #TEMP_VOL_LIST where medId=mediaId),
	volNum = (select count(*) from #TEMP_VOL_LIST where medId=mediaId)
WHERE	isMag=0 and groupType <> -1
-- filter media by media status. mediaStatus is converted for genReportBase::convertMediaStatus().
IF @includeAllStatusMedia = 0
BEGIN
--	IF @includeBadMedia = 0
--		DELETE #TEMP_MEDIA_LIST WHERE isMag = 0 AND medFlag = 2 AND groupType = 0
	IF @includeReadOnlyMedia = 0
		DELETE #TEMP_MEDIA_LIST WHERE isMag = 0 AND (mediaStatus = 2 OR medFlag = 4)
	IF @includeActiveMedia = 0
		DELETE #TEMP_MEDIA_LIST WHERE isMag = 0 AND mediaStatus = 3 AND groupType = 0 AND (medFlag = 1 OR medFlag = 2 AND @includeBadMedia = 0)
	IF @includeAppendableMedia = 0
		DELETE #TEMP_MEDIA_LIST WHERE isMag = 0 AND mediaStatus = 4 AND groupType = 0 AND (medFlag = 1 OR medFlag = 2 AND @includeBadMedia = 0)
	IF @includeFullMedia = 0
		DELETE #TEMP_MEDIA_LIST WHERE isMag = 0 AND mediaStatus = 5 AND groupType = 0 AND (medFlag = 1 OR medFlag = 2 AND @includeBadMedia = 0)
	IF @includeSpareMedia = 0
DELETE #TEMP_MEDIA_LIST WHERE isMag = 0 AND mediaStatus = 6 AND groupType IN (1, 2)
	IF @includeUndiscoveredMedia = 0
DELETE #TEMP_MEDIA_LIST WHERE isMag = 0 AND mediaStatus < 1 AND (groupType = 4 OR groupType = -1 AND medId = 0)
	IF @includeRetiredMedia = 0
DELETE #TEMP_MEDIA_LIST WHERE isMag = 0 AND mediaStatus < 1 AND groupType = 8
	IF @includeForeignMedia = 0
DELETE #TEMP_MEDIA_LIST WHERE isMag = 0 AND mediaStatus < 1 AND groupType = 16
	IF @includeCleaningMedia = 0
DELETE #TEMP_MEDIA_LIST WHERE isMag = 0 AND mediaStatus < 1 AND groupType = 32
	IF @includeOverwriteProtectedMedia = 0
DELETE #TEMP_MEDIA_LIST WHERE isMag = 0 AND mediaStatus < 1 AND groupType = 64
END
--MR 15264
--filter media for selected storage policy/copy
IF @SPOpt > 0
BEGIN
	IF @includeSpareMedia = 1 AND @allCopies = 0
		DELETE	T
		FROM	#TEMP_MEDIA_LIST T
				LEFT OUTER JOIN (
				SELECT	DISTINCT DP.SpareGroupId
				FROM	MMDataPath DP
						INNER JOIN archGroupCopy AGC ON DP.CopyId = AGC.id
						INNER JOIN  @tblSPs t ON AGC.archGroupId = t.t_policyId
				WHERE	DP.SpareGroupId > 0 AND t.t_copyId IN (0, AGC.id)
				) SG ON T.sgId = SG.SpareGroupId
		WHERE	T.sgId > 0 AND SG.SpareGroupId IS NULL
AND T.isMag = 0 AND T.mediaStatus = 6 AND T.groupType IN (1, 2)
	DELETE	T
	FROM	#TEMP_MEDIA_LIST T
			LEFT OUTER JOIN (
				SELECT	c.id
				FROM	archGroupCopy c WITH (NOLOCK), @tblSPs t
				WHERE	c.id > 0 AND t_copyId IN (0, c.id) AND t_policyId IN (0, c.archGroupId)
			) CP ON T.copyId = CP.id
			LEFT OUTER JOIN (
				SELECT	s.mediaGroupId
				FROM	archStream s WITH (NOLOCK), @tblSPs t
				WHERE	t_copyId IN (0, s.archGroupCopyId) AND t_policyId IN (0, s.archGroupId)
			) MG ON T.mgId = MG.mediaGroupId
	WHERE	CP.id IS NULL AND MG.mediaGroupId IS NULL
AND T.groupType NOT IN (1, 2)
		AND (T.medId > 0 AND ((T.mgId > 0 OR T.sgId > 0 OR @IncludeOrphanedMedia = 0) OR (T.mgId = 0 AND  T.sgId = 0)) AND T.groupType IN (0, -1) OR @allCopies = 0)
END
--when no SP/copies are selected, delete all the media with SP associated.
ELSE IF @SPOpt < 0
	DELETE	#TEMP_MEDIA_LIST
	WHERE   policyId > 0
-- MR 93799
-- update isPartOfVtRecall
-- action Type 2 is TM_ACTION_TYPE_RECALL
UPDATE #TEMP_MEDIA_LIST
SET isPartOfVtRecall = 1
FROM #TEMP_MEDIA_LIST
WHERE medId in (select mediaid from vtaction vta LEFT OUTER JOIN vtactionmedia vtam ON vta.actionId= vtam.actionId where actionType = 2)
/*
-- Fixed MR 96007 chandra(knaidu@commvault.com)
-- delete the media in sparegroups if the last write time, last read time, data creation time is selected
----------the fix seems to break things hence commenting out----------- for MR 107720
IF @timeOpt <> 0 AND @timeOpt <> 3
BEGIN
	DELETE #TEMP_MEDIA_LIST
	WHERE groupType in (1,2)
END*/
--MR 17670
--delete dummy media which is created by galaxy when media was not stamped and data protection job use it directly
DELETE #TEMP_MEDIA_LIST
WHERE barCode like 'StdAln_' + CAST(medId as varchar(MAX))
-- Update the MediaAgent Names for magnetic librarires(multiple MA's if it is Shared Mount Path)
CREATE TABLE #MountPathMA  (mountPathId INT, mediaAgent NVARCHAR(1024), numOfMAs INT)
CREATE TABLE #MountPathMAs (mountPathId INT, mediaAgents NVARCHAR(1024))
--IF EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'bUseClientDisplayName' AND relativePath = 'CommServDB.Console' AND type = 'BOOLEAN' AND cast([value] as nvarchar(32)) = N'true' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = 2)
--BEGIN
--    SET @useClientDisplayName = 1
--END
INSERT	INTO #MountPathMA
SELECT  MP.mountPathId, (CASE WHEN @useClientDisplayName = 1 THEN CL.displayname ELSE CL.name END), 1
FROM	(SELECT DISTINCT mountPathId FROM #TEMP_MEDIA_LIST WHERE mountPathId <> 0) T
		INNER JOIN MMMountPath MP ON MP.mountPathID = T.mountPathId
		INNER JOIN MMLibraryController LC ON LC.LibraryId = MP.LibraryId
		INNER JOIN APP_Client CL ON CL.id = LC.clientId
UPDATE	#MountPathMA
SET		numOfMAs = T.numOfMAs
FROM	(SELECT	mountPathId, COUNT(*) AS numOfMAs FROM #MountPathMA GROUP BY mountPathId HAVING COUNT(*) > 1) T
WHERE	#MountPathMA.mountPathId = T.mountPathId
DECLARE GetMountPathMA CURSOR FOR
SELECT	mountPathId, mediaAgent
FROM	#MountPathMA
WHERE	numOfMAs > 1
ORDER BY mountPathId, mediaAgent
DECLARE @l_mountPathId	INT = 0
DECLARE @l_prevMPId		INT = 0
DECLARE @l_mediaAgent	NVARCHAR(1024) = ''
DECLARE @l_maNames		NVARCHAR(1024) = ''
OPEN GetMountPathMA
FETCH NEXT FROM GetMountPathMA INTO @l_mountPathId, @l_mediaAgent
WHILE @@FETCH_STATUS = 0
BEGIN
	IF @l_prevMPId <> @l_mountPathId
	BEGIN
		IF @l_prevMPId > 0
			INSERT INTO #MountPathMAs
			SELECT	@l_prevMPId, @l_maNames
		SET @l_prevMPId = @l_mountPathId
		SET @l_maNames = @l_mediaAgent
	END
	ELSE
		SET @l_maNames = @l_maNames + ', ' + @l_mediaAgent
	FETCH NEXT FROM GetMountPathMA INTO @l_mountPathId, @l_mediaAgent
END
CLOSE GetMountPathMA
DEALLOCATE GetMountPathMA
IF @l_prevMPId > 0
	INSERT	INTO #MountPathMAs
	SELECT	@l_mountPathId, @l_maNames
UPDATE	#TEMP_MEDIA_LIST
SET		maNames = #MountPathMA.mediaAgent
FROM	#MountPathMA
WHERE	#TEMP_MEDIA_LIST.mountPathId = #MountPathMA.mountPathId AND #MountPathMA.numOfMAs = 1
UPDATE	#TEMP_MEDIA_LIST
SET		maNames = #MountPathMAs.mediaAgents
FROM	#MountPathMAs
WHERE	#TEMP_MEDIA_LIST.mountPathId = #MountPathMAs.mountPathId
DROP TABLE #MountPathMA
DROP TABLE #MountPathMAs
--MR 24368
UPDATE #TEMP_MEDIA_LIST
SET	mediaStatus = 1
FROM	#TEMP_MEDIA_LIST
WHERE	isMag=0 and groupType <> -1 and medFlag=2
--Summary info
INSERT INTO #TEMP_MEDIA_LIST (isSum,loc,isMag,mgId,groupType,mediaStatus,statusReason,lastExpTime,volNum,magLastBkpT,magLastRstT,magBytesMB,medFlag,medAttribute,medId,sgId)
SELECT 2,
	(select count(distinct medId) from #TEMP_MEDIA_LIST where medId>0),
	(select count(distinct medId) from #TEMP_MEDIA_LIST where mediaStatus=3 and groupType=0),
	(select count(distinct medId) from #TEMP_MEDIA_LIST where mediaStatus=5 and groupType=0),
	(select count(distinct medId) from #TEMP_MEDIA_LIST where mediaStatus=4 and groupType=0),
	(select count(distinct medId) from #TEMP_MEDIA_LIST where mediaStatus=6 and groupType=0),
	(select count(distinct medId) from #TEMP_MEDIA_LIST where mediaStatus=2 and groupType=0),
	(select count(distinct medId) from #TEMP_MEDIA_LIST where mediaStatus=1 and groupType=0),
	(select count(distinct medId) from #TEMP_MEDIA_LIST where groupType>0),
	(select count(distinct medId) from #TEMP_MEDIA_LIST where groupType=32),
	(select count(distinct medId) from #TEMP_MEDIA_LIST where groupType=8),
	(select sum(magBytesMB) from #TEMP_MEDIA_LIST),
	(select count(distinct medId) from #TEMP_MEDIA_LIST where groupType=16),
	(select count(distinct medId) from #TEMP_MEDIA_LIST where groupType=64),
	(select count(*) from #TEMP_MEDIA_LIST where groupType=-1),
	(select count(*) from #TEMP_MEDIA_LIST where groupType=-1 and (mediaStatus&1)=0 and (mediaStatus&4)=0)
IF @orderBy = 10
BEGIN
	INSERT INTO @tblObjectList SELECT DISTINCT libId FROM #TEMP_MEDIA_LIST WHERE isSum=0
	INSERT INTO #TEMP_MEDIA_LIST (isSum,loc,isMag,mgId,groupType,mediaStatus,statusReason,lastExpTime,volNum,magLastBkpT,magLastRstT,magBytesMB,medFlag,medAttribute,libId,medId,sgId)
	SELECT 1,
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and groupType>=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and mediaStatus=3 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and mediaStatus=5 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and mediaStatus=4 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and mediaStatus=6 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and mediaStatus=2 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and mediaStatus=1 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and groupType>0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and groupType=32),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and groupType=8),
		(select sum(magBytesMB) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and groupType=16),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and groupType=64),t_id,
		(select count(*) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and groupType=-1),
		(select count(*) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and groupType=-1 and (mediaStatus&1)=0 and (mediaStatus&4)=0)
	FROM @tblObjectList
END
IF @orderBy = 15
BEGIN
	UPDATE #TEMP_MEDIA_LIST
	SET policy='ZZZZZ'
	WHERE policyId=0
	INSERT INTO @tblObjectList SELECT DISTINCT policyId FROM #TEMP_MEDIA_LIST WHERE isSum=0
	INSERT INTO #TEMP_MEDIA_LIST (isSum,loc,isMag,mgId,groupType,mediaStatus,statusReason,lastExpTime,volNum,magLastBkpT,magLastRstT,magBytesMB,medFlag,medAttribute,policyId,policy)
	SELECT 1,
		(select count(distinct medId) from #TEMP_MEDIA_LIST where policyId=t_id and isSum=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where policyId=t_id and isSum=0 and mediaStatus=3 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where policyId=t_id and isSum=0 and mediaStatus=5 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where policyId=t_id and isSum=0 and mediaStatus=4 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where policyId=t_id and isSum=0 and mediaStatus=6 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where policyId=t_id and isSum=0 and mediaStatus=2 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where policyId=t_id and isSum=0 and mediaStatus=1 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where policyId=t_id and isSum=0 and groupType>0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where policyId=t_id and isSum=0 and groupType=32),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where policyId=t_id and isSum=0 and groupType=8),
		(select sum(magBytesMB) from #TEMP_MEDIA_LIST where policyId=t_id and isSum=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where policyId=t_id and isSum=0 and groupType=16),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where policyId=t_id and isSum=0 and groupType=64),
		t_id,(CASE t_id WHEN 0 THEN 'ZZZZZ' ELSE (select name from archGroup where id=t_id) END)
	FROM @tblObjectList
END
IF @orderBy = 11
BEGIN
	INSERT INTO @tblObjectList SELECT DISTINCT libId FROM #TEMP_MEDIA_LIST WhERE isSum=0 AND isOutside=0 AND libId>0
	INSERT INTO #TEMP_MEDIA_LIST (isSum,loc,isMag,mgId,groupType,mediaStatus,statusReason,lastExpTime,volNum,magLastBkpT,magLastRstT,magBytesMB,medFlag,medAttribute,libId,isOutside)
	SELECT 1,
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and isOutside=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and isOutside=0 and mediaStatus=3 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and isOutside=0 and mediaStatus=5 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and isOutside=0 and mediaStatus=4 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and isOutside=0 and mediaStatus=6 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and isOutside=0 and mediaStatus=2 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and isOutside=0 and mediaStatus=1 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and isOutside=0 and groupType>0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and isOutside=0 and groupType=32),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and isOutside=0 and groupType=8),
		(select sum(magBytesMB) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and isOutside=0 and groupType=16),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where libId=t_id and isSum=0 and isOutside=0 and groupType=64), t_id,0
	FROM @tblObjectList
	INSERT INTO @tblLocList SELECT DISTINCT expLocation FROM #TEMP_MEDIA_LIST WhERE isSum=0 AND isOutside=1 AND expLocation<>''
	INSERT INTO #TEMP_MEDIA_LIST (isSum,loc,isMag,mgId,groupType,mediaStatus,statusReason,lastExpTime,volNum,magLastBkpT,magLastRstT,magBytesMB,medFlag,medAttribute,location,isOutside)
	SELECT 1,
		(select count(distinct medId) from #TEMP_MEDIA_LIST where expLocation=t_name and isSum=0 and isOutside=1),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where expLocation=t_name and isSum=0 and isOutside=1 and mediaStatus=3 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where expLocation=t_name and isSum=0 and isOutside=1 and mediaStatus=5 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where expLocation=t_name and isSum=0 and isOutside=1 and mediaStatus=4 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where expLocation=t_name and isSum=0 and isOutside=1 and mediaStatus=6 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where expLocation=t_name and isSum=0 and isOutside=1 and mediaStatus=2 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where expLocation=t_name and isSum=0 and isOutside=1 and mediaStatus=1 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where expLocation=t_name and isSum=0 and isOutside=1 and groupType>0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where expLocation=t_name and isSum=0 and isOutside=1 and groupType=32),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where expLocation=t_name and isSum=0 and isOutside=1 and groupType=8),
		(select sum(magBytesMB) from #TEMP_MEDIA_LIST where expLocation=t_name and isSum=0 and isOutside=1),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where expLocation=t_name and isSum=0 and isOutside=1 and groupType=16),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where expLocation=t_name and isSum=0 and isOutside=1 and groupType=64), t_name, 1
	FROM @tblLocList
END
IF @orderBy = 12
BEGIN
	INSERT INTO @tblObjectList SELECT DISTINCT ctId FROM #TEMP_MEDIA_LIST WHERE isSum=0
	INSERT INTO #TEMP_MEDIA_LIST (isSum,loc,isMag,mgId,groupType,mediaStatus,statusReason,lastExpTime,volNum,magLastBkpT,magLastRstT,magBytesMB,medFlag,medAttribute,ctId)
	SELECT 1,
		(select count(distinct medId) from #TEMP_MEDIA_LIST where ctId=t_id and isSum=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where ctId=t_id and isSum=0 and mediaStatus=3 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where ctId=t_id and isSum=0 and mediaStatus=5 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where ctId=t_id and isSum=0 and mediaStatus=4 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where ctId=t_id and isSum=0 and mediaStatus=6 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where ctId=t_id and isSum=0 and mediaStatus=2 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where ctId=t_id and isSum=0 and mediaStatus=1 and groupType=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where ctId=t_id and isSum=0 and groupType>0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where ctId=t_id and isSum=0 and groupType=32),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where ctId=t_id and isSum=0 and groupType=8),
		(select sum(magBytesMB) from #TEMP_MEDIA_LIST where ctId=t_id and isSum=0),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where ctId=t_id and isSum=0 and groupType=16),
		(select count(distinct medId) from #TEMP_MEDIA_LIST where ctId=t_id and isSum=0 and groupType=64),t_id
	FROM @tblObjectList
END
--Update the last write coloumn for media  Updated by vnirala on 10-Oct-2006
UPDATE #TEMP_MEDIA_LIST
SET lastWriteTime = magLastBkpT
WHERE	isSum = 0 AND barcode='Magnetic'
UPDATE #TEMP_MEDIA_LIST
SET lastWriteTime =(SELECT max(B.LastBackupTime) FROM #TEMP_VOL_LIST B WHERE MedId = B.MediaId)
WHERE	isSum = 0 AND barcode<>'Magnetic'
UPDATE #TEMP_MEDIA_LIST
SET	medFlag		= M.mediaFlags,
	Descript = M.Descript,
	medAttribute	= M.Attributes,
	IsInMediaGroup	= M.IsInMediaGroup,
	retentionFlags	= M.retentionFlags,
	retentionExpireTime	= M.retentionExpireTime,
	pinExpireTime	= M.PinMediaExpireTime
FROM	MMMedia M
WHERE	isSum = 0 AND medId = MediaId AND medId > 0
/*
UPDATE #TEMP_MEDIA_LIST
SET retentionExpireTime = 0
FROM archGroupCopy AGC
WHERE	isSum = 0 AND copyId = AGC.id
AND (AGC.extendedFlags & 1) > 0
*/
CREATE TABLE #tblMediaEncryption (mediaId int, encrypted int)
-- Jun Lu: This statement is expensive and only needed for non-disk media.
INSERT INTO #tblMediaEncryption
SELECT f.medId, MAX(CASE WHEN b.encKeyType <> 0 OR d.hwEncKey <> '' THEN 1 ELSE 0 END) + MAX(CASE WHEN b.encKeyType = 0 AND d.hwEncKey = '' THEN 2 ELSE 0 END)
FROM archfile a with (nolock), archFileCopy b with (nolock),
     archChunkMapping c with (nolock), archChunk d with (nolock),
	 mmvolume e with (nolock), #TEMP_MEDIA_LIST f
WHERE a.id = b.archFileId and a.commCellId = b.commCellId
AND a.isValid = 1 and b.isValid = 1
-- Exclude index data as it will not be encrypted always
AND a.fileType NOT IN (2, 33, 5, 35,
6, 7, 9)
AND b.archFileId = c.archFileId and b.commCellId = c.commCellId
AND b.archCopyId = c.archCopyId
AND c.archChunkId = d.id AND c.chunkCommCellId = d.commCellId
AND d.volumeId = e.volumeId
AND e.mediaId = f.medId AND f.isMag = 0
GROUP BY f.medId
UPDATE #TEMP_MEDIA_LIST
SET encrypted = CASE ENC.encrypted WHEN 1 THEN 1 WHEN 3 THEN 2 ELSE 0 END
FROM #tblMediaEncryption ENC
WHERE	isSum = 0 AND medId = ENC.mediaId
DROP TABLE #tblMediaEncryption
-- get a comma separated jobIds string for each media
IF @includeJobIDs = 1
BEGIN
	;WITH MediaJobIdList (MediaId, JobId) AS
	(
		SELECT	V.MediaId, ACM.jobId
		FROM	archChunkMapping ACM WITH (NOLOCK)
				INNER JOIN archChunk AC WITH (NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
AND (@includeAgedData = 1 OR (ACM.flags & 256) = 0 AND (AC.flags & 256) = 0)
INNER JOIN MMVolume V WITH (NOLOCK) ON AC.volumeId = V.VolumeId AND (V.Attributes & 512) = 0
				INNER JOIN #TEMP_MEDIA_LIST M ON V.MediaId = M.medId
		GROUP BY V.MediaId, ACM.jobId
	)
	,MediaJobIds (MediaId, JobIDs) AS
	(
		SELECT	MediaId,
				STUFF((
					SELECT ' ' + CAST(jobId AS VARCHAR(20)) FROM MediaJobIdList WHERE MediaId = A.MediaId ORDER BY JobId FOR XML PATH('')
				),1,1,'')
		FROM	MediaJobIdList A
		GROUP BY MediaId
	)
	UPDATE	#TEMP_MEDIA_LIST SET JobIDs = MJ.JobIDs
	FROM	MediaJobIds MJ
	WHERE	isSum = 0 AND #TEMP_MEDIA_LIST.medId = MJ.MediaId
END
SELECT isSum,loc,isMag,mgId,groupType,mediaStatus,statusReason,lastExpTime,volNum,magLastBkpT,magLastRstT,ROUND(magBytesMB/1024.0,2) AS magBytesGB,medFlag,medAttribute,
	libId,library=(select AliasName from MMLibrary where LibraryId=libId),
	policyId,policy,Location,ctId,containerName=(case ctId when 0 then 'ZZZZZ' else (select containerName from MMContainer where containerId=ctId) end),
	medId,sgId,spareGroup=(case when sgId>0 then (select spareGroupName from MMSpareGroup where spareGroupId=sgId) else '' end),
	barCode,copy,UseSec,VolumeId,VolumeFlags,LastBackupTime,LastRestoreTime,
	VolumeFullReason,VolumeFullTime,VolumeFullJobId,ROUND(physicalBytesMB/1024.0,2) AS physicalBytesGB,volStatus,isErasable,
	NumberOfRestores,NumberOfBackups,NumberOfMounts,NumberOfSoftErrors,NumberOfHardErrors,NumberOfReUses,crTime,
	creationTime=(CASE WHEN crTime>0 THEN DATEDIFF(month, DATEADD(second, crTime, '01/01/1970'), getutcdate()) ELSE 0 END),
	MonthsInUseThreshold, NumberOfReUsesThreshold, ShortLengthDurabilityThreshold, NumberOfSoftErrorsThreshold, NumberOfHardErrorsThreshold,
	slotNum=(case slotId when 0 then 0 else (select count(*) from MMSlot S, MMBay B where S.BayId=B.BayId AND B.LibraryId=libId) end),
	hasMediaError,retentionFlags,retentionExpireTime,isOutside,expLocation,slotId,slotName,lastWriteTime,pinExpireTime,isPartOfVtRecall,maNames,MediaTypeName, encrypted
	, jobIDs, Descript
INTO #FINAL_RETURN_LIST
FROM #TEMP_MEDIA_LIST	LEFT OUTER JOIN #TEMP_VOL_LIST ON medId=MediaID and isSum=0
			LEFT OUTER JOIN MMMediaType ON mediaTypeId=typeId
IF @orderBy = 10
	SELECT * FROM #FINAL_RETURN_LIST ORDER BY isSum DESC, Library, isOutside, BarCode
ELSE IF @orderBy = 15
	SELECT * FROM #FINAL_RETURN_LIST ORDER BY isSum DESC, policy, copy, spareGroup, sgId, BarCode
ELSE IF @orderBy = 11
	SELECT * FROM #FINAL_RETURN_LIST ORDER BY isSum DESC, isOutside, expLocation, Library, slotId, location
ELSE IF @orderBy = 12
	SELECT * FROM #FINAL_RETURN_LIST ORDER BY isSum DESC, containerName, Library, BarCode
ELSE IF @orderBy = 13
	SELECT * FROM #FINAL_RETURN_LIST ORDER BY isSum DESC, lastWriteTime ASC, Library, BarCode
ELSE
	SELECT * FROM #FINAL_RETURN_LIST ORDER BY isSum DESC, BarCode
DROP TABLE #FINAL_RETURN_LIST
DROP TABLE #TEMP_MEDIA_LIST
DROP TABLE #TEMP_VOL_LIST
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetMediaList')
	delete from GxQscripts where name = 'RptGetMediaList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMediaList')
	delete from GXDBVersions where aliasname = 'RptGetMediaList'
GO

insert into GXDBVersions values(2, 'RptGetMediaList',  '00010077000200220000', 'RptGetMediaList', '00010077000200220000')
GO

