

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetMediaForRecovery.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetMediaForRecovery.sp,v $ $Id: RptGetMediaForRecovery.sp,v 1.30.36.6 2018/07/06 01:40:29 prakash Exp $";
-- 	+-----------------------------------------------------------------------+
--  |       PROCEDURE : "RptGetMediaForRecovery"                            |
--  |                                                                       |
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	    |
--	| AND RETURNING RESULTS							                        |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetMediaForRecovery')
BEGIN
	print '>>> Drop Stored Procedure: RptGetMediaForRecovery <<<'
	drop procedure RptGetMediaForRecovery
END
IF EXISTS (select * from GxQscripts where name='RptGetMediaForRecovery')
	delete from GxQscripts where name = 'RptGetMediaForRecovery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMediaForRecovery')
	delete from GXDBVersions where aliasname = 'RptGetMediaForRecovery'
GO
print '... Creating Procedure: RptGetMediaForRecovery'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetMediaForRecovery
  @i_jobId integer
AS
  DECLARE @o_clientId integer;
  DECLARE @o_clientName NVARCHAR(255);
  DECLARE @o_apptypeId integer;
  DECLARE @o_apptypeName char(255);
  DECLARE @o_instanceId integer;
  DECLARE @o_instanceName char(255);
  DECLARE @o_backupSetId integer;
  DECLARE @o_backupSetName char(255);
  DECLARE @o_subclientId integer;
  DECLARE @o_subclientName char(255);
  DECLARE @o_mediaCount integer;
  DECLARE @o_mediaId integer;
  DECLARE @o_barcode char(255);
  DECLARE @o_mediaTypeId integer;
  DECLARE @o_mediaLocation integer;
  DECLARE @o_exportLocation NVARCHAR(255);
  DECLARE @o_containerId integer;
  DECLARE @o_containerName NVARCHAR(255);
  DECLARE @o_libraryId integer;
  DECLARE @o_libraryName NVARCHAR(255);
  DECLARE @o_StoragePolicyId integer;
  DECLARE @o_StoragePolicyName NVARCHAR(255);
  DECLARE @o_StoragePolicyCopyId integer;
  DECLARE @o_StoragePolicyCopyName NVARCHAR(255);
  DECLARE @o_location NVARCHAR(255);
  DECLARE @o_clientDisplayName NVARCHAR(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId		integer
DECLARE @startTime	integer
DECLARE @endTime	integer
DECLARE @clOpt		integer
DECLARE @appTypeOpt	integer
DECLARE @appId		integer
DECLARE @jobType	integer
DECLARE @isSynFull	integer
DECLARE @tblClients	TABLE ( t_clId int )
DECLARE @tblApptypes	TABLE ( t_appTypeId int )
DECLARE @tblAppIds	TABLE ( t_clientId	int,
				t_apptypeId	int,
				t_backupset	int,
				t_instance	int,
				t_appId		int,
				t_medCount	int)
IF object_id('tempdb.dbo.#tempMediaPredictionRptTbl') IS NOT null DROP TABLE #tempMediaPredictionRptTbl
CREATE TABLE #tempMediaPredictionRptTbl ( t_mediaId		int,
t_uniqueId 			char(255),
t_barCode 			char(255),
				t_mediaTypeId		integer,
				t_mediaLocation		integer,
t_exportLocation	nvarchar(255),
				t_containerId		integer,
t_containerName		nvarchar(255),
				t_libraryId			integer,
t_libraryName 		char(255),
				t_subclientId 		integer,
t_subclientName		char(255),
				t_copyPrecedence	integer,
				t_copyId 		integer,
t_copyName 		nvarchar(255),
				t_spId 			integer,
t_spName 		nvarchar(255),
				t_location		nvarchar(1024) default (''))
SET @userId = dbo.GetOptionInt(140019, @i_jobId, 0, 0)
INSERT INTO @tblApptypes EXEC rptOptGetObjectList @i_jobId, 444361887, @appTypeOpt OUTPUT
SET @jobType = dbo.GetOptionInt(245928906, @i_jobId, 0, 0)
SET @isSynFull = (case @jobType & 2 when 0 then 0 else 1 end)
IF @isSynFull > 0
BEGIN
	SET @startTime = 0
	SET @endTime = 0
END
ELSE
	EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
INSERT INTO @tblClients EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
INSERT INTO @tblAppIds
SELECT	clientId, apptypeID, backupset, instance, id, 0
FROM	APP_Application
WHERE	appTypeId<1000 AND appTypeId NOT BETWEEN 600 AND 654 AND
	(@appTypeOpt = 0 OR appTypeId in (select t_appTypeId from @tblApptypes)) AND
	(@clOpt = 0 OR clientId in (select t_clId from @tblClients))
DELETE @tblAppIds
FROM APP_Application A, APP_InstanceName I
WHERE t_appId = A.id and t_instance = I.id and
	((A.subclientStatus & 2) > 0 OR 	-- uninstalled
	 (A.subclientStatus & 4) > 0 OR 	-- deleted
	 (A.subclientStatus & 16) > 0 OR	-- dummy
	 (A.subclientStatus & 32) > 0 OR	-- hidden
	 (I.status & 16) > 0 OR
	 (I.status & 32) > 0)
--got all qualified entries, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @clOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2009, 0, '#rptUserObjects'	-- 2009 = CLIENT_ITEM
	delete #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	delete	@tblAppIds
	WHERE	NOT EXISTS (	select	* from #rptUserObjects U
			 	where	U.clientId IN (0, t_clientId) AND
					U.appTypeId IN (0,t_appTypeId) AND
					U.instanceId IN (0, t_instance) AND
					U.backupsetId IN (0, t_backupSet) AND
					U.subClientId IN (0, t_appId))
	DROP TABLE #rptUserObjects
END
DECLARE getAppIds CURSOR FOR
SELECT t_appId FROM @tblAppIds
OPEN getAppIds
FETCH NEXT FROM getAppIds INTO @appId
WHILE @@FETCH_STATUS = 0
BEGIN
	/*Sebastian: There is a change in the below proc wherein it inserts from proc execution. Nested inserts causes runtime failure.
    So instead we have created temp table #tempMediaPredictionRptTbl and if such a temp table exists, we insert into it in the called proc itself
    INSERT INTO @tblMedia(	t_mediaId, t_uniqueId, t_barCode, t_mediaTypeId, t_mediaLocation, t_exportLocation, t_containerId, t_containerName,
		 		t_libraryId, t_libraryName, t_subclientId, t_subclientName, t_copyPrecedence, t_copyId, t_copyName, t_spId, t_spName)*/
	EXEC GetMediaListForAppIdByTime 0, @appId, @startTime, @endTime, 0
	FETCH NEXT FROM getAppIds INTO @appId
END
CLOSE getAppIds
DEALLOCATE getAppIds
UPDATE @tblAppIds
SET t_medCount = ISNULL((select count(*) from #tempMediaPredictionRptTbl where t_appId = t_subclientId), 0)
UPDATE #tempMediaPredictionRptTbl
SET t_location = (case t_mediaTypeId
when 10001 then S.MountPathName
		else 	(case t_mediaLocation
			when 1 then (SELECT SlotName  FROM MMSlot  WITH (NOLOCK) WHERE MediaId = t_mediaId)
			when 2 then (SELECT AliasName FROM MMDrive WITH (NOLOCK) WHERE MediaId = t_mediaId)
			else t_exportLocation end)
		end)
FROM	#tempMediaPredictionRptTbl, MMS2getMountPathNameGUIView S
WHERE	t_mediaId = S.mediaId
delete from @tblAppIds where t_clientId in (select id from APP_Client where (status&0x10000000)=0x10000000) -- remove edge drive clients (status=0x1000000)
SELECT	t_clientId, clientName=(select name from APP_Client where id=t_clientId),
	t_apptypeId, appTypeName=(select name from APP_iDAType where type=t_apptypeId),
	t_instance, instanceName=(select name from APP_InstanceName where id=t_instance),
	t_backupSet, backupsteName=(select name from APP_BackupSetName where id=t_backupSet),
	t_appId,subclientName=(	case when t_subclientName is null then (select subclientName from APP_application where id=t_appId)
			else t_subclientName end ),
	t_medCount, t_mediaId, t_barCode, t_mediaTypeId, t_mediaLocation, t_exportLocation, t_containerId, (case t_containerid when 0 then '' else t_containerName end),
	t_libraryId, t_libraryName, t_spId, t_spName, t_copyId, t_copyName, t_location,
    clientDisplayName=(select displayname from APP_Client where id=t_clientId)
FROM	@tblAppIds LEFT JOIN #tempMediaPredictionRptTbl ON t_appId = t_subclientId
ORDER BY clientName, appTypeName, instanceName, backupsteName, subclientName
IF object_id('tempdb.dbo.#tempMediaPredictionRptTbl') IS NOT null DROP TABLE #tempMediaPredictionRptTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetMediaForRecovery')
	delete from GxQscripts where name = 'RptGetMediaForRecovery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMediaForRecovery')
	delete from GXDBVersions where aliasname = 'RptGetMediaForRecovery'
GO

insert into GXDBVersions values(2, 'RptGetMediaForRecovery',  '00010030003600060000', 'RptGetMediaForRecovery', '00010030003600060000')
GO

