

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetMediaForCopies.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetMediaForCopies.sp,v $ $Id: RptGetMediaForCopies.sp,v 1.22.88.4 2018/03/22 03:16:44 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptGetMediaForCopies"				|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetMediaForCopies')
BEGIN
	print '>>> Drop Stored Procedure: rptGetMediaForCopies <<<'
	drop procedure rptGetMediaForCopies
END
IF EXISTS (select * from GxQscripts where name='rptGetMediaForCopies')
	delete from GxQscripts where name = 'rptGetMediaForCopies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetMediaForCopies')
	delete from GXDBVersions where aliasname = 'rptGetMediaForCopies'
GO
print '... Creating Procedure: rptGetMediaForCopies'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetMediaForCopies
  @i_jobId integer
AS
  DECLARE @o_policyId integer
  DECLARE @o_policyName NVARCHAR(256)
  DECLARE @o_copyId integer
  DECLARE @o_copyName NVARCHAR(64)
  DECLARE @o_mediaCount integer
  DECLARE @o_streamNum integer
  DECLARE @o_mediaGroupId integer
  DECLARE @o_mediaId integer
  DECLARE @o_uniqueId char(300)
  DECLARE @o_barCode char(256)
  DECLARE @o_attributes integer
  DECLARE @o_guiAttributes integer
  DECLARE @o_libraryId integer
  DECLARE @o_libraryName NVARCHAR(128)
  DECLARE @o_locationType integer
  DECLARE @o_locationId integer
  DECLARE @o_location NVARCHAR(1024)
  DECLARE @o_bytes bigint
  DECLARE @o_reason integer
  DECLARE @o_container NVARCHAR(64)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId		integer
DECLARE @SPOpt		integer
DECLARE @isAuxCopy	integer
DECLARE @isDataVerif	integer
DECLARE @isContentIdx	integer
DECLARE @isMediaRefresh	integer
DECLARE @daysInAdvance	integer
DECLARE @poId		integer
DECLARE @jobType	integer
DECLARE @copyId		integer
DECLARE @tblOptSPs 	TABLE (policyId INT, copyId INT)
DECLARE @tblSPs		TABLE (policyId INT, copyId INT, medCount INT default (0))
CREATE TABLE #AdminJobMedia (
				t_policyId		integer,
t_policyName 	NVARCHAR(256),
				t_copyId		integer,
t_copyName		NVARCHAR(64),
				t_streamNum		integer,
				t_mediaGroupId 	integer,
				t_mediaId		integer,
t_uniqueId		char(300),
t_barCode 		char(256),
				t_attributes	integer,
				t_guiAttributes	integer,
				t_libraryId		integer,
t_libraryName	NVARCHAR(128),
				t_locationType	integer,
				t_locationId 	integer,
t_location		NVARCHAR(1024),
				t_bytes			bigint,
				t_reason		integer)
DECLARE @i_taskId integer
SET @i_taskId = @i_jobId
SET @userId = dbo.GetOptionInt(140019, @i_jobId, 0, 0)
SET @jobType = dbo.GetOptionInt(245928906, @i_jobId, 0, 0)
SET @isAuxCopy		= (case when @jobType = 3 then 1 else 0 end)
SET @isDataVerif	= (case when @jobType = 4 then 1 else 0 end)
SET @isContentIdx	= (case when @jobType = 5 then 1 else 0 end)
SET @isMediaRefresh	= (case when @jobType = 6 then 1 else 0 end)
INSERT INTO @tblOptSPs (policyId, copyId) EXEC rptOptGetStoragePolicies @i_taskId, @SPOpt OUTPUT
-- The value of @daysInAdvance should be set from Assume Media Refreshing will run [ ] days later option
SET	@daysInAdvance = dbo.GetOptionInt(228135985, @i_jobId, 0, 0)
-- get all SPs
IF @isContentIdx > 0
BEGIN
	IF @SPOpt <= 0
		INSERT INTO @tblSPs
		SELECT	archGroupId, 0, 0
		FROM	ArchContentIndexingRules
		WHERE	enabled = 1
	ELSE
		INSERT INTO @tblSPs
		SELECT	archGroupId, 0, 0
		FROM	@tblOptSPs T JOIN ArchContentIndexingRules A ON T.policyId = A.archGroupId
		WHERE	enabled = 1
END
ELSE
IF @SPOpt <= 0
	INSERT INTO @tblSPs
	SELECT	archGroupId, id, 0
	FROM	ArchGroupCopy
	WHERE	archGroupId > 1
AND isSnapCopy = 0 AND type <> 5
AND (@isMediaRefresh = 0 OR (flags & 33554432) <> 0)
ELSE
	INSERT INTO @tblSPs
	SELECT	DISTINCT A.archGroupId, A.id, 0
	FROM	@tblOptSPs T JOIN ArchGroupCopy A ON T.policyId = A.archGroupId
	WHERE	(T.copyId = 0 OR T.copyId = A.Id) AND A.Id > 0
AND isSnapCopy = 0 AND type <> 5
AND (@isMediaRefresh = 0 OR (flags & 33554432) <> 0)
IF @isAuxCopy > 0
	DELETE	@tblSPs
	FROM	@tblSPs T JOIN ArchGroup A ON T.policyId = A.Id
	WHERE	A.defaultcopy = T.copyId
--got all qualified entries, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @SPOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2231, 0, '#rptUserObjects'	-- 2231 = ARCHIVE_GROUP_ITEM
	delete #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR clientId <> 0 OR libraryID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0
	delete @tblSPs
	WHERE NOT EXISTS (select * from #rptUserObjects where archGroupID in (0, policyId))
	DROP TABLE #rptUserObjects
END
DECLARE getSPCIds CURSOR FOR
SELECT DISTINCT policyId, copyId FROM @tblSPs
OPEN getSPCIds
FETCH NEXT FROM getSPCIds INTO @poId, @copyId
WHILE @@FETCH_STATUS = 0
BEGIN
	IF @isContentIdx > 0
--		INSERT INTO #AdminJobMedia
		EXEC archToBeContentIndexedMedia @poId
	ELSE
	IF @isDataVerif > 0
		INSERT INTO #AdminJobMedia
		EXEC archToBeVerifiedMedia @poId, @copyId
	ELSE
	IF @isMediaRefresh > 0
		INSERT INTO #AdminJobMedia
		EXEC archToBeRefreshedMedia @poId, @copyId, @daysInAdvance
	ELSE
		INSERT INTO #AdminJobMedia
		EXEC archUncopiedMedia @poId, @copyId
	FETCH NEXT FROM getSPCIds INTO @poId, @copyId
END
CLOSE getSPCIds
DEALLOCATE getSPCIds
UPDATE @tblSPs
SET medCount = ISNULL((select count(*) from #AdminJobMedia where policyId = t_policyId and (copyId = t_copyId OR copyId = 0)), 0)
SELECT	policyId, policyName=(case when t_policyName is null then (select name from archGroup where id = policyId) else t_policyName end),
		copyId, copyName=(case when t_copyName is not null then t_copyName when copyId > 0 then (select name from archGroupCopy where id = copyId) else '' end),
		medCount, ISNULL(t_streamNum, 0), ISNULL(t_mediaGroupId, 0), ISNULL(t_mediaId, 0), ISNULL(t_uniqueId, ''), ISNULL(t_barCode, ''),
		ISNULL(t_attributes, 0), ISNULL(t_guiAttributes, 0), ISNULL(t_libraryId, 0), ISNULL(t_libraryName, ''),
		ISNULL(t_locationType, 0), ISNULL(t_locationId, ''), ISNULL(t_location, 0), ISNULL(t_bytes, 0), ISNULL(t_reason, 0),
		ISNULL((SELECT ContainerName FROM MMContainer C JOIN MMMedia M ON C.ContainerId=M.ContainerId WHERE M.mediaId=t_mediaId and M.ContainerId>0),
		          (CASE (SELECT mediaTypeId FROM MMMedia M WHERE M.mediaId=t_mediaId) WHEN '10001' THEN 'N/A' ELSE 'None' END))
FROM	@tblSPs	LEFT JOIN #AdminJobMedia ON policyId = t_policyId and (copyId = t_copyId OR copyId = 0)
ORDER BY t_policyName, t_copyName, t_barCode
DROP TABLE #AdminJobMedia
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetMediaForCopies')
	delete from GxQscripts where name = 'RptGetMediaForCopies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMediaForCopies')
	delete from GXDBVersions where aliasname = 'RptGetMediaForCopies'
GO

insert into GXDBVersions values(2, 'RptGetMediaForCopies',  '00010022008800040000', 'RptGetMediaForCopies', '00010022008800040000')
GO

