

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetMagLibs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetMagLibs.sp,v $ $Id: RptGetMagLibs.sp,v 1.52.36.11 2020/08/27 18:13:49 pveeravalli Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetMagLibs"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetMagLibs')
BEGIN
	print '>>> Drop Stored Procedure: RptGetMagLibs <<<'
	drop procedure RptGetMagLibs
END
IF EXISTS (select * from GxQscripts where name='RptGetMagLibs')
	delete from GxQscripts where name = 'RptGetMagLibs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMagLibs')
	delete from GXDBVersions where aliasname = 'RptGetMagLibs'
GO
print '... Creating Procedure: RptGetMagLibs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetMagLibs
  @i_jobId integer
AS
  DECLARE @o_type integer;
  DECLARE @o_libId integer;
  DECLARE @o_libName NVARCHAR(255);
  DECLARE @o_libSoftState integer;
  DECLARE @o_libEnabled integer;
  DECLARE @o_libBroken integer;
  DECLARE @o_barCodeReaderPresent integer;
  DECLARE @o_libVendor char(255);
  DECLARE @o_libModel char(255);
  DECLARE @o_attribute integer;
  DECLARE @o_extAttribute integer;
  DECLARE @o_libStatusReason integer;
  DECLARE @o_lowWaterMark integer;
  DECLARE @o_thresholdPercentage integer;
  DECLARE @o_thresholdVariation integer;
  DECLARE @o_maxSwitchForHost integer;
  DECLARE @o_clientName nchar(255);
  DECLARE @o_mountPathNum integer;
  DECLARE @o_description nchar(4000);
  DECLARE @o_clientDisplayName nvarchar(255);
  DECLARE @o_t_libId integer;
  DECLARE @o_deviceTypeId integer;
  DECLARE @o_mountPathName NVARCHAR(255);
  DECLARE @o_isEnabled integer;
  DECLARE @o_isOffline integer;
  DECLARE @o_pathOfflineReason integer;
  DECLARE @o_maxConcurrentWriters integer;
  DECLARE @o_totalSpaceMB bigint;
  DECLARE @o_freeBytesMB bigint;
  DECLARE @o_physicalBytesMB bigint;
  DECLARE @o_logicalBytesMB bigint;
  DECLARE @o_ApplicationSizeMB bigint;
  DECLARE @o_pathAttribute integer;
  DECLARE @o_numScannedFiles integer;
  DECLARE @o_fragThreshold integer;
  DECLARE @o_numFragFiles integer;
  DECLARE @o_numExFragFiles integer;
  DECLARE @o_fadDate integer;
  DECLARE @o_numSkipFiles integer;
  DECLARE @o_fragThresholdPercent integer;
  DECLARE @o_uploadDataMB bigint;
  DECLARE @o_downloadDataMB bigint;
  DECLARE @o_userGroups varchar(MAX);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId			integer
DECLARE @libOpt			integer
DECLARE @libId 			integer
DECLARE @tblLibs		TABLE (t_libId int)
IF object_id('tempdb.dbo.#MAG_LIB_TEMP') is not null DROP TABLE #MAG_LIB_TEMP
IF object_id('tempdb.dbo.#MOUNTPATH_TEMP') is not null DROP TABLE #MOUNTPATH_TEMP
IF object_id('tempdb.dbo.#magReturnList') is not null DROP TABLE #magReturnList
CREATE	TABLE #MOUNTPATH_TEMP (
	mLibId				INT,
	deviceTypeId		INT,
	MediaSideId			INT,
	MountPathName		NVARCHAR(1024),
	IsEnabled			INT,
	isOffline			INT,
	offlineReason		INT,
	MaxConcurrentWriters INT,
	TotalSpaceMB		BIGINT,
	FreeBytesMB			BIGINT,
	PhysicalBytesMB		BIGINT,
	LogicalBytesMB		BIGINT,
	ApplicationSizeMB	BIGINT,
	attribute			INT,
	numFileFADScanned	INT,
	appliedFADThreshold	INT,
	numFilesFADFlaggedFragmented	INT,
	numTotalExcessFragments			INT,
	fadTaskRunDate		INT,
	numFilesFADSkippedAnalysis		INT,
	thresholdPercent	INT,
	UploadDataMB		BIGINT,
	DownloadDataMB		BIGINT)
SET @userId		= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
INSERT INTO @tblLibs	EXEC rptOptGetObjectList @i_jobId, 412850839, @libOpt OUTPUT
SELECT	libId=LibraryId,AliasName,LibrarySoftState,LibraryEnabled,LibraryBroken,BarCodeReaderPresent,
	LibraryVendor,LibraryModel,LibraryAttribute,ExtendedAttributes,LibraryStatusReason,lowwatermarkmb,thresholdPercentage,thresholdVariation,
	MaxSwitchForHost=ISNULL((select mp.MaxSwitchForHost from MMMasterPool mp where mp.libraryId=L.LibraryId),0),
	clientName=ISNULL((select name from APP_Client where id in (select TOP 1 LC.clientId from MMLibraryController LC
				where LC.LibraryId=L.LibraryId AND LC.LibraryControllerId>0)), 0),
	mountPathNum=0,
	Descript,
    clientDisplayName=ISNULL((select displayname from APP_Client where id in (select TOP 1 LC.clientId from MMLibraryController LC
                where LC.LibraryId=L.LibraryId AND LC.LibraryControllerId>0)), 0)
INTO	#MAG_LIB_TEMP
FROM	MMLibrary L
WHERE 	(@libOpt = 0 OR LibraryId in (select t_libId from @tblLibs)) AND LibraryTypeId=3
--got all qualified media, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @libOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2049, 0, '#rptUserObjects'	-- 2049 = LIBRARY_ITEM
	DELETE #rptUserObjects
	WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR clientId <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0 OR taskId <> 0
	DELETE #MAG_LIB_TEMP
	WHERE NOT EXISTS (select * from #rptUserObjects where libraryId IN (0, libid))
	DROP TABLE #rptUserObjects
END
IF object_id('tempdb.dbo.#tempUserGroupList') is not null	DROP TABLE #tempUserGroupList
CREATE TABLE #tempUserGroupList (t_libId integer, t_groupList text)
--get list of user UMGroups that have permissions on each SP
IF (dbo.isNewSecurity() = 0)
BEGIN
	DECLARE magLibUserGroupList CURSOR FOR
		SELECT DISTINCT LibId FROM #MAG_LIB_TEMP
	OPEN magLibUserGroupList
	FETCH NEXT FROM magLibUserGroupList INTO @libId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO #tempUserGroupList
		EXEC rptGetUserGroups 2049, @libId, 0, 0, 0, 0, 0, 0
		FETCH NEXT FROM magLibUserGroupList INTO @libId
	END
	CLOSE magLibUserGroupList
	DEALLOCATE magLibUserGroupList
END
ELSE
BEGIN
DECLARE @entityType1 INT = 9
	DECLARE @i_entityList XML
	SET @i_entityList = (SELECT
9  as '@entityType1',
	LibId  as '@entityId1'
	FROM   (SELECT DISTINCT LibId FROM #MAG_LIB_TEMP) f
	for xml path('entity'),root('entityList') )
	IF object_id('tempdb.dbo.#tgroupObjects') is not null
        DROP TABLE #tgroupObjects
--	THIS WILL GIVE ALL USERGROUP ASSOCIATED WITH THESE CLIENT WITHOUT USER SECURITY CHECK (USER ID IS NOT PASSED)
CREATE TABLE #tgroupObjects ([userORGroupId] integer, [isUSer] integer, [roleId] integer, [permissionId] integer, [entitytype1]	 integer, [entityId1] integer, [entityType2] integer DEFAULT 0, [entityId2] integer DEFAULT 0, [entityType3] integer DEFAULT 0, [entityId3] integer DEFAULT 0, [entityType4] integer DEFAULT 0, [entityId4] integer DEFAULT 0, [entityType5] integer DEFAULT 0,  [entityId5] integer DEFAULT 0)
exec sec_getUMEntityandPermissionOnEntity '#tgroupObjects' ,9, @i_entityList,0,0,0,0
	-- USER SECURITY CHECK FOR THIS USER
	IF object_id('tempdb.dbo.#entityTable') is not null
		drop table #entityTable
	create table #entityTable
	(
		entityId int
	)
	 exec sec_getUserGroupsForThisUser '#entityTable', @userID
	IF object_id('tempdb.dbo.#usergroups') is not null
		drop table #usergroups
	CREATE table #usergroups (name nvarchar(max),t_libId INT )
	INSERT INTO #usergroups
		select distinct UG.name,t.entityId1
	FROM	UMGroups UG INNER JOIN #tgroupObjects t ON
	UG.id = t.userORGroupId and t.isUSer = 0
	INNER JOIN #entityTable E ON
	UG.id = E.entityId
	drop table #entityTable
	INSERT INTO #tempUserGroupList
	Select distinct cg2.t_libId,
    substring(
        (
            Select ','+cg1.name  AS [text()]
            From #usergroups cg1
            Where cg1.t_libId = cg2.t_libId
            ORDER BY cg1.t_libId
            For XML PATH ('')
        ), 2, 1000) [groups]
	From #usergroups cg2
	IF object_id('tempdb.dbo.#tgroupObjects') is not null
    DROP TABLE #tgroupObjects
	IF object_id('tempdb.dbo.#usergroups') is not null
		drop table #usergroups
END
INSERT INTO #MOUNTPATH_TEMP
SELECT L.LibraryId,
	ISNULL((select D.DisplayDeviceTypeId from MMDevice D, MMMountPathToStorageDevice SD
			where SD.MountPathId = P.MountPathId AND D.DeviceId = SD.DeviceId AND P.MountPathTypeId = 7),0),
	P.MediaSideId,
	P.MountPathName,
	P.IsEnabled,
	P.isOffline,
	P.offlineReason,
	P.MaxConcurrentWriters,
(CASE WHEN (mmp.MountPathTypeId = 7 AND S.TotalSpaceMB = 1048576) THEN -1 ELSE CAST(S.TotalSpaceMB AS BIGINT)  END),
(CASE WHEN (mmp.MountPathTypeId = 7 AND S.FreeBytesMB = 1048576) THEN -1 ELSE CAST(S.FreeBytesMB AS BIGINT) END),
	0,
	0,
	0,
	P.attribute,
	MF.numFileFADScanned ,
	MF.appliedFADThreshold,
	MF.numFilesFADFlaggedFragmented,
	MF.numTotalExcessFragments,
	MF.fadTaskRunDate,
	MF.numFilesFADSkippedAnalysis,
	(SELECT value FROM MMConfigs WHERE name like 'MMS2_CONFIG_FAD_MNTPATH_FRAG_THRESHOLD'),
	S.UploadDataMB,
	S.DownloadDataMB
FROM	MMMountPath as mmp, MMMedia L
		JOIN MMMediaSide S	ON L.MediaId=S.MediaId
		JOIN MMS2getMountPathNameGUIView P	ON S.MediaSideId=P.MediaSideId AND P.MountPathName not like 'CVDiskFolder' --MOUNT_PATH_TEMPLATE_FOLDER
		LEFT JOIN MMMaglibFADTaskInfo MF
			ON P.mountpathid = MF.mountPathId
			AND MF.fadTaskRunDate = (select top (1) fadTaskRunDate from MMMaglibFADTaskInfo
									WHERE mountPathId = P.mountpathid AND taskStatus = 0 order by fadTaskRunDate desc)
			AND MF.adminJobId = (select top (1)adminJobId from MMMagLibFADTaskInfo
									WHERE mountPathId = P.MountPathId and taskStatus = 0 order by adminJobId desc)
WHERE	(@libOpt = 0 OR L.LibraryId in (select t_libId from @tblLibs)) AND
        P.LibraryId = mmp.LibraryId AND mmp.MediaSideId=S.MediaSideId AND mmp.MountPathName not like 'CVDiskFolder' --MOUNT_PATH_TEMPLATE_FOLDER
UPDATE	#MOUNTPATH_TEMP
SET		PhysicalBytesMB	= S.PhysicalBytesMB
FROM	(SELECT	V.MediaSideId, SUM(CAST(V.PhysicalBytesMB AS BIGINT)) AS PhysicalBytesMB
		FROM	#MOUNTPATH_TEMP T, MMVolume V
		WHERE	V.MediaSideId = T.MediaSideId AND V.RecordingFormatId = 10001 AND V.SiloStatus <> 3 AND V.PhysicalBytesMB > 0
		GROUP BY V.MediaSideId) S
WHERE	#MOUNTPATH_TEMP.MediaSideId = S.MediaSideId AND MountPathName not like 'CVDiskFolder' --MOUNT_PATH_TEMPLATE_FOLDER
CREATE TABLE #MountPathAppSize (MediaSideId INT, ApplicationSizeMB BIGINT)
INSERT	INTO #MountPathAppSize
SELECT	MV.MediaSideId, SUM(ACM.unCompSize)/1024/1024
FROM	archChunkMapping ACM WITH (NOLOCK)
		INNER JOIN archChunk AC WITH (NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
		INNER JOIN MMVolume MV WITH (NOLOCK) ON AC.volumeId = MV.VolumeId
		INNER JOIN #MOUNTPATH_TEMP MP ON MV.MediaSideId = MP.MediaSideId
WHERE	ACM.unCompSize > 0 AND MV.SiloStatus <> 3
GROUP BY MV.MediaSideId
-- For chunks with no correct app size (unCompSize = -1), get app size from physicalSize/totalBackupSize ratio
CREATE TABLE #JobCopySize (jobId INT, commCellId INT, totalAppSize BIGINT, totalBackupSize BIGINT)
INSERT	INTO #JobCopySize
SELECT	jobId, commCellId, 0, 0
FROM	archChunkMapping WITH (NOLOCK)
WHERE	physicalSize > 0 AND unCompSize = -1
GROUP BY jobId, commCellId
IF EXISTS (SELECT jobId FROM #JobCopySize)
BEGIN
	UPDATE	T SET totalAppSize = J.totalUncompBytes, totalBackupSize = J.totalBackupSize
	FROM	#JobCopySize T INNER JOIN JMBkpStats J WITH (NOLOCK) ON T.jobId = J.jobId AND T.commCellId = J.commCellId
	WHERE	J.totalBackupSize > 0
	UPDATE	T SET totalAppSize = J.totalBackupSize, totalBackupSize = J.totalBackupSize
	FROM	#JobCopySize T INNER JOIN JMAdminJobStatsTable J WITH (NOLOCK) ON T.jobId = J.jobId AND T.commCellId = J.commCellId
	WHERE	J.totalBackupSize > 0
	INSERT	INTO #MountPathAppSize
	SELECT	MV.MediaSideId, SUM((1.0*ACM.physicalSize/J.totalBackupSize)*J.totalAppSize)/1024/1024
	FROM	#JobCopySize J
			INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON J.jobId = ACM.jobId AND J.commCellId = ACM.commCellId
			INNER JOIN archChunk AC WITH (NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
			INNER JOIN MMVolume MV WITH (NOLOCK) ON AC.volumeId = MV.VolumeId
			INNER JOIN #MOUNTPATH_TEMP MP ON MV.MediaSideId = MP.MediaSideId
	WHERE	J.totalBackupSize > 0 AND ACM.unCompSize = -1 AND MV.SiloStatus <> 3
	GROUP BY MV.MediaSideId
END
DROP TABLE #JobCopySize
UPDATE	T SET ApplicationSizeMB = S.ApplicationSizeMB
FROM	#MOUNTPATH_TEMP T INNER JOIN #MountPathAppSize S ON T.MediaSideId = S.MediaSideId
WHERE	T.MountPathName NOT LIKE 'CVDiskFolder' --MOUNT_PATH_TEMPLATE_FOLDER
DROP TABLE #MountPathAppSize
--MR37308: Mark some option as N/A for Cloud Library in Library and Drive Summary Report
UPDATE #MOUNTPATH_TEMP
SET totalSpaceMB =0 ,
	FreeBytesMB =0
WHERE deviceTypeId > 1
UPDATE	#MAG_LIB_TEMP
SET	mountPathNum = (select count(*) from #MOUNTPATH_TEMP where mLibId=LibId)
SELECT	type=0, L.*,
		M.mLibId,
		M.deviceTypeId,
		M.MountPathName,
		M.IsEnabled,
		M.isOffline,
		M.offlineReason,
		M.MaxConcurrentWriters,
		M.TotalSpaceMB,
		M.FreeBytesMB,
		M.PhysicalBytesMB,
		M.LogicalBytesMB,
		M.ApplicationSizeMB,
		M.attribute,
		M.numFileFADScanned,
		M.appliedFADThreshold,
		M.numFilesFADFlaggedFragmented,
		M.numTotalExcessFragments,
		M.fadTaskRunDate,
		M.numFilesFADSkippedAnalysis,
		M.thresholdPercent,
		M.UploadDataMB,
		M.DownloadDataMB,
		T.t_groupList
INTO #magReturnList
FROM #MAG_LIB_TEMP L
		LEFT OUTER JOIN #MOUNTPATH_TEMP M ON mLibId=LibId
		LEFT OUTER JOIN #tempUserGroupList T ON t_libId=LibId
--summary
INSERT INTO #magReturnList
SELECT  1,LibId,AliasName,0,0,0,0,'','',0,0,0,0,0,0,0,'',0,N'',N'',LibId, max(deviceTypeId),'',0,0,0,0,sum(totalSpaceMB),sum(FreeBytesMB),sum(physicalBytesMB),0,SUM(ApplicationSizeMB),0,0,0,0,0,0,0,0,0,0,''
FROM	#MAG_LIB_TEMP LEFT OUTER JOIN #MOUNTPATH_TEMP ON mLibId=LibId
GROUP BY LibId, AliasName
INSERT INTO #magReturnList
SELECT  2,count(DISTINCT libId),'',0,0,0,0,'','',0,0,0,0,0,0,0,'',0,N'',N'',0,(case when NOT EXISTS (select * from #MOUNTPATH_TEMP where deviceTypeId < 1) then 7 else 0 end),'',0,0,0,0,
totalSpaceMB = (select sum(totalSpaceMB) from #MOUNTPATH_TEMP where mlibid not in ( select mlibid from #MOUNTPATH_TEMP where deviceTypeId >1) and mlibid > 0 and mLibId in (select libid from #magReturnList)),
FreeBytesMB = (select sum(FreeBytesMB) from #MOUNTPATH_TEMP where mlibid not in ( select mlibid from #MOUNTPATH_TEMP where deviceTypeId >1) and mlibid > 0 and mLibId in (select libid from #magReturnList)),
sum(physicalBytesMB),0,SUM(ApplicationSizeMB),0,0,0,0,0,0,0,0,0,0,''
FROM	#MAG_LIB_TEMP LEFT OUTER JOIN #MOUNTPATH_TEMP ON mLibId=LibId
SELECT * FROM #magReturnList ORDER BY type DESC, AliasName
IF object_id('tempdb.dbo.#MAG_LIB_TEMP') is not null DROP TABLE #MAG_LIB_TEMP
IF object_id('tempdb.dbo.#MOUNTPATH_TEMP') is not null DROP TABLE #MOUNTPATH_TEMP
IF object_id('tempdb.dbo.#magReturnList') is not null DROP TABLE #magReturnList
IF object_id('tempdb.dbo.#tempUserGroupList') is not null	DROP TABLE #tempUserGroupList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetMagLibs')
	delete from GxQscripts where name = 'RptGetMagLibs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMagLibs')
	delete from GXDBVersions where aliasname = 'RptGetMagLibs'
GO

insert into GXDBVersions values(2, 'RptGetMagLibs',  '00010052003600110000', 'RptGetMagLibs', '00010052003600110000')
GO

