

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetMAList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetMAList.sp,v $ $Id: RptGetMAList.sp,v 1.34.12.7 2018/11/18 03:49:25 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetMAList"				|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetMAList')
BEGIN
	print '>>> Drop Stored Procedure: RptGetMAList <<<'
	drop procedure RptGetMAList
END
IF EXISTS (select * from GxQscripts where name='RptGetMAList')
	delete from GxQscripts where name = 'RptGetMAList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMAList')
	delete from GXDBVersions where aliasname = 'RptGetMAList'
GO
print '... Creating Procedure: RptGetMAList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetMAList
  @i_jobId integer
AS
  DECLARE @o_id integer;
  DECLARE @o_name nchar(255);
  DECLARE @o_nethostname nchar(255);
  DECLARE @o_OSId integer;
  DECLARE @o_OSName char(255);
  DECLARE @o_installDir char(255);
  DECLARE @o_hwId integer;
  DECLARE @o_hwName char(255);
  DECLARE @o_softState integer;
  DECLARE @o_enabled integer;
  DECLARE @o_offlineReason integer;
  DECLARE @o_mmHostId integer;
  DECLARE @o_attribute integer;
  DECLARE @o_release char(255);
  DECLARE @o_buildId char(255);
  DECLARE @o_isDeleted integer;
  DECLARE @o_description nchar(4000);
  DECLARE @o_displayname nchar(255);
  DECLARE @o_hostId integer;
  DECLARE @o_Path char(255);
  DECLARE @o_username char(255);
  DECLARE @o_pathEnabled integer;
  DECLARE @o_pathSoftState integer;
  DECLARE @o_pathOfflineReason integer;
  DECLARE @o_idxCacheId integer;
  DECLARE @o_idxCacheName NVARCHAR(255);
  DECLARE @o_idxCacheEnabled integer;
  DECLARE @o_idxCacheSoftState integer;
  DECLARE @o_ageingPercentDiskSpace integer;
  DECLARE @o_poolEnabled integer;
  DECLARE @o_isShared integer;
  DECLARE @o_AgeingNoOfDays integer;
  DECLARE @o_idxCacheNum integer;
  DECLARE @o_isVirtual integer;
  DECLARE @o_isCatalogSvr integer;
  DECLARE @o_userGroups varchar(MAX);
  DECLARE @o_CatalogSvrName varchar(MAX);  
  DECLARE @o_malists varchar(MAX);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @userId			integer
DECLARE @MAId 			integer
DECLARE @tblMA			TABLE (t_id int)
IF object_id('tempdb.dbo.#tempUserGroupList') is not null	DROP TABLE #tempUserGroupList
CREATE TABLE #tempUserGroupList(t_MAId integer, t_groupList text)
SET @userId		= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
INSERT INTO @tblMA	EXEC rptOptGetObjectList @i_jobId, 587766369, @MAId OUTPUT
IF object_id('tempdb.dbo.#temp_ma') is not null
	drop table #temp_ma
SELECT	C.id, MAName=C.displayName,C.net_hostname, OSID=O.id, OSName=O.name,
	InstallDir =ISNULL((select install_dir from APP_Platform where clientId = C.id and platformType = 4),''),
	HWID=0, HWName=dbo.GetClientHardwareName(C.id, NULL),
	M.mmhostsoftstate, M.mmhostenabled, M.offlineReason, M.ClientId, M.attribute,
	release = ( select TOP 1 SR.Release from LicUsage A, SimAllGalaxyRel SR
		where A.CId = C.id and A.appType = 1002 AND A.OpType='Install' AND A.LicType NOT in (71, 10, 26) AND SR.id = A.Releaseid order by opTimeUTC DESC ),
	buildId = ( select TOP 1 A.build from LicUsage A
		where A.CId = C.id and A.appType = 1002 AND A.OpType='Install' AND A.LicType NOT in (71, 10, 26) order by opTimeUTC DESC ),
	isDeleted=(select attrVal from APP_ClientProp where componentNameId=C.id and attrName='platformdeleted 2' and modified = 0),
	description=C.clientDescription,
    MADisplayName=C.displayname
INTO	#temp_ma
FROM	APP_Client C, simOperatingSystem O, MMHost M
WHERE	(@MAId = 0 OR C.Id in (select t_id from @tblMA)) AND
	     C.simOperatingSystemId=O.id and M.ClientId=C.id AND C.id > 1
ORDER BY MAName
--got all qualified entries, do the security check before more details and summary
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
IF @userId > 0 AND @isUserAdmin = 0 AND @MAId <= 0
BEGIN
	IF object_id('tempdb.dbo.#rptUserObjects') IS NOT null DROP TABLE #rptUserObjects
create table  #rptUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId, 2048, 0, '#rptUserObjects'
	delete #rptUserObjects
	WHERE clientGroupId <> 0 OR clientId <> 0 OR libraryID <> 0 OR archGroupID <> 0
	OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0
	OR taskId <> 0
	delete #temp_ma
	WHERE 0 = (select count(*) from #rptUserObjects where mediaAgentId in (0, id))
	DROP TABLE #rptUserObjects
END
--get list of user UMGroups that have permissions on each MA
DECLARE @entityType1 INT =  11
	DECLARE @i_entityList XML
	SET @i_entityList = (SELECT
11 as '@entityType1',
	id  as '@entityId1'
	FROM #temp_ma
	for xml path('entity'),root('entityList') )
	IF object_id('tempdb.dbo.#tgroupObjects') is not null
        DROP TABLE #tgroupObjects
--	THIS WILL GIVE ALL USERGROUP ASSOCIATED WITH THESE CLIENT WITHOUT USER SECURITY CHECK (USER ID IS NOT PASSED)
CREATE TABLE #tgroupObjects ([userORGroupId] integer, [isUSer] integer, [roleId] integer, [permissionId] integer, [entitytype1]	 integer, [entityId1] integer, [entityType2] integer DEFAULT 0, [entityId2] integer DEFAULT 0, [entityType3] integer DEFAULT 0, [entityId3] integer DEFAULT 0, [entityType4] integer DEFAULT 0, [entityId4] integer DEFAULT 0, [entityType5] integer DEFAULT 0,  [entityId5] integer DEFAULT 0)
	exec sec_getUMEntityandPermissionOnEntity '#tgroupObjects' ,@entityType1, @i_entityList,0,0,0,0
	-- USER SECURITY CHECK FOR THIS USER
	IF object_id('tempdb.dbo.#entityTable') is not null
		drop table #entityTable
	create table #entityTable
	(
		entityId int
	)
	 exec sec_getUserGroupsForThisUser '#entityTable', @userID
	IF object_id('tempdb.dbo.#clientgroups') is not null
		drop table #clientgroups
	CREATE table #clientgroups (name nvarchar(max),clientId INT )
	INSERT INTO #clientgroups
		select distinct UG.name,t.entityId1
	FROM	UMGroups UG INNER JOIN #tgroupObjects t ON
	UG.id = t.userORGroupId and t.isUSer = 0
	INNER JOIN #entityTable E ON
	UG.id = E.entityId
	drop table #entityTable
	INSERT INTO #tempUserGroupList
	Select distinct cg2.clientId,
    substring(
        (
            Select ','+cg1.name  AS [text()]
            From #clientgroups cg1
            Where cg1.clientId = cg2.clientId
            ORDER BY cg1.clientId
            For XML PATH ('')
        ), 2, 1000) [groups]
	From #clientgroups cg2
	IF object_id('tempdb.dbo.#tgroupObjects') is not null
    DROP TABLE #tgroupObjects
	IF object_id('tempdb.dbo.#clientgroups') is not null
		drop table #clientgroups
IF object_id('tempdb.dbo.#temp_idxcache') IS NOT NULL DROP TABLE #temp_idxcache
create table #temp_idxcache
(m_hostId integer,
	Path varchar(max),
	username varchar(max),
	pathEnabled integer,
	pathSoftState integer,
	offlineReason integer,
	idxCacheId integer,
	description varchar(max),
	idxCacheEnabled integer,
	idxCacheSoftState integer,
	ageingPercentDiskSpace integer,
	poolEnabled integer,
	isShared integer,
	AgeingNoOfDays integer,
	t_groupList varchar(max)
);
insert INTO	#temp_idxcache
SELECT	t.id,
		(select attrVal from APP_ClientProp where attrName='Idx: cache path' and componentNameId=t.id),
		'',
		(select CASE ISNUMERIC(attrVal) WHEN 1 THEN  attrVal ELSE 0 END  from APP_ClientProp where attrName='Idx: cache enabled' and componentNameId=t.id),
		(select CASE ISNUMERIC(attrVal) WHEN 1 THEN  attrVal ELSE 0 END from APP_ClientProp where attrName='Idx: cache enabled' and componentNameId=t.id),
		0,
		t.id,
		'IndexCache',
		(select CASE ISNUMERIC(attrVal) WHEN 1 THEN  attrVal ELSE 0 END from APP_ClientProp where attrName='Idx: cache enabled' and componentNameId=t.id),
		(select CASE ISNUMERIC(attrVal) WHEN 1 THEN  attrVal ELSE 0 END from APP_ClientProp where attrName='Idx: cache enabled' and componentNameId=t.id),
		(select CASE ISNUMERIC(attrVal) WHEN 1 THEN  attrVal ELSE 0 END from APP_ClientProp where attrName='Idx: cleanup percent' and componentNameId=t.id),
		(select CASE ISNUMERIC(attrVal) WHEN 1 THEN  attrVal ELSE 0 END from APP_ClientProp where attrName='Idx: cache enabled' and componentNameId=t.id),
		0,
		(select CASE ISNUMERIC(attrVal) WHEN 1 THEN  attrVal ELSE 0 END from APP_ClientProp where attrName='Idx: age days' and componentNameId=t.id),
		t_groupList
FROM	#temp_ma T 	LEFT OUTER JOIN #tempUserGroupList ON t_maId=T.id
WHERE	(
			convert(FLOAT,t.release)>10.0 and exists (select * from APP_ClientProp where attrName='Idx: configuration GUID' and componentNameId=t.id)
		)
UPDATE #temp_idxcache
SET AgeingNoOfDays = (CASE  WHEN AgeingNoOfDays is null  THEN 15 ELSE AgeingNoOfDays END),
	AgeingPercentDiskspace = (CASE  WHEN AgeingPercentDiskspace is null  THEN 90 ELSE AgeingPercentDiskspace END)
FROM #temp_idxcache tt
WHERE AgeingNoOfDays is null or AgeingPercentDiskspace is null
insert INTO	#temp_idxcache
SELECT	m_hostId=A.ClientId,
		A.Path,
		A.username,
		pathEnabled=A.enabled,
		pathSoftState=A.softState,
		A.offlineReason,
		C.idxCacheId,
		C.description,
		idxCacheEnabled=C.enabled,
		idxCacheSoftState=C.softState,
		C.ageingPercentDiskSpace,
		poolEnabled=P.enabled,
		P.isShared,
		P.AgeingNoOfDays,
		t_groupList
FROM	#temp_ma T 	LEFT JOIN idxAccessPath A ON T.ClientId=A.ClientId
			LEFT JOIN idxCache C ON A.idxCacheId=C.idxCacheId
			LEFT JOIN idxPool P ON C.idxPoolID=P.idxPoolID
			LEFT OUTER JOIN #tempUserGroupList ON t_maId=T.id
WHERE	C.idxCacheType <> 2 and
		(
			convert(FLOAT,t.release)<11.0
			or
			convert(FLOAT,t.release)>10.0 and not exists (select * from APP_ClientProp where attrName='Idx: configuration GUID' and componentNameId=A.ClientId)
		)
--include catalog server information in the commcell config report
Declare @tmpCatalogServer table
(CatalogServerClientId int, ClientId int, catSvrname varchar(1024), maName varchar(1024), malist varchar(MAX))
Declare @maList varchar(MAX) set @maList =''
Declare @maName varchar(MAX)
Declare @oldVal varchar(MAX) set @oldVal = 0
/* MA-CatalogServers cross-map*/
insert into @tmpCatalogServer
select ic.CatalogServerClientId, ap.ClientId , '', C.displayName,''
from IdxAccessPath ap, IdxCache ic, APP_Client C , MMHost H
where ic.IdxCacheId=ap.IdxCacheId and C.id=ap.ClientId and ic.CatalogServerClientId<>0 and H.ClientId =C.id
update @tmpCatalogServer
set catSvrname = C.displayName
FROM APP_Client C, @tmpCatalogServer t
where CatalogServerClientId = C.id
--get list of MA-s pointing to catalog server
DECLARE catalogServerList CURSOR FOR		--getCatalogServerid
	SELECT distinct CatalogServerClientId, maName FROM @tmpCatalogServer where CatalogServerClientId != ClientId
OPEN catalogServerList
FETCH NEXT FROM catalogServerList INTO @maId, @maName
WHILE @@FETCH_STATUS = 0
BEGIN
	IF @oldVal != @maId
	BEGIN
		set @oldVal = @maId
		set @maList =''
	END
	IF @maList <>''
		set @maList = @maList + ', '
	set @maList = @maList + @maName
	UPDATE @tmpCatalogServer
	SET malist = @maList
	where ClientId =@maId
FETCH NEXT FROM catalogServerList INTO @maId, @maName
END
CLOSE catalogServerList
DEALLOCATE catalogServerList
-----------------
SELECT	M.*,
	I.m_hostId, I.Path, I.username, I.pathEnabled, I.pathSoftState,I.offlineReason,
	I.idxCacheId, I.description,I.idxCacheEnabled,I.idxCacheSoftState,I.ageingPercentDiskSpace,
	I.poolEnabled, I.isShared, I.AgeingNoOfDays,
	idxCacheNum=(select count(*) from #temp_idxcache where m_hostId=M.ClientId and idxCacheId>0),
	ISNULL((select attrVal from APP_ClientProp where componentNameId=M.id and attrName='Virtual Client' and modified =0),0),
	isCatalogserver=(case t.CatalogServerClientId when M.clientid then 1 else 0 end), I.t_groupList,
	t.catSvrname, t.malist
FROM	#temp_ma M LEFT OUTER JOIN #temp_idxcache I ON I.m_hostId=M.ClientId
LEFT OUTER JOIN @tmpCatalogServer t ON t.ClientId=M.ClientId
DROP TABLE #temp_ma
DROP TABLE #temp_idxcache
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetMAList')
	delete from GxQscripts where name = 'RptGetMAList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetMAList')
	delete from GXDBVersions where aliasname = 'RptGetMAList'
GO

insert into GXDBVersions values(2, 'RptGetMAList',  '00010034001200070000', 'RptGetMAList', '00010034001200070000')
GO

