

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetLicUsageByCapacity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetLicUsageByCapacity.sp,v $ $Id: RptGetLicUsageByCapacity.sp,v 1.17.56.11 2019/05/31 19:48:17 leiwang Exp $";
--
--  +========================================================================+
--  |      Cursor:  RptGetLicUsageByCapacity()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetLicUsageByCapacity')
BEGIN
	print '>>> Drop Stored Procedure: RptGetLicUsageByCapacity <<<'
	drop procedure RptGetLicUsageByCapacity
END
IF EXISTS (select * from GxQscripts where name='RptGetLicUsageByCapacity')
	delete from GxQscripts where name = 'RptGetLicUsageByCapacity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetLicUsageByCapacity')
	delete from GXDBVersions where aliasname = 'RptGetLicUsageByCapacity'
GO
print '... Creating Procedure: RptGetLicUsageByCapacity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetLicUsageByCapacity
  @i_bIncludeForeignJobs integer,
  @userId integer
AS
  DECLARE @o_RptLevel INT;
  DECLARE @o_EnterrpiseBackupSize BIGINT;
  DECLARE @o_CoreBackupSize BIGINT;
  DECLARE @o_EnterpriseArchiveSize BIGINT;
  DECLARE @o_CoreArchiveSize BIGINT;
  DECLARE @o_SnapshotSize BIGINT;
  DECLARE @o_ReplicationSize BIGINT;
  DECLARE @o_nJobType INT;
  DECLARE @o_appId INT;
  DECLARE @o_jobId INT;
  DECLARE @o_ClientName varchar(255);
  DECLARE @o_ClientId INT;
  DECLARE @o_AppTypeId INT;
  DECLARE @o_AppTypeName varchar(255);
  DECLARE @o_backupSetName varchar(255);
  DECLARE @o_instanceName varchar(255);
  DECLARE @o_subClientName varchar(255);
  DECLARE @o_archGroup INT;
  DECLARE @o_archGroupName varchar(255);
  DECLARE @o_jobSize BIGINT;
  DECLARE @o_bDedupEnabled INT;
  DECLARE @o_bSecondaryEncrypion INT;
  DECLARE @o_bEnterprise INT;
  DECLARE @o_bSnapshot INT;
  DECLARE @o_ClientGroup nvarchar(max);
SET NOCOUNT ON
IF EXISTS(SELECT * FROM tempdb.dbo.sysobjects WHERE ID = OBJECT_ID(N'tempdb..#tmpCommcellUsageReport'))
	DROP TABLE #tmpCommcellUsageReport
create table #tmpCommcellUsageReport ( [EnterpriseBackupSize]	bigint , [CoreBackupSize]		bigint , [EnterpriseArchiveSize] bigint , [CoreArchiveSize]		bigint , [SnapshotSize]			bigint , [ReplicationSize]		bigint , [nJobType]				int , [appId]					int , [jobID]					int , [ClientName]			nvarchar(255) , [ClientId]				int , [AppTypeId]				int , [AppTypeName]			nvarchar(255) , [BackupSetName]			nvarchar(128) , [InstanceName]			nvarchar(512) , [SubclientName]			nvarchar(128) , [SPId]					int , [SPName]				nvarchar(144) , [UncompBytes]			bigint , [DedupEnabled]          int , [SecondaryEncryption]   int , [flag]					int	, [Snapshot]				int default 0, [ClientGroup]			nvarchar(1024) default '')
EXEC QS_CommCellUsageReport '', @i_bIncludeForeignJobs, 1
-- csabjan: update the clientname to the display name if the flag to use the display name is set.
--IF EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'bUseClientDisplayName' AND relativePath = 'CommServDB.Console' AND type = 'BOOLEAN' AND cast([value] as nvarchar(32)) = N'true' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = 2)
-- R11 SP15 Always do this!
--BEGIN
    UPDATE #tmpCommcellUsageReport
    SET #tmpCommcellUsageReport.ClientName = (SELECT displayname FROM APP_CLIENT CL where CL.id = #tmpCommcellUsageReport.ClientId)
--END
DELETE #tmpCommcellUsageReport WHERE flag > 0
IF @userId > 1 --SECURITY
BEGIN
	IF object_id('tempdb.dbo.#tmpObjByUser') IS NOT NULL DROP TABLE #tmpObjByUser
create table  #tmpObjByUser ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
DECLARE @capability BIGINT = 1
EXEC sec_getUserObjects @userId,2013,0,'#tmpObjByUser' --SUB_CLIENT_ITEM->client
	--If a user doesn't have admin level capabilities at commcell level, delete the clients which are not associated with the user
IF NOT EXISTS(SELECT * FROM #tmpObjByUser sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0) AND (capabilities & POWER(2, @capability-1)) > 0)
	delete from #tmpCommcellUsageReport
	where ClientId not in (select clientId from #tmpObjByUser where clientId > 0)
	drop table #tmpObjByUser
END
DECLARE @snapshotAppIds TABLE (t_id INT)
INSERT INTO @snapshotAppIds
SELECT componentNameId
FROM APP_SubclientProp WITH (NOLOCK) WHERE attrName = 'Enable Snap Backups' AND attrVal <> '0' AND modified = 0
UPDATE	#tmpCommcellUsageReport
set 	Snapshot = 1
FROM	@snapshotAppIds
WHERE	t_id = appId
--Updating Snapshot/ClientGroup
UPDATE	#tmpCommcellUsageReport
set ClientGroup  = LEFT(dbo.GetClientGroup(Clientid),1024)
FROM	#tmpCommcellUsageReport usage
DECLARE @AppData1  TABLE
(
	  AppType					varchar(1024),
      AppTypeName               varchar(1024),
      tSize                     BIGINT,
      isEnterprise 				BIGINT,
      nJobType			    INT
 )
INSERT INTO @AppData1
SELECT distinct	AppTypeId, AppTypeName,Sum(UncompBytes) tSize, 0, nJobType
FROM    #tmpCommcellUsageReport
GROUP BY AppTypeId,AppTypeName,nJobType
DECLARE @AppData2  TABLE
(
	  AppType				   varchar(1024),
      AppTypeName              varchar(1024),
      UsedEnterpriseSize		BIGINT,
      UsedCoreSize				BIGINT,
      UsedArchiveSize			BIGINT,
      UsedArchiveEnterpriseSize	BIGINT,
	  UsedSnapshotSize				BIGINT,
      UsedReplicationSize	BIGINT
 )
INSERT INTO @AppData2
SELECT
	DISTINCT A.AppType,
	A.AppTypeName,
ISNULL((select T.tSize from @AppData1 T where T.AppType=A.AppType AND nJobType=0), 0),
0,
0,
ISNULL((select T.tSize from @AppData1 T where T.AppType=A.AppType AND nJobType=1), 0),
ISNULL((select SUM(T.tSize) from @AppData1 T where T.AppType=A.AppType AND nJobType=2), 0),
ISNULL((select SUM(T.tSize) from @AppData1 T where T.AppType=A.AppType AND nJobType=3), 0)
from @AppData1  A order by AppTypeName
SELECT
            1 as RptLevel, SUM(UsedEnterpriseSize) AS EnterpriseBackupSize,SUM(UsedCoreSize)  AS CoreBackupSize,SUM(UsedArchiveEnterpriseSize) AS EnterpriseArchiveSize,SUM(UsedArchiveSize) AS CoreArchiveSize,
			SUM(UsedSnapshotSize) as UsedSnapshotSize, SUM(UsedReplicationSize) as UsedReplicationSize,
            0 as nJobType,0 AS  appId, 0 AS jobId,
            NULL ClientName,0 AS Clientid,0 AS AppTypeId,NULL AppTypeName,
            NULL AS BackupSetName,NULL instanceName, NULL subClientName,
            0 AS SPId,NULL SPName,0 AS UncompBytes,0 as DedupEnabled,0 as SecondaryEncryption, 0 flag ,
            0 as Snapshot,NULL ClientGroup   FROM @AppData2
UNION
SELECT
            2 as RptLevel, SUM(UsedEnterpriseSize) AS EnterpriseBackupSize,SUM(UsedCoreSize)  AS CoreBackupSize,SUM(UsedArchiveEnterpriseSize) AS EnterpriseArchiveSize,SUM(UsedArchiveSize) AS CoreArchiveSize,
			SUM(UsedSnapshotSize) as UsedSnapshotSize, SUM(UsedReplicationSize) as UsedReplicationSize,
            0 as nJobType,0 AS  appId, 0 AS jobId,
            NULL ClientName,0 AS Clientid,0 AS AppTypeId,AppTypeName,
            NULL AS BackupSetName,NULL instanceName, NULL subClientName,
            0 AS SPId,NULL SPName,0 AS UncompBytes,0 as DedupEnabled,0 as SecondaryEncryption, 0 flag ,
            0 as Snapshot,NULL ClientGroup   FROM @AppData2 GROUP BY AppTypeName
UNION
SELECT 		3 as RptLevel, EnterpriseBackupSize, CoreBackupSize,EnterpriseArchiveSize,CoreArchiveSize,
			SnapshotSize, ReplicationSize, nJobType,appId, jobId, ClientName,Clientid, AppTypeId,AppTypeName,
            BackupSetName, instanceName, subClientName, SPId, SPName, UncompBytes, DedupEnabled,
			SecondaryEncryption, flag , Snapshot, ClientGroup
			from #tmpCommcellUsageReport order by RptLevel,ClientName,AppTypeName,instanceName,BackupSetName,subClientName
DROP TABLE #tmpCommcellUsageReport
-----------
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetLicUsageByCapacity')
	delete from GxQscripts where name = 'RptGetLicUsageByCapacity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetLicUsageByCapacity')
	delete from GXDBVersions where aliasname = 'RptGetLicUsageByCapacity'
GO

insert into GXDBVersions values(2, 'RptGetLicUsageByCapacity',  '00010017005600110000', 'RptGetLicUsageByCapacity', '00010017005600110000')
GO

