

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetJobListByVolId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetJobListByVolId.sp,v $ $Id: rptGetJobListByVolId.sp,v 1.2.210.1 2018/03/22 03:17:06 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "rptGetJobListByVolId"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetJobListByVolId')
BEGIN
	print '>>> Drop Stored Procedure: rptGetJobListByVolId <<<'
	drop procedure rptGetJobListByVolId
END
IF EXISTS (select * from GxQscripts where name='rptGetJobListByVolId')
	delete from GxQscripts where name = 'rptGetJobListByVolId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetJobListByVolId')
	delete from GXDBVersions where aliasname = 'rptGetJobListByVolId'
GO
print '... Creating Procedure: rptGetJobListByVolId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetJobListByVolId
  @volId integer,
  @includeAgedData integer,
  @isMedia integer,
  @polId integer
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_jobId integer;
  DECLARE @o_commCellId integer;
  DECLARE @o_appId integer;
--			FETCH AG and AGC info
--			-----------------------------------------
IF object_id('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
IF object_id('tempdb.dbo.#tempAFile') IS NOT NULL DROP TABLE #tempAFile
set @volId				=@volId
set @includeAgedData	=@includeAgedData
set @isMedia            =@isMedia
set @polId              =@polId
--Added condition by vnirala on 10-oct-2006 for Megnatic
		SELECT id, commCellId
		INTO   #tempChunk
		FROM   archChunk
		WHERE
		(@isMedia > 0  AND volumeId in (select  volumeid from MMVolume where mediaid = @volId))
		 OR
		(@isMedia <= 0 AND volumeId  = @volId)
SELECT DISTINCT A.archFileId, A.commCellId, A.flags
INTO   #tempAFile
FROM   archChunkMapping A, #tempChunk B
WHERE  A.archChunkId = B.id AND A.chunkCommCellId = B.commCellId
IF @includeAgedData = 0
BEGIN
	DELETE #tempAFile WHERE (flags&256)>0
END
--Added condition by vnirala on 10-oct-2006 filter by Policy ID
SELECT A.jobId, A.commCellId, A.appId
FROM   archFile A, #tempAFile B
WHERE  A.id = B.archFileId
AND A.commCellId = B.commCellId
AND A.archGroupId = @polId
GROUP BY A.jobId, A.commCellId, A.appId
DROP TABLE #tempChunk
DROP TABLE #tempAFile
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetJobListByVolId')
	delete from GxQscripts where name = 'RptGetJobListByVolId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetJobListByVolId')
	delete from GXDBVersions where aliasname = 'RptGetJobListByVolId'
GO

insert into GXDBVersions values(2, 'RptGetJobListByVolId',  '00010002021000010000', 'RptGetJobListByVolId', '00010002021000010000')
GO

