

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetJobCompletionRate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetJobCompletionRate.sp,v $ $Id: RptGetJobCompletionRate.sp,v 1.4.288.4 2019/04/25 23:47:56 junlu Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetJobCompletionRate"				|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
-- 50 jobs/ per, 100 gb/hr
-- ie. Total jobs that completed in the last hour for that MA and total size of data for those jobs
-- 1	Commcell ID
-- 2	Storage Policy
-- 4	MediaAgent ID
-- 8	Storage Policy & MA
-- 16	Library ID
-- 256	Drive ID
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetJobCompletionRate')
BEGIN
	print '>>> Drop Stored Procedure: RptGetJobCompletionRate <<<'
	drop procedure RptGetJobCompletionRate
END
IF EXISTS (select * from GxQscripts where name='RptGetJobCompletionRate')
	delete from GxQscripts where name = 'RptGetJobCompletionRate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetJobCompletionRate')
	delete from GXDBVersions where aliasname = 'RptGetJobCompletionRate'
GO
print '... Creating Procedure: RptGetJobCompletionRate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetJobCompletionRate
  @i_SelectMode Integer,
  @i_CommCellId Integer,
  @i_MediaAgentId Integer,
  @i_StoragePolicyId Integer,
  @i_LibraryId Integer,
  @i_DriveId Integer,
  @i_StartTime Integer,
  @i_EndTime Integer
AS
  DECLARE @o_id1 integer;
  DECLARE @o_id2 integer;
  DECLARE @o_jobCount integer;
  DECLARE @o_throughputGB bigint;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE	@fmTime	Integer
DECLARE @toTime	Integer
IF (@i_StartTime = 0 or @i_endTime = 0)
BEGIN
	SET @toTime	= dbo.GetUnixTime(dbo.clientlocaltoutctime(getdate(), 2))
	SET @fmTime	= @toTime - 24 * 3600
END
ELSE
BEGIN
	SET @toTime	= @i_EndTime
	SET @fmTime	= @i_StartTime
END
IF OBJECT_ID('tempdb..#JobCompletion') IS NOT NULL DROP TABLE #JobCompletion
CREATE TABLE #JobCompletion (id1 INT, id2 INT, jobCount INT, dataSize BIGINT)
-- commcell ID
IF (@i_SelectMode & 1) > 0
BEGIN
	INSERT INTO	#JobCompletion
	SELECT	commCellId, 0, COUNT(jobId), SUM(totalBackupSize)
	FROM	JMBkpStats
	WHERE	status IN (1,3,14)
		AND	servEndDate > @fmTime AND servEndDate <= @toTime
		AND (commCellId = @i_CommCellId OR @i_CommCellId = 0)
	GROUP BY commCellId
	INSERT INTO	#JobCompletion
	SELECT	commCellId, 0, COUNT(jobId), SUM(totalBackupSize)
	FROM	JMAdminJobStatsTable
	WHERE	status IN (1,3,14)
		AND	servEnd > @fmTime AND servEnd <= @toTime
		AND (commCellId = @i_CommCellId OR @i_CommCellId = 0)
	GROUP BY commCellId
END
-- Storage Policy ID
ELSE IF (@i_SelectMode & 2) > 0
BEGIN
	INSERT INTO	#JobCompletion
	SELECT	J.archGrpId, J.archGrpCopyId, COUNT(B.jobId), SUM(B.totalBackupSize)
	FROM	JMJobDataStats J INNER JOIN JMBkpStats B ON J.jobId = B.jobId AND J.commCellId = B.commCellId
	WHERE	J.copiedTime > @fmTime AND J.copiedTime <= @toTime AND J.dataType = 1 AND J.sizeOnMedia > 0
		AND (J.archGrpId = @i_StoragePolicyId OR @i_StoragePolicyId = 0)
		AND B.dataArchGrpId > 1
	GROUP BY J.archGrpId, J.archGrpCopyId
	INSERT INTO	#JobCompletion
	SELECT	J.archGrpId, J.archGrpCopyId, COUNT(B.jobId), SUM(B.totalBackupSize)
	FROM	JMJobDataStats J INNER JOIN JMBkpStats B ON J.jobId = B.jobId AND J.commCellId = B.commCellId
	WHERE	J.copiedTime > @fmTime AND J.copiedTime <= @toTime AND J.dataType = 4 AND J.sizeOnMedia > 0
		AND (J.archGrpId = @i_StoragePolicyId OR @i_StoragePolicyId = 0)
		AND B.dataBackedUp = 0 AND B.logArchGrpId > 1
	GROUP BY J.archGrpId, J.archGrpCopyId
	INSERT INTO	#JobCompletion
	SELECT	J.archGrpId, J.archGrpCopyId, COUNT(A.jobId), SUM(A.totalBackupSize)
	FROM	JMJobDataStats J INNER JOIN JMAdminJobStatsTable A ON J.jobId = A.jobId AND J.commCellId = A.commCellId
	WHERE	J.copiedTime > @fmTime AND J.copiedTime <= @toTime AND J.dataType = 1 AND J.sizeOnMedia > 0
		AND (J.archGrpId = @i_StoragePolicyId OR @i_StoragePolicyId = 0)
	GROUP BY J.archGrpId, J.archGrpCopyId
END
-- MediaAgent ID
IF (@i_SelectMode & 4) > 0
BEGIN
	INSERT INTO	#JobCompletion
	SELECT	ClientId, 0, COUNT(DISTINCT B.jobId), SUM(B.totalBackupSize)
	FROM	JMJobResourceHistory RH
			INNER JOIN JMBkpStats B ON RH.jobId = B.jobId AND RH.commCellId = B.commCellId
	WHERE	ReleaseTime > @fmTime AND ReleaseTime <= @toTime AND ReservationType = 2
		AND (ClientId = @i_MediaAgentId OR @i_MediaAgentId = 0)
	GROUP BY ClientId
	INSERT INTO	#JobCompletion
	SELECT	ClientId, 0, COUNT(DISTINCT A.jobId), SUM(A.totalBackupSize)
	FROM	JMJobResourceHistory RH
			INNER JOIN JMAdminJobStatsTable A ON RH.jobId = A.jobId AND RH.commCellId = A.commCellId
	WHERE	ReleaseTime > @fmTime AND ReleaseTime <= @toTime AND ReservationType = 2
		AND (ClientId = @i_MediaAgentId OR @i_MediaAgentId = 0)
	GROUP BY ClientId
END
-- MediaAgent and Storage Policy ID
ELSE IF (@i_SelectMode & 8) > 0
BEGIN
	INSERT INTO	#JobCompletion
	SELECT	ClientId, archGroupId, COUNT(DISTINCT B.jobId), SUM(B.totalBackupSize)
	FROM	JMJobResourceHistory RH
			INNER JOIN JMBkpStats B ON RH.jobId = B.jobId AND RH.commCellId = B.commCellId
			INNER JOIN archGroupCopy AGC ON RH.copyId = AGC.id
	WHERE	ReleaseTime > @fmTime AND ReleaseTime <= @toTime AND ReservationType = 2
		AND (ClientId = @i_MediaAgentId OR @i_MediaAgentId = 0)
		AND (archGroupId = @i_StoragePolicyId OR @i_StoragePolicyId = 0)
	GROUP BY ClientId, archGroupId
	INSERT INTO	#JobCompletion
	SELECT	ClientId, archGroupId, COUNT(DISTINCT A.jobId), SUM(A.totalBackupSize)
	FROM	JMJobResourceHistory RH
			INNER JOIN JMAdminJobStatsTable A ON RH.jobId = A.jobId AND RH.commCellId = A.commCellId
			INNER JOIN archGroupCopy AGC ON RH.copyId = AGC.id
	WHERE	ReleaseTime > @fmTime AND ReleaseTime <= @toTime AND ReservationType = 2
		AND (ClientId = @i_MediaAgentId OR @i_MediaAgentId = 0)
		AND (archGroupId = @i_StoragePolicyId OR @i_StoragePolicyId = 0)
	GROUP BY ClientId, archGroupId
END
-- Library ID
ELSE IF (@i_SelectMode & 16) > 0
BEGIN
	INSERT INTO	#JobCompletion
	SELECT	LibraryId, 0, COUNT(DISTINCT B.jobId), SUM(B.totalBackupSize)
	FROM	JMJobResourceHistory RH
			INNER JOIN JMBkpStats B ON RH.jobId = B.jobId AND RH.commCellId = B.commCellId
			INNER JOIN MMMasterPool MP ON RH.MasterPoolId = MP.MasterPoolId
	WHERE	ReleaseTime >= @fmTime AND ReleaseTime <= @toTime AND ReservationType = 2
		AND (LibraryId = @i_LibraryId OR @i_LibraryId = 0)
	GROUP BY LibraryId
	INSERT INTO	#JobCompletion
	SELECT	MP.LibraryId, 0, COUNT(DISTINCT A.jobId), SUM(A.totalBackupSize)
	FROM	JMJobResourceHistory RH
			INNER JOIN JMAdminJobStatsTable A ON RH.jobId = A.jobId AND RH.commCellId = A.commCellId
			INNER JOIN MMMasterPool MP ON RH.MasterPoolId = MP.MasterPoolId
	WHERE	ReleaseTime >= @fmTime AND ReleaseTime <= @toTime AND ReservationType = 2
		AND (MP.LibraryId = @i_LibraryId OR @i_LibraryId = 0)
	GROUP BY MP.LibraryId
END
-- Drive ID
ELSE IF (@i_SelectMode & 256) > 0
BEGIN
	INSERT INTO	#JobCompletion
	SELECT	DriveId, 0, COUNT(DISTINCT B.jobId), SUM(B.totalBackupSize)
	FROM	JMJobResourceHistory RH
			INNER JOIN JMBkpStats B ON RH.jobId = B.jobId AND RH.commCellId = B.commCellId
	WHERE	ReleaseTime > @fmTime AND ReleaseTime <= @toTime AND ReservationType = 2
		AND (DriveId = @i_DriveId OR @i_DriveId = 0)
	GROUP BY DriveId
	INSERT INTO	#JobCompletion
	SELECT	DriveId, 0, COUNT(DISTINCT A.jobId), SUM(A.totalBackupSize)
	FROM	JMJobResourceHistory RH
			INNER JOIN JMAdminJobStatsTable A ON RH.jobId = A.jobId AND RH.commCellId = A.commCellId
	WHERE	ReleaseTime > @fmTime AND ReleaseTime <= @toTime AND ReservationType = 2
		AND (DriveId = @i_DriveId OR @i_DriveId = 0)
	GROUP BY DriveId
END
SELECT	id1, id2, SUM(jobCount), SUM(dataSize)
FROM	#JobCompletion
GROUP BY id1, id2
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetJobCompletionRate')
	delete from GxQscripts where name = 'RptGetJobCompletionRate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetJobCompletionRate')
	delete from GXDBVersions where aliasname = 'RptGetJobCompletionRate'
GO

insert into GXDBVersions values(2, 'RptGetJobCompletionRate',  '00010004028800040000', 'RptGetJobCompletionRate', '00010004028800040000')
GO

