

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetJobAttempsTmpTbl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetJobAttempsTmpTbl.sp,v $ $Id: rptGetJobAttempsTmpTbl.sp,v 1.8.304.3 2018/11/18 03:52:13 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptGetJobAttempsTmpTbl"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetJobAttempsTmpTbl')
BEGIN
	print '>>> Drop Stored Procedure: rptGetJobAttempsTmpTbl <<<'
	drop procedure rptGetJobAttempsTmpTbl
END
IF EXISTS (select * from GxQscripts where name='rptGetJobAttempsTmpTbl')
	delete from GxQscripts where name = 'rptGetJobAttempsTmpTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetJobAttempsTmpTbl')
	delete from GXDBVersions where aliasname = 'rptGetJobAttempsTmpTbl'
GO
print '... Creating Procedure: rptGetJobAttempsTmpTbl'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetJobAttempsTmpTbl
  @i_isActive integer,
  @i_commcellId integer,
  @i_jobId integer,
  @outputTableArg varchar(100)
AS
DECLARE @attemptNum	integer
DECLARE @phaseNum	integer
DECLARE @copyid		integer
DECLARE @rscNum		integer
DECLARE @dataLen	integer
DECLARE @rscName	varchar(1024)
DECLARE @tokSep		varchar(10)
DECLARE @PTRVAL		varbinary(16)
SET @tokSep=', '
IF object_id('tempdb.dbo.#Att_temp') is not null DROP TABLE #Att_temp
CREATE TABLE #Att_temp(
	number		INT,
	phaseNum	INT,
	copyId		INT,
	opTblId		INT,
	opTypeId	INT,
	appTypeId	INT,
	status		INT,
	startTime	INT,
	endTime		INT,
	elapsedTime	INT,
	writeTime	INT,
	uCompBytes	BIGINT,
	objectNum	BIGINT,
	driveName	text default(''),
	MAName		text default(''),
	libraryName	text default(''),
	drivePoolName	text default('')
)
IF @i_isActive > 0
BEGIN
	INSERT INTO #Att_temp(number,phaseNum,copyId,opTblId,opTypeId,appTypeId,status,startTime,endTime,elapsedTime,writeTime,uCompBytes,objectNum)
	SELECT	attemptNum, phaseNum, copyId, 0,
		(select opType from JMJobInfo where jobId=A.jobId),
		(select L.appTypeId from APP_Application L, JMBkpJobInfo I where A.jobId=I.jobId and
									    L.id=I.applicationId),
		status, startTime, endTime, elapsedTime, writeTime, unCompbytes, numFiles
	FROM	JMBkpAttemptInfo A
	WHERE	jobId=@i_jobId
END
ELSE
BEGIN
	INSERT INTO #Att_temp(number,phaseNum,copyId,opTblId,opTypeId,appTypeId,status,startTime,endTime,elapsedTime,writeTime,uCompBytes,objectNum)
	SELECT	number, phase, copyId,
		(select O.id from JMBkpStats B, JMOpTable O where O.appTypeType=B.appType and
								O.operation=B.optype and
								B.jobId=A.jobId and
								B.commCellId=A.commCellId), 0, 0,
		status, servStartDate, servEndDate, elapsedTime, writeTime, unCompBytes, numObjects
	FROM	JMBkpAtmptStats A
	WHERE	commCellId=@i_commcellId and jobId=@i_jobId
END
--get resource info
DECLARE jobAttempts CURSOR FOR
	SELECT number, phaseNum, copyId FROM #Att_temp
OPEN jobAttempts
FETCH NEXT FROM jobAttempts INTO @attemptNum, @phaseNum, @copyId
WHILE @@FETCH_STATUS = 0
BEGIN
	--get drive name
	SET @rscNum = 0
	SELECT @PTRVAL = TEXTPTR(driveName) FROM #Att_temp WHERE number=@attemptNum AND phaseNum=@phaseNum AND copyId=@copyId
	DECLARE jobAttDrive CURSOR FOR
	SELECT DISTINCT M.aliasName
	FROM #Att_temp			LEFT OUTER JOIN JMJobResourceHistory H ON
									H.commCellId = @i_commcellId AND
									H.jobId = @i_jobId AND
									H.phaseNum = @phaseNum AND
									H.attemptNum = @attemptNum AND
									H.copyId=@copyId
			JOIN MMDrive M ON				M.driveId = H.driveId
	OPEN jobAttDrive
	FETCH NEXT FROM jobAttDrive INTO @rscName
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @rscNum > 0
			SET @rscName = @tokSep + @rscName
		SET @dataLen=(select DATALENGTH(driveName) FROM #Att_temp WHERE number=@attemptNum AND phaseNum=@phaseNum AND copyId=@copyId)
		UPDATETEXT #Att_temp.driveName @PTRVAL @dataLen 0 @rscName
		SET @rscNum = @rscNum + 1
		FETCH NEXT FROM jobAttDrive INTO @rscName
	END
	CLOSE jobAttDrive
	DEALLOCATE jobAttDrive
	--get MA name
	SET @rscNum = 0
	SELECT @PTRVAL = TEXTPTR(MAName) FROM #Att_temp WHERE number=@attemptNum AND phaseNum=@phaseNum AND copyId=@copyId
	DECLARE jobAttMA CURSOR FOR
	SELECT DISTINCT C.displayName as name
	FROM #Att_temp
			LEFT OUTER JOIN JMJobResourceHistory H ON
									H.commCellId = @i_commcellId AND
									H.jobId = @i_jobId AND
									H.phaseNum = @phaseNum AND
									H.attemptNum = @attemptNum AND
									H.copyId=@copyId
			JOIN APP_Client C ON				C.id = H.clientId
	OPEN jobAttMA
	FETCH NEXT FROM jobAttMA INTO @rscName
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @rscNum > 0
			SET @rscName = @tokSep + @rscName
		SET @dataLen=(select DATALENGTH(MAName) FROM #Att_temp WHERE number=@attemptNum AND phaseNum=@phaseNum AND copyId=@copyId)
		UPDATETEXT #Att_temp.MAName @PTRVAL @dataLen 0 @rscName
		SET @rscNum = @rscNum + 1
		FETCH NEXT FROM jobAttMA INTO @rscName
	END
	CLOSE jobAttMA
	DEALLOCATE jobAttMA
	--get library name
	SET @rscNum = 0
	SELECT @PTRVAL = TEXTPTR(libraryName) FROM #Att_temp WHERE number=@attemptNum AND phaseNum=@phaseNum AND copyId=@copyId
	DECLARE jobAttLibrary CURSOR FOR
	SELECT DISTINCT L.aliasName
	FROM #Att_temp
			LEFT OUTER JOIN JMJobResourceHistory H ON
									H.commCellId = @i_commcellId AND
									H.jobId = @i_jobId AND
									H.phaseNum = @phaseNum AND
									H.attemptNum = @attemptNum AND
									H.copyId=@copyId
			JOIN MMMasterPool M ON				M.MasterPoolId = H.masterPoolId
			JOIN MMLibrary L ON				L.LibraryId = M.LibraryId
	OPEN jobAttLibrary
	FETCH NEXT FROM jobAttLibrary INTO @rscName
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @rscNum > 0
			SET @rscName = @tokSep + @rscName
		SET @dataLen=(select DATALENGTH(libraryName) FROM #Att_temp WHERE number=@attemptNum AND phaseNum=@phaseNum AND copyId=@copyId)
		UPDATETEXT #Att_temp.libraryName @PTRVAL @dataLen 0 @rscName
		SET @rscNum = @rscNum + 1
		FETCH NEXT FROM jobAttLibrary INTO @rscName
	END
	CLOSE jobAttLibrary
	DEALLOCATE jobAttLibrary
	--get drivepool name
	SET @rscNum = 0
	SELECT @PTRVAL = TEXTPTR(drivePoolName) FROM #Att_temp WHERE number=@attemptNum AND phaseNum=@phaseNum AND copyId=@copyId
	DECLARE jobAttDrivePool CURSOR FOR
	SELECT DISTINCT M.DrivePoolName
	FROM #Att_temp
			LEFT OUTER JOIN JMJobResourceHistory H ON
									H.commCellId = @i_commcellId AND
									H.jobId = @i_jobId AND
									H.phaseNum = @phaseNum AND
									H.attemptNum = @attemptNum AND
									H.copyId=@copyId
			JOIN MMDrivePool M ON				M.DrivePoolId = H.DrivePoolId AND
M.DrivePoolType <> 10001
	OPEN jobAttDrivePool
	FETCH NEXT FROM jobAttDrivePool INTO @rscName
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @rscNum > 0
			SET @rscName = @tokSep + @rscName
		SET @dataLen=(select DATALENGTH(drivePoolName) FROM #Att_temp WHERE number=@attemptNum AND phaseNum=@phaseNum AND copyId=@copyId)
		UPDATETEXT #Att_temp.drivePoolName @PTRVAL @dataLen 0 @rscName
		SET @rscNum = @rscNum + 1
		FETCH NEXT FROM jobAttDrivePool INTO @rscName
	END
	CLOSE jobAttDrivePool
	DEALLOCATE jobAttDrivePool
	FETCH NEXT FROM jobAttempts INTO @attemptNum, @phaseNum, @copyId
END
CLOSE jobAttempts
DEALLOCATE jobAttempts
EXEC (	'INSERT INTO ' + @OutputTableArg + ' SELECT * FROM #Att_temp' )
DROP TABLE #Att_temp
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetJobAttempsTmpTbl')
	delete from GxQscripts where name = 'RptGetJobAttempsTmpTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetJobAttempsTmpTbl')
	delete from GXDBVersions where aliasname = 'RptGetJobAttempsTmpTbl'
GO

insert into GXDBVersions values(2, 'RptGetJobAttempsTmpTbl',  '00010008030400030000', 'RptGetJobAttempsTmpTbl', '00010008030400030000')
GO

