

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetJobAttemps.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetJobAttemps.sp,v $ $Id: RptGetJobAttemps.sp,v 1.3.278.2 2018/03/22 03:16:10 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "RptGetJobAttemps"				|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetJobAttemps <<<'

IF EXISTS (select * from sysobjects where name='RptGetJobAttemps')
	drop procedure RptGetJobAttemps
IF EXISTS (select * from GxQscripts where name='RptGetJobAttemps')
	delete from GxQscripts where name = 'RptGetJobAttemps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetJobAttemps')
	delete from GXDBVersions where aliasname = 'RptGetJobAttemps'
GO
print '... Creating Procedure: RptGetJobAttemps'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure RptGetJobAttemps
  @i_isActive integer,
  @i_commcellId integer,
  @i_jobId integer,
  @i_clientId integer,
  @i_useCSTime integer
AS
  DECLARE @o_attemptNum integer;
  DECLARE @o_phaseNum integer;
  DECLARE @o_phaseName varchar(255);
  DECLARE @o_status integer;
  DECLARE @o_startTime integer;
  DECLARE @o_endTime integer;
  DECLARE @o_elapsedTime integer;
  DECLARE @o_writeTime integer;
  DECLARE @o_dataSize bigint;
  DECLARE @o_objectNum bigint;
  DECLARE @o_driveName NVARCHAR(MAX);
  DECLARE @o_MAName varchar(MAX);
  DECLARE @o_libraryName NVARCHAR(MAX);
  DECLARE @o_drivePoolName NVARCHAR(MAX);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#jobAttemptsTempTbl') IS NOT NULL DROP TABLE #jobAttemptsTempTbl
CREATE TABLE #jobAttemptsTempTbl(
	number		INT,
	phaseNum	INT,
	copyId		INT,
	opTblId		INT,
	opTypeId	INT,
	appTypeId	INT,
	status		INT,
	startTime	INT,
	endTime		INT,
	elapsedTime	INT,
	writeTime	INT,
	uCompBytes	BIGINT,
	objectNum	BIGINT,
	driveName	text,
	MAName		text,
	libraryName	text,
	drivePoolName	text
)
EXEC rptGetJobAttempsTmpTbl @i_isActive, @i_commcellId, @i_jobId, #jobAttemptsTempTbl
SELECT	number, phaseNum,
	phaseName=(case	when opTblId>0 then (select name from JMPhase where optableId=opTblId and phase=phaseNum)
			else (select name from JMPhase P, JMOpTable O where P.phase=phaseNum and P.optableId=O.id and
				O.appTypeType=appTypeId and O.operation=optypeId) END), status,
	(case @i_useCSTime When 0 then DBO.rptgetJobClientTime(@i_ClientId, isnull(startTime,0)) else startTime end),
	(case @i_useCSTime When 0 then DBO.rptgetJobClientTime(@i_ClientId, ISNULL(endTime,0)) else endTime end), elapsedTime, writeTime,
	uCompBytes, objectNum, driveName, MAName, libraryName, drivePoolName
FROM #jobAttemptsTempTbl
ORDER BY phaseNum, number
DROP TABLE #jobAttemptsTempTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetJobAttemps')
	delete from GxQscripts where name = 'RptGetJobAttemps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetJobAttemps')
	delete from GXDBVersions where aliasname = 'RptGetJobAttemps'
GO

insert into GXDBVersions values(2, 'RptGetJobAttemps',  '00010003027800020000', 'RptGetJobAttemps', '00010003027800020000')
GO

