

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetInterfacePairs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetInterfacePairs.sp,v $ $Id: RptGetInterfacePairs.sp,v 1.1.2.5 2018/11/18 03:52:37 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		Procedure: "rptGetInterfacePairs"				                |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetInterfacePairs')
BEGIN
	print '>>> Drop Stored Procedure: rptGetInterfacePairs <<<'
	drop procedure rptGetInterfacePairs
END
IF EXISTS (select * from GxQscripts where name='rptGetInterfacePairs')
	delete from GxQscripts where name = 'rptGetInterfacePairs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetInterfacePairs')
	delete from GXDBVersions where aliasname = 'rptGetInterfacePairs'
GO
print '... Creating Procedure: rptGetInterfacePairs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure rptGetInterfacePairs
  @i_jobId integer,
  @i_userId integer
AS
-- The following lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  DECLARE @srcClient nchar(255);
  DECLARE @srcInterface char(255);
  DECLARE @destClient nchar(255);
  DECLARE @destInterface char(255);
  DECLARE @isActive integer;
  DECLARE @o_srcClientDisplayName nvarchar(255);
  DECLARE @o_destClientDisplayName nvarchar(255);
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @clOpt          INTEGER
DECLARE @appTypeOpt     INTEGER
DECLARE @tblClients     TABLE (t_clId int)
DECLARE @tblApptypes        TABLE (t_appTypeId int)
INSERT INTO @tblClients EXEC rptOptGetClients @i_jobId, @clOpt OUTPUT
INSERT INTO @tblApptypes EXEC rptOptGetAppTypes @i_jobId, @appTypeOpt OUTPUT
IF OBJECT_ID('tempdb..#tblClients') IS NOT NULL
DROP TABLE #tblClients
CREATE TABLE #tblClients (id INT)
IF OBJECT_ID('tempdb..#tblClientGroup') IS NOT NULL
DROP TABLE #tblClientGroup
CREATE TABLE #tblClientGroup (id INT)
IF @clOpt = 0
BEGIN
    IF  @appTypeOpt <= 0
	BEGIN
        INSERT INTO #tblClients
        SELECT  DISTINCT clientId
        FROM    APP_Application A WITH (READUNCOMMITTED)
	END
    ELSE
	BEGIN
        INSERT INTO #tblClients
        SELECT  DISTINCT clientId
        FROM    APP_Application A WITH (READUNCOMMITTED)
                INNER JOIN @tblApptypes T ON A.appTypeId = T.t_appTypeId
	END
		INSERT INTO #tblClientGroup
		SELECT DISTINCT id
		FROM App_clientGroup
END
ELSE
BEGIN
    IF  @appTypeOpt <= 0
        INSERT INTO #tblClients
        SELECT  DISTINCT clientId
        FROM    APP_Application A WITH (READUNCOMMITTED) INNER JOIN @tblClients CL ON A.clientId = CL.t_clId
    ELSE
        INSERT INTO #tblClients
        SELECT DISTINCT clientId
        FROM    APP_Application A WITH (READUNCOMMITTED) INNER JOIN @tblClients CL ON A.clientId = CL.t_clId
                INNER JOIN @tblApptypes T ON A.appTypeId = T.t_appTypeId
		DECLARE @xmlText XML;
		DECLARE @handle INT;
		DECLARE @includeAll INT;
		SET @xmlText = (SELECT dbo.GetXMLJobOptions(@i_jobid))
		EXEC sp_xml_preparedocument @handle OUTPUT, @xmlText
		-- Selection Status [o_id]: -1 - none; 0 - all; 1 - list
			SET @includeAll = ISNULL((SELECT TOP 1 includeAll FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/computerSelectionList', 1) WITH (includeAll int)), 0)
			IF @includeAll = 0      --some clients selected
			BEGIN
				INSERT INTO #tblClientGroup
				SELECT clientGroupId FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/reportOption/computerSelectionList/clientGroupList', 1) WITH (clientGroupId int)
				EXEC sp_xml_removedocument @handle
			END
END
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @i_userId, @isUserAdmin OUTPUT
IF @i_userId > 0 AND @isUserAdmin = 0 AND @clOpt <= 0
BEGIN
	IF object_id('tempdb.dbo.#tempUserObjects') IS NOT null DROP TABLE #tempUserObjects
	--SEC_TABLE_DEFINE(#tempUserObjects)
	create table  #tempUserObjects
	(
		capabilities  bigint    NOT null,
		flag            int NOT null default 0,
		commCellId    int   NOT null,
		clientGroupId int   NOT null,
		clientId      int   NOT null,
		appTypeId     int   NOT null,
		instanceId    int   NOT null,
		backupsetId   int   NOT null,
		subClientId   int   NOT null,
		mediaAgentId  int   NOT null,
		libraryId     int   NOT null,
		archGroupId   int   NOT null,
		vtContainerId int   NOT null,
		vtPolicyId    int   NOT null,
		vtshelfId     int   NOT null,
		reviewSetId   int NOT null default 0,
		querySetId    int NOT null default 0,
		downloadSetId int NOT null default 0,
		ermId         int NOT null default 0,
		legalHoldId   int NOT null default 0,
		tagId         int NOT null default 0,
		cdPolicyId    int NOT null default 0,
		compRptId     int NOT null default 0,
		taskId        int NOT null default 0,
		workflowId    int   NOT null default 0,
		logMonitoringPolicyId int   NOT null default 0,
		arrayId       int   NOT null default 0,
		cloudId       int   NOT null default 0,
		userGroupId   int   NOT null default 0,
		providerId    int   NOT null default 0,
		entityId1     int   NOT null default 0,
		entityId2     int   NOT null default 0,
		entityId3     int   NOT null default 0,
		entityId4     int   NOT null default 0,
		entityId5     int   NOT null default 0,
		entityId6     int   NOT null default 0,
		entityId7     int   NOT null default 0,
		entityId8     int   NOT null default 0,
		entityId9     int   NOT null default 0
	)
	EXEC sec_getUserObjects @i_userId, 2013, 0, '#tempUserObjects'   -- SUB_CLIENT_ITEM = to get SUB_CLIENT_ITEM it will be having client/appType/instance/backupSet/subclient/
	delete #tempUserObjects
	WHERE mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0
		OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0
		OR taskId <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0 OR vtShelfId <> 0
	IF NOT EXISTS (SELECT * FROM #tempUserObjects sec WHERE(sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
	BEGIN
		delete T
		FROM #tblClients T
		WHERE T.id NOT IN (select clientId from #tempUserObjects)
	END
		delete T
		FROM #tblClientGroup T
		WHERE T.id NOT IN (select clientGroupId from #tempUserObjects)
	DROP TABLE #tempUserObjects
END
SELECT DISTINCT  C.name, srcInterface, D.displayName, destInterface, isActive, C.displayName, D.displayName
FROM	archPipeline
	INNER JOIN #tblClients T
		ON T.id IN (srcClientId, destClientId)
	INNER JOIN APP_Client C
		ON C.id=srcClientId
	INNER JOIN APP_Client D
		ON D.id=destClientId
UNION
SELECT DISTINCT  C.name, 'N/A', D.displayName, destInterface, isActive, N'', N''
FROM	archPipeline A
	INNER JOIN #tblClientGroup T
		ON ( @isUserAdmin = 1 OR T.Id = A.srcGroupId  )
	INNER JOIN APP_ClientGroup C
		ON C.id=A.srcGroupId
	INNER JOIN APP_Client D
		ON D.id=destClientId
ORDER BY C.name, srcInterface, D.displayName, destInterface
DROP TABLE #tblClientGroup
DROP TABLE #tblClients
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetInterfacePairs')
	delete from GxQscripts where name = 'RptGetInterfacePairs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetInterfacePairs')
	delete from GXDBVersions where aliasname = 'RptGetInterfacePairs'
GO

insert into GXDBVersions values(2, 'RptGetInterfacePairs',  '00010001000200050000', 'RptGetInterfacePairs', '00010001000200050000')
GO

