

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetDrivesByJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetDrivesByJob.sp,v $ $Id: rptGetDrivesByJob.sp,v 1.10.294.2 2018/03/22 03:12:01 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		CURSOR : "rptGetDrivesByJob"				|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetDrivesByJob')
BEGIN
	print '>>> Drop Stored Procedure: rptGetDrivesByJob <<<'
	drop procedure rptGetDrivesByJob
END
IF EXISTS (select * from GxQscripts where name='rptGetDrivesByJob')
	delete from GxQscripts where name = 'rptGetDrivesByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetDrivesByJob')
	delete from GXDBVersions where aliasname = 'rptGetDrivesByJob'
GO
print '... Creating Procedure: rptGetDrivesByJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetDrivesByJob
  @isActive integer,
  @i_jobId integer
AS
  DECLARE @o_driveList NVARCHAR(1000);
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- :PARAM input lines
SET NOCOUNT ON
DECLARE	@driveType	integer
DECLARE	@driveName	nvarchar(128)
SET @o_driveList=''
CREATE TABLE #tempDrive(
	id	integer
)
	INSERT INTO #tempDrive
	SELECT DISTINCT DriveId
	FROM JMJobResourceHistory
	WHERE jobId=@i_jobId
DECLARE driveList CURSOR FOR
	SELECT DISTINCT DriveTypeId, AliasName
	FROM #tempDrive LEFT JOIN MMDrive WITH (READUNCOMMITTED) ON Id=DriveId
OPEN driveList
FETCH NEXT FROM driveList INTO @driveType, @driveName
WHILE @@FETCH_STATUS <> -1
BEGIN
	IF LEN(@o_driveList) <> 0
		SET @o_driveList =  @o_driveList + ', '
IF @driveType = 10001
		SET @o_driveList = @o_driveList + 'Magnetic'
	ELSE
		SET @o_driveList = @o_driveList + @driveName
	FETCH NEXT FROM driveList INTO @driveType, @driveName
END
CLOSE driveList
DEALLOCATE driveList
SELECT @o_driveList
DROP TABLE #tempDrive
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetDrivesByJob')
	delete from GxQscripts where name = 'RptGetDrivesByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetDrivesByJob')
	delete from GXDBVersions where aliasname = 'RptGetDrivesByJob'
GO

insert into GXDBVersions values(2, 'RptGetDrivesByJob',  '00010010029400020000', 'RptGetDrivesByJob', '00010010029400020000')
GO

