

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetDriveListByLibId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetDriveListByLibId.sp,v $ $Id: rptGetDriveListByLibId.sp,v 1.11.294.2 2018/03/22 03:04:10 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "rptGetDriveListByLibId"			|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetDriveListByLibId')
BEGIN
	print '>>> Drop Stored Procedure: rptGetDriveListByLibId <<<'
	drop procedure rptGetDriveListByLibId
END
IF EXISTS (select * from GxQscripts where name='rptGetDriveListByLibId')
	delete from GxQscripts where name = 'rptGetDriveListByLibId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetDriveListByLibId')
	delete from GXDBVersions where aliasname = 'rptGetDriveListByLibId'
GO
print '... Creating Procedure: rptGetDriveListByLibId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetDriveListByLibId
  @libID integer
AS
  DECLARE @DriveId integer;
  DECLARE @AliasName NVARCHAR(255);
  DECLARE @DriveSoftState integer;
  DECLARE @DriveEnabled integer;
  DECLARE @DriveBroken integer;
  DECLARE @CleaningRequired integer;
  DECLARE @MediaId integer;
  DECLARE @barCode char(255);
  DECLARE @DriveVendor char(255);
  DECLARE @DriveModel char(255);
  DECLARE @firmwareRevision char(255);
  DECLARE @NumRestoresLifeTime integer;
  DECLARE @NumBackupsLifeTime integer;
  DECLARE @NumMountsLifeTime integer;
  DECLARE @NumSoftErrsSinceClean integer;
  DECLARE @NumSoftErrsLifeTime integer;
  DECLARE @NumHardErrsSinceClean integer;
  DECLARE @NumHardErrsLifeTime integer;
  DECLARE @MinutesUsedSinceClean integer;
  DECLARE @MinutesUsedLifeTime integer;
  DECLARE @LastCleantime integer;
  DECLARE @OfflineReason integer;
  DECLARE @attributes integer;
  DECLARE @jobId int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- :PARAM input lines
SELECT	D.DriveId, D.AliasName, D.DriveSoftState, D.DriveEnabled, D.DriveBroken, D.CleaningRequired,
	D.MediaId, barcode=(case D.MediaId when 0 then '' else (select BarCode from MMMedia tm where tm.MediaID=D.MediaId) end),
	D.DriveVendor, D.DriveModel, D.firmwareRevision, D.NumRestoresLifeTime, D.NumBackupsLifeTime, D.NumMountsLifeTime,
	D.NumSoftErrsSinceClean, D.NumSoftErrsLifeTime, D.NumHardErrsSinceClean, D.NumHardErrsLifeTime,
	D.MinutesUsedSinceClean, D.MinutesUsedLifeTime, D.LastCleantime, D.OfflineReason, D.attributes INTO #temp1
FROM	MMDrive D, MMMasterPool MP
WHERE	D.MasterPoolId = MP.MasterPoolId and MP.LibraryId = @libID
SELECT	m_JobId=jobId_l, mr.DriveId INTO #temp2
FROM	MMResourceToJob rj, MMResource mr
WHERE	rj.ReservationId = mr.ReservationId
SELECT	#temp1.*, m_JobId
FROM	#temp1 LEFT JOIN #temp2 ON #temp1.DriveId = #temp2.DriveId
DROP TABLE #temp1
DROP TABLE #temp2
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetDriveListByLibId')
	delete from GxQscripts where name = 'RptGetDriveListByLibId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetDriveListByLibId')
	delete from GXDBVersions where aliasname = 'RptGetDriveListByLibId'
GO

insert into GXDBVersions values(2, 'RptGetDriveListByLibId',  '00010011029400020000', 'RptGetDriveListByLibId', '00010011029400020000')
GO

