

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetDedupeProps.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetDedupeProps.sp,v $ $Id: RptGetDedupeProps.sp,v 1.6.194.4 2018/11/18 03:51:52 skatz Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "RptGetSIStore"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetDedupeProps')
BEGIN
	print '>>> Drop Stored Procedure: RptGetDedupeProps <<<'
	drop procedure RptGetDedupeProps
END
IF EXISTS (select * from GxQscripts where name='RptGetDedupeProps')
	delete from GxQscripts where name = 'RptGetDedupeProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetDedupeProps')
	delete from GXDBVersions where aliasname = 'RptGetDedupeProps'
GO
print '... Creating Procedure: RptGetDedupeProps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetDedupeProps
  @i_policyIdsXml xml
AS
  DECLARE @o_policyId integer;
  DECLARE @o_policyName NVARCHAR(255);
  DECLARE @o_policyFlags integer;
  DECLARE @o_SIBlockSizeKB integer;
  DECLARE @o_copyId integer;
  DECLARE @o_copyName NVARCHAR(255);
  DECLARE @o_isPrimaryCopy integer;
  DECLARE @o_copyFlags integer;
  DECLARE @o_dedupeFlags integer;
  DECLARE @o_GDPolicyName NVARCHAR(255);
  DECLARE @o_siloCopyName NVARCHAR(255);
  DECLARE @o_silosInCache integer;
  DECLARE @o_siloRestoreMA NVARCHAR(255);
  DECLARE @o_siloRestoreDest NVARCHAR(255);
  DECLARE @o_SIDBStoreFlags integer;
  DECLARE @o_oldestObjArchiveTime integer;
  DECLARE @o_sealStoreDataSizeGB bigint;
  DECLARE @o_sealStorePeriodType integer;
  DECLARE @o_sealStoreNumPeriod integer;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @MAXINT	INT
SET		@MAXINT = 0x7FFFFFFF
DECLARE @tblPolicy		TABLE (policyId int)
INSERT	INTO @tblPolicy
SELECT	T.c.value('@policyId', 'int')
FROM	@i_policyIdsXml.nodes('/r/h') T(c)
SELECT	AG.id, AG.name, AG.flags, AG.SIBlockSizeKB,
		AGC.id, AGC.name, CASE WHEN AGC.id = AG.defaultCopy THEN 1 ELSE 0 END,
		AGC.flags, AGC.dedupeFlags,
		GDPolicy = ISNULL(GDP.name, ''),
SiloCopyName = ISNULL((SELECT name FROM archGroupCopy WHERE archGroupId = AG.id AND sourceCopyId = AGC.id AND (flags & 524288) <> 0), ''),
		AGC.silosInCache,
		SiloRestoreMA = ISNULL((SELECT displayName FROM APP_Client WHERE id = AGC.siloRestoreMAClientId), ''),
		SiloRestoreDest = ISNULL((SELECT displayName FROM APP_Client WHERE id = AGC.siloRestoreClientId), ''),
		S.flags, S.oldestEligibleObjArchiveTime,
		T.dataSizeGB, T.periodType, T.numPeriod
FROM	@tblPolicy P
		INNER JOIN archGroup AG
			ON AG.id = P.policyId
		INNER JOIN archGroupCopy AGC
ON AGC.archGroupId = AG.id AND ((AGC.dedupeFlags & 262144) > 0)
		INNER JOIN IdxSIDBStore S
			ON S.SIDBStoreId = AGC.SIDBStoreId
		INNER JOIN IdxSIDBSubStore SS
			ON SS.SIDBStoreId = S.SIDBStoreId AND SS.GroupNumber = 0
		INNER JOIN archTask T
			ON T.id = AGC.sealStoreTaskId
		LEFT OUTER JOIN (SELECT a.name, b.SIDBStoreId FROM archGroup a, archGroupCopy b
WHERE a.id = b.archGroupId AND (b.dedupeFlags & 268435456) <> 0) GDP
			ON GDP.SIDBStoreId = AGC.SIDBStoreId
ORDER BY ISNULL(GDP.name, ''), AG.name, AGC.name
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetDedupeProps')
	delete from GxQscripts where name = 'RptGetDedupeProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetDedupeProps')
	delete from GXDBVersions where aliasname = 'RptGetDedupeProps'
GO

insert into GXDBVersions values(2, 'RptGetDedupeProps',  '00010006019400040000', 'RptGetDedupeProps', '00010006019400040000')
GO

