

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetDateTimeFormatOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems,  Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems,  Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/RptGetDateTimeFormatOptions.sp,v $ $Id: RptGetDateTimeFormatOptions.sp,v 1.1.2.6 2018/03/22 03:13:00 jiechen Exp $";
-- =============================================
-- Author:      Sanket Amrutkar
-- Create date: 25/10/2016
-- Description: Get the Date and Time Format Options
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptGetDateTimeFormatOptions <<<'

IF EXISTS (select * from sysobjects where name='RptGetDateTimeFormatOptions')
	drop procedure RptGetDateTimeFormatOptions
IF EXISTS (select * from GxQscripts where name='RptGetDateTimeFormatOptions')
	delete from GxQscripts where name = 'RptGetDateTimeFormatOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetDateTimeFormatOptions')
	delete from GXDBVersions where aliasname = 'RptGetDateTimeFormatOptions'
GO
print '... Creating Procedure: RptGetDateTimeFormatOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetDateTimeFormatOptions
  @i_jobId integer
AS
DECLARE @userId			integer
SET @userId			= dbo.GetOptionInt(140019, @i_jobId, 0, 0)
  DECLARE @DateTimeFormat INT
  DECLARE @DateFormat varchar(max)
  DECLARE @TimeFormat varchar(max)
DECLARE @value nvarchar(max) = null
SET @value = (SELECT TOP 1 value FROM UMUserPrefs (NOLOCK) WHERE userid = @userId)
DECLARE @userPrefs XML
  IF (CHARINDEX( '<?xml version=''1.0'' encoding=''UTF-8''?>',@value,1)) <> 0
  BEGIN
  	SET @userPrefs  =(SELECT CONVERT(XML,SUBSTRING(@value,LEN('<?xml version=''1.0'' encoding=''UTF-8''?>')+1,LEN(@value)),2))
  END
  IF (CHARINDEX( '<?xml version="1.0" ?>',@value,1)) <> 0
  BEGIN
  	SET @userPrefs  =(SELECT CONVERT(XML,SUBSTRING(@value,LEN('<?xml version="1.0" ?>')+1,LEN(@value)),2))
  END
SELECT   @userPrefs.value('./userprefs_UserPreferences[1]/@useUserdefinedDateTimeFormat','int') as 'DateTimeFormat',
		 @userPrefs.value('./userprefs_UserPreferences[1]/@userdefinedShortDateFormat','varchar(max)') as 'DateFormat',
		 @userPrefs.value('./userprefs_UserPreferences[1]/@userdefinedTimeFormat','varchar(max)') as 'TimeFormat'
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetDateTimeFormatOptions')
	delete from GxQscripts where name = 'RptGetDateTimeFormatOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetDateTimeFormatOptions')
	delete from GXDBVersions where aliasname = 'RptGetDateTimeFormatOptions'
GO

insert into GXDBVersions values(2, 'RptGetDateTimeFormatOptions',  '00010001000200060000', 'RptGetDateTimeFormatOptions', '00010001000200060000')
GO

