

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/RptGetDM2LegalHoldList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/rptGetDM2LegalHoldList.sp,v $ $Id: rptGetDM2LegalHoldList.sp,v 1.7.276.1 2018/03/22 03:14:21 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "rptGetDM2LegalHoldList"                                   |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='rptGetDM2LegalHoldList')
BEGIN
	print '>>> Drop Stored Procedure: rptGetDM2LegalHoldList <<<'
	drop procedure rptGetDM2LegalHoldList
END
IF EXISTS (select * from GxQscripts where name='rptGetDM2LegalHoldList')
	delete from GxQscripts where name = 'rptGetDM2LegalHoldList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='rptGetDM2LegalHoldList')
	delete from GXDBVersions where aliasname = 'rptGetDM2LegalHoldList'
GO
print '... Creating Procedure: rptGetDM2LegalHoldList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure rptGetDM2LegalHoldList
  @i_jobId integer
AS
  DECLARE @o_bkpSetId integer
  DECLARE @o_retainUntil integer
  DECLARE @o_createTime integer
  DECLARE @o_spId integer
  DECLARE @o_retentionDays integer
  DECLARE @o_lastAppendTime integer
  DECLARE @o_compPolId varchar(128)
  DECLARE @o_compPolicyName nvarchar(MAX)
  DECLARE @o_spName nvarchar(MAX)   
  DECLARE @o_groupNames nvarchar(MAX)
  DECLARE @o_compPolDesc nvarchar(MAX)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @startTime		integer
DECLARE @endTime		integer
DECLARE @backupsetId		integer
DECLARE @xmlStr varchar(1024)
DECLARE @tblApplication TABLE (appId int, backupSetId int)
DECLARE @tempLHInfoList TABLE
					(
					  bkpSetId			int,
					  retainUntil		int,
					  createTime		int,
					  spId				int,
					  retentionDays		int,
					  lastAppendTime	int,
					  compPolId			varchar(128),
					  compPolicyName    nvarchar(MAX),
					  spName			nvarchar(MAX),
					  groupNames		nvarchar(MAX),
					  compPolDesc		nvarchar(MAX)
					  )
Declare @SchedLHGetUGroupsList Table
					(
						t_groupNames nvarchar(MAX),
						t_spId int,
						t_spName varchar(MAX),
						t_retentionDays	 int,
						t_lastAppendTime datetime
					 )
EXEC RptOptGetTime @i_jobId, @startTime OUTPUT, @endTime OUTPUT
INSERT INTO @tempLHInfoList
SELECT backupSetId,
(case when  CONVERT(varchar(10), retainUntil,121) = CONVERT(varchar(10),'9999-12-31',121)
        then 0 else dbo.GetUnixTime(RetainUntil) end), dbo.GetUnixTime(createTime), 0, 0, 0, CompPolicyID, CompPolicyName , '','',CompPolicyDesc
FROM DM2CompliancePolicy
DECLARE GetLHInfo CURSOR FOR SELECT DISTINCT BackupsetId FROM DM2CompliancePolicy
OPEN GetLHInfo
FETCH GetLHInfo INTO @backupsetId
WHILE @@FETCH_STATUS = 0
BEGIN
	set @xmlStr  =  '<TMMsg_GetLegalHoldUGroupsFromBackupSetReq backupSetId= "' + CAST(@backupsetId as varchar(128)) + '"/>'
	insert into @SchedLHGetUGroupsList
	exec SchedLHGetUGroupsFromBackupSet  @xmlStr
	UPDATE @tempLHInfoList
	SET groupNames = t_groupNames,
		spId = t_spId,
		spName =t_spName,
		retentionDays =t_retentionDays,
		lastAppendTime =dbo.GetUnixTime(t_lastAppendTime)
	FROM @SchedLHGetUGroupsList
	WHERE bkpSetId = @backupsetId and spId = 0
	DELETE FROM @SchedLHGetUGroupsList
	FETCH GetLHInfo INTO @backupsetId
END
CLOSE GetLHInfo
DEALLOCATE GetLHInfo
--OutPut
SELECT * FROM @tempLHInfoList
WHERE (@startTime = 0 OR createTime >= @startTime) AND (@endTime = 0 OR createTime <= @endTime)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetDM2LegalHoldList')
	delete from GxQscripts where name = 'RptGetDM2LegalHoldList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetDM2LegalHoldList')
	delete from GXDBVersions where aliasname = 'RptGetDM2LegalHoldList'
GO

insert into GXDBVersions values(2, 'RptGetDM2LegalHoldList',  '00010007027600010000', 'RptGetDM2LegalHoldList', '00010007027600010000')
GO

